---
generated_at: 2026-01-22 21:05:00
metrics:
  claims_total: 32
  claims_with_evidence: 28
  claims_without_evidence: 4
confidence_derived: 0.88
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：28 / 32、根拠なし：4
- 優先レビュー（高）
  1. **バックアップ頻度の推奨値**：プロジェクト固有の要件に依存
  2. **本番環境の推奨JVMメモリ**：公式ドキュメント参照推奨
  3. **HA構成の台数**：具体的な構成はプロジェクト依存
  4. **Kubernetesクラスタ構成詳細**：ci.jenkins.ioの実際の構成は非公開

## 2) 参照した情報（Evidence一覧）

- E-01: `pom.xml` - プロジェクト定義、バージョン情報
- E-02: `war/pom.xml` - WARモジュール定義、Winstone/Jettyバージョン
- E-03: `core/pom.xml` - コアモジュール定義、依存関係
- E-04: `Jenkinsfile` - CIパイプライン定義、ビルド構成
- E-05: `core/src/main/resources/META-INF/web-fragment.xml` - Webフラグメント設定
- E-06: `core/src/main/resources/windows-service/jenkins.xml` - Windowsサービス設定
- E-07: `package.json` - Node.js/フロントエンド設定
- E-08: `README.md` - プロジェクト概要
- E-09: `.github/workflows/publish-release-artifact.yml` - リリースワークフロー
- E-10: `ath.sh` - ATH実行スクリプト

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jenkinsバージョンは2.548である | E-01 (pom.xml: revision=2.548) | ○ |
| C-02 | Winstoneバージョンは8.1029.vd3071f6b_5988 | E-01 (pom.xml: winstone.version) | ○ |
| C-03 | Jetty 12 EE9を使用 | E-02 (war/pom.xml: jetty-ee9-maven-plugin 12.1.5) | ○ |
| C-04 | Node.jsバージョンは24.13.0 | E-01, E-07 (pom.xml, package.json) | ○ |
| C-05 | Yarnバージョンは4.12.0 | E-07 (package.json: packageManager) | ○ |
| C-06 | Remotingバージョンは3355.v388858a_47b_33 | E-01 (pom.xml: remoting.version) | ○ |
| C-07 | JDK 21, 25をサポート | E-04 (Jenkinsfile: jdks: [21, 25]) | ○ |
| C-08 | デフォルトHTTPポートは8080 | E-02, E-06 (war/pom.xml, jenkins.xml) | ○ |
| C-09 | デフォルトJVMヒープは256MB | E-06 (jenkins.xml: -Xmx256m) | ○ |
| C-10 | SuspiciousRequestFilterが存在 | E-05 (web-fragment.xml) | ○ |
| C-11 | HudsonFilterが認証を担当 | E-05 (web-fragment.xml) | ○ |
| C-12 | CspFilterが存在 | E-05 (web-fragment.xml) | ○ |
| C-13 | CrumbFilterがCSRF保護を担当 | E-05 (web-fragment.xml) | ○ |
| C-14 | Spring Securityを使用 | E-03 (core/pom.xml: spring-security-web) | ○ |
| C-15 | Apache Mina SSHD 2.16.0を使用 | E-02 (war/pom.xml: mina-sshd-api.version) | ○ |
| C-16 | maven-21, maven-25ラベルのエージェント使用 | E-04 (Jenkinsfile: agentContainerLabel) | ○ |
| C-17 | Windowsエージェントは最新JDKのみ | E-04 (Jenkinsfile: if platform == 'windows') | ○ |
| C-18 | docker-highmemラベルをATHで使用 | E-04 (Jenkinsfile: node('docker-highmem')) | ○ |
| C-19 | リトライ回数は最大2回 | E-04 (Jenkinsfile: count: 2) | ○ |
| C-20 | ログローテーションで50ビルド保持 | E-04 (Jenkinsfile: numToKeepStr: '50') | ○ |
| C-21 | アーティファクトは3ビルド分保持 | E-04 (Jenkinsfile: artifactNumToKeepStr: '3') | ○ |
| C-22 | WinSWで自動再起動が設定 | E-06 (jenkins.xml: onfailure action="restart") | ○ |
| C-23 | 停止タイムアウトは10秒 | E-06 (jenkins.xml: stopTimeout=10000) | ○ |
| C-24 | JaCoCoでカバレッジ計測 | E-04 (Jenkinsfile: recordCoverage, jacoco) | ○ |
| C-25 | SpotBugs閾値はMedium | E-01 (pom.xml: spotbugs.threshold) | ○ |
| C-26 | WAR/DEB/RPM/MSI形式で配布 | E-09 (publish-release-artifact.yml) | ○ |
| C-27 | Launchableサービスとの連携あり | E-04 (Jenkinsfile: launchable) | ○ |
| C-28 | TRACEメソッドが無効化 | E-05 (web-fragment.xml: Disable TRACE) | ○ |
| C-29 | 本番推奨メモリは4GB以上 | **根拠なし** | △ |
| C-30 | バックアップ頻度は日次推奨 | **根拠なし** | △ |
| C-31 | HA構成の場合は複数台 | **根拠なし** | △ |
| C-32 | Kubernetesクラスタ詳細構成 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **本番環境の推奨スペック**: ソースコードからは本番環境の推奨スペックは確認できない
  - 候補：公式ドキュメント / Jenkins Wiki / ハードウェア推奨ガイド
- **バックアップ頻度・保持期間**: プロジェクト固有の運用ポリシーに依存
  - 候補：運用マニュアル / SLA要件定義 / DR計画書
- **HA構成詳細**: 本リポジトリはJenkinsコア開発用であり、HA構成はプラグインやインフラ依存
  - 候補：kubernetes-plugin / CloudFormation/Terraform構成
- **Kubernetesクラスタ詳細**: ci.jenkins.ioの実際の構成は別リポジトリ（jenkins-infra）で管理
  - 候補：jenkins-infra/kubernetes-management / jenkins-infra/charts

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - サーバー構成、ミドルウェアバージョン、ネットワーク構成
  - ソースコードから直接確認可能な内容
- **0: 低リスク** - セキュリティフィルター構成
  - web-fragment.xmlで明確に定義
- **1: 中リスク** - スケーリング設計
  - CIパイプラインでの構成は確認できるが、本番推奨は別途確認が必要
- **1: 中リスク** - 可用性設計
  - Windowsサービス設定は確認できるが、他プラットフォームの設定は限定的
- **2: 高リスク** - バックアップ設計の推奨値
  - プロジェクト固有要件であり、一般的な推奨値を記載

## 6) レビュアーチェックリスト（最小）

- [ ] 本番環境で使用する場合、JVMメモリ設定を公式ドキュメントで確認
- [ ] バックアップポリシーは組織のRPO/RTO要件に基づいて設定
- [ ] HA構成が必要な場合、jenkins-infraリポジトリや公式ドキュメントを参照
- [ ] セキュリティ設定（HTTPS化、認証設定）は別途確認が必要
- [ ] 外部サービス連携のURLは最新のものか確認（特にget.jenkins.io）
- [ ] Kubernetesデプロイの場合、公式Helm Chartを参照
