# インフラ構成図

## システム全体構成図

```mermaid
flowchart TB
    subgraph Users["ユーザー"]
        Browser["Webブラウザ"]
        CLI["Jenkins CLI"]
        API["REST APIクライアント"]
    end

    subgraph JenkinsMaster["Jenkinsマスター"]
        subgraph WebLayer["Webレイヤー"]
            Winstone["Winstone<br/>(Jetty 12 EE9)"]
            Stapler["Stapler<br/>サーブレット"]
        end

        subgraph SecurityFilters["セキュリティフィルター"]
            SuspiciousFilter["SuspiciousRequestFilter"]
            HudsonFilter["HudsonFilter<br/>(認証)"]
            CSPFilter["CSPFilter"]
            CrumbFilter["CrumbFilter<br/>(CSRF)"]
        end

        subgraph Core["Jenkins Core"]
            Scheduler["ジョブスケジューラー"]
            PluginManager["プラグインマネージャー"]
            SecurityRealm["セキュリティレルム"]
            Remoting["Remoting<br/>エージェント通信"]
        end

        subgraph Storage["ストレージ"]
            JenkinsHome["JENKINS_HOME<br/>設定・ジョブ・ビルド履歴"]
        end
    end

    subgraph Agents["ビルドエージェント"]
        Agent1["エージェント 1<br/>(Linux)"]
        Agent2["エージェント 2<br/>(Windows)"]
        AgentN["エージェント N<br/>(動的)"]
    end

    subgraph ExternalServices["外部サービス"]
        MavenRepo["repo.jenkins-ci.org<br/>Mavenリポジトリ"]
        PluginRepo["plugins.jenkins.io<br/>プラグイン"]
        DockerHub["Docker Hub<br/>コンテナイメージ"]
        GitHub["GitHub<br/>ソースコード"]
    end

    Browser -->|HTTP:8080| Winstone
    CLI -->|HTTP:8080| Winstone
    API -->|HTTP:8080| Winstone

    Winstone --> Stapler
    Stapler --> SuspiciousFilter
    SuspiciousFilter --> HudsonFilter
    HudsonFilter --> CSPFilter
    CSPFilter --> CrumbFilter
    CrumbFilter --> Core

    Scheduler --> PluginManager
    Core --> JenkinsHome

    Remoting -->|TCP:50000<br/>JNLP| Agent1
    Remoting -->|TCP:50000<br/>JNLP| Agent2
    Remoting -->|TCP:50000<br/>JNLP| AgentN

    PluginManager -->|HTTPS| MavenRepo
    PluginManager -->|HTTPS| PluginRepo
    Scheduler -->|HTTPS| DockerHub
    Scheduler -->|HTTPS/SSH| GitHub
```

## CI/CDパイプライン構成図

```mermaid
flowchart LR
    subgraph GitHubActions["GitHub Actions"]
        Release["リリーストリガー"]
    end

    subgraph JenkinsCI["Jenkins CI (ci.jenkins.io)"]
        subgraph BuildStage["ビルドステージ"]
            RecordBuild["Record Build<br/>(Launchable)"]
        end

        subgraph ParallelBuilds["並列ビルド"]
            LinuxJDK21["Linux JDK 21"]
            LinuxJDK25["Linux JDK 25"]
            WindowsJDK25["Windows JDK 25"]
        end

        subgraph ATH["ATH (Acceptance Test)"]
            ATHLinux["ATH Linux<br/>Firefox + JDK 21"]
        end

        subgraph Publishing["パブリッシュ"]
            Coverage["コードカバレッジ"]
            StaticAnalysis["静的解析"]
            Artifacts["アーティファクト"]
        end
    end

    subgraph Distribution["配布"]
        WAR["jenkins.war"]
        DEB["jenkins.deb"]
        RPM["jenkins.rpm"]
        MSI["jenkins.msi"]
        Docker["Docker Image"]
    end

    Release --> RecordBuild
    RecordBuild --> LinuxJDK21
    RecordBuild --> LinuxJDK25
    RecordBuild --> WindowsJDK25
    RecordBuild --> ATHLinux

    LinuxJDK21 --> Coverage
    LinuxJDK21 --> StaticAnalysis
    LinuxJDK21 --> Artifacts

    Artifacts --> WAR
    Artifacts --> DEB
    Artifacts --> RPM
    Artifacts --> MSI
    Artifacts --> Docker
```

## Kubernetesエージェント構成図

```mermaid
flowchart TB
    subgraph K8sCluster["Kubernetesクラスター"]
        subgraph MasterPod["マスターPod"]
            JenkinsMaster["Jenkinsマスター"]
        end

        subgraph AgentPods["エージェントPod群"]
            subgraph Linux["Linux Pods"]
                Maven21["maven-21"]
                Maven25["maven-25"]
            end

            subgraph Windows["Windows Pods"]
                Maven21Win["maven-21-windows"]
                Maven25Win["maven-25-windows"]
                Maven25WinNonSpot["maven-25-windows-nonspot<br/>(フォールバック)"]
            end

            subgraph HighMem["高メモリPods"]
                DockerHighMem["docker-highmem<br/>(ATH用)"]
            end
        end
    end

    JenkinsMaster -->|Remoting| Maven21
    JenkinsMaster -->|Remoting| Maven25
    JenkinsMaster -->|Remoting| Maven21Win
    JenkinsMaster -->|Remoting| Maven25Win
    JenkinsMaster -->|リトライ時| Maven25WinNonSpot
    JenkinsMaster -->|Remoting| DockerHighMem
```

## セキュリティ構成図

```mermaid
flowchart TB
    subgraph Request["リクエスト処理"]
        Incoming["着信リクエスト"]

        subgraph FilterChain["フィルターチェーン"]
            F1["SuspiciousRequestFilter<br/>不審リクエスト検出"]
            F2["DiagnosticThreadNameFilter<br/>診断情報"]
            F3["CharacterEncodingFilter<br/>文字エンコーディング"]
            F4["UncaughtExceptionFilter<br/>例外処理"]
            F5["HudsonFilter<br/>認証・認可"]
            F6["CspFilter<br/>CSP設定"]
            F7["CrumbFilter<br/>CSRF保護"]
            F8["ErrorAttributeFilter<br/>エラー処理"]
            F9["PluginServletFilter<br/>プラグインフィルター"]
        end

        subgraph SecurityRoles["セキュリティロール"]
            Admin["admin"]
            User["user"]
            Hudson["hudson"]
        end

        Application["アプリケーション処理"]
    end

    Incoming --> F1
    F1 --> F2
    F2 --> F3
    F3 --> F4
    F4 --> F5
    F5 --> F6
    F6 --> F7
    F7 --> F8
    F8 --> F9
    F9 --> SecurityRoles
    SecurityRoles --> Application
```

## ストレージ構成図

```mermaid
flowchart TB
    subgraph JenkinsHome["JENKINS_HOME"]
        Config["config.xml<br/>グローバル設定"]

        subgraph Jobs["jobs/"]
            Job1["ジョブ1/config.xml"]
            Job1Builds["ジョブ1/builds/"]
        end

        subgraph Plugins["plugins/"]
            DetachedPlugins["WEB-INF/detached-plugins/<br/>デタッチドプラグイン"]
            InstalledPlugins["インストール済みプラグイン"]
        end

        subgraph Users["users/"]
            UserConfig["users.xml"]
            UserDirs["ユーザーディレクトリ"]
        end

        subgraph Nodes["nodes/"]
            NodeConfig["エージェント設定"]
        end

        subgraph Secrets["secrets/"]
            MasterKey["master.key"]
            Credentials["credentials.xml"]
        end

        Logs["logs/<br/>ログファイル"]
        War["war/<br/>展開済みWAR"]
    end

    subgraph Persistence["永続化"]
        XStream["XStream<br/>XMLシリアライゼーション"]
    end

    Config --> XStream
    Jobs --> XStream
    Users --> XStream
    Nodes --> XStream
```

## デプロイメント構成図

```mermaid
flowchart TB
    subgraph Build["ビルド"]
        Maven["Maven Build"]
        WAR["jenkins.war<br/>(実行可能WAR)"]
    end

    subgraph Deployment["デプロイオプション"]
        subgraph Standalone["スタンドアロン"]
            StandaloneJava["java -jar jenkins.war"]
        end

        subgraph Container["コンテナ"]
            Tomcat["Apache Tomcat"]
            Jetty["Jetty (外部)"]
            WildFly["WildFly"]
        end

        subgraph WindowsSvc["Windowsサービス"]
            WinSW["WinSW<br/>サービスラッパー"]
            JenkinsExe["jenkins.exe"]
        end

        subgraph DockerDeploy["Docker"]
            DockerImage["jenkins/jenkins"]
            DockerCompose["docker-compose"]
        end

        subgraph K8s["Kubernetes"]
            Helm["Helm Chart"]
            Operator["Jenkins Operator"]
        end

        subgraph Package["OSパッケージ"]
            DebPkg[".deb<br/>(Debian/Ubuntu)"]
            RpmPkg[".rpm<br/>(RHEL/CentOS)"]
            MsiPkg[".msi<br/>(Windows)"]
        end
    end

    Maven --> WAR
    WAR --> StandaloneJava
    WAR --> Tomcat
    WAR --> Jetty
    WAR --> WildFly
    WAR --> WinSW
    WinSW --> JenkinsExe
    WAR --> DockerImage
    DockerImage --> DockerCompose
    DockerImage --> Helm
    DockerImage --> Operator
    WAR --> DebPkg
    WAR --> RpmPkg
    WAR --> MsiPkg
```
