# インフラ設計書

## 概要

本ドキュメントは、Jenkins（バージョン 2.548）の本体ソースコードリポジトリにおけるインフラ構成を記述したものです。Jenkinsは、Javaベースの継続的インテグレーション/継続的デリバリー（CI/CD）自動化サーバーであり、WAR形式、Docker、ネイティブパッケージなど複数のデプロイ形態をサポートしています。

## システム構成

### 全体構成

Jenkinsは以下の構成要素で構成されています：

1. **アプリケーションサーバー（Winstone/Jetty内蔵）**
   - 組み込みサーブレットコンテナとしてWinstone（Jetty 12ベース）を使用
   - スタンドアロンのWARファイルとして実行可能
   - 外部サーブレットコンテナ（Tomcat等）へのデプロイも対応

2. **クライアント接続**
   - Webブラウザ経由のUI操作
   - CLI経由のコマンドライン操作
   - REST API経由のプログラマティックアクセス

3. **エージェント通信**
   - Remotingプロトコルを使用したビルドエージェント（スレーブ）との通信
   - WebSocket対応（jetty12-ee9実装）

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| Jenkinsマスター | CI/CDオーケストレーション、WebUI提供、ジョブスケジューリング | JVM: 256MB以上（推奨: 4GB以上）、JDK 21/25対応 | 1（HA構成の場合は複数） |
| ビルドエージェント | ビルド・テスト実行 | プロジェクト要件に依存 | 0〜N（スケーラブル） |
| Dockerホスト | ATH実行用コンテナ実行環境 | Docker対応Linux | 必要に応じて |

### ネットワーク構成

| ポート | プロトコル | 用途 |
| --- | --- | --- |
| 8080 | HTTP | WebUI、REST API（デフォルト） |
| 50000 | TCP/IP | エージェント接続（JNLP） |
| カスタム | SSH | SSHベースのエージェント接続（sshdモジュール） |

**セキュリティフィルター構成**：
- SuspiciousRequestFilter: 不審なリクエストのフィルタリング
- HudsonFilter: 認証処理
- CspFilter: Content Security Policy
- CrumbFilter: CSRF保護

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Winstone | 8.1029.vd3071f6b_5988 | 組み込みサーブレットコンテナ（Jettyベース） |
| Jetty EE9 | 12.1.5 | Webサーブレット処理、WebSocket対応 |
| Java (JDK) | 21, 25 | アプリケーション実行ランタイム |
| Node.js | 24.13.0 | フロントエンドビルド（webpack） |
| Yarn | 4.12.0 | Node.js パッケージマネージャー |
| Maven | 3.x | ビルドツール |
| Groovy | バンドル版 | スクリプト実行、Jellyテンプレート |
| Spring Security | バンドル版 | 認証・認可フレームワーク |
| Apache Mina SSHD | 2.16.0-167 | SSH接続サポート |
| Remoting | 3355.v388858a_47b_33 | エージェント通信プロトコル |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| repo.jenkins-ci.org | Mavenリポジトリ、プラグイン配布 | HTTPS |
| get.jenkins.io | リリースアーティファクト配布 | HTTPS |
| plugins.jenkins.io | プラグインカタログ | HTTPS |
| Docker Hub | Dockerイメージ配布（jenkins/jenkins） | HTTPS |
| GitHub | ソースコード管理、Issues、PR | HTTPS/SSH |
| Launchable | テスト最適化サービス（CI） | HTTPS |
| DigiCert TSA | タイムスタンプサービス（署名時） | HTTP |

## スケーリング設計

### 水平スケーリング

1. **ビルドエージェントスケーリング**
   - Jenkins Cloudプラグインによる動的エージェントプロビジョニング
   - Kubernetes、Docker、EC2等のクラウドプラグインによるオンデマンドエージェント
   - エージェント接続はRemotingプロトコル経由

2. **Kubernetesエージェント**（CIパイプライン）
   - `maven-21`, `maven-25` ラベルのPodテンプレート
   - `maven-21-windows`, `maven-25-windows` Windows対応
   - `docker-highmem` ATH実行用高メモリコンテナ
   - 非Spotインスタンスへのフォールバック対応

### 垂直スケーリング

- JVMヒープサイズの調整（デフォルト: 256MB、本番推奨: 4GB以上）
- `-Xmx` パラメータによるメモリ割り当て

## 可用性設計

### フェイルオーバー方式

1. **Windowsサービス構成**
   - WinSW（Windows Service Wrapper）による自動再起動
   - `<onfailure action="restart" />` 設定
   - RunawayProcessKillerExtensionによる異常プロセス終了時の対応

2. **プロセス監視**
   - PIDファイルによるプロセス状態管理
   - 停止タイムアウト: 10秒

3. **Kubernetesリトライ構成**（CI環境）
   - `kubernetesAgent` 条件でのリトライ（最大2回）
   - `nonresumable` 条件での再実行

### データ保護

- `JENKINS_HOME` ディレクトリによる設定・ジョブ・ビルド履歴の永続化
- XStream形式でのXMLシリアライゼーション

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| JENKINS_HOME | ファイルシステムバックアップ | 推奨: 日次 | プロジェクト要件に依存 |
| ビルドログ | logRotator設定 | numToKeepStr: 50 | ビルド50回分 |
| アーティファクト | artifactNumToKeepStr設定 | artifactNumToKeepStr: 3 | 直近3ビルド分 |
| 設定ファイル | SCMバックアップ推奨 | 変更時 | 無制限 |

## 監視設計

### ビルド監視

- realtimeJUnit: リアルタイムテスト結果表示
- healthScaleFactor: 20.0でヘルススコア計算

### 品質監視

| ツール | 対象 | 設定 |
| --- | --- | --- |
| JaCoCo | コードカバレッジ | jacoco-aggregate/jacoco.xml |
| SpotBugs | 静的解析（バグ検出） | threshold: Medium, effort: Max |
| Checkstyle | コードスタイル | checkstyle-configuration.xml |
| ESLint | JavaScriptコード | eslint.config.cjs |
| Stylelint | SCSS/CSSコード | .stylelintrc.js |

### 品質ゲート

- SpotBugs: 新規バグ1件でUNSTABLE
- Checkstyle: 違反1件でUNSTABLE
- ESLint: 警告1件でUNSTABLE
- Stylelint: 警告1件でUNSTABLE
- JavaDoc: 警告1件でUNSTABLE

## デプロイ形態

### 配布形式

| 形式 | 対象OS | 配布元 |
| --- | --- | --- |
| WAR | 全プラットフォーム | get.jenkins.io/war |
| Debian (.deb) | Debian/Ubuntu | get.jenkins.io/debian |
| RPM (.rpm) | RHEL/CentOS/Fedora | get.jenkins.io/rpm |
| MSI | Windows | get.jenkins.io/windows |
| Docker | 全プラットフォーム | docker.io/jenkins/jenkins |

### リリースライン

- **Weekly**: 毎週リリース、最新機能を含む
- **LTS (Long-Term Support)**: 安定版、バックポート修正

## 備考

### セキュリティ考慮事項

- HTTPS化推奨（プロキシ経由またはコネクタ設定）
- CSRF保護（CrumbFilter）がデフォルト有効
- Content Security Policy（CSP）が設定可能
- セッションCookieのHttpOnly属性が有効
- TRACEメソッドが無効化済み

### JVMオプション

Windowsサービス設定での推奨オプション：
```
-Xrs -Xmx256m -Dhudson.lifecycle=hudson.lifecycle.WindowsServiceLifecycle
```

追加推奨オプション（MANIFEST.MF）：
```
--add-opens java.base/java.lang=ALL-UNNAMED
--add-opens java.base/java.io=ALL-UNNAMED
--add-opens java.base/java.util=ALL-UNNAMED
```

### 参考情報

- 公式ドキュメント: https://www.jenkins.io/doc/
- プラグインインデックス: https://plugins.jenkins.io/
- GitHubリポジトリ: https://github.com/jenkinsci/jenkins
