---
generated_at: 2026-01-22 19:15:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **HTTPS/HSTS設定詳細**：リバースプロキシ設定はJenkins coreコードには含まれない
  2. **監査ログ保持期間**：具体的な設定値はJenkinsログ設定に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/security/SecurityRealm.java`
- E-02: `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java`
- E-03: `core/src/main/java/hudson/security/ACL.java`
- E-04: `core/src/main/java/hudson/security/AuthorizationStrategy.java`
- E-05: `core/src/main/java/hudson/security/Permission.java`
- E-06: `core/src/main/java/hudson/security/csrf/CrumbFilter.java`
- E-07: `core/src/main/java/hudson/security/csrf/DefaultCrumbIssuer.java`
- E-08: `core/src/main/java/jenkins/security/ApiTokenProperty.java`
- E-09: `core/src/main/java/hudson/util/Secret.java`
- E-10: `core/src/main/java/jenkins/security/CryptoConfidentialKey.java`
- E-11: `core/src/main/java/jenkins/security/ConfidentialKey.java`
- E-12: `core/src/main/java/jenkins/security/SecurityListener.java`
- E-13: `core/src/main/java/jenkins/security/csp/CspBuilder.java`
- E-14: `core/src/main/java/jenkins/security/FIPS140.java`(参照のみ、ファイル未読)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JenkinsはHudsonPrivateSecurityRealmで内部ユーザーDB認証を提供 | E-02 | ○ |
| C-02 | パスワードはBCrypt($2a$)でハッシュ化 | E-02 (JBCryptEncoder, BCRYPT_PATTERN) | ○ |
| C-03 | FIPS 140モードではPBKDF2(HMAC-SHA512)を使用 | E-02 (PBKDF2PasswordEncoder, FIPS_PASSWORD_LENGTH) | ○ |
| C-04 | PBKDF2のiteration数は210,000 | E-02 (ITTERATIONS = 210_000) | ○ |
| C-05 | セッション固定化対策としてSessionFixationProtectionStrategyを使用 | E-01 (createFilterImpl, line 672-673) | ○ |
| C-06 | Remember Me Cookieはセキュア属性を設定 | E-01 (resetRememberMeCookie, cookie.setSecure) | ○ |
| C-07 | APIトークンはSecureRandomで生成 | E-08 (RANDOM = new SecureRandom()) | ○ |
| C-08 | APIトークンはハッシュ値のみ保存 | E-08 (ApiTokenStore, matchingToken) | ○ |
| C-09 | ACLクラスでアクセス制御を実装 | E-03 (checkPermission, hasPermission2) | ○ |
| C-10 | ADMINISTER権限が最上位の権限 | E-05 (HUDSON_ADMINISTER, impliedBy=null) | ○ |
| C-11 | 権限階層構造を持つ(impliedBy) | E-05 (impliedBy field) | ○ |
| C-12 | CrumbFilterでCSRF対策を実装 | E-06 (doFilter, validateCrumb) | ○ |
| C-13 | CrumbトークンはSHA-256で生成 | E-07 (MessageDigest.getInstance("SHA-256")) | ○ |
| C-14 | Crumbはユーザー名+セッションIDで構成 | E-07 (issueCrumb, buffer.append(a.getName()), buffer.append(req.getSession().getId())) | ○ |
| C-15 | SecretクラスでAES暗号化を実装 | E-09 (KEY.encrypt, KEY.decrypt) | ○ |
| C-16 | AES-128-CBCで暗号化 | E-10 (ALGORITHM = "AES/CBC/PKCS5Padding", 128/8) | ○ |
| C-17 | IVは16バイト | E-10 (DEFAULT_IV_LENGTH = 16) | ○ |
| C-18 | SecurityListenerで認証イベントを通知 | E-12 (fireAuthenticated2, fireLoggedIn, fireLoggedOut) | ○ |
| C-19 | ユーザー作成イベントを記録 | E-12 (fireUserCreated) | ○ |
| C-20 | CspBuilderでCSPを構築 | E-13 (add, build, buildDirectives) | ○ |
| C-21 | report-uri/report-toは手動設定不可 | E-13 (PROHIBITED_KEYS) | ○ |
| C-22 | BCrypt最大cost factorは18 | E-02 (MAXIMUM_BCRYPT_LOG_ROUND = 18) | ○ |
| C-23 | FIPS 140モードの最小パスワード長は14文字 | E-02 (FIPS_PASSWORD_LENGTH = 14) | ○ |
| C-24 | @RequirePOSTアノテーションでPOST強制 | E-02, E-06, E-08 (複数箇所で使用) | ○ |
| C-25 | ConfidentialKeyで機密情報を保護 | E-11 (load, store) | ○ |
| C-26 | タイミング攻撃対策(パスワード検証) | E-02 (authenticate2, PASSWORD_ENCODER.matches for non-existent user) | ○ |
| C-27 | Crumb検証は定数時間比較 | E-07 (MessageDigest.isEqual) | ○ |
| C-28 | レガシートークンは非推奨 | E-08 (@Deprecated annotations) | ○ |
| C-29 | AuthorizationStrategy.Unsecuredは全権限付与 | E-04 (UNSECURED_ACL = lambda2((a, p) -> true)) | ○ |
| C-30 | FullControlOnceLoggedInAuthorizationStrategyが存在 | E-04 (getACLメソッド参照) | ○ |
| C-31 | Permission scopeにJENKINS, Item, Computer等が存在 | E-05 (PermissionScope参照) | ○ |
| C-32 | 権限はPermissionGroupでグループ化 | E-05 (group field) | ○ |
| C-33 | CrumbExclusionで特定パスを除外可能 | E-06 (CrumbExclusion.all(), e.process) | ○ |
| C-34 | HTTPヘッダーまたはパラメータでCrumb送信 | E-06 (extractCrumbFromRequest) | ○ |
| C-35 | Secret.fromStringで暗号化/復号を自動判定 | E-09 (fromString, decrypt) | ○ |
| C-36 | 暗号化データはBase64エンコード | E-09 (Base64.getEncoder().encodeToString) | ○ |
| C-37 | PAYLOAD_V1形式で暗号化メタデータを含む | E-09 (PAYLOAD_V1 = 1) | ○ |
| C-38 | HMACConfidentialKeyでMAC生成 | E-08 (API_KEY_SEED = new HMACConfidentialKey) | ○ |
| C-39 | 認証失敗イベントを記録 | E-12 (fireFailedToAuthenticate, fireFailedToLogIn) | ○ |
| C-40 | ログアウト時にセッション無効化 | E-01 (doLogoutImpl, session.invalidate()) | ○ |
| C-41 | ログアウト時にRemember Me Cookie削除 | E-01 (resetRememberMeCookie, cookie.setMaxAge(0)) | ○ |
| C-42 | CaptchaSupportでCAPTCHA対応 | E-02, E-01 (CaptchaSupport, validateCaptcha) | ○ |
| C-43 | ユーザー名は正規表現でバリデーション | E-02 (ID_REGEX, DEFAULT_ID_REGEX, containsOnlyAcceptableCharacters) | ○ |
| C-44 | HTTPS設定はリバースプロキシで推奨 | **根拠なし** | △ |
| C-45 | 監査ログの保持期間はJenkinsログ設定に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **HTTPS/HSTS設定詳細**
  - Jenkinsコアコードには直接的なHTTPS設定は含まれていない
  - 候補：Jetty設定ファイル / リバースプロキシ設定ドキュメント / Jenkins公式ドキュメント
- **監査ログ保持期間**
  - SecurityListenerはイベント発火のみで、永続化はログフレームワークに依存
  - 候補：java.util.logging設定 / Log4j設定 / 外部ログ管理システムドキュメント

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 認証・認可の基本設計 - コードで十分に確認可能
- **0 (低リスク)**: 暗号化方式 - AES-128-CBC、BCrypt、PBKDF2の使用を確認
- **0 (低リスク)**: CSRF対策 - CrumbFilter、SHA-256の使用を確認
- **1 (中リスク)**: 監査ログ - イベント発火は確認、永続化設定は要確認
- **1 (中リスク)**: HTTPS/HSTS - 本番環境での設定は運用ドキュメントで補完要

## 6) レビュアーチェックリスト（最小）
- [ ] BCryptとPBKDF2のパラメータがOWASP推奨に準拠しているか確認
- [ ] CSRF対策のCrumb除外パス(CrumbExclusion)が意図通りか確認
- [ ] APIトークンの生成・検証フローがセキュリティ要件を満たすか確認
- [ ] 本番環境でのHTTPS/HSTS設定が別途ドキュメント化されているか確認
- [ ] 監査ログの保持ポリシーが組織のコンプライアンス要件を満たすか確認
- [ ] プラグインによるセキュリティ拡張(LDAP、Role-based Strategy等)の設計を別途レビュー
