# セキュリティ設計書

## 概要

本ドキュメントは、Jenkinsのセキュリティアーキテクチャを記載したセキュリティ設計書です。Jenkinsは継続的インテグレーション/継続的デリバリー(CI/CD)を実現するオープンソースの自動化サーバーであり、プラグイン可能なセキュリティレルム(SecurityRealm)と認可戦略(AuthorizationStrategy)を通じて柔軟なセキュリティモデルを提供しています。

## 認証設計

### 認証方式

Jenkinsは複数の認証方式をサポートしています。

| 認証方式 | 実装クラス | 説明 |
| --- | --- | --- |
| Jenkins内部ユーザーデータベース | `HudsonPrivateSecurityRealm` | Jenkins独自のユーザーデータベースを使用した認証。BCryptまたはPBKDF2でパスワードをハッシュ化 |
| 外部認証(LDAP等) | `SecurityRealm`の拡張 | プラグインによる外部認証システムとの連携 |
| コンテナ認証 | `LegacySecurityRealm` | サーブレットコンテナ(Jetty等)の認証機能を使用 |
| API Token認証 | `ApiTokenProperty` | REST API呼び出し用のトークンベース認証 |
| Basic認証 | `BasicHeaderProcessor` | HTTPヘッダーによる基本認証 |
| Remember Me | `TokenBasedRememberMeServices2` | 継続的ログインのためのCookieベース認証 |

### パスワードハッシュ方式

| 方式 | 使用条件 | パラメータ |
| --- | --- | --- |
| BCrypt | 通常モード(非FIPS) | cost factor: デフォルト10、最大18 |
| PBKDF2 (HMAC-SHA512) | FIPS 140準拠モード | iterations: 210,000、key length: 512bit、salt: 16bytes |

### セッション管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| セッション固定化対策 | SessionFixationProtectionStrategy | 認証成功時にセッションIDを再生成 |
| セッションCookie名 | JSESSIONID | Jettyによるデフォルト |
| Remember Me Cookie | SPRING_SECURITY_REMEMBER_ME_COOKIE | HttpOnly属性、Secure属性(HTTPS時)を設定 |
| SameSite属性 | 対応 | JettySameSiteCookieSetupで設定 |

### APIトークン管理

| 項目 | 設定値 | 備考 |
| --- | --- | --- |
| トークン生成 | SecureRandomによるランダム生成 | 128bit以上のエントロピー |
| トークン保存 | ハッシュ値のみ保存 | 平文は生成時のみ表示 |
| トークン使用統計 | オプション機能 | ApiTokenStatsで管理 |
| レガシートークン | 非推奨 | 新方式への移行を推奨 |

## 認可設計

### 権限体系

Jenkinsは階層的な権限モデルを採用しています。

| ロール | 権限 | 説明 |
| --- | --- | --- |
| ADMINISTER | 全権限 | システム管理者。他の全ての権限を含む |
| READ | 読み取り | 基本的な読み取り権限 |
| WRITE | 書き込み | 設定変更を含む書き込み権限 |
| CREATE | 作成 | 新規アイテム作成権限(WRITEに含まれる) |
| UPDATE | 更新 | 既存アイテム更新権限(WRITEに含まれる) |
| DELETE | 削除 | アイテム削除権限(WRITEに含まれる) |
| CONFIGURE | 設定 | 設定変更権限(UPDATEに含まれる) |

### アクセス制御

Jenkinsは`ACL`(Access Control List)クラスを通じてアクセス制御を実装しています。

#### AuthorizationStrategy

| 戦略 | 実装クラス | 説明 |
| --- | --- | --- |
| 無制限 | `AuthorizationStrategy.Unsecured` | 全員に全権限を付与(開発環境用) |
| ログイン後全権限 | `FullControlOnceLoggedInAuthorizationStrategy` | 認証済みユーザーに全権限を付与 |
| レガシー方式 | `LegacyAuthorizationStrategy` | 管理者以外はビルドのみ可能 |
| プラグイン拡張 | `AuthorizationStrategy`の拡張 | Matrix-based、Role-based等 |

#### 権限スコープ

| スコープ | 説明 |
| --- | --- |
| JENKINS | グローバルスコープ(Jenkins全体) |
| Item | ジョブ/プロジェクト単位 |
| Computer | エージェント/ノード単位 |
| View | ビュー単位 |
| User | ユーザー単位 |
| Cloud | クラウド設定単位 |

## 通信セキュリティ

| 項目 | 対策 |
| --- | --- |
| HTTPS | リバースプロキシまたはJettyでの直接設定を推奨 |
| HSTS | リバースプロキシでの設定を推奨 |
| WebSocket | wss://プロトコルをサポート(Jetty12EE9Provider) |
| エージェント通信 | JNLPプロトコル4(暗号化)を使用 |

## データセキュリティ

### 暗号化

| 対象 | 暗号化方式 |
| --- | --- |
| 保存データ(Secret) | AES-128-CBC (CryptoConfidentialKey) |
| 初期化ベクトル(IV) | 16bytes、SecureRandomで生成 |
| 鍵管理 | ConfidentialStoreによる集中管理 |
| パスワードハッシュ | BCrypt($2a$)またはPBKDF2(FIPS 140モード) |
| HMAC | HMACConfidentialKeyで実装 |
| デジタル署名 | RSA(RSADigitalSignatureConfidentialKey) |

### 機密情報管理

| 機密情報の種類 | 管理方式 |
| --- | --- |
| パスワード/シークレット | `Secret`クラスで暗号化保存 |
| APIトークン | ハッシュ値のみ保存(平文は保存しない) |
| プライベートキー | `ConfidentialKey`による保護 |
| Jenkins Master Key | `$JENKINS_HOME/secrets/master.key`に保存 |

#### ConfidentialKeyの種類

| クラス | 用途 |
| --- | --- |
| `CryptoConfidentialKey` | AES暗号化用の秘密鍵 |
| `HMACConfidentialKey` | メッセージ認証コード生成用 |
| `HexStringConfidentialKey` | 16進数文字列形式の鍵 |
| `RSAConfidentialKey` | RSA公開鍵暗号用キーペア |

## 入出力対策

| 脅威 | 対策 |
| --- | --- |
| XSS | Jelly/Groovyテンプレートでのエスケープ処理、CSP(Content Security Policy)の適用 |
| SQLインジェクション | パラメータバインディング(該当箇所では使用)、Jenkins独自のXML永続化を主に使用 |
| CSRF | CrumbIssuerによるトークン検証、@RequirePOSTアノテーション |
| パストラバーサル | ファイルパスの正規化、サニタイズ処理 |
| XML外部実体参照(XXE) | XMLパーサーの安全な設定 |

### CSRF対策詳細

| 項目 | 実装 |
| --- | --- |
| Crumbトークン生成 | `DefaultCrumbIssuer`(SHA-256ベース) |
| トークン構成要素 | ユーザー名 + セッションID + ソルト |
| 検証タイミング | POSTリクエスト時 |
| トークン送信方法 | HTTPヘッダー(`Jenkins-Crumb`)またはフォームパラメータ |
| 除外パス | `CrumbExclusion`で定義(CLI, webhook等) |

### Content Security Policy (CSP)

| ディレクティブ | 説明 |
| --- | --- |
| default-src | デフォルトのリソース取得元制限 |
| script-src | JavaScriptの取得元制限 |
| style-src | CSSの取得元制限 |
| img-src | 画像の取得元制限 |
| frame-ancestors | iframe埋め込み元制限 |
| report-uri / report-to | CSP違反レポート送信先 |

CSPは`CspBuilder`クラスで構築され、`Contributor`拡張ポイントでプラグインがカスタマイズ可能です。

## 監査ログ

| ログ種別 | 記録内容 | 保持期間 |
| --- | --- | --- |
| 認証成功 | ユーザー名、タイムスタンプ、付与された権限 | Jenkinsログ設定に依存 |
| 認証失敗 | ユーザー名、タイムスタンプ | Jenkinsログ設定に依存 |
| ログイン | ユーザー名、タイムスタンプ | Jenkinsログ設定に依存 |
| ログアウト | ユーザー名、タイムスタンプ | Jenkinsログ設定に依存 |
| ユーザー作成 | ユーザー名、タイムスタンプ | Jenkinsログ設定に依存 |

### SecurityListener

`SecurityListener`クラスが以下のセキュリティイベントをリスナーに通知します。

| イベント | メソッド | 説明 |
| --- | --- | --- |
| authenticated | `fireAuthenticated2()` | 認証成功時 |
| failedToAuthenticate | `fireFailedToAuthenticate()` | 認証失敗時 |
| loggedIn | `fireLoggedIn()` | ログイン成功時 |
| failedToLogIn | `fireFailedToLogIn()` | ログイン失敗時 |
| loggedOut | `fireLoggedOut()` | ログアウト時 |
| userCreated | `fireUserCreated()` | ユーザー作成時 |

## FIPS 140準拠

Jenkinsは`FIPS140`クラスを通じてFIPS 140準拠モードをサポートしています。

| 項目 | 通常モード | FIPS 140モード |
| --- | --- | --- |
| パスワードハッシュ | BCrypt | PBKDF2 (HMAC-SHA512) |
| 最小パスワード長 | なし | 14文字 |
| 暗号化アルゴリズム | AES-128-CBC | AES-128-CBC(FIPS認定プロバイダ使用) |

## 備考

### セキュリティに関する推奨事項

1. **本番環境での認証**: `HudsonPrivateSecurityRealm`またはLDAP/Active Directory等の外部認証を使用
2. **認可戦略**: Matrix-based AuthorizationまたはRole-based Strategy プラグインの使用を推奨
3. **HTTPS**: 本番環境では必ずHTTPSを有効化
4. **APIトークン**: パスワードの代わりにAPIトークンの使用を推奨
5. **定期的なセキュリティ更新**: Jenkins本体およびプラグインの定期的な更新

### 関連する設定ファイル

| ファイル | パス | 説明 |
| --- | --- | --- |
| config.xml | `$JENKINS_HOME/config.xml` | グローバル設定(認証・認可含む) |
| secrets/ | `$JENKINS_HOME/secrets/` | 暗号鍵の保存ディレクトリ |
| users/ | `$JENKINS_HOME/users/` | ユーザー情報の保存ディレクトリ |
