---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **カバレッジ目標値**：明示的な目標値が設定されていないと記載したが、組織ポリシー文書等で別途定義されている可能性
  2. **性能テスト実施タイミング**：リリース前と記載したが、具体的な性能テスト設定ファイルが見つからない

## 2) 参照した情報（Evidence一覧）

- E-01: `pom.xml`（ルート）
- E-02: `test/pom.xml`
- E-03: `core/pom.xml`
- E-04: `coverage/pom.xml`
- E-05: `Jenkinsfile`
- E-06: `ath.sh`
- E-07: `CONTRIBUTING.md`
- E-08: `.github/workflows/changelog.yml`
- E-09: `.github/workflows/*.yml`（GitHub Actions設定群）
- E-10: `test/src/test/java/`（テストソースディレクトリ構造）
- E-11: `core/src/test/java/`（coreテストソースディレクトリ構造）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JUnit Jupiterを単体テストフレームワークとして使用 | E-02, E-03 | ○ |
| C-02 | Jenkins Test Harnessバージョン 2545.va_5c4d17e3_ef | E-02 | ○ |
| C-03 | ATHバージョン 6518.v018e9d499cf2 | E-06 | ○ |
| C-04 | JaCoCo 0.8.14によるカバレッジ計測 | E-01 | ○ |
| C-05 | Checkstyle 13.0.0による静的解析 | E-01 | ○ |
| C-06 | Maven Surefire Pluginでテスト実行 | E-01, E-02 | ○ |
| C-07 | light-testプロファイルで単体テストのみ実行 | E-02 | ○ |
| C-08 | smoke-testプロファイルでSmokeTestタグ付きテスト実行 | E-02 | ○ |
| C-09 | all-testsプロファイルがデフォルト | E-02 | ○ |
| C-10 | enable-jacocoプロファイルでカバレッジ有効化 | E-02, E-03, E-04 | ○ |
| C-11 | CI環境はLinux JDK21/25とWindows JDK25 | E-05 | ○ |
| C-12 | Windows環境はJDK25のみ（リソース効率化） | E-05 | ○ |
| C-13 | Launchableでテストサブセット選択 | E-05 | ○ |
| C-14 | PRビルド時Linux 100%、Windows 30%のテスト実行 | E-05 | ○ |
| C-15 | full-testラベルで全テスト実行 | E-05 | ○ |
| C-16 | ATHはLinux JDK21 Firefox環境で実行 | E-05, E-06 | ○ |
| C-17 | SpotBugsで新規issue=unstable | E-05 | ○ |
| C-18 | Checkstyle違反1件でunstable | E-05 | ○ |
| C-19 | surefire.skipAfterFailureCount=100 | E-02 | ○ |
| C-20 | releaseプロファイルで失敗テスト再実行 | E-02 | ○ |
| C-21 | JDK 21または25が必要 | E-07 | ○ |
| C-22 | Maven 3.9.6以上が必要 | E-07 | ○ |
| C-23 | JVMオプション--add-opensが必要 | E-02, E-03, E-07 | ○ |
| C-24 | フロントエンドテストはyarn lint実行 | E-01, E-07 | ○ |
| C-25 | GitHub Issuesで不具合管理 | E-01, E-07 | ○ |
| C-26 | ci.jenkins.ioでCI実行 | E-05, E-07 | ○ |
| C-27 | カバレッジ目標値は明示的に設定されていない | **根拠なし** | △ |
| C-28 | 性能テストはリリース前に実施 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **カバレッジ目標値（C-27）**: pom.xmlやJenkinsfileにカバレッジ閾値の設定がない。組織レベルのポリシー文書や外部ドキュメントで定義されている可能性あり。
  - 候補：Jenkins Wiki / 内部ポリシー文書 / SLAドキュメント

- **性能テスト詳細（C-28）**: 明示的な性能テスト設定（JMeter設定、Gatling設定等）が見つからない。別リポジトリまたは手動テストの可能性。
  - 候補：jenkins-infra リポジトリ / 別途性能テストリポジトリ / 手動テスト手順書

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: テストフレームワーク・ツールの記載 - pom.xmlとJenkinsfileから直接確認可能
- **0（低リスク）**: CI/CD構成 - Jenkinsfileに明確に定義
- **0（低リスク）**: テストプロファイル - test/pom.xmlに明確に定義
- **1（中リスク）**: カバレッジ目標 - 目標値がないことの確認は難しい（設定がないことの証明）
- **1（中リスク）**: 性能テスト - 実施有無の確認が必要

## 6) レビュアーチェックリスト（最小）

- [ ] JUnit Jupiter / Test Harness / ATHのバージョンが最新のpom.xmlと一致するか確認
- [ ] Jenkinsfileのビルドマトリックス設定と記載内容が一致するか確認
- [ ] カバレッジ目標値について組織ポリシーを確認（存在する場合は追記が必要）
- [ ] 性能テストの実施有無・方法について関係者に確認
- [ ] ATHのSmokeTestタグの対象テスト範囲が適切か確認
- [ ] IntelliJ IDEAの回避策が現在も有効か確認（JetBrains/intellij-community#1976の状況）
