# テスト方針書

## 概要

本ドキュメントは、Jenkins（継続的インテグレーション/継続的デリバリーサーバー）のテスト方針を定義します。Jenkinsは大規模なオープンソースプロジェクトであり、複数のテストレベルと種別を組み合わせた包括的なテスト戦略を採用しています。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のクラス・メソッドの動作検証 | 開発者 |
| 結合テスト | モジュール間の連携検証、機能テスト | 開発者・CI |
| システムテスト | Jenkins全体としての動作検証（ATH） | CI・QAチーム |
| 受入テスト | ユーザー視点での機能検証（ATH Smoke Test） | CI・コミュニティ |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | コア機能の正常動作確認 | PRマージ前（CI） |
| 性能テスト | ビルド実行速度・メモリ使用量の検証 | リリース前 |
| セキュリティテスト | 脆弱性スキャン・セキュリティ監査 | 継続的（SpotBugs） |
| 静的解析テスト | コード品質・スタイルの検証 | コミット時（CI） |
| 回帰テスト | 既存機能への影響確認 | PRマージ前（CI） |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発時のテスト実行 | JDK 21/25、Maven 3.9.6以上 |
| CI環境（Linux） | 自動テスト実行 | ci.jenkins.io、Kubernetes Pod（maven-21/maven-25） |
| CI環境（Windows） | クロスプラットフォーム検証 | ci.jenkins.io、maven-25-windows |
| ATH環境 | E2Eテスト実行 | Docker Compose、Firefox |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| JUnit Jupiter | 単体テストフレームワーク | 5.x（junit-jupiter） |
| Jenkins Test Harness | 機能テストフレームワーク | 2545.va_5c4d17e3_ef |
| Acceptance Test Harness (ATH) | E2E・受入テスト | 6518.v018e9d499cf2 |
| Mockito | モックライブラリ | mockito-junit-jupiter |
| JaCoCo | コードカバレッジ計測 | 0.8.14 |
| Maven Surefire Plugin | テスト実行 | 親POMで指定 |
| SpotBugs | 静的バグ検出 | 親POMで指定 |
| Checkstyle | コードスタイル検証 | 13.0.0 |
| ESLint | JavaScriptリント | package.jsonで指定 |
| StyleLint | CSSリント | package.jsonで指定 |
| Prettier | コードフォーマッター | package.jsonで指定 |
| Spotless | Javaコードフォーマッター | 親POMで指定 |
| Launchable | テスト最適化・予測 | CLI経由 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値は設定されていない（計測のみ） |
| 分岐カバレッジ | 明示的な目標値は設定されていない（計測のみ） |

**補足**: JaCoCoによるカバレッジ計測は `enable-jacoco` プロファイルで有効化され、CI環境で集約レポートが生成されます。カバレッジ対象は以下のパッケージです：
- `hudson/*`
- `hudson/**/*`
- `jenkins/*`
- `jenkins/**/*`
- `org/jenkins/**/*`

## テストデータ

テストデータの準備方針は以下の通りです：

1. **XMLテストリソース**: `src/test/resources/` 配下に設定ファイル・データファイルを配置
2. **Jenkins Test Harness**: テスト用Jenkinsインスタンスを自動生成、プラグイン依存関係を解決
3. **旧バージョンRemoting**: 後方互換性テスト用に古いRemotingバージョンを `old-remoting/` に配置
4. **テストプラグイン**: `maven-hpi-plugin` により依存プラグインを自動解決・配置

## 不具合管理

不具合の管理方法は以下の通りです：

1. **Issue管理**: GitHub Issues（https://github.com/jenkinsci/jenkins/issues）
2. **PRラベル**:
   - `needs-fix`: 修正が必要なPR
   - `needs-more-review`: 追加レビューが必要
   - `stalled`: 停滞中のPR
3. **テスト失敗時の対応**:
   - `surefire.skipAfterFailureCount=100`: 100件失敗後にテスト中断
   - `surefire.rerunFailingTestsCount=1`（releaseプロファイル）: 失敗テストを1回再実行
   - `maven.test.failure.ignore`: CI環境ではテスト失敗を無視して継続

## CI/CD連携

### CI/CDパイプライン構成

Jenkinsfileで定義されたCI/CDパイプラインは以下の構成で実行されます：

1. **ビルドマトリックス**:
   - Linux: JDK 21, JDK 25
   - Windows: JDK 25のみ（リソース効率化のため）

2. **ステージ構成**:
   - **Record build**: Launchableでビルド記録
   - **Checkout**: ソースコードチェックアウト
   - **Build / Test**: Maven ビルド・テスト実行
   - **Publish**: テスト結果・カバレッジ・静的解析結果の公開

3. **テスト最適化（Launchable）**:
   - PRビルド時: テストサブセット選択（Linux: 100%、Windows: 30%）
   - `full-test` ラベル付きPR: 全テスト実行
   - 過去のテストセッションから除外ルールを生成

4. **静的解析**:
   - SpotBugs: バグ検出（新規issue = unstable）
   - Checkstyle: スタイル違反（1件でも = unstable）
   - ESLint: JavaScript lint
   - StyleLint: CSS lint

5. **ATH（Acceptance Test Harness）**:
   - プラットフォーム: Linux
   - JDK: 21
   - ブラウザ: Firefox
   - 対象: `org.jenkinsci.test.acceptance.junit.SmokeTest` タグ付きテスト

### テストプロファイル

| プロファイル | 説明 |
| --- | --- |
| `light-test` | 単体テストのみ実行（機能テストスキップ） |
| `smoke-test` | 単体テスト + SmokeTestタグ付き機能テスト |
| `all-tests` | 全テスト実行（デフォルト） |
| `enable-jacoco` | JaCoCoカバレッジ計測有効化 |
| `release` | リリースビルド用（失敗テスト再実行有効） |

### テスト実行コマンド例

```bash
# クイックビルド（テストなし）
mvn -am -pl war,bom -Pquick-build clean install

# 単体テストのみ
mvn -Plight-test test

# スモークテストのみ
mvn -Psmoke-test test

# カバレッジ計測付きフルテスト
mvn -Penable-jacoco clean install

# ATH実行
./ath.sh 21 firefox
```

## 備考

### テストに関する注意事項

1. **JDK要件**: JDK 21または25が必要（プロジェクトでは Eclipse Temurin または OpenJDK を推奨）

2. **Maven設定**: 以下のJVMオプションが必要
   ```
   --add-opens java.base/java.lang=ALL-UNNAMED
   --add-opens java.base/java.io=ALL-UNNAMED
   --add-opens java.base/java.util=ALL-UNNAMED
   ```

3. **フロントエンドテスト**: Yarn経由で実行
   ```bash
   yarn lint      # ローカル
   yarn lint:ci   # CI環境
   ```

4. **IntelliJ IDEA使用時**: `argLine` の `@{jenkins.addOpens}` 展開バグを回避するため、Settings > Build, Execution, Deployment > Build Tools > Maven > Running Tests で `argLine` のチェックを外す必要があります。

5. **テスト貢献ガイドライン**: 複雑なUI変更を提案する場合は、ATHに新しいテストを追加することが推奨されます。

### 関連リンク

- Jenkins CI: https://ci.jenkins.io/
- Acceptance Test Harness: https://github.com/jenkinsci/acceptance-test-harness
- Jenkins Test Harness: https://github.com/jenkinsci/jenkins-test-harness
- 貢献ガイド: CONTRIBUTING.md
