# ER図（Entity-Relationship Diagram）

## 概要

本ドキュメントは、Jenkinsのデータエンティティ間の関係を表すER図です。

JenkinsはRDBMSを使用せずXMLファイルベースで永続化を行いますが、データモデルとしてはエンティティ間に明確な関連性があります。以下のER図はこれらの論理的な関係を表現しています。

## 全体ER図

```mermaid
erDiagram
    JENKINS ||--o{ JOB : contains
    JENKINS ||--o{ VIEW : has
    JENKINS ||--o{ NODE : manages
    JENKINS ||--o{ USER : has
    JENKINS ||--|{ QUEUE : has
    JENKINS {
        string version
        int numExecutors
        enum mode
        boolean useSecurity
        string workspaceDir
        string buildsDir
        int quietPeriod
        string primaryView
    }

    JOB ||--o{ RUN : produces
    JOB {
        string name PK
        string description
        string displayName
        boolean disabled
        boolean keepDependencies
        boolean concurrentBuild
        int nextBuildNumber
    }

    RUN ||--o{ ACTION : has
    RUN ||--o{ CAUSE : triggered_by
    RUN }o--|| FINGERPRINT : creates
    RUN {
        int number PK
        long timestamp
        long startTime
        long duration
        enum result
        string charset
        boolean keepLog
        string description
        long queueId
    }

    USER ||--o{ USER_PROPERTY : has
    USER {
        string id PK
        string fullName
        string description
        int version
    }

    NODE ||--o{ NODE_PROPERTY : has
    NODE {
        string name PK
        string nodeDescription
        string remoteFS
        int numExecutors
        enum mode
        string labelString
    }

    VIEW ||--o{ VIEW_PROPERTY : has
    VIEW }o--o{ JOB : displays
    VIEW {
        string name PK
        string description
        boolean filterExecutors
        boolean filterQueue
        string includeRegex
    }

    QUEUE ||--o{ QUEUE_ITEM : contains
    QUEUE {
        datetime lastUpdated
    }

    QUEUE_ITEM }o--|| JOB : references
    QUEUE_ITEM ||--o{ ACTION : has
    QUEUE_ITEM {
        long id PK
        long timestamp
        string why
        long buildableStartMilliseconds
    }

    FINGERPRINT ||--o{ FINGERPRINT_USAGE : tracked_in
    FINGERPRINT ||--o{ FINGERPRINT_FACET : has
    FINGERPRINT {
        string md5sum PK
        string fileName
        datetime timestamp
    }

    FINGERPRINT_USAGE }o--|| JOB : used_by
    FINGERPRINT_USAGE {
        string jobName FK
        string buildRanges
    }

    ACTION {
        string type
        string data
    }

    CAUSE {
        string shortDescription
        string userId
    }

    USER_PROPERTY {
        string type
        string data
    }

    NODE_PROPERTY {
        string type
        string data
    }

    VIEW_PROPERTY {
        string type
        string data
    }

    FINGERPRINT_FACET {
        string type
        string data
    }
```

## ジョブとビルドの詳細関係

```mermaid
erDiagram
    JOB ||--o{ RUN : "1対多"
    JOB ||--o{ JOB_PROPERTY : has
    JOB ||--o| BUILD_DISCARDER : has
    JOB ||--o| SCM : uses
    JOB ||--o{ TRIGGER : triggered_by
    JOB ||--o{ BUILDER : executes
    JOB ||--o{ PUBLISHER : publishes_with
    JOB ||--o{ BUILD_WRAPPER : wrapped_by

    JOB {
        string name PK
        string description
        string displayName
        boolean disabled
        boolean keepDependencies
        boolean concurrentBuild
        string assignedNode
        boolean canRoam
        boolean blockBuildWhenDownstreamBuilding
        boolean blockBuildWhenUpstreamBuilding
        string authToken
    }

    RUN ||--o{ RUN_ACTION : has
    RUN ||--o{ CAUSE : triggered_by
    RUN ||--o{ CHANGELOG_ENTRY : includes
    RUN ||--o| ARTIFACT_MANAGER : stores_artifacts

    RUN {
        int number PK
        long timestamp
        long startTime
        long duration
        enum result
        string charset
        boolean keepLog
        string description
        string displayName
        long queueId
    }

    JOB_PROPERTY {
        string type
        string configuration
    }

    BUILD_DISCARDER {
        int daysToKeep
        int numToKeep
        int artifactDaysToKeep
        int artifactNumToKeep
    }

    SCM {
        string type
        string repositoryUrl
        string branch
        string credentials
    }

    TRIGGER {
        string type
        string schedule
    }

    BUILDER {
        string type
        string command
    }

    PUBLISHER {
        string type
        string configuration
    }

    BUILD_WRAPPER {
        string type
        string configuration
    }

    RUN_ACTION {
        string type
        string data
    }

    CAUSE {
        string shortDescription
        string userId
        int upstreamBuild
        string upstreamProject
    }

    CHANGELOG_ENTRY {
        string commitId
        string author
        string message
        datetime timestamp
    }

    ARTIFACT_MANAGER {
        string type
        string storagePath
    }
```

## ユーザーとセキュリティの関係

```mermaid
erDiagram
    USER ||--o{ USER_PROPERTY : has
    USER ||--o{ API_TOKEN_PROPERTY : has
    USER ||--o{ MAILER_PROPERTY : has
    USER }o--o{ RUN : triggers

    USER {
        string id PK
        string fullName
        string description
        int version
    }

    JENKINS ||--|| SECURITY_REALM : uses
    JENKINS ||--|| AUTHORIZATION_STRATEGY : uses
    JENKINS ||--o| CRUMB_ISSUER : uses

    SECURITY_REALM {
        string type
        string configuration
    }

    AUTHORIZATION_STRATEGY {
        string type
        string configuration
    }

    CRUMB_ISSUER {
        string type
        string excludeClientIPFromCrumb
    }

    USER_PROPERTY {
        string type
        string data
    }

    API_TOKEN_PROPERTY {
        string tokenHash
        datetime created
        string name
    }

    MAILER_PROPERTY {
        string emailAddress
    }
```

## ノードとコンピュータの関係

```mermaid
erDiagram
    JENKINS ||--o{ NODE : manages
    NODE ||--|| COMPUTER : represents
    NODE ||--o{ NODE_PROPERTY : has
    NODE ||--|| COMPUTER_LAUNCHER : launched_by
    NODE ||--|| RETENTION_STRATEGY : retained_by
    COMPUTER ||--o{ EXECUTOR : has

    NODE {
        string name PK
        string nodeDescription
        string remoteFS
        int numExecutors
        enum mode
        string labelString
    }

    COMPUTER {
        string name
        boolean offline
        string offlineCauseReason
        int numExecutors
        boolean temporarilyOffline
    }

    COMPUTER_LAUNCHER {
        string type
        string host
        int port
        string credentials
    }

    RETENTION_STRATEGY {
        string type
        int idleDelay
        int availabilityStartTime
        int availabilityEndTime
    }

    NODE_PROPERTY {
        string type
        string data
    }

    EXECUTOR {
        int number
        string currentTask
        boolean idle
        long startTime
    }
```

## フィンガープリントの関係

```mermaid
erDiagram
    FINGERPRINT ||--|| BUILD_PTR : original
    FINGERPRINT ||--o{ USAGE : tracked_in
    FINGERPRINT ||--o{ FINGERPRINT_FACET : extended_by

    FINGERPRINT {
        string md5sum PK
        string fileName
        datetime timestamp
    }

    BUILD_PTR {
        string jobName FK
        int buildNumber FK
    }

    USAGE {
        string jobName FK
        string rangeSet
    }

    FINGERPRINT_FACET {
        string type
        string data
    }

    JOB ||--o{ RUN : produces
    RUN }o--o{ FINGERPRINT : "creates/uses"

    JOB {
        string name PK
    }

    RUN {
        int number PK
        string jobName FK
    }
```

## 備考

### 関係の説明

| 関係 | カーディナリティ | 説明 |
|------|-----------------|------|
| Jenkins - Job | 1:N | Jenkinsインスタンスは複数のジョブを持つ |
| Jenkins - Node | 1:N | Jenkinsインスタンスは複数のノードを管理する |
| Jenkins - User | 1:N | Jenkinsインスタンスは複数のユーザーを持つ |
| Jenkins - View | 1:N | Jenkinsインスタンスは複数のビューを持つ |
| Job - Run | 1:N | ジョブは複数のビルド実行を生成する |
| View - Job | N:M | ビューは複数のジョブを表示し、ジョブは複数のビューに属する |
| Run - Fingerprint | N:M | ビルドは複数のファイルを追跡し、ファイルは複数のビルドで使用される |
| User - Run | N:M | ユーザーは複数のビルドをトリガーし、ビルドは複数のユーザーに関連する |

### ファイルシステムとの対応

各エンティティは以下のファイルパスに対応します：

| エンティティ | ファイルパス |
|-------------|-------------|
| Jenkins | `$JENKINS_HOME/config.xml` |
| Job | `$JENKINS_HOME/jobs/{job_name}/config.xml` |
| Run | `$JENKINS_HOME/jobs/{job_name}/builds/{build_number}/build.xml` |
| User | `$JENKINS_HOME/users/{user_id}/config.xml` |
| Node | `$JENKINS_HOME/nodes/{node_name}/config.xml` |
| Queue | `$JENKINS_HOME/queue.xml` |
| Fingerprint | `$JENKINS_HOME/fingerprints/{hash_prefix}/{fingerprint_id}.xml` |

### 注意事項

- ER図はあくまで論理的なデータモデルを表現しています
- JenkinsはRDBMSを使用しないため、外部キー制約やリレーショナル整合性は自動的には保証されません
- データの整合性はアプリケーション層（Javaコード）で管理されています
- プラグインによって追加のエンティティや関係が導入される場合があります
