# データベース設計書

## 概要

本ドキュメントは、Jenkinsのデータ永続化構造に関する設計書です。

Jenkinsは従来のリレーショナルデータベース（MySQL、PostgreSQL等）を使用せず、**XMLファイルベースの永続化アーキテクチャ**を採用しています。すべての設定データ、ジョブ情報、ビルド履歴、ユーザー情報などは、JENKINS_HOME ディレクトリ配下のXMLファイルとして保存されます。

### 永続化メカニズム

Jenkinsの永続化は以下のコンポーネントで構成されています：

1. **XmlFile** (`hudson.XmlFile`): XMLファイルの読み書きを担当するコアクラス
2. **XStream2** (`hudson.util.XStream2`): Javaオブジェクトとxml間のシリアライゼーション/デシリアライゼーション
3. **Saveable** (`hudson.model.Saveable`): 永続化可能なオブジェクトが実装するインターフェース
4. **BulkChange** (`hudson.BulkChange`): バルク更新時の効率的な保存処理を提供

### ストレージ構造

```
JENKINS_HOME/
├── config.xml                    # Jenkins全体の設定
├── queue.xml                     # ビルドキュー
├── jobs/                         # ジョブ定義
│   └── {job_name}/
│       ├── config.xml            # ジョブ設定
│       ├── nextBuildNumber       # 次のビルド番号
│       └── builds/               # ビルド履歴
│           └── {build_number}/
│               ├── build.xml     # ビルド情報
│               └── log           # ビルドログ
├── users/                        # ユーザー情報
│   ├── users.xml                 # ユーザーIDマッピング
│   └── {user_id}/
│       └── config.xml            # ユーザー設定
├── nodes/                        # エージェントノード
│   └── {node_name}/
│       └── config.xml            # ノード設定
├── fingerprints/                 # ファイルフィンガープリント
│   └── {hash_prefix}/
│       └── {fingerprint_id}.xml
├── secrets/                      # 機密情報
├── plugins/                      # プラグイン
└── updates/                      # アップデートセンター情報
```

## テーブル一覧

JenkinsはRDBMSを使用しないため、以下は論理的なデータエンティティの一覧です。各エンティティはXMLファイルとしてディスクに保存されます。

| エンティティ名（XMLファイル） | 対応Javaクラス | 説明 |
| --- | --- | --- |
| Jenkins設定 (config.xml) | jenkins.model.Jenkins | Jenkins全体の設定情報 |
| Job (jobs/{name}/config.xml) | hudson.model.Job | ジョブ/プロジェクトの設定 |
| Run (builds/{num}/build.xml) | hudson.model.Run | 個々のビルド実行記録 |
| User (users/{id}/config.xml) | hudson.model.User | ユーザー情報 |
| Node (nodes/{name}/config.xml) | hudson.model.Node | エージェントノード設定 |
| View (config.xml内) | hudson.model.View | ジョブの表示ビュー |
| Queue (queue.xml) | hudson.model.Queue | ビルドキュー |
| Fingerprint ({hash}.xml) | hudson.model.Fingerprint | ファイルトラッキング情報 |

## 各テーブル定義

### 1. Jenkins設定 (Jenkins)

Jenkinsインスタンス全体の設定を管理するルートエンティティです。`$JENKINS_HOME/config.xml` に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| version | String | No | Jenkinsバージョン |
| numExecutors | int | No | マスターの実行者数 |
| mode | Enum (NORMAL/EXCLUSIVE) | No | マスターの利用モード |
| useSecurity | boolean | No | セキュリティ有効化フラグ |
| authorizationStrategy | AuthorizationStrategy | Yes | 認可戦略 |
| securityRealm | SecurityRealm | Yes | 認証レルム |
| disableRememberMe | boolean | No | ログイン記憶無効化 |
| projectNamingStrategy | ProjectNamingStrategy | Yes | プロジェクト命名規則 |
| workspaceDir | String | Yes | ワークスペースディレクトリ |
| buildsDir | String | Yes | ビルドディレクトリ |
| markupFormatter | MarkupFormatter | Yes | マークアップフォーマッター |
| jdks | List&lt;JDK&gt; | Yes | JDK設定リスト |
| viewsTabBar | ViewsTabBar | Yes | ビュータブバー設定 |
| myViewsTabBar | MyViewsTabBar | Yes | マイビュータブバー設定 |
| clouds | List&lt;Cloud&gt; | Yes | クラウド設定リスト |
| quietPeriod | int | No | クワイエット期間（秒） |
| scmCheckoutRetryCount | int | No | SCMチェックアウトリトライ数 |
| views | List&lt;View&gt; | No | ビューリスト |
| primaryView | String | Yes | プライマリビュー名 |
| nodeProperties | List&lt;NodeProperty&gt; | Yes | ノードプロパティ |
| globalNodeProperties | List&lt;NodeProperty&gt; | Yes | グローバルノードプロパティ |
| crumbIssuer | CrumbIssuer | Yes | CSRF対策設定 |

### 2. Job（ジョブ）

ビルド・デプロイ等の自動化タスクを定義するエンティティです。`$JENKINS_HOME/jobs/{name}/config.xml` に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | No | ジョブ名（ディレクトリ名から取得） |
| description | String | Yes | ジョブの説明 |
| displayName | String | Yes | 表示名 |
| keepDependencies | boolean | No | 依存関係保持フラグ |
| properties | List&lt;JobProperty&gt; | Yes | ジョブプロパティリスト |
| logRotator / buildDiscarder | BuildDiscarder | Yes | ビルド破棄ポリシー |
| scm | SCM | Yes | ソースコード管理設定 |
| assignedNode | String | Yes | 割り当てノード |
| canRoam | boolean | No | ノード間移動可能フラグ |
| disabled | boolean | No | 無効化フラグ |
| blockBuildWhenDownstreamBuilding | boolean | No | 下流ビルド時ブロック |
| blockBuildWhenUpstreamBuilding | boolean | No | 上流ビルド時ブロック |
| triggers | List&lt;Trigger&gt; | Yes | トリガーリスト |
| concurrentBuild | boolean | No | 並行ビルド許可 |
| builders | List&lt;Builder&gt; | Yes | ビルダーリスト |
| publishers | List&lt;Publisher&gt; | Yes | パブリッシャーリスト |
| buildWrappers | List&lt;BuildWrapper&gt; | Yes | ビルドラッパーリスト |
| authToken | String | Yes | リモートビルドトークン |
| nextBuildNumber | int | No | 次のビルド番号（別ファイル） |

### 3. Run（ビルド実行）

ジョブの個々の実行を記録するエンティティです。`$JENKINS_HOME/jobs/{name}/builds/{number}/build.xml` に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| number | int | No | ビルド番号 |
| timestamp | long | No | ビルド開始時刻（エポックミリ秒） |
| startTime | long | No | 開始時刻 |
| duration | long | No | 実行時間（ミリ秒） |
| result | Result (SUCCESS/FAILURE/UNSTABLE/ABORTED/NOT_BUILT) | Yes | ビルド結果 |
| charset | String | Yes | ログの文字エンコーディング |
| keepLog | boolean | No | ログ保持フラグ |
| description | String | Yes | ビルドの説明 |
| displayName | String | Yes | 表示名 |
| actions | List&lt;Action&gt; | Yes | アクションリスト |
| causes | List&lt;Cause&gt; | Yes | ビルド開始原因 |
| queueId | long | No | キューID |
| culprits | Set&lt;String&gt; | Yes | 問題を引き起こしたユーザー |

### 4. User（ユーザー）

Jenkinsユーザーを管理するエンティティです。`$JENKINS_HOME/users/{id}/config.xml` に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | String | No | ユーザーID |
| fullName | String | Yes | フルネーム |
| description | String | Yes | ユーザーの説明 |
| properties | List&lt;UserProperty&gt; | Yes | ユーザープロパティリスト |
| version | int | No | データバージョン（現在10） |

ユーザーIDのマッピングは `$JENKINS_HOME/users/users.xml` で管理されます。

### 5. Node（エージェントノード）

ビルドを実行するエージェントを定義するエンティティです。`$JENKINS_HOME/nodes/{name}/config.xml` に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | No | ノード名 |
| nodeDescription | String | Yes | ノードの説明 |
| remoteFS | String | No | リモートルートディレクトリ |
| numExecutors | int | No | 実行者数 |
| mode | Mode (NORMAL/EXCLUSIVE) | No | 利用モード |
| labelString | String | Yes | ラベル文字列 |
| launcher | ComputerLauncher | Yes | 起動方法 |
| retentionStrategy | RetentionStrategy | Yes | 保持戦略 |
| nodeProperties | List&lt;NodeProperty&gt; | Yes | ノードプロパティ |
| userId | String | Yes | 所有ユーザーID |

### 6. View（ビュー）

ジョブの表示方法を定義するエンティティです。Jenkins設定ファイル内またはフォルダー設定内に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| name | String | No | ビュー名 |
| description | String | Yes | ビューの説明 |
| filterExecutors | boolean | No | 実行者フィルタリング |
| filterQueue | boolean | No | キューフィルタリング |
| properties | List&lt;ViewProperty&gt; | Yes | ビュープロパティ |
| jobNames | Set&lt;String&gt; | Yes | 表示ジョブ名リスト（ListViewの場合） |
| columns | List&lt;ListViewColumn&gt; | Yes | カラム設定（ListViewの場合） |
| includeRegex | String | Yes | 含めるジョブの正規表現 |
| recurse | boolean | No | 再帰的にフォルダーを含める |
| statusFilter | boolean | Yes | ステータスフィルター |

### 7. Queue（ビルドキュー）

ビルド待ち行列を管理するエンティティです。`$JENKINS_HOME/queue.xml` に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| items | List&lt;Item&gt; | No | キューアイテムリスト |

各キューアイテム（Queue.Item）の構造：

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | long | No | アイテムID |
| task | Task | No | 実行タスク |
| actions | List&lt;Action&gt; | Yes | アクションリスト |
| timestamp | long | No | キュー投入時刻 |
| why | String | Yes | 待機理由 |
| buildableStartMilliseconds | long | Yes | ビルド可能になった時刻 |

### 8. Fingerprint（フィンガープリント）

ファイルのトラッキング情報を管理するエンティティです。`$JENKINS_HOME/fingerprints/{hash_prefix}/{fingerprint_id}.xml` に保存されます。

| カラム名（XMLフィールド） | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| md5sum | String | No | MD5ハッシュ値 |
| fileName | String | No | ファイル名 |
| timestamp | Date | No | 作成タイムスタンプ |
| original | BuildPtr | Yes | オリジナルビルドへのポインタ |
| usages | Map&lt;String, RangeSet&gt; | No | 使用ジョブとビルド番号範囲 |
| facets | List&lt;FingerprintFacet&gt; | Yes | 追加ファセット情報 |

## 備考

### データ整合性について

JenkinsはRDBMSを使用しないため、従来のACIDトランザクションは提供されません。代わりに以下のメカニズムでデータ整合性を確保しています：

1. **アトミックファイル書き込み**: `AtomicFileWriter` を使用して、ファイル書き込みのアトミック性を確保
2. **BulkChange**: 複数の変更を一括で保存し、中間状態の永続化を防止
3. **ファイルシステムの fsync**: 明示的なディスク同期によるデータ永続性の保証

### パフォーマンス考慮事項

- 大量のジョブやビルド履歴がある場合、ファイルシステムのI/Oがボトルネックになる可能性があります
- SSDやRAIDを使用することで読み書き性能を向上できます
- `FingerprintStorage` は拡張ポイントとして設計されており、プラグインによる外部ストレージへの保存が可能です

### セキュリティ考慮事項

- パスワードや秘密鍵などの機密情報は `Secret` クラスによって暗号化されて保存されます
- 暗号化キーは `$JENKINS_HOME/secrets/` ディレクトリに保存されます
- XMLファイルには直接アクセス制御がないため、ファイルシステムレベルでの保護が重要です

### マイグレーションとバージョン管理

- JenkinsはXStreamのエイリアス機能を使用して、データフォーマットの後方互換性を維持しています
- 古いバージョンのデータは読み込み時に自動的に新しいフォーマットに変換されます
- `OldDataMonitor` が古いデータフォーマットの使用を監視し、管理者に通知します
