---
generated_at: 2026-01-22 19:16:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java`
- E-02: `core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageChecker.java`
- E-03: `core/src/main/java/hudson/model/LoadStatistics.java` (LoadStatisticsUpdater内部クラス)
- E-04: `core/src/main/java/hudson/model/FingerprintCleanupThread.java`
- E-05: `core/src/main/java/hudson/model/WorkspaceCleanupThread.java`
- E-06: `core/src/main/java/jenkins/model/BackgroundGlobalBuildDiscarder.java`
- E-07: `core/src/main/java/jenkins/DailyCheck.java`
- E-08: `core/src/main/java/hudson/slaves/ConnectionActivityMonitor.java`
- E-09: `core/src/main/java/hudson/slaves/ComputerRetentionWork.java`
- E-10: `core/src/main/java/hudson/slaves/NodeProvisioner.java` (NodeProvisionerInvoker内部クラス)
- E-11: `core/src/main/java/hudson/triggers/Trigger.java` (Cron内部クラス)
- E-12: `core/src/main/java/hudson/util/DoubleLaunchChecker.java` (Schedule内部クラス)
- E-13: `core/src/main/java/jenkins/telemetry/Telemetry.java` (TelemetryReporter内部クラス)
- E-14: `core/src/main/java/hudson/model/PeriodicWork.java`
- E-15: `core/src/main/java/hudson/model/AsyncPeriodicWork.java`
- E-16: `core/src/main/java/hudson/model/AperiodicWork.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemoryUsageMonitorは10秒ごとにメモリ使用量を監視 | E-01 (getRecurrencePeriod: TimeUnit.SECONDS.toMillis(10)) | ○ |
| C-02 | HudsonHomeDiskUsageCheckerは1時間ごとにディスク使用量をチェック | E-02 (getRecurrencePeriod: HOUR) | ○ |
| C-03 | LoadStatisticsUpdaterは10秒ごとに統計情報を更新 | E-03 (getRecurrencePeriod: CLOCK = 10秒) | ○ |
| C-04 | FingerprintCleanupThreadは1日ごとに古いフィンガープリントを削除 | E-04 (getRecurrencePeriod: DAY) | ○ |
| C-05 | WorkspaceCleanupThreadは24時間ごとにワークスペースをクリーンアップ | E-05 (getRecurrencePeriod: recurrencePeriodHours * HOUR = 24時間) | ○ |
| C-06 | BackgroundGlobalBuildDiscarderは1時間ごとにビルド破棄を実行 | E-06 (getRecurrencePeriod: HOUR) | ○ |
| C-07 | DailyCheckは1日ごとに更新チェックを実行 | E-07 (getRecurrencePeriod: DAY) | ○ |
| C-08 | ConnectionActivityMonitorは10秒ごとに接続を監視（有効時） | E-08 (getRecurrencePeriod: FREQUENCY = 10秒) | ○ |
| C-09 | ComputerRetentionWorkは設定可能な間隔でエージェント再接続を試行 | E-09 (getRecurrencePeriod: GlobalComputerRetentionCheckIntervalConfiguration設定値) | ○ |
| C-10 | NodeProvisionerInvokerは10秒ごとにノードプロビジョニングを実行 | E-10 (getRecurrencePeriod: RECURRENCEPERIOD = CLOCK) | ○ |
| C-11 | Trigger.Cronは1分ごとにトリガーを評価 | E-11 (getRecurrencePeriod: MIN) | ○ |
| C-12 | DoubleLaunchChecker.Scheduleは60-90分の間隔で重複起動をチェック | E-12 (getRecurrencePeriod: random.nextInt(30) + 60分) | ○ |
| C-13 | Telemetry.TelemetryReporterは24時間ごとにテレメトリを収集 | E-13 (getRecurrencePeriod: TimeUnit.HOURS.toMillis(24)) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのバッチ処理についてソースコードから直接確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] PeriodicWork/AsyncPeriodicWork/AperiodicWorkを継承した他のバッチ処理が存在しないか確認（プラグイン内等）
- [ ] 各バッチの実行間隔がシステム要件と一致しているか確認
- [ ] 無効化設定（disabled、enabled フラグ）の記載が正確か確認
- [ ] デフォルト値（閾値、保持期間等）が最新のソースコードと一致しているか確認
