# バッチ設計書 10-NodeProvisionerInvoker

## 概要

本ドキュメントは、JenkinsのNodeProvisionerInvokerバッチ処理の設計について記載する。このバッチはクラウドベースのノードプロビジョニングを定期的に呼び出し、負荷に応じてエージェントを動的に追加するエージェント管理機能を提供する。

### 本バッチの処理概要

NodeProvisionerInvokerは、Jenkinsの各ラベルおよびラベルなしタスク用のNodeProvisionerを定期的に呼び出し、ビルドキューの負荷状況に応じてクラウドからエージェントを動的にプロビジョニングするバッチ処理である。

**業務上の目的・背景**：クラウド環境でのCI/CDでは、ビルド負荷に応じてエージェントを動的にスケールさせることがコスト効率と処理速度の両面で重要である。本バッチは、LoadStatisticsUpdaterが収集した負荷統計情報を基に、NodeProvisionerがクラウドプロバイダー（AWS EC2、Kubernetes、Azureなど）からエージェントを動的にプロビジョニングすることを可能にする。これにより、ピーク時には自動的にスケールアウトし、アイドル時にはスケールインすることで、リソースの最適化を実現する。

**バッチの実行タイミング**：デフォルト10秒（LoadStatistics.CLOCK）間隔で定期実行される。初回実行はウォームアップ期間（デフォルトCLOCK*10 = 100秒）後に開始される。実行間隔はシステムプロパティで変更可能。

**主要な処理内容**：
1. unlabeledNodeProvisionerのupdate()を呼び出し
2. 全ラベルをイテレートし、各ラベルのnodeProvisionerのupdate()を呼び出し

**前後の処理との関連**：LoadStatisticsUpdaterと密接に連携。LoadStatisticsUpdaterが更新した統計データを基に、NodeProvisionerがプロビジョニング判断を行う。CloudProvisioningListenerを通じてプロビジョニングイベントを通知する。

**影響範囲**：Cloudプラグイン（EC2 Plugin、Kubernetes Pluginなど）を通じて外部クラウドリソースを操作する。新しいエージェントノードがJenkinsに追加される。

## バッチ種別

エージェント管理 / クラウドプロビジョニング

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 10秒ごと（RECURRENCEPERIOD、LoadStatistics.CLOCK） |
| 初回遅延 | 100秒（INITIALDELAY、CLOCK * 10） |
| 実行時刻 | 常時（Jenkins稼働中） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | PeriodicWorkによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Jenkinsが起動していること | PeriodicWorkの初期化後に自動スケジュール |
| Cloudプラグインがインストールされていること | プロビジョニング対象のクラウド定義が必要 |
| クラウドが設定されていること | Jenkins.get().cloudsに1つ以上のCloud定義 |

### 実行可否判定

常に実行される。クラウドが設定されていない場合やキューが空の場合は、update()内部で早期リターンされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| INITIALDELAY | int | No | CLOCK * 10 (100秒) | 初回実行までの遅延（ミリ秒）。システムプロパティ `hudson.slaves.NodeProvisioner.initialDelay` で設定可能 |
| RECURRENCEPERIOD | int | No | CLOCK (10秒) | 実行間隔（ミリ秒）。システムプロパティ `hudson.slaves.NodeProvisioner.recurrencePeriod` で設定可能 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Jenkins.get().unlabeledNodeProvisioner | NodeProvisioner | ラベルなしタスク用のプロビジョナー |
| Jenkins.get().getLabels() | Set<Label> | 全ラベルの集合 |
| Label.nodeProvisioner | NodeProvisioner | 各ラベルのプロビジョナー |
| LoadStatistics | 統計データ | 負荷統計情報 |
| Jenkins.get().clouds | List<Cloud> | 設定されているクラウドプロバイダー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Jenkins.nodes | Node追加 | プロビジョニングされたノードの追加 |
| NodeProvisioner.pendingLaunches | List<PlannedNode> | プロビジョニング中のノード一覧 |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし |
| 出力先 | なし |
| 文字コード | なし |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. doRun()メソッドが呼び出される
   └─ PeriodicWorkのタイマーによりRECURRENCEPERIOD間隔で実行
2. Jenkinsインスタンスを取得
   └─ Jenkins j = Jenkins.get()
3. ラベルなしNodeProvisionerのupdate()を呼び出し
   └─ j.unlabeledNodeProvisioner.update()
4. 全ラベルをイテレート
   └─ for (Label l : j.getLabels())
5. 各ラベルのnodeProvisioner.update()を呼び出し
   └─ l.nodeProvisioner.update()
```

### NodeProvisioner.update()の内部処理

```
1. provisioningLockを取得
2. pendingLaunches（進行中のプロビジョニング）を処理
   └─ 完了したものはJenkinsにノードを追加
   └─ 失敗したものはログ出力
3. LoadStatisticsSnapshotを計算
4. キュー長 > 利用可能エグゼキューターの場合
   └─ Strategyを順に適用してプロビジョニング判断
5. StandardStrategyImpl:
   └─ excessWorkload = キュー長 - 計画容量 - 接続中容量
   └─ excessWorkload > 閾値の場合、各Cloudにプロビジョニング要求
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Jenkinsインスタンス取得]
    B --> C[unlabeledNodeProvisioner.update]
    C --> D[全ラベルをイテレート]
    D --> E[label.nodeProvisioner.update]
    E --> F{全ラベル処理完了?}
    F -->|No| D
    F -->|Yes| G[バッチ終了]

    subgraph update処理
    H[provisioningLock取得] --> I[pendingLaunches処理]
    I --> J[LoadStatisticsSnapshot計算]
    J --> K{キュー長 > 利用可能?}
    K -->|No| L[終了]
    K -->|Yes| M[Strategy適用]
    M --> N{プロビジョニング必要?}
    N -->|No| L
    N -->|Yes| O[Cloud.provision呼び出し]
    O --> P[PlannedNodeを記録]
    P --> L
    end
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベースへのアクセスは行わない |

### テーブル別操作詳細

データベース操作は存在しない。外部クラウドAPIへのアクセスはCloudプラグインが担当。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | AbortException | プロビジョニング中止 | 通常のログ（WARNINGなし） |
| なし | ExecutionException | プロビジョニング失敗 | WARNINGログ出力、CloudProvisioningListener.onFailure呼び出し |
| なし | IOException | ノード追加失敗 | WARNINGログ出力、CloudProvisioningListener.onRollback呼び出し |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回の定期実行で再試行） |
| リトライ間隔 | RECURRENCEPERIOD（デフォルト10秒） |
| リトライ対象エラー | なし |

### 障害時対応

プロビジョニングに失敗しても、pendingLaunchesから削除され、次回の評価で再度プロビジョニングが検討される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし（CloudProvisioningListener.onRollback経由で通知のみ） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ラベル数 + 1（unlabeled） |
| 目標処理時間 | ログ出力によるとミリ秒単位で計測 |
| メモリ使用量上限 | pendingLaunchesのサイズに依存 |

## 排他制御

- NodeProvisioner.provisioningLockによるリエントラントロック
- update()は同時に1つのインスタンスでのみ実行される
- pendingLaunchesはAtomicReferenceで管理され、CAS操作で更新

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 出力なし（標準のPeriodicWorkログなし） |
| プロビジョニング開始 | Cloud.provision成功時 | "Started provisioning {displayName} from {cloudName} with {numExecutors} executors. Remaining excess workload: {excessWorkload}" (INFO) |
| プロビジョニング完了 | ノード追加成功時 | "{displayName} provisioning successfully completed. We have now {count} computer(s)" (INFO) |
| 終了ログ | なし | 出力なし |
| エラーログ | プロビジョニング失敗時 | "Unexpected exception encountered while provisioning agent {displayName}" (WARNING) |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし（CloudProvisioningListenerで拡張可能） |

## 備考

- シンボル名: なし（NodeProvisionerInvokerには@Symbolアノテーションなし）
- NodeProvisionerInvokerはNodeProvisionerの内部クラスとして定義
- INITIALDELAYとRECURRENCEPERIODは@SuppressFBWarningsで"MS_SHOULD_BE_FINAL"を抑制（Script Console変更可能）
- SystemProperties.getDuration()を使用して時間単位の設定をサポート
- StandardStrategyImpl:
  - MARGIN: 閾値マージン（デフォルト10%）
  - MARGIN0: 初期マージン（デフォルト50%）
  - MARGIN_DECAY: マージン減衰率（デフォルト0.5）
- プロビジョニング判断:
  - excessWorkload > 1 - MARGIN の場合にプロビジョニング
  - 既存エグゼキューターが0の場合は即座にプロビジョニング（needSomeWhenNoneAtAll）
- suggestReviewNow()メソッドで即座にupdate()を呼び出し可能（スロットリングあり）
- CloudProvisioningListenerで以下のイベントをフック可能:
  - canProvision: プロビジョニング可否の判断に介入
  - onStarted: プロビジョニング開始時
  - onComplete: プロビジョニング完了時
  - onCommit: ノード追加時
  - onFailure: プロビジョニング失敗時
  - onRollback: ノード追加失敗時
