# バッチ設計書 2-HudsonHomeDiskUsageChecker

## 概要

本ドキュメントは、JenkinsのHudsonHomeDiskUsageCheckerバッチ処理の設計について記載する。このバッチはJENKINS_HOMEディレクトリのディスク使用量を定期的にチェックし、空き容量が閾値を下回った場合に警告を表示するシステム監視機能を提供する。

### 本バッチの処理概要

HudsonHomeDiskUsageCheckerは、JENKINS_HOMEディレクトリのディスク空き容量を定期的に監視し、ディスク容量不足の危険がある場合にHudsonHomeDiskUsageMonitorを活性化して管理者に警告を表示するバッチ処理である。

**業務上の目的・背景**：Jenkinsはビルド成果物、ワークスペース、ログファイルなどを大量に保存するため、ディスク容量不足はシステム障害の主要な原因となる。ディスクが満杯になるとビルドが失敗し、最悪の場合はJenkinsが起動できなくなる。本バッチは、ディスク容量が危険な水準に達する前に管理者に警告を発することで、事前の対処（不要ファイルの削除、ディスク増設など）を可能にし、サービス継続性を確保する。

**バッチの実行タイミング**：1時間間隔で定期実行される。Jenkins起動時に自動的にスケジュールされ、初回実行は0〜1時間のランダムな遅延後に開始される。

**主要な処理内容**：
1. JENKINS_HOMEディレクトリ（Jenkins.get().getRootDir()）のディスク情報を取得
2. 利用可能な空き容量（getUsableSpace）と総容量（getTotalSpace）を取得
3. ディスク情報が利用不可の場合はバッチをキャンセル
4. 90%以上使用済み かつ 空き容量が閾値（デフォルト10GB）未満の場合、警告を活性化
5. HudsonHomeDiskUsageMonitorのactivatedフラグを更新

**前後の処理との関連**：HudsonHomeDiskUsageMonitorと連携して動作する。本バッチはチェックのみを行い、警告の表示はHudsonHomeDiskUsageMonitor（AdministrativeMonitor）が担当する。

**影響範囲**：ファイルシステムの統計情報のみを参照する読み取り専用の処理。HudsonHomeDiskUsageMonitor.activatedフラグの更新により、Jenkins管理画面に警告バナーが表示される。

## バッチ種別

システム監視 / ディスク容量チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 1時間ごと |
| 実行時刻 | 常時（Jenkins稼働中） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | PeriodicWorkによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Jenkinsが起動していること | PeriodicWorkの初期化後に自動スケジュール |
| JENKINS_HOMEディレクトリが存在すること | getRootDir()でアクセス |
| ファイルシステムがディスク統計をサポート | getUsableSpace/getTotalSpaceが有効な値を返すこと |

### 実行可否判定

ディスク情報が取得できない場合（free <= 0 または total <= 0）、バッチは自身をキャンセルし、以降の実行を停止する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| FREE_SPACE_THRESHOLD | long | No | 10737418240 (10GB) | 空き容量の警告閾値（バイト単位）。システムプロパティ `hudson.diagnosis.HudsonHomeDiskUsageChecker.freeSpaceThreshold` で設定可能 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Jenkins.get().getRootDir() | File | JENKINS_HOMEディレクトリのFileオブジェクト |
| File.getUsableSpace() | long | 利用可能な空き容量（バイト） |
| File.getTotalSpace() | long | ディスクの総容量（バイト） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| HudsonHomeDiskUsageMonitor.activated | boolean | 警告表示フラグ（trueで警告表示） |

### 出力ファイル仕様

ファイル出力は行わない。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし |
| 出力先 | HudsonHomeDiskUsageMonitor.activated（メモリ内フラグ） |
| 文字コード | なし |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. doRun()メソッドが呼び出される
   └─ PeriodicWorkのタイマーにより1時間ごとに実行
2. JENKINS_HOMEディレクトリの空き容量を取得
   └─ Jenkins.get().getRootDir().getUsableSpace()
3. JENKINS_HOMEディレクトリの総容量を取得
   └─ Jenkins.get().getRootDir().getTotalSpace()
4. ディスク情報の有効性チェック
   └─ free <= 0 または total <= 0 の場合、cancel()を呼び出して終了
5. ディスク使用率と空き容量を評価
   └─ 条件: total / free > 10 (90%以上使用) AND free < FREE_SPACE_THRESHOLD
6. HudsonHomeDiskUsageMonitor.activatedを更新
   └─ 条件を満たす場合はtrue、そうでない場合はfalse
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[JENKINS_HOMEの空き容量を取得]
    B --> C[JENKINS_HOMEの総容量を取得]
    C --> D{free <= 0 OR total <= 0?}
    D -->|Yes| E[ログ出力]
    E --> F[cancel を呼び出し]
    F --> G[バッチ終了]
    D -->|No| H[ログ出力: total と free の値]
    H --> I{total/free > 10 AND free < 閾値?}
    I -->|Yes| J[activated = true]
    I -->|No| K[activated = false]
    J --> L[バッチ終了]
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベースへのアクセスは行わない |

### テーブル別操作詳細

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | 情報取得不可 | getUsableSpace()/getTotalSpace()が0以下を返す | バッチをキャンセルしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（キャンセル後は実行されない） |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

### 障害時対応

ディスク情報が取得できない場合、バッチは自身をキャンセルする。これは通常、ファイルシステムがディスク統計をサポートしていない環境で発生する。Jenkins再起動時に再度試行される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回の呼び出しで1ディレクトリをチェック |
| 目標処理時間 | 1ミリ秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御は実装されていない。PeriodicWorkのdoRun()はシングルスレッドで実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 出力なし |
| 進捗ログ | ディスク情報取得後 | "Monitoring disk usage of JENKINS_HOME. total={total} free={free}" (FINE) |
| 終了ログ | なし | 出力なし |
| エラーログ | ディスク情報取得不可時 | "JENKINS_HOME disk usage information isn't available. aborting to monitor" (INFO) |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ディスク空き容量 | FREE_SPACE_THRESHOLD（デフォルト10GB）かつ使用率90%超 | Jenkins管理画面の警告バナー（HudsonHomeDiskUsageMonitor経由） |

## 備考

- シンボル名: `diskUsageCheck`（@Symbolアノテーション）
- FREE_SPACE_THRESHOLDはシステムプロパティで変更可能: `hudson.diagnosis.HudsonHomeDiskUsageChecker.freeSpaceThreshold`
- デフォルトの閾値計算: `1024L * 1024 * 1024 * 10` = 10GB
- 警告条件は「AND」で結合されている（両方の条件を満たす必要がある）
  - これにより、小さなJENKINS_HOMEでは警告が出にくく、大容量ディスクでも空き容量が十分であれば警告は出ない
- HudsonHomeDiskUsageMonitorはAdministrativeMonitorとして実装されており、activated=trueの場合にJenkins管理画面にバナーで警告を表示する
