# バッチ設計書 3-LoadStatisticsUpdater

## 概要

本ドキュメントは、JenkinsのLoadStatisticsUpdaterバッチ処理の設計について記載する。このバッチはJenkinsのエグゼキューター（オンライン、ビジー、アイドル等）およびキュー長の統計情報を定期的に更新するシステム監視機能を提供する。

### 本バッチの処理概要

LoadStatisticsUpdaterは、Jenkinsシステム全体およびラベルごとのエグゼキューター統計情報を定期的に収集・更新し、負荷状況のトレンドデータを蓄積するバッチ処理である。収集されたデータは、Jenkins管理画面でのグラフ表示やNodeProvisionerによるクラウドノードの自動プロビジョニング判断に使用される。

**業務上の目的・背景**：CI/CDシステムの効率的な運用には、リソース使用状況の把握が不可欠である。本バッチは、エグゼキューターの定義数、オンライン数、接続中数、ビジー数、アイドル数、利用可能数、およびキュー長を継続的に収集することで、システムの負荷状況を可視化する。このデータは、手動でのキャパシティプランニングに活用されるほか、NodeProvisionerが自動的にクラウドノードをプロビジョニングする際の判断材料となる。

**バッチの実行タイミング**：デフォルト10秒間隔で定期実行される。実行間隔はシステムプロパティ`hudson.model.LoadStatistics.clock`で変更可能。

**主要な処理内容**：
1. ビルドキューからBuildableItemのリストを取得
2. 各ラベル（Label）のLoadStatisticsを更新
3. ラベルなしタスク用のunlabeledLoadを更新
4. システム全体のoverallLoadを更新

**前後の処理との関連**：NodeProvisionerInvokerと密接に連携している。LoadStatisticsUpdaterが更新した統計データを基に、NodeProvisionerが追加ノードの必要性を判断する。また、MemoryUsageMonitorと同様にMultiStageTimeSeriesを使用して時系列データを保持する。

**影響範囲**：LoadStatisticsオブジェクト（各ラベル、unlabeledLoad、overallLoad）のMultiStageTimeSeriesを更新する。読み取り専用のデータ収集であり、ビルドキューの状態は変更しない。

## バッチ種別

システム監視 / メトリクス収集

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 10秒ごと（CLOCK設定値） |
| 実行時刻 | 常時（Jenkins稼働中） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | PeriodicWorkによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Jenkinsが起動していること | PeriodicWorkの初期化後に自動スケジュール |
| Jenkins.get()がnullでないこと | Jenkinsインスタンスへのアクセスが必要 |

### 実行可否判定

常に実行される。実行をスキップする条件はない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| CLOCK | int | No | 10000（10秒） | 実行間隔（ミリ秒）。システムプロパティ `hudson.model.LoadStatistics.clock` で設定可能 |
| DECAY | float | No | 0.9 | 時系列データの減衰率。システムプロパティ `hudson.model.LoadStatistics.decay` で設定可能 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Jenkins.get().getQueue().getBuildableItems() | List<BuildableItem> | ビルド可能なキューアイテム |
| Jenkins.get().getLabels() | Set<Label> | 全ラベルの集合 |
| Label.loadStatistics | LoadStatistics | 各ラベルの統計オブジェクト |
| Jenkins.unlabeledLoad | LoadStatistics | ラベルなしタスクの統計 |
| Jenkins.overallLoad | LoadStatistics | システム全体の統計 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| LoadStatistics.definedExecutors | MultiStageTimeSeries | 定義済みエグゼキューター数 |
| LoadStatistics.onlineExecutors | MultiStageTimeSeries | オンラインエグゼキューター数 |
| LoadStatistics.connectingExecutors | MultiStageTimeSeries | 接続中エグゼキューター数 |
| LoadStatistics.busyExecutors | MultiStageTimeSeries | ビジーエグゼキューター数 |
| LoadStatistics.idleExecutors | MultiStageTimeSeries | アイドルエグゼキューター数 |
| LoadStatistics.availableExecutors | MultiStageTimeSeries | 利用可能エグゼキューター数 |
| LoadStatistics.queueLength | MultiStageTimeSeries | キュー長 |

### 出力ファイル仕様

ファイル出力は行わない。メモリ内にのみデータを保持する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | なし |
| 出力先 | メモリ（MultiStageTimeSeries） |
| 文字コード | なし |
| 区切り文字 | なし |

## 処理フロー

### 処理シーケンス

```
1. doRun()メソッドが呼び出される
   └─ PeriodicWorkのタイマーによりCLOCK間隔で実行
2. Jenkinsインスタンスを取得
   └─ Jenkins.get()
3. ビルドキューからBuildableItemリストを取得
   └─ j.getQueue().getBuildableItems()
4. 全ラベルをイテレートして統計を更新
   └─ for (Label l : j.getLabels())
   └─ l.loadStatistics.updateCounts(l.loadStatistics.computeSnapshot(bis))
5. ラベルなし統計を更新
   └─ j.unlabeledLoad.updateCounts(j.unlabeledLoad.computeSnapshot(bis))
6. システム全体統計を更新
   └─ j.overallLoad.updateCounts(j.overallLoad.computeSnapshot(bis))
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Jenkinsインスタンス取得]
    B --> C[BuildableItemリスト取得]
    C --> D[全ラベルをイテレート]
    D --> E[ラベルのスナップショット計算]
    E --> F[LoadStatistics更新]
    F --> G{全ラベル処理完了?}
    G -->|No| D
    G -->|Yes| H[unlabeledLoadのスナップショット計算]
    H --> I[unlabeledLoad更新]
    I --> J[overallLoadのスナップショット計算]
    J --> K[overallLoad更新]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベースへのアクセスは行わない |

### テーブル別操作詳細

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | NullPointerException（可能性） | Jenkins.get()がnullの場合 | Jenkins起動完了後に実行されるため通常は発生しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回の定期実行で再試行） |
| リトライ間隔 | CLOCK（デフォルト10秒） |
| リトライ対象エラー | なし |

### 障害時対応

単一の実行でエラーが発生しても、次回の定期実行は継続される。統計データが一時的に欠損する可能性があるが、時系列データの傾向分析には大きな影響を与えない。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ラベル数 + 2（unlabeledLoad, overallLoad） |
| 目標処理時間 | 100ミリ秒未満 |
| メモリ使用量上限 | BuildableItemリストのサイズに依存 |

## 排他制御

排他制御は実装されていない。PeriodicWorkのdoRun()はシングルスレッドで実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | なし | 出力なし |
| 進捗ログ | なし | 出力なし |
| 終了ログ | なし | 出力なし |
| エラーログ | なし | 出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし（統計データは管理画面で可視化） |

## 備考

- シンボル名: `loadStatistics`（@Symbolアノテーション）
- LoadStatisticsUpdaterはLoadStatisticsクラスの内部クラスとして定義されている
- CLOCKのデフォルト値10秒は`TimeUnit.SECONDS.toMillis(10)`で計算
- DECAYのデフォルト値0.9は、約1分で半減する減衰率に相当
- computeSnapshot()メソッドは、一貫性のあるスナップショットを返すことを保証（カウント中にジョブが開始されても矛盾が生じない）
- LoadStatisticsSnapshot.Builderを使用して、ノードごとの統計を集計
- キュー長のカウントはラベルごとにフィルタリングされ、該当ラベルに対応するSubTaskのみがカウントされる
