# バッチ設計書 4-FingerprintCleanupThread

## 概要

本ドキュメントは、JenkinsのFingerprintCleanupThreadバッチ処理の設計について記載する。このバッチは古いフィンガープリントレコードをスキャンし、関連ビルドが存在しない不要なレコードを削除するクリーンアップ機能を提供する。

### 本バッチの処理概要

FingerprintCleanupThreadは、Jenkinsのフィンガープリントデータベースをスキャンし、関連するビルド記録が存在しなくなった古いフィンガープリントレコードを削除することで、ストレージ容量を回収するバッチ処理である。

**業務上の目的・背景**：Jenkinsのフィンガープリント機能は、ビルド間でのファイル共有や依存関係の追跡に使用される。ビルド履歴が削除されると、対応するフィンガープリントが不要になるが、自動的には削除されない。放置すると、フィンガープリントデータベースが肥大化し、ディスク容量を消費するとともに、検索パフォーマンスが低下する。本バッチは、不要なフィンガープリントを定期的に削除することで、ストレージ効率とシステムパフォーマンスを維持する。

**バッチの実行タイミング**：1日（24時間）間隔で定期実行される。AsyncPeriodicWorkを継承しているため、長時間実行されてもメインのタイマースレッドをブロックしない。

**主要な処理内容**：
1. GlobalFingerprintConfiguration設定でクリーンアップが無効化されていないかチェック
2. 無効化されている場合はスキップ
3. FingerprintStorage.get()を通じてフィンガープリントストレージにアクセス
4. iterateAndCleanupFingerprints()を呼び出して不要レコードを削除
5. 外部ストレージが設定されている場合、ファイルベースストレージのクリーンアップも実行

**前後の処理との関連**：独立したバッチ処理であり、他のバッチとの依存関係はない。ビルド削除やLogRotatorによるビルド履歴の削除後に、対応するフィンガープリントが孤立する。

**影響範囲**：フィンガープリントストレージ（デフォルトはファイルベース）のレコードを削除する。削除されたフィンガープリントは復元不可能だが、参照するビルドが存在しないため業務影響はない。

## バッチ種別

クリーンアップ / データ削除

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 1日ごと（DAY定数） |
| 実行時刻 | 不定（Jenkins起動時からの経過時間に依存） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | AsyncPeriodicWorkによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Jenkinsが起動していること | AsyncPeriodicWorkの初期化後に自動スケジュール |
| フィンガープリントクリーンアップが有効 | GlobalFingerprintConfiguration.isFingerprintCleanupDisabled()がfalse |

### 実行可否判定

GlobalFingerprintConfiguration.get().isFingerprintCleanupDisabled()がtrueの場合、処理をスキップする。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| isFingerprintCleanupDisabled | boolean | No | false | trueの場合、クリーンアップを実行しない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| FingerprintStorage.get() | FingerprintStorage | フィンガープリントストレージへのアクセス |
| FileFingerprintStorage | FingerprintStorage | ファイルベースのフィンガープリントストレージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| FingerprintStorage | ストレージ | 不要なフィンガープリントレコードの削除 |
| ログファイル | テキスト | 処理結果（$JENKINS_HOME/logs/tasks/Fingerprint cleanup.log） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Fingerprint cleanup.log |
| 出力先 | $JENKINS_HOME/logs/tasks/ |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

## 処理フロー

### 処理シーケンス

```
1. execute()メソッドが呼び出される
   └─ AsyncPeriodicWorkのタイマーにより1日ごとに実行
2. クリーンアップ無効化チェック
   └─ GlobalFingerprintConfiguration.get().isFingerprintCleanupDisabled()
3. 無効化されている場合
   └─ ログ出力してreturn
4. メインストレージのクリーンアップ
   └─ FingerprintStorage.get().iterateAndCleanupFingerprints(listener)
5. 外部ストレージ使用時のファイルストレージクリーンアップ
   └─ 5.1 現在のストレージがFileFingerprintStorageでないかチェック
   └─ 5.2 FileFingerprintStorageがreadyかチェック
   └─ 5.3 条件を満たす場合、fileFingerprintStorage.iterateAndCleanupFingerprints(listener)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{クリーンアップ無効?}
    B -->|Yes| C[ログ出力: Disabled]
    C --> D[バッチ終了]
    B -->|No| E[FingerprintStorage取得]
    E --> F[iterateAndCleanupFingerprints実行]
    F --> G{外部ストレージ使用中?}
    G -->|Yes| H{FileFingerprintStorage ready?}
    G -->|No| D
    H -->|Yes| I[FileFingerprintStorageクリーンアップ]
    H -->|No| D
    I --> D
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベースへのアクセスは行わない（ファイルベースストレージが標準） |

### テーブル別操作詳細

データベース操作は存在しない。外部FingerprintStorageプラグインが使用されている場合は、そのプラグインの仕様に依存する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | IOException | ファイル削除失敗 | ログ出力、次回実行で再試行 |
| なし | InterruptedException | 処理中断 | ログ出力、次回実行で再試行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回の定期実行で再試行） |
| リトライ間隔 | 1日（DAY） |
| リトライ対象エラー | なし |

### 障害時対応

処理中にエラーが発生しても、AsyncPeriodicWorkのフレームワークがエラーをログに記録し、次回の定期実行は継続される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルベースストレージ） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | フィンガープリントの総数に依存（数千〜数十万） |
| 目標処理時間 | 制限なし（AsyncPeriodicWorkで非同期実行） |
| メモリ使用量上限 | イテレーション処理のため最小限 |

## 排他制御

AsyncPeriodicWorkを継承しているため、前回の実行が完了する前に次回実行がトリガーされた場合、実行はスキップされる（"thread is still running. Execution aborted."メッセージが出力される）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | execute開始時 | Started at {timestamp} |
| 進捗ログ | 処理中 | 削除されたフィンガープリント情報（FingerprintStorage実装依存） |
| 終了ログ | execute終了時 | Finished at {timestamp}. {duration}ms |
| エラーログ | エラー発生時 | 例外スタックトレース |
| スキップログ | 無効化時 | "Fingerprint cleanup is disabled. Skipping execution" (FINE) |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし |

## 備考

- シンボル名: `fingerprintCleanup`（@Symbolアノテーション）
- @Restricted(NoExternalUse.class)が付与されており、外部からの直接呼び出しは非推奨
- invoke()メソッドで手動実行可能
- コンストラクタで"Fingerprint cleanup"という名前を設定（ログファイル名に使用）
- 外部FingerprintStorageプラグイン使用時は、メインストレージとファイルストレージの両方がクリーンアップ対象となる
- FileFingerprintStorage.isReady()は、ストレージが初期化完了しているかをチェック
