# バッチ設計書 6-BackgroundGlobalBuildDiscarder

## 概要

本ドキュメントは、JenkinsのBackgroundGlobalBuildDiscarderバッチ処理の設計について記載する。このバッチはグローバルに設定されたビルド破棄ルールをすべてのジョブに対してバックグラウンドで適用するクリーンアップ機能を提供する。

### 本バッチの処理概要

BackgroundGlobalBuildDiscarderは、Jenkins全体で設定されたビルド破棄ストラテジー（GlobalBuildDiscarderStrategy）を全ジョブに対して定期的に適用し、古いビルド履歴を自動的に削除するバッチ処理である。

**業務上の目的・背景**：CI/CDシステムでは日々多数のビルドが実行され、ビルド履歴（ログ、成果物など）がストレージを消費する。個別のジョブでLogRotatorを設定することも可能だが、全社的な保持ポリシーを一括適用したい場合がある。本バッチは、グローバルに設定されたビルド破棄ルール（例：全ジョブで90日を超えたビルドを削除）を定期的に適用することで、ストレージ管理を自動化し、運用負荷を軽減する。

**バッチの実行タイミング**：1時間間隔で定期実行される。AsyncPeriodicWorkを継承しているため、長時間実行されてもメインのタイマースレッドをブロックしない。

**主要な処理内容**：
1. 全Jobインスタンスをイテレート
2. 各ジョブに対してprocessJob()を呼び出し
3. GlobalBuildDiscarderConfiguration設定から全ストラテジーを取得
4. 各ストラテジーについてisApplicable()でジョブへの適用可否を判定
5. 適用可能な場合、strategy.apply()でビルド破棄を実行

**前後の処理との関連**：GlobalBuildDiscarderConfigurationと連携して動作する。設定画面でグローバルビルド破棄ルールを定義し、本バッチがその設定を実行する。ジョブ個別のLogRotatorとは独立して動作する。

**影響範囲**：古いビルド履歴（ビルドログ、成果物、テスト結果など）を削除する。削除されたビルドは復元不可能。

## バッチ種別

クリーンアップ / ビルド履歴管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 1時間ごと（HOUR定数） |
| 実行時刻 | 不定（Jenkins起動時からの経過時間に依存） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | AsyncPeriodicWorkによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Jenkinsが起動していること | AsyncPeriodicWorkの初期化後に自動スケジュール |
| グローバルビルド破棄ルールが設定されていること | GlobalBuildDiscarderConfigurationに1つ以上のストラテジーが設定 |

### 実行可否判定

常に実行される。グローバル設定がない場合は実質的にno-op（何も実行されない）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータは存在しない（設定はGlobalBuildDiscarderConfigurationで管理） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Jenkins.get().allItems(Job.class) | Iterable<Job> | 全ジョブインスタンス |
| GlobalBuildDiscarderConfiguration.get().getConfiguredBuildDiscarders() | List<GlobalBuildDiscarderStrategy> | グローバル設定のビルド破棄ストラテジー |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ジョブディレクトリ | ディレクトリ削除 | 古いビルドディレクトリの削除 |
| ログファイル | テキスト | 処理結果（$JENKINS_HOME/logs/tasks/Periodic background build discarder.log） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Periodic background build discarder.log |
| 出力先 | $JENKINS_HOME/logs/tasks/ |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

## 処理フロー

### 処理シーケンス

```
1. execute()メソッドが呼び出される
   └─ AsyncPeriodicWorkのタイマーにより1時間ごとに実行
2. 全Jobをイテレート
   └─ for (Job job : Jenkins.get().allItems(Job.class))
3. 各ジョブに対してprocessJob()を呼び出し
   └─ processJob(listener, job)
4. processJob()内でストラテジーを取得
   └─ GlobalBuildDiscarderConfiguration.get().getConfiguredBuildDiscarders().stream()
5. 各ストラテジーをイテレート
   └─ strategies.forEach(strategy -> ...)
6. 適用可否を判定
   └─ strategy.isApplicable(job)
7. 適用可能な場合、ビルド破棄を実行
   └─ strategy.apply(job)
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[全Jobをイテレート]
    B --> C[processJob呼び出し]
    C --> D[グローバルストラテジー取得]
    D --> E[各ストラテジーをイテレート]
    E --> F{isApplicable?}
    F -->|Yes| G[strategy.apply実行]
    F -->|No| H[スキップ]
    G --> I{エラー発生?}
    I -->|Yes| J[エラーログ出力]
    I -->|No| K[次のストラテジーへ]
    H --> K
    J --> K
    K --> E
    E --> L{全ストラテジー処理完了?}
    L -->|No| E
    L -->|Yes| M{全Job処理完了?}
    M -->|No| B
    M -->|Yes| N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベースへのアクセスは行わない（ファイルベースの削除） |

### テーブル別操作詳細

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | Exception | strategy.apply()の実行失敗 | listener.error()とLOGGER.log()でログ出力、次のストラテジーへ続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回の定期実行で再試行） |
| リトライ間隔 | 1時間（HOUR） |
| リトライ対象エラー | なし |

### 障害時対応

個別のジョブ・ストラテジーでエラーが発生しても、他のジョブ・ストラテジーの処理は継続される。エラーはログファイルに記録される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ジョブ数 × ストラテジー数 |
| 目標処理時間 | 制限なし（AsyncPeriodicWorkで非同期実行） |
| メモリ使用量上限 | イテレーション処理のため最小限 |

## 排他制御

AsyncPeriodicWorkを継承しているため、前回の実行が完了する前に次回実行がトリガーされた場合、実行はスキップされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | execute開始時 | Started at {timestamp} |
| 進捗ログ | なし | 出力なし |
| 終了ログ | execute終了時 | Finished at {timestamp}. {duration}ms |
| エラーログ | strategy.apply()失敗時 | "An exception occurred when executing {displayName}: {message}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし |

## 備考

- シンボル名: なし（@Symbolアノテーションなし）
- @Restricted(NoExternalUse.class)が付与されており、外部からの直接呼び出しは非推奨
- processJob()メソッドはpublic staticで、外部から呼び出し可能（GlobalBuildDiscarderListenerなどから使用）
- processJob()のオーバーロードにより、特定のストラテジーセットのみ適用することも可能
- GlobalBuildDiscarderStrategyの実装例:
  - JobGlobalBuildDiscarderStrategy: ジョブ設定のLogRotatorがない場合にデフォルトを適用
  - SimpleGlobalBuildDiscarderStrategy: 全ジョブに一律のルールを適用
- i18n対応のTODOコメントがあるが、コンストラクタの名前は未国際化
