# バッチ設計書 7-DailyCheck

## 概要

本ドキュメントは、JenkinsのDailyCheckバッチ処理の設計について記載する。このバッチはアップデートサイトおよびダウンロード可能データ（ツールインストーラメタデータ等）の更新を毎日チェックする更新チェック機能を提供する。

### 本バッチの処理概要

DailyCheckは、Jenkinsのアップデートセンター情報およびダウンロード可能なメタデータ（JDKインストーラ、Mavenなどのツールメタデータ）の更新を日次でチェックし、最新の情報をダウンロードするバッチ処理である。

**業務上の目的・背景**：Jenkinsはプラグインのアップデート情報やセキュリティ勧告、ツールインストーラのメタデータなどを外部のアップデートサイトから取得する。これらの情報が古くなると、新しいプラグインが表示されない、セキュリティ脆弱性の通知が遅れる、ツールの自動インストールが失敗するなどの問題が発生する。本バッチは、これらの情報を自動的に更新することで、管理者の手動操作を不要にし、システムを常に最新の状態に保つ。

**バッチの実行タイミング**：1日（24時間）間隔で定期実行される。ただし、本バッチは更新が「due（期限切れ）」のサイトのみを更新するため、実際の更新は24〜48時間前の情報に基づく。ユニットテスト時は初回遅延がDAYに設定される。

**主要な処理内容**：
1. 全アップデートサイトのdue状態をチェック
2. いずれかのサイトがdue（更新期限切れ）の場合:
   - PluginManager.doCheckUpdatesServer()を呼び出し
   - アップデートサイトとダウンロード可能データを一括更新
3. どのサイトもdueでない場合:
   - 個別のDownloadable（ツールメタデータ）のdue状態をチェック
   - dueのものだけを個別に更新

**前後の処理との関連**：独立したバッチ処理。UpdateCenterプラグインの管理画面からの手動更新とは独立して動作する。

**影響範囲**：アップデートセンターのキャッシュデータ（$JENKINS_HOME/updates/）を更新する。外部ネットワークへのアクセスが発生する。

## バッチ種別

更新チェック / メタデータ同期

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 1日ごと（DAY定数） |
| 実行時刻 | 不定（Jenkins起動時からの経過時間に依存） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | AsyncPeriodicWorkによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Jenkinsが起動していること | AsyncPeriodicWorkの初期化後に自動スケジュール |
| ネットワーク接続が可能 | アップデートサイトへのHTTPアクセスが必要 |

### 実行可否判定

常に実行される。ただし、実際の更新はサイト/Downloadableがdue（更新期限切れ）の場合のみ行われる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータは存在しない |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Jenkins.get().getUpdateCenter().getSites() | List<UpdateSite> | 全アップデートサイト |
| DownloadService.Downloadable.all() | ExtensionList<Downloadable> | 全ダウンロード可能データ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $JENKINS_HOME/updates/ | JSONファイル | アップデートサイトのキャッシュ |
| ログファイル | テキスト | 処理結果（$JENKINS_HOME/logs/tasks/Download metadata.log） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Download metadata.log |
| 出力先 | $JENKINS_HOME/logs/tasks/ |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

## 処理フロー

### 処理シーケンス

```
1. execute()メソッドが呼び出される
   └─ AsyncPeriodicWorkのタイマーにより1日ごとに実行
2. 全アップデートサイトのdue状態をチェック
   └─ for (UpdateSite site : Jenkins.get().getUpdateCenter().getSites())
   └─ site.isDue()でチェック
3. いずれかがdueの場合
   └─ PluginManager.doCheckUpdatesServer()を呼び出し
   └─ FormValidationエラーの場合はlistener.error()で出力
   └─ return
4. どのサイトもdueでない場合
   └─ for (DownloadService.Downloadable d : DownloadService.Downloadable.all())
   └─ d.getDue() <= now かチェック
   └─ dueのものについてd.updateNow()を呼び出し
   └─ 例外発生時はWARNINGレベルでログ出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[全UpdateSiteをチェック]
    B --> C{いずれかがdue?}
    C -->|Yes| D[doCheckUpdatesServer呼び出し]
    D --> E{FormValidation?}
    E -->|Yes| F[listener.error出力]
    E -->|No| G[バッチ終了]
    F --> G
    C -->|No| H[全Downloadableをチェック]
    H --> I{d.getDue <= now?}
    I -->|Yes| J[d.updateNow呼び出し]
    I -->|No| K[スキップ]
    J --> L{例外発生?}
    L -->|Yes| M[WARNINGログ出力]
    L -->|No| N[次のDownloadableへ]
    K --> N
    M --> N
    N --> O{全Downloadable処理完了?}
    O -->|No| H
    O -->|Yes| G
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベースへのアクセスは行わない（ファイルベースのキャッシュ更新） |

### テーブル別操作詳細

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | FormValidation | doCheckUpdatesServer()のエラー | listener.error()でHTML出力 |
| なし | Exception | d.updateNow()の失敗 | WARNINGレベルでログ出力、次のDownloadableへ続行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回の定期実行で再試行） |
| リトライ間隔 | 1日（DAY） |
| リトライ対象エラー | なし |

### 障害時対応

ネットワークエラーなどで更新に失敗しても、次回の定期実行で再試行される。キャッシュは古いデータのまま保持される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（ファイルシステム操作） |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | アップデートサイト数 + Downloadable数 |
| 目標処理時間 | ネットワーク速度に依存（通常数秒〜数分） |
| メモリ使用量上限 | ダウンロードするJSONデータサイズに依存 |

## 排他制御

AsyncPeriodicWorkを継承しているため、前回の実行が完了する前に次回実行がトリガーされた場合、実行はスキップされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | execute開始時 | Started at {timestamp} |
| 進捗ログ | なし | 出力なし（doCheckUpdatesServerが内部でログ出力） |
| 終了ログ | execute終了時 | Finished at {timestamp}. {duration}ms |
| エラーログ | Downloadable更新失敗時 | "Unable to update downloadable [{id}]" (WARNING) |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし |

## 備考

- シンボル名: `updateCenterCheck`（@Symbolアノテーション）
- @Restricted(NoExternalUse.class)が付与されており、外部からの直接呼び出しは非推奨
- getInitialDelay()がオーバーライドされており、ユニットテスト時は初回遅延がDAY（即時実行を避ける）
- isDue()はサイトの最終更新時刻が24時間を超えているかをチェック
- JENKINS-32886対応: 「再起動後にインストール」されたプラグインのツールインストーラメタデータが更新されない問題に対処
- FormValidationはHTMLをレンダリングしてlistener.error()に出力
- doCheckUpdatesServer()はアップデートサイトとDownloadableの両方を更新
