# バッチ設計書 8-ConnectionActivityMonitor

## 概要

本ドキュメントは、JenkinsのConnectionActivityMonitorバッチ処理の設計について記載する。このバッチはエージェントへの接続が生きているかを監視し、タイムアウトした場合は切断処理を行うエージェント管理機能を提供する。

### 本バッチの処理概要

ConnectionActivityMonitorは、Jenkinsコントローラーとエージェント間のリモート接続をアクティブに監視し、接続が応答しなくなった場合に切断処理を行うことで、孤立したエージェント接続を検出・解消するバッチ処理である。

**業務上の目的・背景**：TCP接続はネットワーク障害時に長時間ハングする可能性があり、TCPの再送タイムアウトに依存すると検出に10分以上かかることがある。この間、エージェントは「オンライン」と表示されるが実際には使用できず、ビルドが割り当てられても失敗する。本バッチは、アクティブなPingコマンドを送信して接続の生死を確認し、応答がない場合は迅速に切断することで、システムの信頼性を向上させる。

**バッチの実行タイミング**：有効時は10秒間隔で定期実行される。デフォルトでは無効化されており、enabledフラグをtrueに設定する必要がある。無効時は30日間隔となる（実質的に無効化）。

**主要な処理内容**：
1. enabled == false の場合は何もしない
2. 全コンピューターをイテレート
3. 各コンピューターのChannelを取得
4. 最後にデータを受信してからTIME_TILL_PING（デフォルト3分）を超えている場合:
   - Pingコマンドを非同期で送信
   - 前回のPingからTIMEOUT（デフォルト4分）を超えても応答がない場合は切断

**前後の処理との関連**：ComputerRetentionWorkと補完的な関係。ConnectionActivityMonitorは接続の「死活監視」を行い、ComputerRetentionWorkは「再接続」を行う。

**影響範囲**：タイムアウトしたエージェント接続を切断する。切断されたエージェントはオフライン状態となり、ComputerRetentionWorkまたは手動で再接続される。

## バッチ種別

エージェント管理 / 接続監視

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 有効時: 10秒ごと（FREQUENCY）、無効時: 30日ごと |
| 実行時刻 | 常時（Jenkins稼働中） |
| 実行曜日 | 毎日 |
| 実行日 | 毎日 |
| トリガー | AsyncPeriodicWorkによる定期実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Jenkinsが起動していること | AsyncPeriodicWorkの初期化後に自動スケジュール |
| enabled == true | デフォルトは無効。システムプロパティで有効化が必要 |

### 実行可否判定

- `enabled == false` の場合、処理をスキップ（returnで即終了）
- 各コンピューターのチャネルがnullまたはChannel以外の場合はスキップ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| enabled | boolean | No | false | trueの場合、監視を有効化。システムプロパティ `hudson.slaves.ConnectionActivityMonitor.enabled` で設定 |
| TIME_TILL_PING | long | No | 180000 (3分) | 最後のデータ受信からPing送信までの時間（ミリ秒）。システムプロパティで設定可能 |
| FREQUENCY | long | No | 10000 (10秒) | 監視間隔（ミリ秒）。システムプロパティで設定可能 |
| TIMEOUT | long | No | 240000 (4分) | Ping送信から切断までのタイムアウト（ミリ秒）。システムプロパティで設定可能 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Jenkins.get().getComputers() | Computer[] | 全コンピューター |
| Computer.getChannel() | VirtualChannel | エージェントとの通信チャネル |
| Channel.getLastHeard() | long | 最後にデータを受信した時刻 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Computer | 状態変更 | タイムアウト時に切断（disconnect） |
| Channel.property | Object | Pingの最終送信時刻を保存 |
| ログファイル | テキスト | 処理結果（$JENKINS_HOME/logs/tasks/Connection Activity monitoring to agents.log） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Connection Activity monitoring to agents.log |
| 出力先 | $JENKINS_HOME/logs/tasks/ |
| 文字コード | UTF-8 |
| 区切り文字 | 改行 |

## 処理フロー

### 処理シーケンス

```
1. execute()メソッドが呼び出される
   └─ AsyncPeriodicWorkのタイマーにより定期実行
2. enabled チェック
   └─ enabled == false の場合、return
3. 全コンピューターをイテレート
   └─ for (Computer c : Jenkins.get().getComputers())
4. Channelの取得とキャスト
   └─ ch instanceof Channel の場合のみ処理
5. 最後にデータを受信してからの経過時間をチェック
   └─ now - channel.getLastHeard() > TIME_TILL_PING
6. TIME_TILL_PINGを超えている場合
   └─ 6.1 前回のPing時刻を取得（channel.getProperty）
   └─ 6.2 lastPing != null かつ now - lastPing > TIMEOUT の場合、切断
   └─ 6.3 そうでなければPingコマンドを非同期送信、初回ならlastPingを記録
7. TIME_TILL_PING以内の場合
   └─ lastPingプロパティをクリア（正常受信中）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{enabled?}
    B -->|No| C[バッチ終了]
    B -->|Yes| D[全コンピューターをイテレート]
    D --> E{Channelがnull?}
    E -->|Yes| D
    E -->|No| F{lastHeardからTIME_TILL_PING超過?}
    F -->|No| G[lastPingプロパティをクリア]
    G --> D
    F -->|Yes| H{lastPing存在?}
    H -->|No| I[Pingコマンド送信]
    I --> J[lastPingを記録]
    J --> D
    H -->|Yes| K{lastPingからTIMEOUT超過?}
    K -->|No| L[Pingコマンド送信]
    L --> D
    K -->|Yes| M[ログ出力: Disconnecting]
    M --> N[disconnect呼び出し]
    N --> D
    D --> O{全コンピューター処理完了?}
    O -->|No| D
    O -->|Yes| C
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベースへのアクセスは行わない |

### テーブル別操作詳細

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | IOException | チャネル操作失敗 | 例外はAsyncPeriodicWorkでキャッチされログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（次回の定期実行で再試行） |
| リトライ間隔 | 10秒（FREQUENCY） |
| リトライ対象エラー | なし |

### 障害時対応

Pingの送受信に失敗しても、次回の定期実行で再度チェックされる。複数回連続してPingが失敗した場合に切断される。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | なし |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | コンピューター数 |
| 目標処理時間 | 100ミリ秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

AsyncPeriodicWorkを継承しているため、前回の実行が完了する前に次回実行がトリガーされた場合、実行はスキップされる。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | execute開始時 | Started at {timestamp} |
| 進捗ログ | なし | 出力なし |
| 切断ログ | タイムアウト検出時 | "Repeated ping attempts failed on {computerName}. Disconnecting" (INFO) |
| 終了ログ | execute終了時 | Finished at {timestamp}. {duration}ms |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | なし | なし |

## 備考

- シンボル名: `connectionActivityMonitor`（@Symbolアノテーション）
- デフォルトで無効化されている理由: "disabled by default until proven in the production"
- PingCommandはSlaveToMasterCallableを継承した空のコマンド（応答を返すだけ）
- Channel.getLastHeard()は最後にデータを受信した時刻を返す
- callAsync()で非同期にPingを送信し、応答はgetLastHeard()の更新で検出
- OfflineCauseはMessages._ConnectionActivityMonitor_OfflineCause()で生成
- 有効化方法:
  - システムプロパティ: `-Dhudson.slaves.ConnectionActivityMonitor.enabled=true`
  - Script Console: `ExtensionList.lookupSingleton(ConnectionActivityMonitor.class).enabled = true`
- TIME_TILL_PINGとTIMEOUTの設定が同じキー（timeToPing）を使用している（潜在的なバグ）
