---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-MemoryUsageMonitor.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java` (L1-121)
- E-02: `core/src/main/java/hudson/model/PeriodicWork.java` (L1-150)
- E-03: `core/src/main/java/jenkins/diagnosis/MemoryUsageMonitorAction.java` (L1-53)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L2)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 実行間隔は10秒 | E-01 (L112-114): `return TimeUnit.SECONDS.toMillis(10);` | ○ |
| C-02 | PeriodicWorkを継承 | E-01 (L51): `extends PeriodicWork` | ○ |
| C-03 | ヒープと非ヒープの2種類のメモリを監視 | E-01 (L102-108): `heap = new MemoryGroup(pools, MemoryType.HEAP); nonHeap = new MemoryGroup(pools, MemoryType.NON_HEAP);` | ○ |
| C-04 | ManagementFactoryからメモリプール情報を取得 | E-01 (L106): `ManagementFactory.getMemoryPoolMXBeans()` | ○ |
| C-05 | GC後のメモリ使用量を取得 | E-01 (L79): `pool.getCollectionUsage()` | ○ |
| C-06 | バイトからKBに変換 | E-01 (L86-87): `used /= 1024; max /= 1024;` | ○ |
| C-07 | MultiStageTimeSeriesにデータを記録 | E-01 (L62-66, L89-90): `MultiStageTimeSeries used`, `this.used.update(used)` | ○ |
| C-08 | @Extensionアノテーションで自動登録 | E-01 (L50): `@Extension @Symbol("memoryUsage")` | ○ |
| C-09 | シンボル名はmemoryUsage | E-01 (L50): `@Symbol("memoryUsage")` | ○ |
| C-10 | doRun()でheapとnonHeapを更新 | E-01 (L117-120): `heap.update(); nonHeap.update();` | ○ |
| C-11 | MemoryUsageMonitorActionがWebUIへのアクセスを提供 | E-03 (L43-52): `RootAction`実装、`getHeap()`メソッド | ○ |
| C-12 | グラフ表示時にSYSTEM_READまたはMANAGE権限が必要 | E-01 (L97), E-03 (L50): `checkAnyPermission(Jenkins.SYSTEM_READ, Jenkins.MANAGE)` | ○ |
| C-13 | doGraphでTrendChartを生成 | E-01 (L96-99): `TrendChart doGraph` | ○ |
| C-14 | 初回実行は0〜getRecurrencePeriod()のランダム遅延 | E-02 (L89-95): `getInitialDelay()` | ○ |
| C-15 | Jenkins起動時に自動スケジュール | E-02 (L104-116): `init()`、`schedulePeriodicWork(p)` | ○ |
| C-16 | nullチェックでスキップ | E-01 (L80): `if (usage == null) continue;` | ○ |
| C-17 | カテゴリはシステム監視 | E-04: `"システム監視"` | ○ |
| C-18 | ColorPalette.REDとBLUEを使用 | E-01 (L62, L66): `ColorPalette.RED`, `ColorPalette.BLUE` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] MemoryUsageMonitor.javaの実装が設計書の記述と一致しているか確認
- [ ] バッチ一覧.csvのカテゴリ・説明との整合性を確認
- [ ] PeriodicWorkの動作仕様との整合性を確認
