---
generated_at: 2026-01-22 10:39:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-NodeProvisionerInvoker.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/slaves/NodeProvisioner.java` (L1-919)
- E-02: `core/src/main/java/hudson/model/PeriodicWork.java` (L1-150)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L11)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 実行間隔はRECURRENCEPERIOD（デフォルトCLOCK=10秒） | E-01 (L816-818): `return RECURRENCEPERIOD;`, L808: `RECURRENCEPERIOD = ...Duration.ofMillis(LoadStatistics.CLOCK)` | ○ |
| C-02 | 初回遅延はINITIALDELAY（CLOCK*10=100秒） | E-01 (L811-813): `return INITIALDELAY;`, L806: `INITIALDELAY = ...Duration.ofMillis((long) LoadStatistics.CLOCK * 10)` | ○ |
| C-03 | PeriodicWorkを継承 | E-01 (L800): `extends PeriodicWork` | ○ |
| C-04 | 内部クラスとして定義 | E-01 (L799): `public static class NodeProvisionerInvoker extends PeriodicWork` (NodeProvisioner内) | ○ |
| C-05 | doRun()でunlabeledNodeProvisioner.update()呼び出し | E-01 (L822-823): `j.unlabeledNodeProvisioner.update()` | ○ |
| C-06 | 全ラベルのnodeProvisioner.update()呼び出し | E-01 (L824-825): `for (Label l : j.getLabels()) l.nodeProvisioner.update()` | ○ |
| C-07 | @Extensionアノテーションで自動登録 | E-01 (L799): `@Extension` | ○ |
| C-08 | INITIALDELAYはScript Console変更可能 | E-01 (L805): `@SuppressFBWarnings(value = "MS_SHOULD_BE_FINAL", justification = "for script console")` | ○ |
| C-09 | RECURRENCEPERIODはScript Console変更可能 | E-01 (L807): `@SuppressFBWarnings(value = "MS_SHOULD_BE_FINAL", justification = "for script console")` | ○ |
| C-10 | provisioningLockで排他制御 | E-01 (L144, L216-217): `private final Lock provisioningLock = new ReentrantLock();`, `provisioningLock.lock()` | ○ |
| C-11 | pendingLaunchesはAtomicReference | E-01 (L141-142): `private final AtomicReference<List<PlannedNode>> pendingLaunches = new AtomicReference<>(...)` | ○ |
| C-12 | StandardStrategyImplがデフォルト戦略 | E-01 (L322-324): `strategies.isEmpty() ? List.of(new StandardStrategyImpl()) : strategies` | ○ |
| C-13 | MARGINのデフォルト値は10% | E-01 (L830): `MARGIN = SystemProperties.getInteger(..., 10) / 100f` | ○ |
| C-14 | MARGIN0のデフォルト値は50% | E-01 (L831): `MARGIN0 = ...getFloatSystemProperty(..., 0.5f)` | ○ |
| C-15 | MARGIN_DECAYのデフォルト値は0.5 | E-01 (L832): `MARGIN_DECAY = getFloatSystemProperty(..., 0.5f)` | ○ |
| C-16 | excessWorkload > 1 - MARGIN でプロビジョニング | E-01 (L686): `if (excessWorkload > 1 - m)` | ○ |
| C-17 | needSomeWhenNoneAtAllで即座にプロビジョニング | E-01 (L663-665, L680-684): `needSomeWhenNoneAtAll`条件とexcessWorkload = 1の設定 | ○ |
| C-18 | Cloud.provision()呼び出し | E-01 (L728): `Collection<PlannedNode> additionalCapacities = c.provision(cloudState, workloadToProvision)` | ○ |
| C-19 | CloudProvisioningListener.onStarted呼び出し | E-01 (L730): `fireOnStarted(c, state.getLabel(), additionalCapacities)` | ○ |
| C-20 | プロビジョニング成功時INFOログ | E-01 (L251-254): `LOGGER.log(Level.INFO, "{0} provisioning successfully completed. ...")` | ○ |
| C-21 | カテゴリはエージェント管理 | E-03: `"エージェント管理"` | ○ |
| C-22 | suggestReviewNow()でスロットリング付き即時呼び出し | E-01 (L184-205): `suggestReviewNow()`実装 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] NodeProvisioner.javaのNodeProvisionerInvoker内部クラスの実装が設計書の記述と一致しているか確認
- [ ] LoadStatisticsUpdaterとの連携を確認
- [ ] StandardStrategyImplのプロビジョニング判断ロジックを確認
- [ ] CloudProvisioningListenerの各イベントハンドラを確認
- [ ] バッチ一覧.csvのカテゴリ・説明との整合性を確認
