---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-Trigger.Cron.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **想定処理件数（数百〜数千ジョブ）**：具体的な根拠なし
  2. **JENKINS_HOME/logs/ への出力**：実装依存のため要確認
  3. **Jenkins 2.289 での CRON_THRESHOLD 単位変更**：@RestrictedSince アノテーションで確認済みだが詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/triggers/Trigger.java` - Cron 内部クラス（行 218-251）
- E-02: `core/src/main/java/hudson/triggers/Trigger.java` - checkTriggers メソッド（行 256-330）
- E-03: `core/src/main/java/hudson/triggers/Trigger.java` - CRON_THRESHOLD 定義（行 338）
- E-04: `core/src/main/java/hudson/triggers/TimerTrigger.java` - run() メソッド（行 61-67）
- E-05: `core/src/main/java/hudson/triggers/SCMTrigger.java` - run() メソッド（行 160-194）
- E-06: `core/src/main/java/hudson/triggers/SCMTrigger.java` - synchronousPolling フラグ（行 238）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義（行 12）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 毎分実行される（60秒間隔） | E-01: getRecurrencePeriod() が MIN を返す | ○ |
| C-02 | PeriodicWork を継承 | E-01: Cron extends PeriodicWork | ○ |
| C-03 | cron 式に基づいてトリガーを評価 | E-02: t.tabs.check(cal) でマッチング | ○ |
| C-04 | TimerTrigger と SCMTrigger を処理 | E-04, E-05: 両クラスの run() 実装 | ○ |
| C-05 | 初回実行タイミングの調整 | E-01: getInitialDelay() 実装 | ○ |
| C-06 | カレンダーの秒・ミリ秒を0に設定 | E-01: コンストラクタで設定 | ○ |
| C-07 | 同期ポーリングモードの存在 | E-06: synchronousPolling フラグ | ○ |
| C-08 | CRON_THRESHOLD デフォルト30秒 | E-03: SystemProperties.getLong で 30L | ○ |
| C-09 | SlowTriggerAdminMonitor への報告 | E-02: SlowTriggerAdminMonitor.getInstance().report() | ○ |
| C-10 | 例外発生時もログ出力して継続 | E-02: catch ブロックで LOGGER.log | ○ |
| C-11 | previousSynchronousPolling による制御 | E-02: isDone() チェック | ○ |
| C-12 | @Extension @Symbol("cron") アノテーション | E-01: 行 218 | ○ |
| C-13 | allItems(TriggeredItem.class) で走査 | E-02: 行 291 | ○ |
| C-14 | カレンダーを1分進める | E-01: cal.add(Calendar.MINUTE, 1) | ○ |
| C-15 | Jenkins 2.289 で単位変更 | E-03: @RestrictedSince("2.289") | ○ |
| C-16 | TriggeredItem インターフェース使用 | E-02: jenkins.triggers.TriggeredItem import | ○ |
| C-17 | 想定処理件数：数百〜数千ジョブ | **根拠なし** | △ |
| C-18 | STARVATION_THRESHOLD 1時間 | E-05 (SCMTrigger.java 行 782) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-17（想定処理件数）について具体的な根拠がない
  - 候補：Jenkins 公式ドキュメント / ベンチマークレポート / 運用実績データ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローは全てソースコードから確認可能
- 1: 中リスク - パフォーマンス要件（想定処理件数）は推定値であり、実環境での検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Trigger.java の Cron 内部クラスの実装を確認
- [ ] checkTriggers メソッドの処理フローを確認
- [ ] 同期ポーリングモードの動作条件を確認
- [ ] CRON_THRESHOLD の単位変更履歴を確認
- [ ] SlowTriggerAdminMonitor の動作を確認
