---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-DoubleLaunchChecker.Schedule.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張にソースコードからの根拠あり
  2. 特に優先的に確認が必要な項目なし
  3. 実装が比較的シンプルで、ソースコードとの整合性が高い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/DoubleLaunchChecker.java` - クラス定義（行 61-62）
- E-02: `core/src/main/java/hudson/util/DoubleLaunchChecker.java` - execute() メソッド（行 93-118）
- E-03: `core/src/main/java/hudson/util/DoubleLaunchChecker.java` - Schedule 内部クラス（行 132-154）
- E-04: `core/src/main/java/hudson/util/DoubleLaunchChecker.java` - getId() メソッド（行 123-125）
- E-05: `core/src/main/java/hudson/util/DoubleLaunchChecker.java` - getRecurrencePeriod() メソッド（行 144-147）
- E-06: `core/src/main/java/hudson/util/DoubleLaunchChecker.java` - home フィールド（行 71, 80）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義（行 13）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AperiodicWork を継承 | E-03: Schedule extends AperiodicWork | ○ |
| C-02 | 60-90分のランダム間隔で実行 | E-05: Duration.ofMinutes(random.nextInt(30) + 60) | ○ |
| C-03 | テスト環境では20-30秒間隔 | E-05: Main.isUnitTest ? Duration.ofSeconds(random.nextInt(10) + 20) | ○ |
| C-04 | .owner ファイルのタイムスタンプを確認 | E-02: timestampFile.lastModified() | ○ |
| C-05 | タイムスタンプ比較で衝突検知 | E-02: t != lastWriteTime の条件 | ○ |
| C-06 | プロセス ID を .owner に書き込み | E-04: ProcessHandle.current().pid() | ○ |
| C-07 | AdministrativeMonitor を継承 | E-01: extends AdministrativeMonitor | ○ |
| C-08 | activated フラグで警告表示制御 | E-02: activated = true | ○ |
| C-09 | collidingId に衝突相手の ID を記録 | E-02: Files.readString で読み込み | ○ |
| C-10 | @Extension アノテーションで自動登録 | E-01, E-03: @Extension アノテーション | ○ |
| C-11 | ExtensionList.lookupSingleton で取得 | E-03: doAperiodicRun() 内の実装 | ○ |
| C-12 | lastWriteTime を 0 で初期化 | E-01: lastWriteTime = 0L | ○ |
| C-13 | 書き込み失敗時に lastWriteTime を 0 にリセット | E-02: catch ブロック内の処理 | ○ |
| C-14 | SEVERE ログで衝突検知を報告 | E-02: LOGGER.severe("Collision detected...") | ○ |
| C-15 | isEnabled() でモニター有効性を確認 | E-02: isEnabled() 条件 | ○ |
| C-16 | getNewInstance() で新規インスタンス生成 | E-03: return new Schedule() | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主要な主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードからの根拠があり、実装がシンプル
- 0: 低リスク - ファイル I/O のみで、データベースやネットワーク操作がない

## 6) レビュアーチェックリスト（最小）
- [ ] DoubleLaunchChecker.java の execute() メソッドの処理フローを確認
- [ ] Schedule 内部クラスの getRecurrencePeriod() のランダム化ロジックを確認
- [ ] ProcessHandle.current().pid() の Java バージョン依存性を確認
- [ ] isEnabled() の継承元（AdministrativeMonitor）の動作を確認
- [ ] Main.isUnitTest フラグの判定条件を確認
