---
generated_at: 2026-01-22 10:32:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-LoadStatisticsUpdater.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/LoadStatistics.java` (L1-627)
- E-02: `core/src/main/java/hudson/model/PeriodicWork.java` (L1-150)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L4)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 実行間隔はCLOCK（デフォルト10秒） | E-01 (L354-356): `return CLOCK;` | ○ |
| C-02 | CLOCKのデフォルト値は10秒 | E-01 (L346): `CLOCK = SystemProperties.getInteger(..., (int) TimeUnit.SECONDS.toMillis(10))` | ○ |
| C-03 | PeriodicWorkを継承 | E-01 (L352): `extends PeriodicWork` | ○ |
| C-04 | BuildableItemリストを取得 | E-01 (L361): `j.getQueue().getBuildableItems()` | ○ |
| C-05 | 全ラベルをイテレートして統計更新 | E-01 (L364-366): `for (Label l : j.getLabels()) { l.loadStatistics.updateCounts(...) }` | ○ |
| C-06 | unlabeledLoadを更新 | E-01 (L369): `j.unlabeledLoad.updateCounts(...)` | ○ |
| C-07 | overallLoadを更新 | E-01 (L371): `j.overallLoad.updateCounts(...)` | ○ |
| C-08 | @Extensionアノテーションで自動登録 | E-01 (L351): `@Extension @Symbol("loadStatistics")` | ○ |
| C-09 | シンボル名はloadStatistics | E-01 (L351): `@Symbol("loadStatistics")` | ○ |
| C-10 | 7種類の統計を収集 | E-01 (L79-130): definedExecutors, onlineExecutors, connectingExecutors, busyExecutors, idleExecutors, availableExecutors, queueLength | ○ |
| C-11 | DECAYのデフォルト値は0.9 | E-01 (L341): `DECAY = Float.parseFloat(SystemProperties.getString(..., "0.9"))` | ○ |
| C-12 | computeSnapshot()で一貫性のあるスナップショット取得 | E-01 (L304-306, L315-334): `computeSnapshot()`実装 | ○ |
| C-13 | LoadStatisticsSnapshot.Builderで統計集計 | E-01 (L564-624): `Builder`クラス | ○ |
| C-14 | 内部クラスとして定義 | E-01 (L352): `public static class LoadStatisticsUpdater extends PeriodicWork` (LoadStatistics内) | ○ |
| C-15 | updateCounts()で統計を更新 | E-01 (L267-275): `updateCounts(LoadStatisticsSnapshot current)` | ○ |
| C-16 | MultiStageTimeSeriesでデータ保持 | E-01 (L79-130): `MultiStageTimeSeries` フィールド群 | ○ |
| C-17 | ColorPaletteで色設定 | E-01 (L134-148): `ColorPalette.YELLOW`, `ColorPalette.BLUE`, `ColorPalette.RED`, `ColorPalette.GREY` | ○ |
| C-18 | カテゴリはシステム監視 | E-03: `"システム監視"` | ○ |
| C-19 | 初回実行はランダム遅延 | E-02 (L89-95): `getInitialDelay()` | ○ |
| C-20 | システムプロパティでCLOCK設定可能 | E-01 (L346): `SystemProperties.getInteger(LoadStatistics.class.getName() + ".clock", ...)` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] LoadStatistics.javaのLoadStatisticsUpdater内部クラスの実装が設計書の記述と一致しているか確認
- [ ] NodeProvisionerInvokerとの連携動作を確認
- [ ] MultiStageTimeSeriesの減衰率（DECAY）が適切か確認
- [ ] バッチ一覧.csvのカテゴリ・説明との整合性を確認
