---
generated_at: 2026-01-22 10:34:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-WorkspaceCleanupThread.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/WorkspaceCleanupThread.java` (L1-220)
- E-02: `core/src/main/java/hudson/model/AsyncPeriodicWork.java` (L1-286)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L6)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 実行間隔は24時間（デフォルト） | E-01 (L65-67): `return recurrencePeriodHours * HOUR;`, L213: `recurrencePeriodHours = ...getInteger(..., 24)` | ○ |
| C-02 | AsyncPeriodicWorkを継承 | E-01 (L60): `extends AsyncPeriodicWork` | ○ |
| C-03 | コンストラクタで"Workspace clean-up"を設定 | E-01 (L61-63): `super("Workspace clean-up");` | ○ |
| C-04 | disabledフラグでチェック | E-01 (L74-77): `if (disabled) { LOGGER.fine("Disabled. Skipping execution"); return; }` | ○ |
| C-05 | 全ノードリストを構築 | E-01 (L78-81): `nodes.add(j); nodes.addAll(j.getNodes());` | ○ |
| C-06 | allItems(TopLevelItem.class)でイテレート | E-01 (L82): `for (TopLevelItem item : j.allItems(TopLevelItem.class))` | ○ |
| C-07 | ModifiableTopLevelItemGroupはスキップ | E-01 (L83-85): `if (item instanceof ModifiableTopLevelItemGroup) { continue; }` | ○ |
| C-08 | getWorkspaceFor()でワークスペースパス取得 | E-01 (L88): `node.getWorkspaceFor(item)` | ○ |
| C-09 | オフラインノードはスキップ（wsがnull） | E-01 (L89-91): `if (ws == null) { continue; // offline, fine }` | ○ |
| C-10 | shouldBeDeleted()で削除判定 | E-01 (L93-98): `check = shouldBeDeleted(item, ws, node)` | ○ |
| C-11 | 最後にビルドしたノードでは削除しない | E-01 (L117-123): `if (lb != null && lb.equals(n)) { return false; }` | ○ |
| C-12 | SCMが拒否した場合は削除しない | E-01 (L125-128): `if (!p.getScm().processWorkspaceBeforeDeletion(...)) { return false; }` | ○ |
| C-13 | ビルド中の場合は削除しない | E-01 (L132-137): `if (j.isBuilding()) { return false; }` | ○ |
| C-14 | 保持期間はretainForDays（デフォルト30日） | E-01 (L219): `retainForDays = SystemProperties.getInteger(..., 30)` | ○ |
| C-15 | lastModifiedで保持期間チェック | E-01 (L192-196): `if (dir.lastModified() + this.retentionInDays * DAY > now) { return false; }` | ○ |
| C-16 | @Extensionアノテーションで自動登録 | E-01 (L59): `@Extension @Symbol("workspaceCleanup")` | ○ |
| C-17 | シンボル名はworkspaceCleanup | E-01 (L59): `@Symbol("workspaceCleanup")` | ○ |
| C-18 | ワークスペースサフィックスも削除対象 | E-01 (L187): `dir.getName().startsWith(workspaceBaseName + WorkspaceList.COMBINATOR)` | ○ |
| C-19 | MasterToSlaveFileCallableでエージェント上実行 | E-01 (L142): `extends MasterToSlaveFileCallable<Void>` | ○ |
| C-20 | カテゴリはクリーンアップ | E-03: `"クリーンアップ"` | ○ |
| C-21 | disabled, retainForDaysはScript Console変更可能 | E-01 (L207, L218): `@SuppressFBWarnings(value = "MS_SHOULD_BE_FINAL", justification = "Accessible via System Groovy Scripts")` | ○ |
| C-22 | recurrencePeriodHoursはfinal | E-01 (L213): `public static final int recurrencePeriodHours = ...` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] WorkspaceCleanupThread.javaの実装が設計書の記述と一致しているか確認
- [ ] shouldBeDeleted()の削除条件が業務要件に合致しているか確認
- [ ] retainForDaysのデフォルト値（30日）が適切か確認
- [ ] バッチ一覧.csvのカテゴリ・説明との整合性を確認
