---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-BackgroundGlobalBuildDiscarder.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/model/BackgroundGlobalBuildDiscarder.java` (L1-88)
- E-02: `core/src/main/java/hudson/model/AsyncPeriodicWork.java` (L1-286)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L7)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 実行間隔は1時間（HOUR） | E-01 (L85-87): `return HOUR;` | ○ |
| C-02 | AsyncPeriodicWorkを継承 | E-01 (L46): `extends AsyncPeriodicWork` | ○ |
| C-03 | コンストラクタで"Periodic background build discarder"を設定 | E-01 (L49-51): `super("Periodic background build discarder");` | ○ |
| C-04 | allItems(Job.class)でイテレート | E-01 (L55): `for (Job job : Jenkins.get().allItems(Job.class))` | ○ |
| C-05 | processJob()を呼び出し | E-01 (L56): `processJob(listener, job);` | ○ |
| C-06 | getConfiguredBuildDiscarders()でストラテジー取得 | E-01 (L64): `GlobalBuildDiscarderConfiguration.get().getConfiguredBuildDiscarders().stream()` | ○ |
| C-07 | isApplicable()で適用可否判定 | E-01 (L73): `if (strategy.isApplicable(job))` | ○ |
| C-08 | strategy.apply()でビルド破棄実行 | E-01 (L75): `strategy.apply(job)` | ○ |
| C-09 | @Extensionアノテーションで自動登録 | E-01 (L45): `@Extension` | ○ |
| C-10 | @Restricted(NoExternalUse.class)が付与 | E-01 (L44): `@Restricted(NoExternalUse.class)` | ○ |
| C-11 | processJob()はpublic static | E-01 (L63): `public static void processJob(TaskListener listener, Job job)` | ○ |
| C-12 | エラー時はlistener.error()とLOGGER.log()で出力 | E-01 (L77-78): `listener.error("An exception occurred when executing " + displayName + ": " + ex.getMessage()); LOGGER.log(Level.WARNING, ...)` | ○ |
| C-13 | カテゴリはクリーンアップ | E-03: `"クリーンアップ"` | ○ |
| C-14 | i18n対応のTODOコメントあり | E-01 (L50): `// TODO i18n` | ○ |
| C-15 | Streamでストラテジーをイテレート | E-01 (L70-71): `strategies.forEach(strategy -> { ... })` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] BackgroundGlobalBuildDiscarder.javaの実装が設計書の記述と一致しているか確認
- [ ] GlobalBuildDiscarderConfigurationとの連携動作を確認
- [ ] GlobalBuildDiscarderStrategyの実装（JobGlobalBuildDiscarderStrategy, SimpleGlobalBuildDiscarderStrategy）を確認
- [ ] バッチ一覧.csvのカテゴリ・説明との整合性を確認
