---
generated_at: 2026-01-22 10:37:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ConnectionActivityMonitor.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/slaves/ConnectionActivityMonitor.java` (L1-120)
- E-02: `core/src/main/java/hudson/model/AsyncPeriodicWork.java` (L1-286)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L9)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 有効時の実行間隔はFREQUENCY（10秒） | E-01 (L88-90): `return enabled ? FREQUENCY : TimeUnit.DAYS.toMillis(30);`, L97: `FREQUENCY = ...toMillis(10)` | ○ |
| C-02 | 無効時は30日間隔 | E-01 (L89): `TimeUnit.DAYS.toMillis(30)` | ○ |
| C-03 | AsyncPeriodicWorkを継承 | E-01 (L52): `extends AsyncPeriodicWork` | ○ |
| C-04 | コンストラクタで"Connection Activity monitoring to agents"を設定 | E-01 (L53-55): `super("Connection Activity monitoring to agents");` | ○ |
| C-05 | enabled == falseの場合はreturn | E-01 (L59): `if (!enabled) return;` | ○ |
| C-06 | デフォルトで無効 | E-01 (L106): `enabled = SystemProperties.getBoolean(..., false)` (デフォルトなし = false) | ○ |
| C-07 | TIME_TILL_PINGはデフォルト3分 | E-01 (L95): `TIME_TILL_PING = ...toMillis(3)` | ○ |
| C-08 | TIMEOUTはデフォルト4分 | E-01 (L102): `TIMEOUT = ...toMillis(4)` | ○ |
| C-09 | 全コンピューターをイテレート | E-01 (L62): `for (Computer c : Jenkins.get().getComputers())` | ○ |
| C-10 | Channel.getLastHeard()で最後の受信時刻取得 | E-01 (L66): `now - channel.getLastHeard() > TIME_TILL_PING` | ○ |
| C-11 | lastPingをChannel.getPropertyで取得 | E-01 (L68): `Long lastPing = (Long) channel.getProperty(ConnectionActivityMonitor.class)` | ○ |
| C-12 | タイムアウト時はdisconnect呼び出し | E-01 (L71-72): `c.disconnect(OfflineCause.create(...))` | ○ |
| C-13 | callAsync()でPing送信 | E-01 (L75): `channel.callAsync(PING_COMMAND)` | ○ |
| C-14 | 正常時はlastPingプロパティをクリア | E-01 (L81): `channel.setProperty(ConnectionActivityMonitor.class, null)` | ○ |
| C-15 | @Extensionアノテーションで自動登録 | E-01 (L51): `@Extension @Symbol("connectionActivityMonitor")` | ○ |
| C-16 | シンボル名はconnectionActivityMonitor | E-01 (L51): `@Symbol("connectionActivityMonitor")` | ○ |
| C-17 | PingCommandはSlaveToMasterCallable | E-01 (L110): `extends SlaveToMasterCallable<Void, RuntimeException>` | ○ |
| C-18 | PingCommandは空のcall()を持つ | E-01 (L112-114): `public Void call() throws RuntimeException { return null; }` | ○ |
| C-19 | カテゴリはエージェント管理 | E-03: `"エージェント管理"` | ○ |
| C-20 | 無効化理由のコメント | E-01 (L105): `// disabled by default until proven in the production` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている
- 注意: TIME_TILL_PINGとTIMEOUTが同じシステムプロパティキー（timeToPing）を参照している可能性（L95, L102）

## 6) レビュアーチェックリスト（最小）
- [ ] ConnectionActivityMonitor.javaの実装が設計書の記述と一致しているか確認
- [ ] enabled有効化の運用手順を確認
- [ ] TIME_TILL_PINGとTIMEOUTのシステムプロパティ名の重複を確認
- [ ] バッチ一覧.csvのカテゴリ・説明との整合性を確認
