---
generated_at: 2026-01-22 10:38:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-ComputerRetentionWork.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/slaves/ComputerRetentionWork.java` (L1-82)
- E-02: `core/src/main/java/hudson/model/AperiodicWork.java` (L1-145)
- E-03: `core/src/main/java/jenkins/model/GlobalComputerRetentionCheckIntervalConfiguration.java` (L1-72)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (L10)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト実行間隔は60秒 | E-03 (L21): `computerRetentionCheckInterval = 60` | ○ |
| C-02 | 設定可能範囲は1〜60秒 | E-03 (L29-36, L48-53): 範囲チェックロジック | ○ |
| C-03 | AperiodicWorkを継承 | E-01 (L47): `extends AperiodicWork` | ○ |
| C-04 | getRecurrencePeriod()で間隔取得 | E-01 (L55-57): `return ExtensionList.lookupSingleton(...).getComputerRetentionCheckInterval() * 1000L` | ○ |
| C-05 | getNewInstance()はthisを返す | E-01 (L60-63): `return this;` | ○ |
| C-06 | 全コンピューターをイテレート | E-01 (L69): `for (final Computer c : Jenkins.get().getComputers())` | ○ |
| C-07 | Queue.runWithLock()で排他制御 | E-01 (L70): `Queue.runWithLock(() -> { ... })` | ○ |
| C-08 | isHoldOffLaunchUntilSave()チェック | E-01 (L72-73): `if (n != null && n.isHoldOffLaunchUntilSave()) return;` | ○ |
| C-09 | nextCheckマップで次回チェック時刻管理 | E-01 (L52, L74-77): `private final Map<Computer, Long> nextCheck = new WeakHashMap<>();` | ○ |
| C-10 | RetentionStrategy.check()を呼び出し | E-01 (L76): `c.getRetentionStrategy().check(c)` | ○ |
| C-11 | 待機時間を0-60分に制限 | E-01 (L76): `Math.max(0, Math.min(60, ...))` | ○ |
| C-12 | 60分制限のコメント | E-01 (L75): `// at the moment I don't trust strategies to wait more than 60 minutes` | ○ |
| C-13 | WeakHashMapを使用 | E-01 (L52): `new WeakHashMap<>()` | ○ |
| C-14 | @Extensionアノテーションで自動登録 | E-01 (L46): `@Extension @Symbol("computerRetention")` | ○ |
| C-15 | シンボル名はcomputerRetention | E-01 (L46): `@Symbol("computerRetention")` | ○ |
| C-16 | カテゴリはエージェント管理 | E-04: `"エージェント管理"` | ○ |
| C-17 | 不正値時は60秒にフォールバック | E-03 (L29-31, L33-35): `if (computerRetentionCheckInterval <= 0 \|\| > 60) { return 60; }` | ○ |
| C-18 | GlobalComputerRetentionCheckIntervalConfigurationのordinalは401 | E-03 (L16): `@Extension(ordinal = 401)` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全ての主張はソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] ComputerRetentionWork.javaの実装が設計書の記述と一致しているか確認
- [ ] GlobalComputerRetentionCheckIntervalConfigurationの設定範囲を確認
- [ ] RetentionStrategyの実装（各クラウドプラグイン）との連携を確認
- [ ] バッチ一覧.csvのカテゴリ・説明との整合性を確認
