---
generated_at: 2026-01-22 21:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：antlr モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/antlr/ANTLRException.java` - ANTLRException クラス定義（21行）
- E-02: Java言語仕様 - IllegalArgumentException の継承関係
- E-03: Java言語仕様 - コンストラクタオーバーロードの動作

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ANTLRException(String) コンストラクタが存在し、メッセージを受け取れる | E-01 (L10-12) | ○ |
| C-02 | null メッセージを渡した場合の挙動 | E-01, E-02 | ○ |
| C-03 | 空文字メッセージを渡した場合の挙動 | E-01, E-02 | ○ |
| C-04 | ANTLRException(String, Throwable) コンストラクタが存在する | E-01 (L14-16) | ○ |
| C-05 | メッセージ null、原因あり の場合の挙動 | E-01, E-02 | ○ |
| C-06 | 原因 null、メッセージありの場合の挙動 | E-01, E-02 | ○ |
| C-07 | ANTLRException(Throwable) コンストラクタが存在する | E-01 (L18-20) | ○ |
| C-08 | 原因が null の場合の挙動 | E-01, E-02 | ○ |
| C-09 | IllegalArgumentException を継承している | E-01 (L9) | ○ |
| C-10 | RuntimeException として catch できる | E-01, E-02 | ○ |
| C-11 | Exception として catch できる | E-01, E-02 | ○ |
| C-12 | @Deprecated アノテーションが付与されている | E-01 (L8) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - antlr モジュールは1ファイル1クラスのシンプルな構造であり、すべてのテストケースがソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 後方互換性のための単純な例外クラスであり、ロジックを持たない

## 6) レビュアーチェックリスト（最小）
- [ ] ANTLRException が後方互換性の目的で残されていることを理解している
- [ ] @Deprecated アノテーションが適切に付与されていることを確認
- [ ] IllegalArgumentException への移行推奨が適切であることを確認
- [ ] 3つのコンストラクタすべてがテストケースでカバーされていることを確認
