---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 158
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：hudson-root単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：158 / 160、根拠なし：2
- 優先レビュー（高）
  1. **UT-HUD-107**: Platform.isDarwin() - システム依存のため実環境でのテストが必要
  2. **UT-HUD-108**: Platform.isSnowLeopardOrLater() - macOS特有の機能のため実環境確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/Util.java` - 汎用ユーティリティクラス（1998行）
- E-02: `core/src/main/java/hudson/EnvVars.java` - 環境変数管理クラス（474行）
- E-03: `core/src/main/java/hudson/ExtensionList.java` - 拡張リスト管理クラス（497行）
- E-04: `core/src/main/java/hudson/BulkChange.java` - バルク変更管理クラス（166行）
- E-05: `core/src/main/java/hudson/MarkupText.java` - マークアップテキストクラス（338行）
- E-06: `core/src/main/java/hudson/AbstractMarkupText.java` - 抽象マークアップテキストクラス（167行）
- E-07: `core/src/main/java/hudson/XmlFile.java` - XMLファイル操作クラス（389行）
- E-08: `core/src/main/java/hudson/Platform.java` - プラットフォーム判定enumクラス（76行）
- E-09: `core/src/main/java/hudson/Launcher.java` - プロセス起動クラス（1000行以上）
- E-10: `core/src/main/java/hudson/Proc.java` - プロセスラッパークラス（518行）
- E-11: `core/src/main/java/hudson/Plugin.java` - プラグイン基底クラス（375行）
- E-12: `core/src/main/java/hudson/PluginWrapper.java` - プラグインラッパークラス（500行以上）
- E-13: `core/src/main/java/hudson/Extension.java` - 拡張アノテーション（118行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Util.filter() - フィルタリング処理 | E-01 (lines 150-166) | ○ |
| C-02 | Util.replaceMacro() - マクロ置換処理 | E-01 (lines 180-219) | ○ |
| C-03 | Util.loadFile() - ファイル読み込み | E-01 (lines 232-277) | ○ |
| C-04 | Util.deleteContentsRecursive() - 再帰削除 | E-01 (lines 288-301) | ○ |
| C-05 | Util.deleteFile() - ファイル削除 | E-01 (lines 310-312) | ○ |
| C-06 | Util.deleteRecursive() - 再帰的ディレクトリ削除 | E-01 (lines 322-335) | ○ |
| C-07 | Util.isSymlink() - シンボリックリンク判定 | E-01 (lines 357-381) | ○ |
| C-08 | Util.isRelativePath() - 相対パス判定 | E-01 (lines 391-405) | ○ |
| C-09 | Util.isDescendant() - 子孫パス判定 | E-01 (lines 416-419) | ○ |
| C-10 | Util.createTempDir() - 一時ディレクトリ作成 | E-01 (lines 425-446) | ○ |
| C-11 | Util.getHostName() - ホスト名取得 | E-01 (lines 511-518) | ○ |
| C-12 | Util.tokenize() - 文字列トークン化 | E-01 (lines 567-574) | ○ |
| C-13 | Util.mapToEnv() - Map変換 | E-01 (lines 580-588) | ○ |
| C-14 | Util.min() - 最小値計算 | E-01 (lines 590-596) | ○ |
| C-15 | Util.fixNull() - null安全変換 | E-01 (lines 1097-1109) | ○ |
| C-16 | Util.fixEmpty() - 空文字列変換 | E-01 (lines 1115-1118) | ○ |
| C-17 | Util.fixEmptyAndTrim() - トリム付き変換 | E-01 (lines 1126-1129) | ○ |
| C-18 | Util.getFileName() - ファイル名抽出 | E-01 (lines 1191-1199) | ○ |
| C-19 | Util.getDigestOf() - MD5計算 | E-01 (lines 640-659) | ○ |
| C-20 | Util.toAes128Key() - 暗号鍵生成 | E-01 (lines 696-708) | ○ |
| C-21 | Util.toHexString() - Hex変換 | E-01 (lines 711-718) | ○ |
| C-22 | Util.fromHexString() - Hex逆変換 | E-01 (lines 721-723) | ○ |
| C-23 | Util.getTimeSpanString() - 時間間隔フォーマット | E-01 (lines 733-768) | ○ |
| C-24 | Util.rawEncode() - URLエンコード | E-01 (lines 918-921) | ○ |
| C-25 | Util.escape() - HTMLエスケープ | E-01 (lines 1011-1045) | ○ |
| C-26 | Util.xmlEscape() - XMLエスケープ | E-01 (lines 1048-1064) | ○ |
| C-27 | Util.isSafeToRedirectTo() - リダイレクト安全性チェック | E-01 (lines 1653-1655) | ○ |
| C-28 | Util.isOverridden() - メソッドオーバーライド検出 | E-01 (lines 1515-1534) | ○ |
| C-29 | Util.createSymlink() - シンボリックリンク作成 | E-01 (lines 1348-1388) | ○ |
| C-30 | Util.resolveSymlink() - シンボリックリンク解決 | E-01 (lines 1435-1449) | ○ |
| C-31 | Util.permissionsToMode() - パーミッション変換 | E-01 (lines 1704-1712) | ○ |
| C-32 | Util.modeToPermissions() - モード変換 | E-01 (lines 1715-1733) | ○ |
| C-33 | EnvVars constructor - コンストラクタ | E-02 (lines 107-137) | ○ |
| C-34 | EnvVars.override() - 環境変数オーバーライド | E-02 (lines 145-168) | ○ |
| C-35 | EnvVars.overrideAll() - 一括オーバーライド | E-02 (lines 175-180) | ○ |
| C-36 | EnvVars.overrideExpandingAll() - 変数展開オーバーライド | E-02 (lines 351-356) | ○ |
| C-37 | EnvVars.get() - デフォルト値付き取得 | E-02 (lines 371-375) | ○ |
| C-38 | EnvVars.put() - null値禁止 | E-02 (lines 378-381) | ○ |
| C-39 | EnvVars.putIfNotNull() - 条件付き追加 | E-02 (lines 387-390) | ○ |
| C-40 | EnvVars.addLine() - 行形式追加 | E-02 (lines 404-409) | ○ |
| C-41 | EnvVars.expand() - 変数展開 | E-02 (lines 414-416) | ○ |
| C-42 | EnvVars.createCookie() - クッキー作成 | E-02 (lines 422-424) | ○ |
| C-43 | EnvVars.getRemote() - リモート取得 | E-02 (lines 434-438) | ○ |
| C-44 | EnvVars.getPlatform() - プラットフォーム取得 | E-02 (lines 94-96) | ○ |
| C-45 | EnvVars.setPlatform() - プラットフォーム設定 | E-02 (lines 103-105) | ○ |
| C-46 | ExtensionList.lookup() - 拡張リスト取得 | E-03 (lines 436-439) | ○ |
| C-47 | ExtensionList.lookupSingleton() - シングルトン取得 | E-03 (lines 452-461) | ○ |
| C-48 | ExtensionList.lookupFirst() - 最優先インスタンス取得 | E-03 (lines 474-486) | ○ |
| C-49 | ExtensionList.get() - 型指定取得 | E-03 (lines 136-141) | ○ |
| C-50 | ExtensionList.getInstance() - getInstance例外 | E-03 (lines 149-155) | ○ |
| C-51 | ExtensionList.add() - インスタンス追加 | E-03 (lines 262-281) | ○ |
| C-52 | ExtensionList.remove() - インスタンス削除 | E-03 (lines 203-211) | ○ |
| C-53 | ExtensionList.addListener() - リスナー追加 | E-03 (lines 128-130) | ○ |
| C-54 | ExtensionList.reverseView() - 逆順ビュー | E-03 (lines 188-200) | ○ |
| C-55 | BulkChange constructor - コンストラクタ | E-04 (lines 78-87) | ○ |
| C-56 | BulkChange.commit() - コミット | E-04 (lines 92-99) | ○ |
| C-57 | BulkChange.abort() - アボート | E-04 (lines 120-124) | ○ |
| C-58 | BulkChange.contains() - スコープ判定 | E-04 (lines 151-156) | ○ |
| C-59 | BulkChange.current() - 現在のBulkChange取得 | E-04 (lines 140-142) | ○ |
| C-60 | BulkChange.close() - AutoCloseable対応 | E-04 (lines 104-107) | ○ |
| C-61 | MarkupText constructor - コンストラクタ | E-05 (lines 239-241) | ○ |
| C-62 | MarkupText.getText() - テキスト取得 | E-05 (lines 244-246) | ○ |
| C-63 | MarkupText.addMarkup() - マークアップ追加 | E-05 (lines 260-270) | ○ |
| C-64 | MarkupText.toString() - マークアップ出力 | E-05 (lines 301-324) | ○ |
| C-65 | MarkupText.subText() - サブテキスト取得 | E-05 (lines 255-257) | ○ |
| C-66 | MarkupText.findTokens() - トークン検出 | E-05 (lines 329-331), E-06 (lines 141-163) | ○ |
| C-67 | MarkupText.SubText.surroundWith() - タグ囲み | E-05 (lines 123-125) | ○ |
| C-68 | MarkupText.SubText.group() - グループ取得 | E-05 (lines 179-183) | ○ |
| C-69 | XmlFile constructor - コンストラクタ | E-07 (lines 129-147) | ○ |
| C-70 | XmlFile.read() - XML読み込み | E-07 (lines 160-169) | ○ |
| C-71 | XmlFile.write() - XML書き込み | E-07 (lines 203-227) | ○ |
| C-72 | XmlFile.unmarshal() - アンマーシャル | E-07 (lines 178-201) | ○ |
| C-73 | XmlFile.exists() - ファイル存在チェック | E-07 (lines 250-252) | ○ |
| C-74 | XmlFile.delete() - ファイル削除 | E-07 (lines 254-256) | ○ |
| C-75 | XmlFile.sniffEncoding() - エンコーディング検出 | E-07 (lines 317-377) | ○ |
| C-76 | XmlFile.asString() - 文字列取得 | E-07 (lines 293-297) | ○ |
| C-77 | Platform.current() - 現在プラットフォーム | E-08 (lines 54-57) | ○ |
| C-78 | Platform.isDarwin() - macOS検出 | E-08 (lines 59-62) | △ |
| C-79 | Platform.isSnowLeopardOrLater() - macOSバージョン検出 | E-08 (lines 67-74) | △ |
| C-80 | Launcher.launch() - ProcStarter作成 | E-09 (lines 564-566) | ○ |
| C-81 | Launcher.getChannel() - チャネル取得 | E-09 (lines 141-143) | ○ |
| C-82 | Launcher.getListener() - リスナー取得 | E-09 (lines 152-154) | ○ |
| C-83 | Launcher.isUnix() - Unix判定 | E-09 (lines 782-784) | ○ |
| C-84 | Launcher.decorateFor() - Launcher装飾 | E-09 (lines 857-862) | ○ |
| C-85 | Launcher.decorateByPrefix() - プレフィックス装飾 | E-09 (lines 872-913) | ○ |
| C-86 | Launcher.decorateByEnv() - 環境変数装飾 | E-09 (lines 925-958) | ○ |
| C-87 | Launcher.ProcStarter.cmds() - コマンド設定 | E-09 (lines 227-251) | ○ |
| C-88 | Launcher.ProcStarter.pwd() - 作業ディレクトリ設定 | E-09 (lines 296-312) | ○ |
| C-89 | Launcher.ProcStarter.envs() - 環境変数設定 | E-09 (lines 401-433) | ○ |
| C-90 | Launcher.ProcStarter.stdout() - stdout設定 | E-09 (lines 321-347) | ○ |
| C-91 | Launcher.ProcStarter.stderr() - stderr設定 | E-09 (lines 353-366) | ○ |
| C-92 | Launcher.ProcStarter.stdin() - stdin設定 | E-09 (lines 374-388) | ○ |
| C-93 | Launcher.ProcStarter.start() - プロセス開始 | E-09 (lines 506-508) | ○ |
| C-94 | Launcher.ProcStarter.join() - プロセス待機 | E-09 (lines 516-543) | ○ |
| C-95 | Launcher.ProcStarter.masks() - マスク設定 | E-09 (lines 260-268) | ○ |
| C-96 | Launcher.ProcStarter.quiet() - 静音モード | E-09 (lines 277-286) | ○ |
| C-97 | Proc.isAlive() - 生存判定 | E-10 (lines 71) | ○ |
| C-98 | Proc.kill() - プロセス終了 | E-10 (lines 80) | ○ |
| C-99 | Proc.join() - プロセス待機 | E-10 (lines 98) | ○ |
| C-100 | Proc.joinWithTimeout() - タイムアウト付き待機 | E-10 (lines 154-176) | ○ |
| C-101 | Proc.getStdout() - stdout取得 | E-10 (lines 112) | ○ |
| C-102 | Proc.getStderr() - stderr取得 | E-10 (lines 126) | ○ |
| C-103 | Proc.getStdin() - stdin取得 | E-10 (lines 140) | ○ |
| C-104 | Proc.LocalProc constructor - LocalProcコンストラクタ | E-10 (lines 191-298) | ○ |
| C-105 | Proc.LocalProc.join() - LocalProc待機 | E-10 (lines 319-366) | ○ |
| C-106 | Proc.RemoteProc constructor - RemoteProcコンストラクタ | E-10 (lines 442-444) | ○ |
| C-107 | Proc.RemoteProc.kill() - RemoteProc終了 | E-10 (lines 447-456) | ○ |
| C-108 | Plugin.start() - プラグイン開始 | E-11 (lines 165-166) | ○ |
| C-109 | Plugin.stop() - プラグイン停止 | E-11 (lines 191-192) | ○ |
| C-110 | Plugin.postInitialize() - 後初期化 | E-11 (lines 174) | ○ |
| C-111 | Plugin.load() - 設定読み込み | E-11 (lines 318-322) | ○ |
| C-112 | Plugin.save() - 設定保存 | E-11 (lines 330-335) | ○ |
| C-113 | Plugin.configure() - 設定更新 | E-11 (lines 229-239) | ○ |
| C-114 | Plugin.getWrapper() - Wrapper取得 | E-11 (lines 139-141) | ○ |
| C-115 | Plugin.getTarget() - ターゲット取得 | E-11 (lines 352-358) | ○ |
| C-116 | PluginWrapper - プラグイン管理機能 | E-12 (lines 111-500) | ○ |
| C-117 | PluginWrapper.Dependency - 依存関係解析 | E-12 (lines 455-491) | ○ |
| C-118 | Extension annotation - 拡張アノテーション | E-13 (lines 75-117) | ○ |

## 4) 不足情報（Unknown / Missing）
- Platform.isDarwin() / isSnowLeopardOrLater(): システムプロパティ`os.name`に依存するため、実際のmacOS環境でのテストが必要
  - 候補：モック化によるテスト / 実環境での統合テスト / システムプロパティ設定によるユニットテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- 1: 中リスク - Platform関連のテストケース（UT-HUD-107, UT-HUD-108）は実環境依存のため要確認
- 0: 低リスク - セキュリティ関連のテストケース（isSafeToRedirectTo, escape, xmlEscapeなど）は重要だが根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] Util.replaceMacro()のマクロ置換パターンが網羅されているか確認
- [ ] EnvVars.override()のPATH+形式処理が正しくテストされているか確認
- [ ] ExtensionList.lookupSingleton()の例外ケースが適切にテストされているか確認
- [ ] BulkChange のスコープ管理が正しくテストされているか確認
- [ ] XmlFile のエンコーディング検出が各種エンコーディングでテストされているか確認
- [ ] Launcher.ProcStarter のプロセス起動フローが網羅されているか確認
- [ ] セキュリティ関連メソッド（escape, xmlEscape, isSafeToRedirectTo）のエッジケースが網羅されているか確認
- [ ] Platform依存のテストケースを実環境で確認するか、モック化するか決定
