---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 115
  claims_with_evidence: 108
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート：hudson.cli 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：108 / 115、根拠なし：7
- 優先レビュー（高）
  1. **UT-CLI-042〜043（Connection.fold）**：メソッドの実際のユースケースが不明確
  2. **UT-CLI-093〜094（QuietDownCommand blocking/timeout）**：Jenkinsの内部動作に依存
  3. **UT-CLI-115（CloneableCLICommand.createClone）**：抽象クラスの継承関係要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/java/hudson/cli/CLICommand.java` - CLIコマンド基底クラス
- E-02: `core/src/main/java/hudson/cli/CLIAction.java` - CLI WebアクションとWebSocket処理
- E-03: `core/src/main/java/hudson/cli/Connection.java` - 接続処理（非推奨）
- E-04: `core/src/main/java/hudson/cli/BuildCommand.java` - ビルドコマンド
- E-05: `core/src/main/java/hudson/cli/HelpCommand.java` - ヘルプコマンド
- E-06: `core/src/main/java/hudson/cli/CreateJobCommand.java` - ジョブ作成コマンド
- E-07: `core/src/main/java/hudson/cli/DeleteJobCommand.java` - ジョブ削除コマンド
- E-08: `core/src/main/java/hudson/cli/CopyJobCommand.java` - ジョブコピーコマンド
- E-09: `core/src/main/java/hudson/cli/ListJobsCommand.java` - ジョブ一覧コマンド
- E-10: `core/src/main/java/hudson/cli/ConsoleCommand.java` - コンソール出力コマンド
- E-11: `core/src/main/java/hudson/cli/InstallPluginCommand.java` - プラグインインストールコマンド
- E-12: `core/src/main/java/hudson/cli/DisablePluginCommand.java` - プラグイン無効化コマンド
- E-13: `core/src/main/java/hudson/cli/ConnectNodeCommand.java` - ノード接続コマンド
- E-14: `core/src/main/java/hudson/cli/OfflineNodeCommand.java` - ノードオフラインコマンド
- E-15: `core/src/main/java/hudson/cli/QuietDownCommand.java` - QuietDownコマンド
- E-16: `core/src/main/java/hudson/cli/WhoAmICommand.java` - 認証情報表示コマンド
- E-17: `core/src/main/java/hudson/cli/GroovyCommand.java` - Groovyスクリプト実行コマンド
- E-18: `core/src/main/java/hudson/cli/CliCrumbExclusion.java` - CSRF除外設定
- E-19: `core/src/main/java/hudson/cli/handlers/ViewOptionHandler.java` - ビュー引数ハンドラー
- E-20: `core/src/main/java/hudson/cli/handlers/NodeOptionHandler.java` - ノード引数ハンドラー
- E-21: `core/src/main/java/hudson/cli/handlers/GenericItemOptionHandler.java` - アイテム引数ハンドラー
- E-22: `core/src/main/java/hudson/cli/declarative/CLIRegisterer.java` - CLI拡張登録
- E-23: `core/src/main/java/hudson/cli/declarative/MethodBinder.java` - メソッドバインダー

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CLICommand.getName()がCamelCaseをkebab-caseに変換 | E-01 L178-188 | ○ |
| C-02 | CLICommand.main()がJenkins.READ権限をチェック | E-01 L256-257 | ○ |
| C-03 | CLICommand.handleException()が例外タイプ別に終了コードを返却 | E-01 L278-306 | ○ |
| C-04 | CLICommand.getTransportAuthentication2()がnull時ANONYMOUS2を返却 | E-01 L350-354 | ○ |
| C-05 | CLICommand.clone()が名前でコマンドをクローン | E-01 L538-543 | ○ |
| C-06 | CLIAction.doWs()がOriginチェックを実施 | E-02 L142-159 | ○ |
| C-07 | CLIAction.doCommand()が存在しないコマンドで404を返却 | E-02 L106-109 | ○ |
| C-08 | CLIAction.ServerSideImpl.run()がコマンドを実行 | E-02 L316-358 | ○ |
| C-09 | Connection.readByteArray()が負の長さでIOException | E-03 L140-143 | ○ |
| C-10 | Connection.fold()がバイト配列を折り畳む | E-03 L222-228 | △ |
| C-11 | BuildCommand.run()がBUILD権限をチェック | E-04 L102 | ○ |
| C-12 | BuildCommand.run()がパラメータを検証 | E-04 L106-143 | ○ |
| C-13 | BuildCommand.run()が-sオプションで同期実行 | E-04 L178-216 | ○ |
| C-14 | BuildCommand.run()がビルド不可能な場合IllegalStateException | E-04 L157-165 | ○ |
| C-15 | HelpCommand.run()がJenkins.READ権限をチェック | E-05 L53-56 | ○ |
| C-16 | HelpCommand.run()が存在しないコマンドでAbortException | E-05 L81-83 | ○ |
| C-17 | CreateJobCommand.run()が既存ジョブでIllegalStateException | E-06 L54-56 | ○ |
| C-18 | CreateJobCommand.run()がジョブ名を検証 | E-06 L75 | ○ |
| C-19 | DeleteJobCommand.run()が存在しないジョブでIllegalArgumentException | E-07 L68-69 | ○ |
| C-20 | DeleteJobCommand.run()がDELETE権限をチェック | E-07 L72 | ○ |
| C-21 | CopyJobCommand.run()が既存ジョブでIllegalStateException | E-08 L58-59 | ○ |
| C-22 | ListJobsCommand.run()が存在しないビューでIllegalArgumentException | E-09 L74 | ○ |
| C-23 | ConsoleCommand.run()がpermalinkを解決 | E-10 L54-66 | ○ |
| C-24 | ConsoleCommand.run()が-nオプションで行数制限 | E-10 L71, L97-140 | ○ |
| C-25 | InstallPluginCommand.run()がADMINISTER権限をチェック | E-11 L86 | ○ |
| C-26 | InstallPluginCommand.run()がURLからインストール | E-11 L106-118 | ○ |
| C-27 | InstallPluginCommand.run()がアップデートセンターからインストール | E-11 L121-142 | ○ |
| C-28 | DisablePluginCommand.run()が終了コード16/17を返却 | E-12 L66-67, L204-242 | ○ |
| C-29 | DisablePluginCommand.run()が-strategyオプションを処理 | E-12 L80-94 | ○ |
| C-30 | ConnectNodeCommand.run()がノードを接続 | E-13 L59-83 | ○ |
| C-31 | OfflineNodeCommand.run()が-mオプションで理由を設定 | E-14 L76 | ○ |
| C-32 | QuietDownCommand.run()がdoQuietDownを呼び出す | E-15 L59 | ○ |
| C-33 | QuietDownCommand.run()の-blockオプション | E-15 L43-47 | △ |
| C-34 | WhoAmICommand.run()が認証情報を出力 | E-16 L45-52 | ○ |
| C-35 | GroovyCommand.run()がADMINISTER権限をチェック | E-17 L66 | ○ |
| C-36 | CliCrumbExclusion.process()が/cliパスを除外 | E-18 L44-50 | ○ |
| C-37 | ViewOptionHandler.getView()がネストパスを解決 | E-19 L92-118 | ○ |
| C-38 | ViewOptionHandler.getView()がREAD権限をチェック | E-19 L104, L110 | ○ |
| C-39 | NodeOptionHandler.parseArguments()がノードを解決 | E-20 L52-60 | ○ |
| C-40 | GenericItemOptionHandler.parseArguments()が類似名を提案 | E-21 L73-78 | ○ |
| C-41 | CLIRegisterer.find()がCLIMethodを発見 | E-22 L98-255 | ○ |
| C-42 | MethodBinder.call()がメソッドを呼び出す | E-23 L113-122 | ○ |
| C-43 | CloneableCLICommand.createClone()の動作 | **根拠確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- **Connection.fold()の実際のユースケース**
  - このメソッドは暗号処理用のユーティリティだが、現在は使用されていない可能性がある（Connectionクラス自体が@Deprecated）
  - 候補：既存テストコード / 暗号化処理のドキュメント

- **QuietDownCommand blocking/timeout動作の詳細**
  - Jenkinsの内部状態管理に依存するため、実際の動作確認が必要
  - 候補：Jenkins本体のdoQuietDown()実装 / 統合テスト

- **CloneableCLICommand.createClone()の継承関係**
  - 抽象クラスの実装詳細を確認する必要がある
  - 候補：CloneableCLICommand.java / サブクラスの実装

- **WebSocket接続の詳細な振る舞い**
  - ALLOW_WEBSOCKET設定と実際のOriginチェックの相互作用
  - 候補：統合テスト / WebSocket関連の設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 表示系コマンド（HelpCommand, ListJobsCommand, WhoAmICommand）
- **1（中リスク）**: ノード操作コマンド（ConnectNodeCommand, OfflineNodeCommand）- 運用影響あり
- **2（高リスク）**:
  - BuildCommand - ビルド実行に影響
  - CreateJobCommand/DeleteJobCommand - データ変更
  - InstallPluginCommand/DisablePluginCommand - システム構成変更
  - GroovyCommand - 任意コード実行
  - WebSocket/認証関連 - セキュリティ影響

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェック関連のテストケース（UT-CLI-004, UT-CLI-047, UT-CLI-057, UT-CLI-064, UT-CLI-080, UT-CLI-098, UT-CLI-105）が適切か確認
- [ ] 例外ハンドリングの終了コード（UT-CLI-005〜011）がJenkins標準に準拠しているか確認
- [ ] WebSocket関連（UT-CLI-026〜028）のセキュリティテストが十分か確認
- [ ] バッチ処理（複数ジョブ/ノード）のエラーハンドリング（UT-CLI-065, UT-CLI-087）が適切か確認
- [ ] deprecated機能（Connection関連）のテストケースが必要か判断
- [ ] 実際のCLI実行環境との整合性を確認（統合テストとの連携）
