---
generated_at: 2026-01-22 21:30:00
metrics:
  claims_total: 116
  claims_with_evidence: 112
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：hudson.console 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：112 / 116、根拠なし：4
- 優先レビュー（高）
  1. **UT-CON-073 (C-73)**：リプレイ攻撃対策のタイムスタンプ検証ロジックの具体的な境界条件
  2. **UT-CON-089 (C-89)**：AbstractBuild後方互換性の実装詳細
  3. **UT-CON-101 (C-101)**：LineBuffer 64KB閾値の根拠（コード内定数から推測）
  4. **UT-CON-116 (C-116)**：ExpandableDetailsNote.encodeToのエラーハンドリング詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ConsoleNote.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ConsoleAnnotator.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/LineTransformationOutputStream.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/HyperlinkNote.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ModelHyperlinkNote.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/AnnotatedLargeText.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ConsoleAnnotatorFactory.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ConsoleAnnotationDescriptor.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/PlainTextConsoleOutputStream.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ConsoleLogFilter.java`
- E-11: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ConsoleAnnotationOutputStream.java`
- E-12: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/UrlAnnotator.java`
- E-13: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/console/ExpandableDetailsNote.java`
- E-14: `/Users/tomoka.baba/Work/jenkins-master/core/src/test/java/hudson/console/LineTransformationOutputStreamTest.java`
- E-15: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/console/HyperlinkNoteTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ConsoleNote クラス（C-01 〜 C-21）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | encode()でPREAMBLE+Base64(GZIP)+POSTAMBLE形式 | E-01 (L201-222) | ○ |
| C-02 | encodeTo(OutputStream)のアトミック書き込み | E-01 (L182-187) | ○ |
| C-03 | encodeTo(Writer)の動作 | E-01 (L196-199) | ○ |
| C-04 | readFrom()でのMAC検証付きデコード | E-01 (L240-292) | ○ |
| C-05 | 不正プリアンブルでnull返却 | E-01 (L244-245) | ○ |
| C-06 | 不正ポストアンブルでnull返却 | E-01 (L269-270) | ○ |
| C-07 | MAC不一致でIOException | E-01 (L275-276) | ○ |
| C-08 | 未署名ノートでIOException | E-01 (L273-274) | ○ |
| C-09 | INSECUREモードでの未署名許可 | E-01 (L272, L150) | ○ |
| C-10 | skip()の動作 | E-01 (L302-321) | ○ |
| C-11 | skip()での不正プリアンブル処理 | E-01 (L305-306) | ○ |
| C-12 | findPreamble()の検出ロジック | E-01 (L343-358) | ○ |
| C-13 | findPreamble()で-1返却 | E-01 (L357) | ○ |
| C-14 | findPreamble()先頭境界値 | E-01 (L343-358) | ○ |
| C-15 | findPreamble()末尾境界値 | E-01 (L343-358) | ○ |
| C-16 | removeNotes(String)単一ノート除去 | E-01 (L377-385) | ○ |
| C-17 | removeNotes(String)複数ノート除去 | E-01 (L378 whileループ) | ○ |
| C-18 | removeNotes(String)ノートなし | E-01 (L379-380) | ○ |
| C-19 | removeNotes(String)POSTAMBLE欠落 | E-01 (L381-382) | ○ |
| C-20 | removeNotes(Collection)の動作 | E-01 (L365-370) | ○ |
| C-21 | getDescriptor()の動作 | E-01 (L169-172) | ○ |

### ConsoleAnnotator クラス（C-22 〜 C-30）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | annotate()抽象メソッド | E-02 (L84-85) | ○ |
| C-23 | cast()メソッド | E-02 (L91-93) | ○ |
| C-24 | combine()空コレクション | E-02 (L132-133) | ○ |
| C-25 | combine()単一要素 | E-02 (L134) | ○ |
| C-26 | combine()複数要素 | E-02 (L135) | ○ |
| C-27 | ConsoleAnnotatorAggregator.annotate() | E-02 (L104-119) | ○ |
| C-28 | null返却でAnnotator除去 | E-02 (L109-110) | ○ |
| C-29 | initial()メソッド | E-02 (L143-145) | ○ |
| C-30 | _for()メソッド | E-02 (L151-161) | ○ |

### LineTransformationOutputStream クラス（C-31 〜 C-44）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | write(int)でLF処理 | E-03 (L61-62) | ○ |
| C-32 | write(int)でCRLF処理 | E-03 (L57-65), E-14 | ○ |
| C-33 | write(int)でCR単独処理 | E-03 (L63-64), E-14 | ○ |
| C-34 | 通常文字のバッファ蓄積 | E-03 (L60) | ○ |
| C-35 | write(byte[],int,int)処理 | E-03 (L80-85) | ○ |
| C-36 | close()でバッファ処理 | E-03 (L88-90) | ○ |
| C-37 | forceEol()バッファあり | E-03 (L98-106) | ○ |
| C-38 | forceEol()バッファ空 | E-03 (L99) | ○ |
| C-39 | trimEOL()でLF除去 | E-03 (L108-120) | ○ |
| C-40 | trimEOL()でCRLF除去 | E-03 (L108-120) | ○ |
| C-41 | trimEOL()改行なし | E-03 (L108-120) | ○ |
| C-42 | 4KB超でバッファリセット | E-03 (L72-75) | ○ |
| C-43 | Delegating.flush() | E-03 (L137-139) | ○ |
| C-44 | Delegating.close() | E-03 (L142-145) | ○ |

### HyperlinkNote クラス（C-45 〜 C-53）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | コンストラクタ | E-04 (L56-59) | ○ |
| C-46 | annotate()コンテキストパス | E-04 (L64-68) | ○ |
| C-47 | annotate()ルートURL | E-04 (L69-72) | ○ |
| C-48 | annotate()絶対URL | E-04 (L62-74) | ○ |
| C-49 | annotate()特殊文字エスケープ | E-04 (L74) Util.escape() | ○ |
| C-50 | encodeTo() | E-04 (L82-84) | ○ |
| C-51 | 改行をスペースに置換 | E-04 (L92), E-15 | ○ |
| C-52 | CRをスペースに置換 | E-04 (L92), E-15 | ○ |
| C-53 | extraAttributes() | E-04 (L78-80) | ○ |

### ModelHyperlinkNote クラス（C-54 〜 C-61）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-54 | extraAttributes()でmodel-link | E-05 (L30-32) | ○ |
| C-55 | encodeTo(User) | E-05 (L34-35) | ○ |
| C-56 | encodeTo(Item) | E-05 (L42-43) | ○ |
| C-57 | encodeTo(Run) | E-05 (L50-52) | ○ |
| C-58 | encodeTo(Node)Computer付き | E-05 (L55-57) | ○ |
| C-59 | encodeTo(Node)Computer無し | E-05 (L58-60) | ○ |
| C-60 | encodeTo(Node)マスター | E-05 (L59) | ○ |
| C-61 | encodeTo(Label) | E-05 (L66-68) | ○ |

### AnnotatedLargeText クラス（C-62 〜 C-73）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタ(File) | E-06 (L87-90) | ○ |
| C-63 | コンストラクタ(ByteBuffer) | E-06 (L92-95) | ○ |
| C-64 | doProgressiveHtml() | E-06 (L105-111) | ○ |
| C-65 | doProgressiveText() | E-06 (L132-134) | ○ |
| C-66 | writeLogTo()HTML | E-06 (L211-216) | ○ |
| C-67 | writeLogTo()非HTML | E-06 (L215) | ○ |
| C-68 | writeLogTo(OutputStream) | E-06 (L229-231) | ○ |
| C-69 | writeRawLogTo() | E-06 (L238-240) | ○ |
| C-70 | writeHtmlTo()ヘッダー | E-06 (L256-261) | ○ |
| C-71 | createAnnotator()復元 | E-06 (L180-202) | ○ |
| C-72 | createAnnotator()ヘッダーなし | E-06 (L200-201) | ○ |
| C-73 | createAnnotator()タイムスタンプ検証 | E-06 (L189-192) | △ |

### ConsoleAnnotatorFactory クラス（C-74 〜 C-79）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | type()ジェネリック型取得 | E-07 (L91-97) | ○ |
| C-75 | type()型引数なし | E-07 (L95-96) | ○ |
| C-76 | hasScript()あり | E-07 (L102-104) | ○ |
| C-77 | hasScript()なし | E-07 (L102-104) | ○ |
| C-78 | hasStylesheet() | E-07 (L106-108) | ○ |
| C-79 | all() | E-07 (L132-134) | ○ |

### ConsoleAnnotationDescriptor クラス（C-80 〜 C-82）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | hasScript() | E-08 (L68-70) | ○ |
| C-81 | hasStylesheet() | E-08 (L75-77) | ○ |
| C-82 | all() | E-08 (L96-98) | ○ |

### PlainTextConsoleOutputStream クラス（C-83 〜 C-87）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | コンストラクタ | E-09 (L48-50) | ○ |
| C-84 | eol()ConsoleNote除去 | E-09 (L56-87) | ○ |
| C-85 | eol()通常テキスト | E-09 (L86) | ○ |
| C-86 | eol()複数ConsoleNote | E-09 (L62-84 whileループ) | ○ |
| C-87 | eol()不正Note処理 | E-09 (L75-77) | ○ |

### ConsoleLogFilter クラス（C-88 〜 C-91）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | decorateLogger(Run, OutputStream) | E-10 (L85-96) | ○ |
| C-89 | decorateLogger(AbstractBuild, OutputStream) | E-10 (L66-75) | △ |
| C-90 | decorateLogger(Computer, OutputStream) | E-10 (L106-108) | ○ |
| C-91 | all() | E-10 (L113-115) | ○ |

### ConsoleAnnotationOutputStream クラス（C-92 〜 C-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | コンストラクタ | E-11 (L69-74) | ○ |
| C-93 | getConsoleAnnotator() | E-11 (L76-78) | ○ |
| C-94 | eol()MarkupText変換 | E-11 (L86-149) | ○ |
| C-95 | eol()Annotator更新 | E-11 (L137-141, L147) | ○ |
| C-96 | eol()複数ConsoleNote | E-11 (L92-133) | ○ |
| C-97 | eol()デシリアライズ失敗 | E-11 (L123-126) | ○ |
| C-98 | flush() | E-11 (L152-154) | ○ |
| C-99 | close() | E-11 (L156-160) | ○ |
| C-100 | LineBuffer.reset()64KB未満 | E-11 (L174-179) | ○ |
| C-101 | LineBuffer.reset()64KB以上 | E-11 (L176-177) | △ |

### UrlAnnotator クラス（C-102 〜 C-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | newInstance() | E-12 (L18-20) | ○ |
| C-103 | HTTP URLハイパーリンク化 | E-12 (L45 Pattern) | ○ |
| C-104 | HTTPS URLハイパーリンク化 | E-12 (L45 Pattern) | ○ |
| C-105 | FTP URLハイパーリンク化 | E-12 (L45 Pattern) | ○ |
| C-106 | File URLハイパーリンク化 | E-12 (L45 Pattern) | ○ |
| C-107 | 括弧内URL閉じ括弧除外 | E-12 (L26-31, L47-48) | ○ |
| C-108 | 引用符内URL除外 | E-12 (L47-48 OPEN/CLOSE) | ○ |
| C-109 | 末尾句読点除外 | E-12 (L45 Pattern末尾) | ○ |
| C-110 | 複数URLリンク化 | E-12 (L25 forループ) | ○ |
| C-111 | self返却 | E-12 (L34) | ○ |

### ExpandableDetailsNote クラス（C-112 〜 C-116）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 | コンストラクタ | E-13 (L48-51) | ○ |
| C-113 | annotate()マークアップ追加 | E-13 (L54-59) | ○ |
| C-114 | captionエスケープ | E-13 (L57) Util.xmlEscape() | ○ |
| C-115 | encodeTo()正常 | E-13 (L61-69) | ○ |
| C-116 | encodeTo()エラー時 | E-13 (L64-67) | △ |

## 4) 不足情報（Unknown / Missing）

### C-73: リプレイ攻撃対策のタイムスタンプ検証
- コード上は `TimeUnit.HOURS.toMillis(1)` で1時間の閾値が設定されているが、この値の選定根拠となる設計文書は見つからなかった
- 候補：セキュリティ設計書 / Jenkins Security Advisory

### C-89: AbstractBuild後方互換性
- `Util.isOverridden` を使用した後方互換性ロジックは実装から読み取れるが、どのバージョンからの互換性を保証しているかの明示的な文書なし
- 候補：リリースノート / 移行ガイド

### C-101: LineBuffer 64KB閾値
- コード内で `64 * 1024` という定数で64KBが設定されているが、この値の選定根拠は不明
- 候補：パフォーマンステスト結果 / メモリ使用量分析

### C-116: ExpandableDetailsNote.encodeToエラーハンドリング
- IOExceptionをキャッチして空文字列を返すエラーハンドリングは実装されているが、どのような状況でIOExceptionが発生するかの詳細文書なし
- 候補：例外設計書

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコードから直接導出可能
- **1 (中リスク)**: C-73のリプレイ攻撃対策は1時間という閾値の妥当性を別途検証推奨
- **1 (中リスク)**: C-07/C-08のMAC検証関連はセキュリティクリティカルなため実装との整合性を重点確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ConsoleNote.readFrom()のMAC検証ロジック（C-04〜C-09）がセキュリティ要件を満たしているか
- [ ] LineTransformationOutputStreamの改行処理（C-31〜C-33）が全プラットフォームで動作するか
- [ ] HyperlinkNoteのXSS対策（C-49, C-114）が十分か
- [ ] AnnotatedLargeText.createAnnotator()のタイムスタンプ検証（C-73）が適切か
- [ ] UrlAnnotatorのURL検出パターン（C-103〜C-109）が想定されるURL形式を網羅しているか
