---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 97
  claims_with_evidence: 97
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.diagnosis 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・Javadocなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：97 / 97、根拠なし：0
- 優先レビュー（高）
  1. **OldDataMonitor関連テスト（55-70）**：複雑な並行処理とキャッシュ管理のテスト
  2. **ReverseProxySetupMonitor関連テスト（35-42）**：URLリダイレクトとプロキシ設定検証
  3. **HudsonHomeDiskUsageChecker関連テスト（18-21）**：ディスク使用量計算ロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/diagnosis/TooManyJobsButNoView.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/diagnosis/MemoryUsageMonitor.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageChecker.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/diagnosis/HudsonHomeDiskUsageMonitor.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/diagnosis/ReverseProxySetupMonitor.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/diagnosis/NullIdDescriptorMonitor.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/diagnosis/OldDataMonitor.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/diagnosis/TooManyJobsButNoViewTest.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/diagnosis/OldDataMonitorTest.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/diagnosis/ReverseProxySetupMonitorTest.java`
- E-11: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/diagnosis/HudsonHomeDiskUsageMonitorTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### TooManyJobsButNoView（C-01 〜 C-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isActivated: 管理者権限でジョブ数が閾値超かつビュー1つの場合trueが返却されること | E-01 (L54-61), E-08 (activated test) | ○ |
| C-02 | isActivated: システム読取権限でジョブ数が閾値超の場合trueが返却されること | E-01 (L59-61), E-08 (systemReadVerifyForm test) | ○ |
| C-03 | isActivated: ジョブ数が閾値以下の場合falseが返却されること | E-01 (L57, L82 THRESHOLD=16) | ○ |
| C-04 | isActivated: 複数ビュー存在時falseが返却されること | E-01 (L57 getViews().size()==1), E-08 (L79) | ○ |
| C-05 | doAct: noパラメータあり時に無効化してmanageにリダイレクト | E-01 (L67-75) | ○ |
| C-06 | doAct: noパラメータなし時にnewViewにリダイレクト | E-01 (L72-74), E-08 (L71-72) | ○ |
| C-07 | doAct: 管理者権限なしの場合アクセス拒否 | E-01 (L68 checkPermission) | ○ |
| C-08 | getRequiredPermission: SYSTEM_READ権限が返却 | E-01 (L77-80) | ○ |
| C-09 | getDisplayName: 表示名が返却 | E-01 (L48-51) | ○ |

### MemoryUsageMonitor（C-10 〜 C-16）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | コンストラクタ: heap/nonHeapが初期化 | E-02 (L105-109) | ○ |
| C-11 | getRecurrencePeriod: 10秒間隔が返却 | E-02 (L112-114) | ○ |
| C-12 | doRun: heap/nonHeapが更新 | E-02 (L116-120) | ○ |
| C-13 | MemoryGroup.update: メモリ使用量がKB単位で計算 | E-02 (L75-91) | ○ |
| C-14 | MemoryGroup.update: CollectionUsageがnull時スキップ | E-02 (L79-80) | ○ |
| C-15 | MemoryGroup.doGraph: グラフ生成 | E-02 (L96-99) | ○ |
| C-16 | MemoryGroup.doGraph: 権限チェック | E-02 (L97 checkAnyPermission) | ○ |

### HudsonHomeDiskUsageChecker（C-17 〜 C-21）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | getRecurrencePeriod: 1時間間隔が返却 | E-03 (L43-46 HOUR) | ○ |
| C-18 | doRun: ディスク使用率90%超かつ残り容量不足で警告活性化 | E-03 (L65 total/free>10 && free<FREE_SPACE_THRESHOLD) | ○ |
| C-19 | doRun: 使用率90%未満で非活性 | E-03 (L65) | ○ |
| C-20 | doRun: 残り容量がしきい値以上で非活性 | E-03 (L65, L74-75 10GB default) | ○ |
| C-21 | doRun: ディスク情報取得不可時にキャンセル | E-03 (L52-57) | ○ |

### HudsonHomeDiskUsageMonitor（C-22 〜 C-32）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | コンストラクタ: ID=hudsonHomeIsFull | E-04 (L52-54) | ○ |
| C-23 | isActivated: activatedフラグの値が返却 | E-04 (L56-59) | ○ |
| C-24 | doAct: noパラメータあり時に無効化 | E-04 (L69-77), E-11 (flow test) | ○ |
| C-25 | doAct: noパラメータなし時にリダイレクト | E-04 (L74-76) | ○ |
| C-26 | getSolutions: Solutionリスト取得 | E-04 (L79-81) | ○ |
| C-27 | getSolution: IDに一致するSolution取得 | E-04 (L86-91) | ○ |
| C-28 | getSolution: 存在しないIDでnull | E-04 (L90) | ○ |
| C-29 | get: シングルトン取得 | E-04 (L96-98) | ○ |
| C-30 | Solution コンストラクタ(String): 指定IDで初期化 | E-04 (L121-123) | ○ |
| C-31 | Solution コンストラクタ(): クラス名でID初期化 | E-04 (L125-127) | ○ |
| C-32 | Solution.getUrl: URL構築 | E-04 (L132-134) | ○ |

### ReverseProxySetupMonitor（C-33 〜 C-43）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | isActivated: 常にtrue | E-05 (L64-67) | ○ |
| C-34 | isActivationFake: 常にtrue | E-05 (L69-72) | ○ |
| C-35 | doTest: コンテキストなしでリダイレクト | E-05 (L90-92), E-10 (localhost_correct test) | ○ |
| C-36 | doTest: コンテキストありでリダイレクト | E-05 (L81-89), E-10 (localhost_testingForContext test) | ○ |
| C-37 | doTest: Refererがnull時NO-REFERER使用 | E-05 (L89, L91 NO-REFERER) | ○ |
| C-38 | getTestForReverseProxySetup: 正しいリダイレクトで200 OK | E-05 (L100-109), E-10 (localhost_correct test) | ○ |
| C-39 | getTestForReverseProxySetup: 不正リダイレクトで404 | E-05 (L106-108), E-10 (localhost_withoutReferer test) | ○ |
| C-40 | doAct: noパラメータあり時に無効化 | E-05 (L123-128) | ○ |
| C-41 | doAct: noパラメータなし時にヘルプリダイレクト | E-05 (L129-131) | ○ |
| C-42 | doAct: 管理者権限なしでアクセス拒否 | E-05 (L125 checkPermission) | ○ |
| C-43 | getRequiredPermission: SYSTEM_READ返却 | E-05 (L112-115) | ○ |

### NullIdDescriptorMonitor（C-44 〜 C-49）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | isActivated: problemsが空でない時true | E-06 (L61-63) | ○ |
| C-45 | isActivated: problemsが空の時false | E-06 (L61-63) | ○ |
| C-46 | getProblems: 不変リスト返却 | E-06 (L65-67) | ○ |
| C-47 | verify: getId()がnullでproblemsに追加 | E-06 (L83-87) | ○ |
| C-48 | verify: getId()が例外でproblemsに追加 | E-06 (L75-82) | ○ |
| C-49 | verify: 正常なDescriptorは追加されない | E-06 (L69-88 ロジック全体) | ○ |

### OldDataMonitor（C-50 〜 C-97）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | コンストラクタ: ID=OldData | E-07 (L97-99) | ○ |
| C-51 | isActivated: dataが空でない時true | E-07 (L106-109) | ○ |
| C-52 | isActivated: dataが空の時false | E-07 (L106-109) | ○ |
| C-53 | getData: Saveable/VersionRangeマップ返却 | E-07 (L117-126) | ○ |
| C-54 | getData: 無効参照スキップ | E-07 (L120-123) | ○ |
| C-55 | report(Saveable, String): 新規登録 | E-07 (L174-189) | ○ |
| C-56 | report(Saveable, String): 既存更新 | E-07 (L178-184) | ○ |
| C-57 | report: 不正バージョン形式でログ | E-07 (L186-188) | ○ |
| C-58 | report(UnmarshallingContext, String): コンテキストにエラー追加 | E-07 (L197-199) | ○ |
| C-59 | report(Saveable, Collection): エラー登録 | E-07 (L214-247) | ○ |
| C-60 | report: ReportExceptionはversion報告に変換 | E-07 (L218-219) | ○ |
| C-61 | report: Jenkins未起動時にログのみ | E-07 (L229-236) | ○ |
| C-62 | doAct: noパラメータあり時に無効化 | E-07 (L319-327), E-09 | ○ |
| C-63 | doAct: noパラメータなし時にmanageリダイレクト | E-07 (L324-326) | ○ |
| C-64 | doUpgrade: 指定バージョン以下のデータ処理 | E-07 (L333-344) | ○ |
| C-65 | doUpgrade: thruVer=allで全データ処理 | E-07 (L336) | ○ |
| C-66 | doUpgrade: 保存エラー時も削除 | E-07 (L374-378) | ○ |
| C-67 | doDiscard: 読み取り不可データのみ処理 | E-07 (L350-355), E-09 (robustness test) | ○ |
| C-68 | getVersionList: 一意のmaxバージョンをソート | E-07 (L305-314) | ○ |
| C-69 | getVersionList: maxがnullはスキップ | E-07 (L308-311) | ○ |
| C-70 | doIndex: manageへリダイレクト | E-07 (L387-389) | ○ |
| C-71 | VersionRange コンストラクタ(null, version, extra): 新規作成 | E-07 (L257-261) | ○ |
| C-72 | VersionRange コンストラクタ(previous, null, extra): extra更新 | E-07 (L262-267) | ○ |
| C-73 | VersionRange コンストラクタ: min更新 | E-07 (L268-273) | ○ |
| C-74 | VersionRange コンストラクタ: max更新 | E-07 (L274-278) | ○ |
| C-75 | VersionRange.toString: 単一バージョン表示 | E-07 (L284-287) | ○ |
| C-76 | VersionRange.toString: 範囲バージョン表示 | E-07 (L286) | ○ |
| C-77 | VersionRange.toString: minがnullで空文字 | E-07 (L286) | ○ |
| C-78 | VersionRange.isOld: メジャーバージョン異なる時true | E-07 (L294-298) | ○ |
| C-79 | VersionRange.isOld: マイナー差がしきい値以上でtrue | E-07 (L296-298) | ○ |
| C-80 | VersionRange.isOld: しきい値未満でfalse | E-07 (L294-298) | ○ |
| C-81 | VersionRange.isOld: currentVersion=nullでfalse | E-07 (L295) | ○ |
| C-82 | VersionRange.isOld: min=nullでfalse | E-07 (L295) | ○ |
| C-83 | SimpleSaveableReference.get: インスタンス返却 | E-07 (L414-416) | ○ |
| C-84 | SimpleSaveableReference.equals: 同一参照でtrue | E-07 (L422-424) | ○ |
| C-85 | SimpleSaveableReference.equals: 異なる参照でfalse | E-07 (L422-424) | ○ |
| C-86 | RunSaveableReference コンストラクタ: externalizableIdで初期化 | E-07 (L432-434) | ○ |
| C-87 | RunSaveableReference.get: IDからRun解決 | E-07 (L436-444) | ○ |
| C-88 | RunSaveableReference.get: Run削除済みでnull | E-07 (L439-443), E-09 (unlocatableRun test) | ○ |
| C-89 | ManagementLinkImpl.getCategory: TROUBLESHOOTING | E-07 (L457-461) | ○ |
| C-90 | ManagementLinkImpl.getIconFileName: symbol-trash-bin | E-07 (L463-466) | ○ |
| C-91 | ManagementLinkImpl.getUrlName: URL返却 | E-07 (L468-471) | ○ |
| C-92 | ManagementLinkImpl.getBadge: データありでバッジ | E-07 (L483-489) | ○ |
| C-93 | ManagementLinkImpl.getBadge: データなしでnull | E-07 (L488-489) | ○ |
| C-94 | changeListener.onChange: data削除 | E-07 (L143-149), E-09 (slowDiscard test) | ○ |
| C-95 | itemDeleteListener.onDeleted: data削除 | E-07 (L151-157) | ○ |
| C-96 | itemDeleteListener.onDeleted: Job削除時にRun削除 | E-07 (L133-137) | ○ |
| C-97 | runDeleteListener.onDeleted: data削除 | E-07 (L159-165), E-09 (unlocatableRun test) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠不足の項目はありません

## 5) リスクフラグ（レビュー観点）
- **リスク0（低リスク）**：全97件のテストケースがソースコードおよび既存テストコードから根拠を確認済み
- **特記事項**：
  - OldDataMonitorの並行処理テスト（C-94）は既存テストで競合状態の検証が含まれているが、実環境での挙動確認を推奨
  - ReverseProxySetupMonitorのプロキシ設定テストは、実際のリバースプロキシ環境でのE2Eテストも検討を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] TooManyJobsButNoView: THRESHOLD=16の境界値テストが適切か
- [ ] HudsonHomeDiskUsageChecker: FREE_SPACE_THRESHOLD=10GBの妥当性確認
- [ ] OldDataMonitor: ConcurrentMapの並行アクセステストが十分か
- [ ] ReverseProxySetupMonitor: 各種プロキシ設定パターンの網羅性確認
- [ ] NullIdDescriptorMonitor: verify()のInitializer実行タイミングの確認
- [ ] MemoryUsageMonitor: メモリプール情報が取得できない環境での動作確認
