---
generated_at: 2026-01-22 21:15:00
metrics:
  claims_total: 101
  claims_with_evidence: 98
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：hudson.init 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：98 / 101、根拠なし：3
- 優先レビュー（高）
  1. **UT-INIT-082, 083**: GroovyInitScript.initのGroovyHookScriptの内部動作（外部クラス依存）
  2. **UT-INIT-085**: Groovyスクリプトエラー時の挙動（外部クラスの例外ハンドリングに依存）
  3. **UT-INIT-054**: InitStrategy.listPluginArchivesのIOException条件（ファイルシステム依存）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/init/InitMilestone.java`
- E-02: `core/src/main/java/hudson/init/TermMilestone.java`
- E-03: `core/src/main/java/hudson/init/InitializerFinder.java`
- E-04: `core/src/main/java/hudson/init/TerminatorFinder.java`
- E-05: `core/src/main/java/hudson/init/TaskMethodFinder.java`
- E-06: `core/src/main/java/hudson/init/InitStrategy.java`
- E-07: `core/src/main/java/hudson/init/impl/InstallUncaughtExceptionHandler.java`
- E-08: `core/src/main/java/hudson/init/impl/GroovyInitScript.java`
- E-09: `core/src/main/java/hudson/init/impl/InitialUserContent.java`
- E-10: `core/src/main/java/hudson/init/Initializer.java`
- E-11: `core/src/main/java/hudson/init/Terminator.java`
- E-12: `test/src/test/java/hudson/init/InitMilestoneTest.java`（既存テスト参考）
- E-13: `test/src/test/java/hudson/init/impl/GroovyInitScriptTest.java`（既存テスト参考）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-INIT-001) | InitMilestone.ordering()がマイルストーン数-1個のタスクを生成 | E-01 L132-138 | ○ |
| C-02 (UT-INIT-002) | タスクがv[i]をrequiresしv[i+1]をattainsする | E-01 L136 | ○ |
| C-03 (UT-INIT-003) | InitMilestone.STARTEDのtoString()が"Started initialization"を返す | E-01 L62 | ○ |
| C-04 (UT-INIT-004) | InitMilestone.COMPLETEDのtoString()が"Completed initialization"を返す | E-01 L121 | ○ |
| C-05 (UT-INIT-005) | InitMilestoneに10個のenum値が定義 | E-01 L56-121 | ○ |
| C-06 (UT-INIT-006) | マイルストーンの順序が正しい | E-01 L40-52, L56-121 | ○ |
| C-07 (UT-INIT-007) | TermMilestone.ordering()がマイルストーン数-1個のタスクを生成 | E-02 L44-49 | ○ |
| C-08 (UT-INIT-008) | TermMilestone.STARTEDのtoString()が"Started termination"を返す | E-02 L26 | ○ |
| C-09 (UT-INIT-009) | TermMilestone.COMPLETEDのtoString()が"Completed termination"を返す | E-02 L33 | ○ |
| C-10 (UT-INIT-010) | TermMilestoneに2個のenum値が定義 | E-02 L26, L33 | ○ |
| C-11 (UT-INIT-011) | InitializerFinder(ClassLoader)コンストラクタ | E-03 L36-38 | ○ |
| C-12 (UT-INIT-012) | InitializerFinder()がThread.currentThread().getContextClassLoader()を使用 | E-03 L40-42 | ○ |
| C-13 (UT-INIT-013) | displayNameOf()がi.displayName()を返す | E-03 L45-47 | ○ |
| C-14 (UT-INIT-014) | requiresOf()がi.requires()を返す | E-03 L50-52 | ○ |
| C-15 (UT-INIT-015) | attainsOf()がi.attains()を返す | E-03 L55-57 | ○ |
| C-16 (UT-INIT-016) | afterOf()がi.after()を返す | E-03 L60-62 | ○ |
| C-17 (UT-INIT-017) | beforeOf()がi.before()を返す | E-03 L65-67 | ○ |
| C-18 (UT-INIT-018) | fatalOf()がi.fatal()を返す(true) | E-03 L70-72 | ○ |
| C-19 (UT-INIT-019) | fatalOf()がi.fatal()を返す(false) | E-03 L70-72 | ○ |
| C-20 (UT-INIT-020) | TerminatorFinder(ClassLoader)コンストラクタ | E-04 L9-11 | ○ |
| C-21 (UT-INIT-021) | TerminatorFinder.displayNameOf()がi.displayName()を返す | E-04 L14-16 | ○ |
| C-22 (UT-INIT-022) | TerminatorFinder.requiresOf()がi.requires()を返す | E-04 L19-21 | ○ |
| C-23 (UT-INIT-023) | TerminatorFinder.attainsOf()がi.attains()を返す | E-04 L24-26 | ○ |
| C-24 (UT-INIT-024) | TerminatorFinder.afterOf()がi.after()を返す | E-04 L29-31 | ○ |
| C-25 (UT-INIT-025) | TerminatorFinder.beforeOf()がi.before()を返す | E-04 L33-35 | ○ |
| C-26 (UT-INIT-026) | TerminatorFinder.fatalOf()が常にfalseを返す | E-04 L41-44 | ○ |
| C-27 (UT-INIT-027) | TaskImpl.requiresの構築 | E-05 L145 | ○ |
| C-28 (UT-INIT-028) | TaskImpl.attainsの構築 | E-05 L146 | ○ |
| C-29 (UT-INIT-029) | displayName空の場合ClassName.methodName形式 | E-05 L85 | ○ |
| C-30 (UT-INIT-030) | displayName指定時Messages.propertiesから取得 | E-05 L87-89 | ○ |
| C-31 (UT-INIT-031) | Messages.propertiesにキーがない場合キー自体を返す | E-05 L93-95 | ○ |
| C-32 (UT-INIT-032) | failureIsFatal()がfatalOf()の結果を返す | E-05 L179-181 | ○ |
| C-33 (UT-INIT-033) | TaskImpl.run()がinvoke()を呼ぶ | E-05 L184-186 | ○ |
| C-34 (UT-INIT-034) | TaskImpl.toString()がe.toString()を返す | E-05 L189-191 | ○ |
| C-35 (UT-INIT-035) | getAnnotation()がiを返す | E-05 L152-154 | ○ |
| C-36 (UT-INIT-036) | getMethod()がeを返す | E-05 L159-161 | ○ |
| C-37 (UT-INIT-037) | toMilestones()が文字列をenum値に変換 | E-05 L197 | ○ |
| C-38 (UT-INIT-038) | toMilestones()が未知文字列をMilestoneImplに変換 | E-05 L198-199 | ○ |
| C-39 (UT-INIT-039) | discoverTasks()がアノテーション付きメソッドを発見 | E-05 L59-69 | ○ |
| C-40 (UT-INIT-040) | filter()で重複メソッドがフィルタリング | E-05 L62, L75-77 | ○ |
| C-41 (UT-INIT-041) | stale indexの場合スキップ | E-05 L65 | ○ |
| C-42 (UT-INIT-042) | filter()初回呼び出しでfalse | E-05 L75-77 | ○ |
| C-43 (UT-INIT-043) | filter()2回目呼び出しでtrue | E-05 L75-77 | ○ |
| C-44 (UT-INIT-044) | staticメソッドがnullインスタンスで呼び出し | E-05 L110 | ○ |
| C-45 (UT-INIT-045) | インスタンスメソッドがDI解決インスタンスで呼び出し | E-05 L110 | ○ |
| C-46 (UT-INIT-046) | Jenkins型パラメータが注入 | E-05 L125-126 | ○ |
| C-47 (UT-INIT-047) | Hudson型パラメータが注入 | E-05 L125-126 | ○ |
| C-48 (UT-INIT-048) | 注入不可能な型でIllegalArgumentException | E-05 L130 | ○ |
| C-49 (UT-INIT-049) | IllegalAccessExceptionでIllegalAccessError | E-05 L113 | ○ |
| C-50 (UT-INIT-050) | InvocationTargetExceptionでError | E-05 L115 | ○ |
| C-51 (UT-INIT-051) | listPluginArchives()がプラグインリストを返す | E-06 L46-61 | ○ |
| C-52 (UT-INIT-052) | 優先順位順でリスト返却(jpl>hpl>jpi>hpi) | E-06 L55-58 | ○ |
| C-53 (UT-INIT-053) | bundled.pluginsが先に追加 | E-06 L52 | ○ |
| C-54 (UT-INIT-054) | rootDir不存在でIOException | E-06 L66 | ○ |
| C-55 (UT-INIT-055) | プラグイン0件で空リスト | E-06 L47, L60 | ○ |
| C-56 (UT-INIT-056) | カンマ区切り複数プラグイン取得 | E-06 L85 | ○ |
| C-57 (UT-INIT-057) | glob patternでプラグイン取得 | E-06 L89-95 | ○ |
| C-58 (UT-INIT-058) | 存在しないファイルで警告ログ | E-06 L100 | ○ |
| C-59 (UT-INIT-059) | プロパティnullで何も追加しない | E-06 L83 | ○ |
| C-60 (UT-INIT-060) | ファイル名でソート | E-06 L103 | ○ |
| C-61 (UT-INIT-061) | skipInitTask()がデフォルトfalse | E-06 L114-116 | ○ |
| C-62 (UT-INIT-062) | ServiceLoaderで実装返却 | E-06 L123-128 | ○ |
| C-63 (UT-INIT-063) | ServiceLoader未登録でデフォルト | E-06 L124-125 | ○ |
| C-64 (UT-INIT-064) | FilterByExtension.accept()指定拡張子でtrue | E-06 L142-148 | ○ |
| C-65 (UT-INIT-065) | FilterByExtension.accept()指定外でfalse | E-06 L142-148 | ○ |
| C-66 (UT-INIT-066) | FilterByExtension複数拡張子対応 | E-06 L143-145 | ○ |
| C-67 (UT-INIT-067) | InstallUncaughtExceptionHandler.init()でハンドラ設定 | E-07 L33 | ○ |
| C-68 (UT-INIT-068) | DefaultUncaughtExceptionHandlerがスレッドに設定 | E-07 L35 | ○ |
| C-69 (UT-INIT-069) | SecurityExceptionで警告ログ | E-07 L38-44 | ○ |
| C-70 (UT-INIT-070) | レスポンス未コミット時/oopsページ | E-07 L59 | ○ |
| C-71 (UT-INIT-071) | レスポンスコミット済みでログのみ | E-07 L49-51 | ○ |
| C-72 (UT-INIT-072) | 例外IDがUUIDで生成 | E-07 L53-55 | ○ |
| C-73 (UT-INIT-073) | EOFExceptionでFINEレベルログ | E-07 L50, L54 | ○ |
| C-74 (UT-INIT-074) | 非EOFExceptionでWARNINGレベルログ | E-07 L50, L54 | ○ |
| C-75 (UT-INIT-075) | isEOFException()でEOFExceptionはtrue | E-07 L88-89 | ○ |
| C-76 (UT-INIT-076) | isEOFException()でnullはfalse | E-07 L86-87 | ○ |
| C-77 (UT-INIT-077) | isEOFException()でcauseがEOFExceptionならtrue | E-07 L91 | ○ |
| C-78 (UT-INIT-078) | isEOFException()でcauseがnullでEOF以外はfalse | E-07 L86-91 | ○ |
| C-79 (UT-INIT-079) | DefaultUncaughtExceptionHandler.uncaughtException()でSEVEREログ | E-07 L101-104 | ○ |
| C-80 (UT-INIT-080) | ErrorCustomizer.handleError()でJenkins存在時HttpResponseException | E-07 L72-81 | ○ |
| C-81 (UT-INIT-081) | ErrorCustomizer.handleError()でJenkinsがnullならnull | E-07 L73-74 | ○ |
| C-82 (UT-INIT-082) | GroovyInitScript.init()でinit.groovyが実行 | E-08 L42 | △ |
| C-83 (UT-INIT-083) | init.groovy.dディレクトリのスクリプト実行 | E-08 L42 | △ |
| C-84 (UT-INIT-084) | スクリプト不存在でエラーなく完了 | E-08 L42, E-13 | ○ |
| C-85 (UT-INIT-085) | スクリプトエラー時ログ出力 | E-08 L42 | △ |
| C-86 (UT-INIT-086) | InitialUserContent.init()でuserContentディレクトリ作成 | E-09 L46-47 | ○ |
| C-87 (UT-INIT-087) | readme.txt作成 | E-09 L48 | ○ |
| C-88 (UT-INIT-088) | readme.txtにメッセージ含む | E-09 L48 | ○ |
| C-89 (UT-INIT-089) | 既存userContentで何もしない | E-09 L46 | ○ |
| C-90 (UT-INIT-090) | ディレクトリ作成失敗でIOException | E-09 L47-48 | ○ |
| C-91 (UT-INIT-091) | Initializer.after()デフォルトSTARTED | E-10 L69 | ○ |
| C-92 (UT-INIT-092) | Initializer.before()デフォルトCOMPLETED | E-10 L78 | ○ |
| C-93 (UT-INIT-093) | Initializer.requires()デフォルト空配列 | E-10 L83 | ○ |
| C-94 (UT-INIT-094) | Initializer.attains()デフォルト空配列 | E-10 L91 | ○ |
| C-95 (UT-INIT-095) | Initializer.displayName()デフォルト空文字列 | E-10 L97 | ○ |
| C-96 (UT-INIT-096) | Initializer.fatal()デフォルトtrue | E-10 L104 | ○ |
| C-97 (UT-INIT-097) | Terminator.after()デフォルトSTARTED | E-11 L30 | ○ |
| C-98 (UT-INIT-098) | Terminator.before()デフォルトCOMPLETED | E-11 L39 | ○ |
| C-99 (UT-INIT-099) | Terminator.requires()デフォルト空配列 | E-11 L44 | ○ |
| C-100 (UT-INIT-100) | Terminator.attains()デフォルト空配列 | E-11 L52 | ○ |
| C-101 (UT-INIT-101) | Terminator.displayName()デフォルト空文字列 | E-11 L58 | ○ |

## 4) 不足情報（Unknown / Missing）
- **GroovyHookScriptの内部動作**：GroovyInitScript.init()はGroovyHookScriptに処理を委譲しているため、init.groovyやinit.groovy.d/の詳細な動作はGroovyHookScriptクラス（jenkins.util.groovy.GroovyHookScript）の実装に依存
  - 候補：jenkins/util/groovy/GroovyHookScript.java / 既存のGroovyInitScriptTest.java
- **glob展開のエッジケース**：InitStrategy.getBundledPluginsFromProperty()のglob展開はDirScanner.Globに依存しており、パターンマッチングの詳細な挙動は外部クラスの実装に依存
  - 候補：hudson/util/DirScanner.java

## 5) リスクフラグ（レビュー観点）
- 0: InitMilestone/TermMilestoneのenum定義とordering()メソッド - 低リスク（単純なデータ構造）
- 0: アノテーション定義（Initializer/Terminator） - 低リスク（宣言的定義）
- 1: TaskMethodFinder.invoke() - 中リスク（リフレクションとDIの複合処理）
- 1: InitStrategy.listPluginArchives() - 中リスク（ファイルシステム操作）
- 1: InstallUncaughtExceptionHandler - 中リスク（例外ハンドリングとServlet API連携）
- 2: GroovyInitScript.init() - 高リスク（外部スクリプト実行、セキュリティ影響あり）

## 6) レビュアーチェックリスト（最小）
- [ ] InitMilestoneの順序が実際のJenkins起動シーケンスと一致しているか確認
- [ ] TerminatorFinder.fatalOf()が常にfalseを返すことが意図通りか確認
- [ ] TaskMethodFinder.invoke()のDI解決が実運用環境で正しく動作するか確認
- [ ] InitStrategy.listPluginArchives()のファイル優先順位がプラグイン開発時の期待と一致するか確認
- [ ] GroovyInitScript関連のテストケースがセキュリティ観点で十分かレビュー
- [ ] InstallUncaughtExceptionHandler.handleException()でのエラーページ表示がUX要件を満たすか確認
