---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 70
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.lifecycle 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・処理が存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なメソッド・分岐をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：70 / 70、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/lifecycle/Lifecycle.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/lifecycle/ExitLifecycle.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/lifecycle/SystemdLifecycle.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/lifecycle/UnixLifecycle.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/lifecycle/SolarisSMFLifecycle.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/lifecycle/WindowsServiceLifecycle.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/lifecycle/RestartNotSupportedException.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/lifecycle/LifecycleTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### Lifecycle.java 関連 (UT-LCY-001 〜 UT-LCY-033)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-LCY-001 | get()でシステムプロパティ未設定時デフォルトLifecycle返却 | E-01 (L71-144) | ○ |
| UT-LCY-002 | get()でシステムプロパティ指定クラスロード | E-01 (L74-78), E-08 | ○ |
| UT-LCY-003 | get()で存在しないクラス指定時Placeholder返却 | E-01 (L91-93) | ○ |
| UT-LCY-004 | Windows環境でデフォルトLifecycle | E-01 (L109-116) | ○ |
| UT-LCY-005 | Solaris SMF環境でSolarisSMFLifecycle | E-01 (L117-119) | ○ |
| UT-LCY-006 | systemd環境でSystemdLifecycle | E-01 (L120-122) | ○ |
| UT-LCY-007 | Unix環境でUnixLifecycle | E-01 (L124-136) | ○ |
| UT-LCY-008 | getHudsonWar()でexecutable-warからパス取得 | E-01 (L154-159) | ○ |
| UT-LCY-009 | getHudsonWar()でプロパティ未設定時null | E-01 (L155-158) | ○ |
| UT-LCY-010 | getHudsonWar()で存在しないパス時null | E-01 (L156-157) | ○ |
| UT-LCY-011 | rewriteHudsonWar()でwar置換 | E-01 (L169-187) | ○ |
| UT-LCY-012 | rewriteHudsonWar()でwar位置不明時IOException | E-01 (L172-173) | ○ |
| UT-LCY-013 | rewriteHudsonWar()でbakからの復元時削除 | E-01 (L184-186) | ○ |
| UT-LCY-014 | canRewriteHudsonWar()で書き込み可能時true | E-01 (L192-203) | ○ |
| UT-LCY-015 | canRewriteHudsonWar()でwar不明時false | E-01 (L194-196) | ○ |
| UT-LCY-016 | canRewriteHudsonWar()でwar書き込み不可時false | E-01 (L195) | ○ |
| UT-LCY-017 | canRewriteHudsonWar()で親ディレクトリ書き込み不可時false | E-01 (L198-201) | ○ |
| UT-LCY-018 | restart()デフォルト実装でUnsupportedOperationException | E-01 (L218-220) | ○ |
| UT-LCY-019 | verifyRestartable()でrestartオーバーライド時例外なし | E-01 (L228-233) | ○ |
| UT-LCY-020 | verifyRestartable()で未オーバーライド時RestartNotSupportedException | E-01 (L230-232) | ○ |
| UT-LCY-021 | canRestart()で再起動可能時true | E-01 (L239-246) | ○ |
| UT-LCY-022 | canRestart()で再起動不可時false | E-01 (L243-244) | ○ |
| UT-LCY-023 | onReady()でログ出力 | E-01 (L254-256) | ○ |
| UT-LCY-024 | onReload()でリモートアドレス有りログ | E-01 (L266-275) | ○ |
| UT-LCY-025 | onReload()でリモートアドレスnull時ログ | E-01 (L273-274) | ○ |
| UT-LCY-026 | onStop()でリモートアドレス有りログ | E-01 (L282-291) | ○ |
| UT-LCY-027 | onStop()でリモートアドレスnull時ログ | E-01 (L289-290) | ○ |
| UT-LCY-028 | onExtendTimeout()が正常呼び出し可能 | E-01 (L303) | ○ |
| UT-LCY-029 | onStatusUpdate()でログ出力 | E-01 (L313-315) | ○ |
| UT-LCY-030 | supportsDynamicLoad()でtrue | E-01 (L324-326) | ○ |
| UT-LCY-031 | onBootFailure()が正常呼び出し可能 | E-01 (L333-334) | ○ |
| UT-LCY-032 | PlaceholderLifecycle.replacePlaceholder()で置換 | E-01 (L339-350) | ○ |
| UT-LCY-033 | PlaceholderLifecycle.replacePlaceholder()でロード失敗時維持 | E-01 (L346-348) | ○ |

### ExitLifecycle.java 関連 (UT-LCY-034 〜 UT-LCY-039)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-LCY-034 | コンストラクタでデフォルト終了コード5 | E-02 (L50-51, L56) | ○ |
| UT-LCY-035 | コンストラクタでカスタム終了コード設定 | E-02 (L56) | ○ |
| UT-LCY-036 | restart()でcleanUp後System.exit | E-02 (L61-73) | ○ |
| UT-LCY-037 | restart()でJenkins null時もSystem.exit | E-02 (L62, L72) | ○ |
| UT-LCY-038 | restart()でcleanUp失敗時もSystem.exit | E-02 (L68-70, L72) | ○ |
| UT-LCY-039 | onBootFailure()でrestart呼び出し | E-02 (L76-78) | ○ |

### SystemdLifecycle.java 関連 (UT-LCY-040 〜 UT-LCY-045)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-LCY-040 | onReady()でREADY=1送信 | E-03 (L30-33) | ○ |
| UT-LCY-041 | onReload()でRELOADING=1送信 | E-03 (L36-39) | ○ |
| UT-LCY-042 | onStop()でSTOPPING=1送信 | E-03 (L42-45) | ○ |
| UT-LCY-043 | onExtendTimeout()でEXTEND_TIMEOUT_USEC送信 | E-03 (L48-51) | ○ |
| UT-LCY-044 | onStatusUpdate()でSTATUS送信 | E-03 (L54-57) | ○ |
| UT-LCY-045 | notify()でsd_notifyエラー時WARNINGログ | E-03 (L59-64) | ○ |

### UnixLifecycle.java 関連 (UT-LCY-046 〜 UT-LCY-053)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-LCY-046 | コンストラクタでJVM引数取得 | E-04 (L59-61) | ○ |
| UT-LCY-047 | restart()でcleanUp後execvp実行 | E-04 (L64-86) | ○ |
| UT-LCY-048 | restart()でFD_CLOEXEC設定 | E-04 (L75-80) | ○ |
| UT-LCY-049 | restart()でJenkins null時もexecvp | E-04 (L65, L84) | ○ |
| UT-LCY-050 | restart()でexecvp失敗時IOException | E-04 (L85) | ○ |
| UT-LCY-051 | verifyRestartable()でglibc対応時例外なし | E-04 (L89-102) | ○ |
| UT-LCY-052 | verifyRestartable()でglibc非対応時例外 | E-04 (L90-91) | ○ |
| UT-LCY-053 | verifyRestartable()でMac OS X (Snow Leopard以前)で例外 | E-04 (L100-101) | ○ |

### SolarisSMFLifecycle.java 関連 (UT-LCY-054 〜 UT-LCY-056)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-LCY-054 | restart()でcleanUp後System.exit(0) | E-05 (L44-54) | ○ |
| UT-LCY-055 | restart()でJenkins null時もSystem.exit(0) | E-05 (L45, L53) | ○ |
| UT-LCY-056 | restart()でcleanUp失敗時もSystem.exit(0) | E-05 (L50-52, L53) | ○ |

### WindowsServiceLifecycle.java 関連 (UT-LCY-057 〜 UT-LCY-068)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-LCY-057 | コンストラクタで古いjenkins.exe更新スケジュール | E-06 (L55-91) | ○ |
| UT-LCY-058 | コンストラクタで最新jenkins.exe時スキップ | E-06 (L77) | ○ |
| UT-LCY-059 | コンストラクタでjenkins.exe不在時スキップ | E-06 (L74) | ○ |
| UT-LCY-060 | rewriteHudsonWar()でcopiesファイル書き込み | E-06 (L98-119) | ○ |
| UT-LCY-061 | rewriteHudsonWar()でwar不明時IOException | E-06 (L101-102) | ○ |
| UT-LCY-062 | rewriteHudsonWar()でbakファイル作成 | E-06 (L106-108) | ○ |
| UT-LCY-063 | restart()でjenkins.exe restart!実行 | E-06 (L123-150) | ○ |
| UT-LCY-064 | restart()でWINSW_EXECUTABLE使用 | E-06 (L139-141) | ○ |
| UT-LCY-065 | restart()でコマンド失敗時IOException | E-06 (L148-149) | ○ |
| UT-LCY-066 | restart()でhudson.exeフォールバック | E-06 (L142-143) | ○ |
| UT-LCY-067 | getBaseDir()でBASE環境変数からディレクトリ取得 | E-06 (L152-163) | ○ |
| UT-LCY-068 | getBaseDir()でBASE未設定時JENKINS_HOME | E-06 (L158-160) | ○ |

### RestartNotSupportedException.java 関連 (UT-LCY-069 〜 UT-LCY-070)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-LCY-069 | コンストラクタ(String)で理由設定 | E-07 (L9-11) | ○ |
| UT-LCY-070 | コンストラクタ(String, Throwable)で理由と原因設定 | E-07 (L13-15) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースにソースコードの根拠あり

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードに基づいている

### 特記事項
- システム呼び出し（System.exit, execvp, sd_notify）を伴うテストは、モック化が必要
- OS依存の分岐（Windows/Unix/Solaris/systemd）は、環境に応じたテスト実行が必要
- JNA経由のネイティブライブラリ呼び出しは、統合テスト環境での検証が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] OS依存のテストケース（UT-LCY-004〜007）が適切なOS環境で実行されることを確認
- [ ] System.exit()を呼び出すテスト（UT-LCY-036〜039, UT-LCY-054〜056）がモック化されていることを確認
- [ ] JNAネイティブ呼び出し（sd_notify, execvp, MoveFileExA）のモック戦略を確認
- [ ] Jenkinsインスタンスのモック化方針を確認
- [ ] ファイルシステム操作（rewriteHudsonWar）のテストがテンポラリディレクトリを使用していることを確認
