---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 105
  claims_with_evidence: 105
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.logging 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：105 / 105、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全ての主張にソースコードの根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/logging/LogRecorder.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/logging/LogRecorderManager.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/logging/WeakLogHandler.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/test/java/hudson/logging/LogRecorderTest.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/logging/LogRecorderManagerTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### LogRecorder クラス関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LogRecorder(String)コンストラクタで名前が設定される | E-01 (L109-114) | ○ |
| C-02 | nullの名前でも例外が発生しない | E-01 (L109) | ○ |
| C-03 | getLoggers()は初期状態で空リストを返す | E-01 (L105, L116-118) | ○ |
| C-04 | setLoggers()でTargetリストを設定可能 | E-01 (L120-122) | ○ |
| C-05 | orderedTargets()は名前の長さ降順でソート | E-01 (L125-131), E-04 (L94-107) | ○ |
| C-06 | orderedTargets()は空リストで空配列を返す | E-01 (L127-129) | ○ |
| C-07 | getAutoCompletionCandidates()が共通プレフィックスを含む | E-01 (L136-165), E-04 (L147-169) | ○ |
| C-08 | getAutoCompletionCandidates()が完全ロガー名を含む | E-01 (L153-154), E-04 (L157-163) | ○ |
| C-09 | getAutoCompletionCandidates()は空リストで空セットを返す | E-01 (L136-165) | ○ |
| C-10 | doCheckName()で空名前・FINE以下レベルは警告を返す | E-01 (L176-190), E-05 (L106-131) | ○ |
| C-11 | doCheckName()で名前指定時はOKを返す | E-01 (L176-190), E-05 (L115-120) | ○ |
| C-12 | doCheckName()で空名前・CONFIG以上レベルはOKを返す | E-01 (L179), E-05 (L121-125) | ○ |
| C-13 | doCheckName()で不正レベルかつ空名前は警告を返す | E-01 (L183-187), E-05 (L110) | ○ |
| C-14 | doAutoCompleteLoggerName()が部分一致候補を返す | E-01 (L193-214) | ○ |
| C-15 | doAutoCompleteLoggerName()はnullで空候補を返す | E-01 (L194-196) | ○ |
| C-16 | getDisplayName()は名前を返す | E-01 (L395-397) | ○ |
| C-17 | getSearchUrl()はURLエンコードされた名前を返す | E-01 (L400-402) | ○ |
| C-18 | getName()は設定された名前を返す | E-01 (L404-406) | ○ |
| C-19 | doClear()でハンドラがクリアされる | E-01 (L443-448), E-04 (L73-91) | ○ |
| C-20 | load()で設定ファイルから読み込まれる | E-01 (L454-457) | ○ |
| C-21 | save()で設定ファイルに保存される | E-01 (L462-470) | ○ |
| C-22 | save()はBulkChange中スキップされる | E-01 (L464) | ○ |
| C-23 | equals()は同名でtrue | E-01 (L473-482) | ○ |
| C-24 | equals()は異名でfalse | E-01 (L480-481) | ○ |
| C-25 | equals()はnullでfalse | E-01 (L476-477) | ○ |
| C-26 | hashCode()は同名で同じ値 | E-01 (L485-487) | ○ |
| C-27 | delete()で設定ファイル削除とManager除去 | E-01 (L503-514), E-05 (L188-199) | ○ |
| C-28 | delete()でSaveableListener.fireOnDeletedが呼ばれる | E-01 (L513), E-05 (L201-213) | ○ |
| C-29 | getLogRecords()でログビューを返す | E-01 (L533-535) | ○ |
| C-30 | getSlaveLogRecords()でエージェント別Mapを返す | E-01 (L542-573) | ○ |

### LogRecorder.Target クラス関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | Target(String, Level)で名前とレベルが設定される | E-01 (L247-249) | ○ |
| C-32 | Target(String, int)で名前と数値レベルが設定される | E-01 (L251-254) | ○ |
| C-33 | Target(String, String)で名前と文字列レベルが設定される | E-01 (L256-259) | ○ |
| C-34 | Target(String, String)で不正レベルは例外 | E-01 (L258) Level.parse()がIllegalArgumentException | ○ |
| C-35 | getLevel()は設定レベルを返す | E-01 (L261-263) | ○ |
| C-36 | getName()は設定名前を返す | E-01 (L265-267) | ○ |
| C-37 | includes()は完全一致でtrue | E-01 (L287-298), E-04 (L50-51) | ○ |
| C-38 | includes()はプレフィックス一致でtrue | E-01 (L293-297), E-04 (L54) | ○ |
| C-39 | includes()は空ターゲットで全てtrue | E-01 (L290-291), E-04 (L56) | ○ |
| C-40 | includes()はレベル未満でfalse | E-01 (L288-289) | ○ |
| C-41 | includes()は別名前空間でfalse | E-01 (L294-295), E-04 (L52-53) | ○ |
| C-42 | matches()は一致・十分レベルでtrue | E-01 (L301-314), E-04 (L60-61) | ○ |
| C-43 | matches()は一致・不十分レベルでfalse | E-01 (L302, L311), E-04 (L62) | ○ |
| C-44 | matches()は名前空間外でnull | E-01 (L306-308), E-04 (L63-64, L67) | ○ |
| C-45 | matches()は空ターゲット・十分レベルでtrue | E-01 (L303-304), E-04 (L68) | ○ |
| C-46 | matches()は空ターゲット・不十分レベルでfalse | E-01 (L303-304), E-04 (L69) | ○ |
| C-47 | matches()はloggerName nullでnull | E-01 (L307) | ○ |
| C-48 | getLogger()は指定名のLoggerを返す | E-01 (L316-321) | ○ |
| C-49 | getLogger()はキャッシュされたインスタンスを返す | E-01 (L317-319) | ○ |
| C-50 | enable()でLoggerレベルが設定される | E-01 (L326-330) | ○ |
| C-51 | enable()は既に十分なレベルなら変更しない | E-01 (L328) | ○ |
| C-52 | disable()でLoggerレベルがnullになる | E-01 (L333-336) | ○ |
| C-53 | Target.equals()は同設定でtrue | E-01 (L269-279) | ○ |
| C-54 | Target.equals()は異名でfalse | E-01 (L278) | ○ |
| C-55 | Target.equals()は異レベルでfalse | E-01 (L278) | ○ |
| C-56 | Target.hashCode()は同設定で同値 | E-01 (L282-284) | ○ |

### TargetComparator 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | compare()は名前長い方が先になる | E-01 (L340-348) | ○ |
| C-58 | compare()は同長なら0を返す | E-01 (L346) | ○ |

### LogRecorder.handler 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | handler.publish()でマッチログが記録される | E-01 (L217-236), E-04 (L94-123) | ○ |
| C-60 | handler.publish()で非マッチログは記録されない | E-01 (L222-233), E-04 (L110-112) | ○ |
| C-61 | handler.publish()でより具体的なTargetが優先 | E-01 (L220-233), E-04 (L94-123) | ○ |

### LogRecorderManager クラス関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | LogRecorderManager()で空リスト初期化 | E-02 (L100-103) | ○ |
| C-63 | getRecorders()で設定済みリストを返す | E-02 (L105-107) | ○ |
| C-64 | setRecorders()でリストが設定される | E-02 (L109-123) | ○ |
| C-65 | setRecorders()で重複は無視される | E-02 (L117-120) | ○ |
| C-66 | getDisplayName()で表示名を返す | E-02 (L126-128) | ○ |
| C-67 | getSearchUrl()で"/log"を返す | E-02 (L131-133) | ○ |
| C-68 | getDynamic()で一致するLogRecorderを返す | E-02 (L135-137) | ○ |
| C-69 | getDynamic()で存在しない場合null | E-02 (L135-137, L140) | ○ |
| C-70 | getLogRecorder()で一致するLogRecorderを返す | E-02 (L139-141) | ○ |
| C-71 | getLogRecorder()で存在しない場合null | E-02 (L140) | ○ |
| C-72 | configDir()でJENKINS_HOME/logを返す | E-02 (L143-145) | ○ |
| C-73 | load()で設定ディレクトリから読込 | E-02 (L150-162), E-05 (L81-91) | ○ |
| C-74 | load()はディレクトリなしでも正常 | E-02 (L154) | ○ |
| C-75 | load()はXMLのみ読込 | E-02 (L153) WildcardFileFilter("*.xml") | ○ |
| C-76 | doNewLogRecorder()で新規作成・リダイレクト | E-02 (L167-177) | ○ |
| C-77 | doNewLogRecorder()で不正名は例外 | E-02 (L171) Jenkins.checkGoodName | ○ |
| C-78 | doCheckNewName()で空文字はOK | E-02 (L180-191) | ○ |
| C-79 | doCheckNewName()で有効名はOK | E-02 (L180-191) | ○ |
| C-80 | doCheckNewName()で不正名はエラー | E-02 (L187-188), E-05 (L94-102) | ○ |
| C-81 | doConfigLogger()でLoggerレベル設定 | E-02 (L206-226), E-05 (L79-91) | ○ |
| C-82 | doConfigLogger()でinheritはnull設定 | E-02 (L214-216) | ○ |
| C-83 | doConfigLogger()で存在しないロガーはFailure | E-02 (L223-225), E-05 (L94-102) | ○ |
| C-84 | doRss()でRSSフィード出力 | E-02 (L231-233) | ○ |
| C-85 | doRss(static)でレベルフィルタ | E-02 (L238-286) | ○ |
| C-86 | init()でload呼出 | E-02 (L288-291) | ○ |
| C-87 | getTarget()で権限ありならthis返却 | E-02 (L294-300) | ○ |
| C-88 | getTarget()でSKIP_PERMISSION_CHECKならスキップ | E-02 (L296, L313) | ○ |

### WeakLogHandler クラス関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | コンストラクタでLoggerにハンドラ追加 | E-03 (L45-49) | ○ |
| C-90 | publish()でターゲットに転送 | E-03 (L52-56) | ○ |
| C-91 | publish()でGC済みなら何もしない | E-03 (L53-55, L72-77) | ○ |
| C-92 | flush()でターゲットに転送 | E-03 (L59-63) | ○ |
| C-93 | flush()でGC済みなら何もしない | E-03 (L60-62) | ○ |
| C-94 | close()でターゲットに転送 | E-03 (L66-70) | ○ |
| C-95 | close()でGC済みなら何もしない | E-03 (L67-69) | ○ |
| C-96 | resolve()でターゲット返却 | E-03 (L72-77) | ○ |
| C-97 | resolve()でGC済みならnull返却・ハンドラ削除 | E-03 (L74-75) | ○ |
| C-98 | setFormatter()でターゲットに設定 | E-03 (L80-85) | ○ |
| C-99 | setEncoding()でターゲットに設定 | E-03 (L88-93) | ○ |
| C-100 | setFilter()でターゲットに設定 | E-03 (L96-101) | ○ |
| C-101 | setErrorManager()でターゲットに設定 | E-03 (L104-109) | ○ |
| C-102 | setLevel()でターゲットに設定 | E-03 (L112-117) | ○ |
| C-103 | isLoggable()でターゲットに委譲 | E-03 (L120-126) | ○ |
| C-104 | isLoggable()でGC済みなら親クラス呼出 | E-03 (L124-125) | ○ |

### ComputerLogInitializer 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | preOnline()でエージェントにSetLevel送信 | E-01 (L384-392), E-05 (L133-185) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全てのテストケースはソースコードの実装に基づいています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり

主なリスク領域：
1. **分散ログ機能（getSlaveLogRecords, ComputerLogInitializer）**: エージェント接続が必要な統合テスト的な側面があるため、単体テストの範囲を超える可能性あり
2. **永続化機能（load/save）**: ファイルシステム操作を伴うため、モック化が必要
3. **権限チェック（doCheckName, getTarget）**: Jenkins権限システムとの統合が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの全publicメソッドをカバーしているか
- [ ] 正常系/異常系/境界値の観点が適切に網羅されているか
- [ ] deprecated メソッド（includes）のテストケースが含まれているか
- [ ] 内部クラス（Target, TargetComparator, SetLevel, ComputerLogInitializer）のテストが適切か
- [ ] 弱参照（WeakLogHandler）の GC 動作テストが現実的に実装可能か
- [ ] エージェント関連テスト（loggingOnSlaves）が既存テストと重複していないか
