---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：hudson.markup 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存テストコード・Javadocなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **C-33**：絵文字（サロゲートペア）の処理 - Util.escape()の仕様確認が必要
  2. **C-39**：PREVIEWS_SET_CSP=false時の挙動 - システムプロパティの実際の動作確認が必要

## 2) 参照した情報（Evidence一覧）
> 実在するソースファイルとその内容を列挙

- E-01: `core/src/main/java/hudson/markup/MarkupFormatter.java` - 抽象基底クラス、translate()、doPreviewDescription()、previewsNowNeedPostForSecurity2153()
- E-02: `core/src/main/java/hudson/markup/MarkupFormatterDescriptor.java` - Descriptorクラス、all()メソッド
- E-03: `core/src/main/java/hudson/markup/EscapedMarkupFormatter.java` - HTMLエスケープ実装、translate()メソッド
- E-04: `test/src/test/java/hudson/markup/MarkupFormatterTest.java` - 既存テストコード（configRoundtrip, defaultEscaped, security2153RequiresPOST, security2153SetsCSP）
- E-05: `MarkupFormatter.java:84-85` - PREVIEWS_ALLOW_GET、PREVIEWS_SET_CSPシステムプロパティ定義
- E-06: `MarkupFormatter.java:96` - translate()抽象メソッドのJavadoc（スレッドセーフ性）
- E-07: `EscapedMarkupFormatter.java:48-52` - translate()実装（null チェックとUtil.escape()呼び出し）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | translate(String, Writer)でマークアップがHTMLに変換される | E-01, E-06 | ○ |
| C-02 | translate(String, Writer)でnull入力時の挙動 | E-07 | ○ |
| C-03 | translate(String, Writer)で空文字列の処理 | E-04 (defaultEscaped) | ○ |
| C-04 | translate(String)で文字列変換が行われる | E-01:98-102 | ○ |
| C-05 | translate(String)でnull入力時の挙動 | E-04:95 | ○ |
| C-06 | translate(String)で空文字列の処理 | E-04:94 | ○ |
| C-07 | getHelpUrl()でヘルプURLが取得できる | E-01:114-116 | ○ |
| C-08 | getHelpUrl()でヘルプなし時にnullが返る | E-01:111-112 (Javadoc) | ○ |
| C-09 | getDescriptor()でMarkupFormatterDescriptorが返る | E-01:118-121 | ○ |
| C-10 | doPreviewDescription()でプレビューHTMLが生成される | E-01:127-136, E-04:112-119 | ○ |
| C-11 | doPreviewDescription()でCSPヘッダーが設定される | E-01:132-134, E-04:118 | ○ |
| C-12 | doPreviewDescription()でXSSが安全に処理される | E-03, E-04:93 | ○ |
| C-13 | doPreviewDescription()で空文字列の処理 | E-01:129-130 | ○ |
| C-14 | doPreviewDescription()でnull入力の処理 | E-07 | ○ |
| C-15 | previewsNowNeedPostForSecurity2153でGETが405を返す | E-01:145-150, E-04:100-108 | ○ |
| C-16 | PREVIEWS_ALLOW_GET有効時はGETでもプレビューが返る | E-01:147-148, E-05 | ○ |
| C-17 | GETリクエストでテキストが漏洩しない | E-04:107 | ○ |
| C-18 | all()で全Descriptorが取得できる | E-02:41-44 | ○ |
| C-19 | all()にEscapedMarkupFormatterが含まれる | E-03:54 (@Extension) | ○ |
| C-20 | Jenkins未初期化時のall()の挙動 | E-02:42-43 | ○ |
| C-21 | EscapedMarkupFormatterのコンストラクタ | E-03:43-45 | ○ |
| C-22 | HTMLタグがエスケープされる | E-03:50, E-04:93 | ○ |
| C-23 | アンパサンドがエスケープされる | E-03:50 (Util.escape) | ○ |
| C-24 | ダブルクォートがエスケープされる | E-03:50 (Util.escape) | ○ |
| C-25 | シングルクォートがエスケープされる | E-03:50 (Util.escape) | ○ |
| C-26 | 大なり小なり記号がエスケープされる | E-03:50, E-04:93 | ○ |
| C-27 | null入力時に何も出力されない | E-07:49 | ○ |
| C-28 | 空文字列入力時に空文字列が出力される | E-04:94 | ○ |
| C-29 | 通常テキストはそのまま出力される | E-03:50 | ○ |
| C-30 | 長い文字列が正しく処理される | E-03:50 (Util.escapeに依存) | ○ |
| C-31 | 改行コードが保持される | E-03:50 (Util.escapeに依存) | ○ |
| C-32 | Unicode文字が正しく処理される | E-03:50 (Util.escapeに依存) | ○ |
| C-33 | 絵文字が正しく処理される | **根拠不足** | △ |
| C-34 | getDisplayName()で表示名が取得できる | E-03:57-61 | ○ |
| C-35 | getDisplayName()がnullでない | E-03:57-58 (@NonNull) | ○ |
| C-36 | 複数スレッドから同時呼び出し可能 | E-06 (Javadoc) | ○ |
| C-37 | 複合的なHTMLがすべてエスケープされる | E-03:50, E-04:93 | ○ |
| C-38 | 長いテキストのプレビュー | E-01:129-130 | ○ |
| C-39 | PREVIEWS_SET_CSP=false時の挙動 | **根拠不足** | △ |
| C-40 | IOExceptionがスローされる | E-03:48 (throws宣言) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-33（絵文字処理）**: `Util.escape()`がサロゲートペアを正しく処理するかの明示的な仕様・テストが見つからない
  - 候補：`hudson/Util.java` の実装確認 / 既存のUtilテストケース確認
- **C-39（PREVIEWS_SET_CSP=false時）**: システムプロパティを変更した状態でのテストが既存テストに存在しない
  - 候補：MarkupFormatterTestに条件付きテスト追加 / 手動でのシステムプロパティ変更確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UT-MKP-007, UT-MKP-008, UT-MKP-030, UT-MKP-033, UT-MKP-034, UT-MKP-035, UT-MKP-038 - UI/表示関連の補助機能
- **1（中リスク）**: UT-MKP-003, UT-MKP-006, UT-MKP-009, UT-MKP-013, UT-MKP-014, UT-MKP-016, UT-MKP-018, UT-MKP-019, UT-MKP-020, UT-MKP-025, UT-MKP-028, UT-MKP-029, UT-MKP-031, UT-MKP-032, UT-MKP-036, UT-MKP-039, UT-MKP-040 - 機能の正常動作確認
- **2（高リスク）**: UT-MKP-001, UT-MKP-002, UT-MKP-004, UT-MKP-005, UT-MKP-010, UT-MKP-011, UT-MKP-012, UT-MKP-015, UT-MKP-017, UT-MKP-022, UT-MKP-023, UT-MKP-024, UT-MKP-026, UT-MKP-027, UT-MKP-037 - セキュリティ（XSS対策、CSP設定）・コア機能

## 6) レビュアーチェックリスト（最小）
- [ ] UT-MKP-022~027のエスケープテストケースが`Util.escape()`の仕様と整合しているか確認
- [ ] UT-MKP-011, UT-MKP-015, UT-MKP-017のセキュリティテストがSECURITY-2153の要件を満たしているか確認
- [ ] UT-MKP-033（絵文字処理）の期待結果が正しいか、`Util.escape()`の実装を確認
- [ ] UT-MKP-039のCSP無効化オプションのテストが必要かどうか検討
- [ ] 既存テスト（MarkupFormatterTest.java）との重複・不足がないか確認
