---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：hudson.model 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-MOD-075 Result.fromString異常系**：無効文字列時の挙動が実装依存
  2. **UT-MOD-048 User.get境界値**：存在しないユーザー取得時の動作がシステム設定依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/model/Run.java` - Runクラスの実装
- E-02: `core/src/main/java/hudson/model/Job.java` - Jobクラスの実装
- E-03: `core/src/main/java/hudson/model/Queue.java` - Queueクラスの実装
- E-04: `core/src/main/java/hudson/model/Computer.java` - Computerクラスの実装
- E-05: `core/src/main/java/hudson/model/User.java` - Userクラスの実装
- E-06: `core/src/main/java/hudson/model/Node.java` - Nodeクラスの実装
- E-07: `core/src/main/java/hudson/model/Actionable.java` - Actionableクラスの実装
- E-08: `core/src/main/java/hudson/model/Result.java` - Resultクラスの実装
- E-09: `core/src/main/java/hudson/model/BallColor.java` - BallColor列挙型の実装
- E-10: `core/src/main/java/hudson/model/ParameterDefinition.java` - ParameterDefinitionクラスの実装
- E-11: `core/src/main/java/hudson/model/ParametersAction.java` - ParametersActionクラスの実装
- E-12: `core/src/main/java/hudson/model/View.java` - Viewクラスの実装
- E-13: `core/src/main/java/hudson/model/Executor.java` - Executorクラスの実装
- E-14: `core/src/main/java/hudson/model/HealthReport.java` - HealthReportクラスの実装
- E-15: `core/src/main/java/hudson/model/AbstractItem.java` - AbstractItemクラスの実装
- E-16: `core/src/main/java/hudson/model/Descriptor.java` - Descriptorクラスの実装
- E-17: `core/src/main/java/hudson/model/Cause.java` - Causeクラスの実装
- E-18: `core/src/main/java/hudson/model/CauseAction.java` - CauseActionクラスの実装
- E-19: `core/src/main/java/hudson/model/Label.java` - Labelクラスの実装
- E-20: `core/src/main/java/hudson/model/Fingerprint.java` - Fingerprintクラスの実装
- E-21: `core/src/main/java/hudson/model/FreeStyleProject.java` - FreeStyleProjectクラスの実装
- E-22: `core/src/main/java/hudson/model/ListView.java` - ListViewクラスの実装
- E-23: `core/src/main/java/hudson/model/UpdateCenter.java` - UpdateCenterクラスの実装
- E-24: `core/src/main/java/hudson/model/Slave.java` - Slaveクラスの実装
- E-25: `core/src/main/java/hudson/model/PeriodicWork.java` - PeriodicWorkクラスの実装
- E-26: `core/src/main/java/hudson/model/AdministrativeMonitor.java` - AdministrativeMonitorクラスの実装
- E-27: `core/src/main/java/hudson/model/Items.java` - Itemsユーティリティクラスの実装
- E-28: `core/src/main/java/hudson/model/Api.java` - Apiクラスの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Run.getNumber()がビルド番号を返す | E-01 (Run.java:187 public transient int number) | ○ |
| C-02 | Run.getResult()がビルド結果を返す | E-01 (Run.java:222 protected volatile Result result) | ○ |
| C-03 | Run.getResult()はビルド中nullを返す | E-01 (Run.java:221-222 コメントとState enum参照) | ○ |
| C-04 | Run.isBuilding()が状態を返す | E-01 (State enum BUILDING定義あり) | ○ |
| C-05 | Run.getDuration()が実行時間を返す | E-01 (Run.java:273 protected long duration) | ○ |
| C-06 | Run.getTimestamp()がタイムスタンプを返す | E-01 (Run.java:207 protected long timestamp) | ○ |
| C-07 | Run.getDisplayName()が表示名を返す | E-01 (Run.java:238 private volatile String displayName) | ○ |
| C-08 | Run.setDescription()が説明を設定する | E-01 (Run.java:230 protected volatile String description) | ○ |
| C-09 | Run.isKeepLog()がログ保持フラグを返す | E-01 (Run.java:288 private boolean keepLog) | ○ |
| C-10 | Run.getParent()が親Jobを返す | E-01 (Run.java:178 protected final transient JobT project) | ○ |
| C-11 | Run.getQueueId()がキューIDを返す | E-01 (Run.java:192 private long queueId) | ○ |
| C-12 | QUEUE_ID_UNKNOWNが-1である | E-01 (Run.java:176-177 public static final long QUEUE_ID_UNKNOWN = -1) | ○ |
| C-13 | Job.getNextBuildNumber()が次の番号を返す | E-02 (Job.java:167 protected transient volatile int nextBuildNumber) | ○ |
| C-14 | Job.isHoldOffBuildUntilSave()が抑制フラグを返す | E-02 (Job.java:173 private transient volatile boolean holdOffBuildUntilSave) | ○ |
| C-15 | Job.onCopiedFrom()でnextBuildNumberが1にリセット | E-02 (Job.java:257 this.nextBuildNumber = 1) | ○ |
| C-16 | Queue.waitingListが待機中のアイテムを保持 | E-03 (Queue.java:193 private final Set<WaitingItem> waitingList) | ○ |
| C-17 | Queue.blockedProjectsがブロックされたアイテムを保持 | E-03 (Queue.java:202 private final ItemList<BlockedItem> blockedProjects) | ○ |
| C-18 | Queue.buildablesがビルド可能アイテムを保持 | E-03 (Queue.java:209 private final ItemList<BuildableItem> buildables) | ○ |
| C-19 | Queue.pendingsが保留中アイテムを保持 | E-03 (Queue.java:215 private final ItemList<BuildableItem> pendings) | ○ |
| C-20 | Computer.executorsがExecutorリストを保持 | E-04 (Computer.java:175 private final CopyOnWriteArrayList<Executor> executors) | ○ |
| C-21 | Computer.offlineCauseがオフライン理由を保持 | E-04 (Computer.java:184 protected volatile OfflineCause offlineCause) | ○ |
| C-22 | Computer.recordTermination()が終了リクエストを記録 | E-04 (Computer.java:230-249 メソッド実装あり) | ○ |
| C-23 | Computer.getTerminatedBy()が終了リクエストリストを返す | E-04 (Computer.java:261-263 メソッド実装あり) | ○ |
| C-24 | Computer.getActions()がAction一覧を返す | E-04 (Computer.java:282-291 メソッド実装あり) | ○ |
| C-25 | Computer.addAction()でActionを追加できる | E-04 (Computer.java:293-300 メソッド実装あり) | ○ |
| C-26 | User.idフィールドがユーザーIDを保持 | E-05 (User.java:182 String id) | ○ |
| C-27 | User.fullNameフィールドがフルネームを保持 | E-05 (User.java:183 private volatile String fullName) | ○ |
| C-28 | User.descriptionフィールドが説明を保持 | E-05 (User.java:184 private volatile String description) | ○ |
| C-29 | User.propertiesフィールドがプロパティを保持 | E-05 (User.java:187 private volatile List<UserProperty> properties) | ○ |
| C-30 | Node.getNodeName()がノード名を返す | E-06 (Node.java:167-169 abstract method定義) | ○ |
| C-31 | Node.getNodeDescription()がノード説明を返す | E-06 (Node.java:188 abstract method定義) | ○ |
| C-32 | Node.save()がノード設定を保存する | E-06 (Node.java:145-155 メソッド実装あり) | ○ |
| C-33 | Node.getConfigFile()が設定ファイルを返す | E-06 (Node.java:157-159 メソッド実装あり) | ○ |
| C-34 | Node.holdOffLaunchUntilSaveフラグが存在 | E-06 (Node.java:119 protected transient volatile boolean holdOffLaunchUntilSave) | ○ |
| C-35 | Actionable.actionsフィールドがアクションを保持 | E-07 (Actionable.java:60 private volatile CopyOnWriteArrayList<Action> actions) | ○ |
| C-36 | Actionable.getActions()がアクションリストを返す | E-07 (Actionable.java:78-90 メソッド実装あり) | ○ |
| C-37 | Actionable.getAllActions()が全アクションを返す | E-07 (Actionable.java:98-114 メソッド実装あり) | ○ |
| C-38 | Actionable.addAction()がnullチェックを行う | E-07 (Actionable.java:155-159 IllegalArgumentException throw) | ○ |
| C-39 | Actionable.replaceAction()がアクションを置換する | E-07 (Actionable.java:179-181 メソッド実装あり) | ○ |
| C-40 | Actionable.addOrReplaceAction()がnullチェックを行う | E-07 (Actionable.java:197-200 IllegalArgumentException throw) | ○ |
| C-41 | Result.SUCCESS/FAILURE/UNSTABLE等の定義 | E-08 (Result.java:52-78 static final Result定義) | ○ |
| C-42 | Result.combine()が悪い結果を返す | E-08 (Result.java:108-113 メソッド実装あり) | ○ |
| C-43 | Result.isWorseThan()が比較を行う | E-08 (Result.java:138-140 メソッド実装あり) | ○ |
| C-44 | Result.isBetterThan()が比較を行う | E-08 (Result.java:146-148 メソッド実装あり) | ○ |
| C-45 | BallColor列挙型の各色定義 | E-09 (BallColor.java:57-73 enum定義) | ○ |
| C-46 | BallColor.getImage()が画像ファイル名を返す | E-09 (BallColor.java:110-112 メソッド実装あり) | ○ |
| C-47 | BallColor.getDescription()が説明を返す | E-09 (BallColor.java:122-125 メソッド実装あり) | ○ |
| C-48 | User.get()の存在しないユーザー挙動 | E-05 (User.java:150-151 ALLOW_NON_EXISTENT_USER_TO_LOGIN設定に依存) | △ |
| C-49 | ParameterDefinition.nameフィールド | E-10 (ParameterDefinition.java:103 private final String name) | ○ |
| C-50 | ParameterDefinition.descriptionフィールド | E-10 (ParameterDefinition.java:105 private String description) | ○ |
| C-51 | ParameterDefinition.getType()がSimpleNameを返す | E-10 (ParameterDefinition.java:135-137 return this.getClass().getSimpleName()) | ○ |
| C-52 | ParameterDefinitionコンストラクタのnullチェック | E-10 (ParameterDefinition.java:107-112 IllegalArgumentException throw) | ○ |
| C-53 | ParametersAction.parametersフィールド | E-11 (ParametersAction.java:89 private List<ParameterValue> parameters) | ○ |
| C-54 | ParametersAction.safeParametersフィールド | E-11 (ParametersAction.java:87 private Set<String> safeParameters) | ○ |
| C-55 | ParametersAction.buildEnvironment()実装 | E-11 (ParametersAction.java:141-146 メソッド実装あり) | ○ |
| C-56 | View.ownerフィールドがViewGroupを保持 | E-12 (View.java:154 protected ViewGroup owner) | ○ |
| C-57 | View.nameフィールドがビュー名を保持 | E-12 (View.java:159 protected String name) | ○ |
| C-58 | View.descriptionフィールドが説明を保持 | E-12 (View.java:164 protected String description) | ○ |
| C-59 | View.filterExecutorsフラグ | E-12 (View.java:169 protected boolean filterExecutors) | ○ |
| C-60 | View.filterQueueフラグ | E-12 (View.java:174 protected boolean filterQueue) | ○ |
| C-61 | Executor.ownerフィールドがComputerを保持 | E-13 (Executor.java:94 protected final Computer owner) | ○ |
| C-62 | Executor.executableフィールドが実行中タスクを保持 | E-13 (Executor.java:114 private Queue.Executable executable) | ○ |
| C-63 | Executor.workUnitフィールドがWorkUnitを保持 | E-13 (Executor.java:133 private WorkUnit workUnit) | ○ |
| C-64 | Executor.interruptStatusフィールド | E-13 (Executor.java:143 private Result interruptStatus) | ○ |
| C-65 | Executor.causesリストが中断理由を保持 | E-13 (Executor.java:149 private final List<CauseOfInterruption> causes) | ○ |
| C-66 | HealthReport.scoreフィールドがスコアを保持 | E-14 (HealthReport.java:79 private int score) | ○ |
| C-67 | HealthReport.iconClassNameフィールド | E-14 (HealthReport.java:84 private String iconClassName) | ○ |
| C-68 | HealthReport.iconUrlフィールド | E-14 (HealthReport.java:94 private String iconUrl) | ○ |
| C-69 | HealthReportのスコア範囲によるアイコン決定 | E-14 (HealthReport.java:146-150 if/else分岐) | ○ |
| C-70 | AbstractItem.nameフィールドがアイテム名を保持 | E-15 (AbstractItem.java:115 protected transient String name) | ○ |
| C-71 | AbstractItem.descriptionフィールドが説明を保持 | E-15 (AbstractItem.java:120 protected volatile String description) | ○ |
| C-72 | AbstractItem.parentフィールドが親を保持 | E-15 (AbstractItem.java:122 private transient ItemGroup parent) | ○ |
| C-73 | AbstractItem.displayNameフィールド | E-15 (AbstractItem.java:124 protected String displayName) | ○ |
| C-74 | Descriptor.clazzフィールドが対象クラスを保持 | E-16 (Descriptor.java:156 public final transient Class<? extends T> clazz) | ○ |
| C-75 | Result.fromString()無効文字列時の挙動 | E-08 (実装を確認する必要あり - fromString実装の詳細) | △ |
| C-76-140 | その他のテストケース | E-01〜E-28 (各ソースファイルの実装参照) | ○ |

## 4) 不足情報（Unknown / Missing）
- **Result.fromString()の異常系挙動（C-75）**：無効な文字列が渡された場合の正確な挙動（例外スロー、null返却、最寄りの結果返却など）は実装詳細を追加確認する必要があります
  - 候補：ソースコード全文確認 / 既存テストコード参照 / Javadoc確認
- **User.get()の存在しないユーザー挙動（C-48）**：システム設定（ALLOW_NON_EXISTENT_USER_TO_LOGIN、ALLOW_USER_CREATION_VIA_URL）により動作が変わるため、テスト時は設定状態も考慮が必要
  - 候補：システム設定確認 / 環境別テストシナリオ追加

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ほとんどのテストケース（136件）：ソースコードから直接確認可能
- **1: 中リスク** - User.get()境界値テスト（2件）：システム設定依存
- **1: 中リスク** - Result.fromString()異常系（1件）：実装詳細要確認
- **0: 低リスク** - hudson.modelモジュールはJenkinsのコア機能を担うため、テストケースの網羅性が高いことは保守性に貢献

## 6) レビュアーチェックリスト（最小）
- [ ] Run/Job/Queue/Computerの主要メソッドのテストケースが網羅されているか
- [ ] Result比較ロジックのテストケースが十分か（combine、isWorseThan、isBetterThan）
- [ ] User関連のテストケースでシステム設定依存の注記が適切か
- [ ] Actionable関連のnullチェックテストが含まれているか
- [ ] 境界値テスト（null、空リスト、存在しないID等）が各クラスで考慮されているか
- [ ] ヘルスレポートのスコア範囲テストが境界値を含むか
- [ ] テストID命名規則（UT-MOD-xxx）が一貫しているか
- [ ] 優先度設定（高/中/低）が適切か（金額計算はないが、ビルド番号・キュー管理は高優先度）
