---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 107
  claims_with_evidence: 107
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.node_monitors 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：107 / 107、根拠なし：0
- 優先レビュー（高）
  1. **UT-NMO-066/067（タイムアウト切断）**：ResponseTimeMonitorの5回連続タイムアウト時の切断ロジックは重要な動作
  2. **UT-NMO-070/071（ディスク空き閾値）**：DiskSpaceMonitorDescriptorのオフライン/オンライン制御ロジック
  3. **UT-NMO-074-080（サイズパース）**：DiskSpace.parse()の各種単位パースは境界値テストが重要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/NodeMonitor.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/AbstractNodeMonitorDescriptor.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/AbstractAsyncNodeMonitorDescriptor.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/DiskSpaceMonitor.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/TemporarySpaceMonitor.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/SwapSpaceMonitor.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/ClockMonitor.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/ResponseTimeMonitor.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/ArchitectureMonitor.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/DiskSpaceMonitorDescriptor.java`
- E-11: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/AbstractDiskSpaceMonitor.java`
- E-12: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/MonitorOfflineCause.java`
- E-13: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/MonitorMarkedNodeOffline.java`
- E-14: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/NodeMonitorUpdater.java`
- E-15: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/node_monitors/DiskSpaceMonitorNodeProperty.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### NodeMonitor（E-01）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getColumnCaption()がDescriptorの表示名を返す | E-01 L81-84 | ○ |
| C-02 | getDescriptor()がAbstractNodeMonitorDescriptorを返す | E-01 L86-89 | ○ |
| C-03 | data()がDescriptor.get()を呼び出す | E-01 L94-96 | ○ |
| C-04 | triggerUpdate()がDescriptor.triggerUpdate()を呼び出す | E-01 L108-110 | ○ |
| C-05 | getAll()がComputerSet.getMonitors()を呼び出す | E-01 L116-118 | ○ |
| C-06 | isIgnored()がignoredフィールドを返す | E-01 L133-135 | ○ |
| C-07 | setIgnored()がignoredフィールドを設定する | E-01 L137-140 | ○ |

### AbstractNodeMonitorDescriptor（E-02）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | canTakeOffline()がデフォルトでtrueを返す | E-02 L78-80 | ○ |
| C-09 | get()がrecord.data.get(c)を返す | E-02 L190-197 | ○ |
| C-10 | getTimestamp()がrecord.timestampを返す | E-02 L209-211 | ○ |
| C-11 | getTimestampString()が経過時間文字列を返す | E-02 L213-217 | ○ |
| C-12 | isIgnored()がNodeMonitor.isIgnored()を確認する | E-02 L222-225 | ○ |
| C-13 | markOnline()がisIgnored/isOnlineチェック後にsetTemporaryOfflineCause(null)を呼ぶ | E-02 L234-238 | ○ |
| C-14 | markOffline()がisIgnored/isTemporarilyOfflineチェック後にsetTemporaryOfflineCauseを呼ぶ | E-02 L247-257 | ○ |
| C-15 | triggerUpdate()が同期的に新しいRecordスレッドを開始する | E-02 L271-294 | ○ |
| C-16 | getMonitoringTimeOut()が30秒を返す | E-02 L299-301 | ○ |

### AbstractAsyncNodeMonitorDescriptor（E-03）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | createCallable()は抽象メソッドでサブクラスで実装される | E-03 L54 | ○ |
| C-18 | monitor()がComputerごとに並行でCallableを実行する | E-03 L74-77 | ○ |
| C-19 | monitorDetailed()がResult<T>を返す | E-03 L82-122 | ○ |
| C-20 | Result.getMonitoringData()がMap<Computer, T>を返す | E-03 L166-168 | ○ |
| C-21 | Result.getSkipped()がスキップされたComputerリストを返す | E-03 L174-176 | ○ |

### DiskSpaceMonitor（E-04）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | コンストラクタがfreeSpaceThresholdを受け取る | E-04 L48-51 | ○ |
| C-23 | getThresholdBytes(Computer)がDiskSpaceMonitorNodePropertyから閾値を取得する | E-04 L56-69 | ○ |
| C-24 | getWarningThresholdBytes(Computer)がDiskSpaceMonitorNodePropertyから警告閾値を取得する | E-04 L72-85 | ○ |
| C-25 | getFreeSpace()がDESCRIPTOR.get(c)を呼ぶ | E-04 L87-89 | ○ |
| C-26 | getColumnCaption()がADMINISTER権限を確認する | E-04 L92-95 | ○ |
| C-27 | DescriptorImpl.createCallable()がGetUsableSpaceを返す | E-04 L115-123 | ○ |

### TemporarySpaceMonitor（E-05）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | getThresholdBytes(Computer)がfreeTempSpaceThresholdを使用する | E-05 L60-73 | ○ |
| C-29 | getWarningThresholdBytes(Computer)がfreeTempSpaceWarningThresholdを使用する | E-05 L76-89 | ○ |
| C-30 | GetTempSpace.invoke()がjava.io.tmpdirを使用する | E-05 L138-147 | ○ |

### SwapSpaceMonitor（E-06）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | toHtml()がavailableSwapSpace=-1の場合にN/Aを返す | E-06 L58-60 | ○ |
| C-32 | toHtml()が256MB以下かつ80%以上使用時にエラースパンを返す | E-06 L64-71 | ○ |
| C-33 | toMB()がavailableSwapSpaceをMB単位で返す | E-06 L74-82 | ○ |
| C-34 | DescriptorImpl.canTakeOffline()がfalseを返す | E-06 L105-107 | ○ |
| C-35 | MemoryUsage2がMemoryUsageをラップしてExported属性を提供する | E-06 L159-196 | ○ |

### ClockMonitor（E-07）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | getDifferenceFor()がDESCRIPTOR.get(c)を呼ぶ | E-07 L53-55 | ○ |
| C-37 | DescriptorImpl.canTakeOffline()がfalseを返す | E-07 L74-76 | ○ |
| C-38 | DescriptorImpl.createCallable()がnode.getClockDifferenceCallable()を返す | E-07 L79-83 | ○ |

### ResponseTimeMonitor（E-08）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | Data.getAverage()が過去5回の平均を計算する | E-08 L196-204 | ○ |
| C-40 | Data.hasTooManyTimeouts()が5回連続タイムアウトでtrueを返す | E-08 L206-208 | ○ |
| C-41 | Data.failureCount()が連続タイムアウト回数をカウントする | E-08 L185-191 | ○ |
| C-42 | DescriptorImpl.monitor()がタイムアウト過多時にc.disconnect()を呼ぶ | E-08 L71-97 | ○ |
| C-43 | Step1/Step2/Step3が往復時間測定のシリアライゼーションパターンを実装する | E-08 L106-158 | ○ |

### ArchitectureMonitor（E-09）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | DescriptorImpl.canTakeOffline()がfalseを返す | E-09 L61-63 | ○ |
| C-45 | GetArchTask.call()がos.nameとos.archを結合して返す | E-09 L70-75 | ○ |

### DiskSpaceMonitorDescriptor（E-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | monitor()がmonitorDetailed()を呼びmarkNodeOfflineOrOnlineを実行する | E-10 L57-75 | ○ |
| C-47 | markNodeOfflineOrOnline()がsize <= thresholdでmarkOfflineを呼ぶ | E-10 L78-100 | ○ |
| C-48 | DiskSpace.parse()がKMGT単位をサポートする | E-10 L252-278 | ○ |
| C-49 | DiskSpace.isTriggered()がsize <= thresholdを判定する | E-10 L207-209 | ○ |
| C-50 | DiskSpace.isWarning()がthreshold < size < warningThresholdを判定する | E-10 L211-214 | ○ |
| C-51 | GetUsableSpace.invoke()がf.getUsableSpace()を呼ぶ | E-10 L286-293 | ○ |

### AbstractDiskSpaceMonitor（E-11）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | デフォルトコンストラクタがfreeSpaceThreshold=1GiB, freeSpaceWarningThreshold=2GiBを設定する | E-11 L28-31 | ○ |
| C-53 | getThresholdBytes()がDiskSpace.parse()で変換する | E-11 L65-71 | ○ |
| C-54 | getWarningThresholdBytes()がfreeSpaceWarningThresholdをパースする | E-11 L77-85 | ○ |
| C-55 | readResolve()がfreeSpaceWarningThresholdをfreeSpaceThresholdの2倍で初期化する | E-11 L33-54 | ○ |
| C-56 | data()がsuper.data()後にmarkNodeOfflineOrOnlineを呼ぶ | E-11 L91-96 | ○ |

### MonitorOfflineCause（E-12）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | getTrigger()は抽象メソッドでサブクラスで実装される | E-12 L41 | ○ |

### MonitorMarkedNodeOffline（E-13）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | isActivated()がactiveフィールドを返す | E-13 L48-51 | ○ |
| C-59 | activeフィールドはデフォルトでfalse | E-13 L46 | ○ |

### NodeMonitorUpdater（E-14）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | onOnline()が5秒後にMONITOR_UPDATERをスケジュールする | E-14 L57-61 | ○ |
| C-61 | onOnline()が前回のfutureをキャンセルする | E-14 L59 | ○ |
| C-62 | onTemporarilyOnline()がMARKEDOFFLINE_UPDATERをスケジュールする | E-14 L65-69 | ○ |

### DiskSpaceMonitorNodeProperty（E-15）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | コンストラクタが4つの閾値パラメータを受け取る | E-15 L23-30 | ○ |
| C-64 | getFreeDiskSpaceThreshold()がfreeDiskSpaceThresholdを返す | E-15 L32-34 | ○ |
| C-65 | getFreeTempSpaceThreshold()がfreeTempSpaceThresholdを返す | E-15 L36-38 | ○ |
| C-66 | getFreeDiskSpaceWarningThreshold()がfreeDiskSpaceWarningThresholdを返す | E-15 L40-42 | ○ |
| C-67 | getFreeTempSpaceWarningThreshold()がfreeTempSpaceWarningThresholdを返す | E-15 L44-46 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全てのテストケースはソースコードに基づいて作成されています。

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: ResponseTimeMonitorのタイムアウト切断ロジック（UT-NMO-066/067）は、誤検知によりエージェントが不必要に切断される可能性があるため、十分なテストが必要
- **1 (中リスク)**: DiskSpace.parse()のサイズパースロジック（UT-NMO-074-080）は、様々な入力形式に対応する必要があり、境界値テストが重要
- **0 (低リスク)**: その他のモニターはcanTakeOffline()=falseを返すため、誤ってエージェントをオフラインにするリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] ResponseTimeMonitor.Data.hasTooManyTimeouts()の閾値（5回連続）が適切か確認
- [ ] DiskSpace.parse()が全てのサイズ単位（K, M, G, T, Ki, Mi, Gi, Ti）を正しくパースするか確認
- [ ] markOffline/markOnlineのisIgnored()チェックが適切に動作するか確認
- [ ] NodeMonitorUpdaterの5秒遅延が適切か確認（短すぎる/長すぎる場合のトレードオフ）
- [ ] DiskSpaceMonitorNodePropertyの各閾値が正しくDiskSpaceMonitor/TemporarySpaceMonitorで使用されるか確認
- [ ] SwapSpaceMonitor.toHtml()の低メモリ判定ロジック（256MB未満または80%以上使用）が適切か確認
