---
generated_at: 2026-01-22 21:15:00
metrics:
  claims_total: 37
  claims_with_evidence: 35
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：hudson.os 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：35 / 37、根拠なし：2
- 優先レビュー（高）
  1. **UT-OS-029**: execCmdの空配列時の挙動は実際の動作確認が必要
  2. **UT-OS-033**: createJunctionの存在しないディレクトリ時の挙動はコード上では明示されていない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/os/PosixException.java` - PosixException例外クラス定義
- E-02: `core/src/main/java/hudson/os/WindowsUtil.java` - WindowsUtilユーティリティクラス定義
- E-03: `core/src/test/java/hudson/os/WindowsUtilTest.java` - 既存テストケース（quoteArgument, quoteArgumentForCmd）
- E-04: WindowsUtil.java L45 - NEEDS_QUOTINGパターン定義 `Pattern.compile("[\\s\"]")`
- E-05: WindowsUtil.java L83 - CMD_METACHARSパターン定義 `Pattern.compile("[()%!^\"<>&|]")`
- E-06: WindowsUtil.java L53-81 - quoteArgumentメソッド実装
- E-07: WindowsUtil.java L90-92 - quoteArgumentForCmdメソッド実装
- E-08: WindowsUtil.java L100-103 - execCmdメソッド実装
- E-09: WindowsUtil.java L115-127 - createJunctionメソッド実装
- E-10: PosixException.java L11-19 - コンストラクタ定義
- E-11: WindowsUtilTest.java L38-43 - testQuoteArgument（複合エスケープテスト）
- E-12: WindowsUtilTest.java L46-49 - testQuoteArgument_OnlyQuotesWhenNecessary
- E-13: WindowsUtilTest.java L53-58 - testQuoteArgumentForCmd
- E-14: WindowsUtilTest.java L61-65 - testQuoteArgumentForCmd_OnlyQuotesWhenNecessary

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OS-001 | メッセージのみでPosixExceptionが生成できること | E-01, E-10 | ○ |
| UT-OS-002 | 空文字列メッセージでPosixExceptionが生成できること | E-01, E-10 | ○ |
| UT-OS-003 | nullメッセージでPosixExceptionが生成できること | E-01, E-10 | ○ |
| UT-OS-004 | メッセージと原因でPosixExceptionが生成できること | E-01, E-10 | ○ |
| UT-OS-005 | nullの原因でPosixExceptionが生成できること | E-01, E-10 | ○ |
| UT-OS-006 | PosixExceptionがRuntimeExceptionを継承していること | E-01 | ○ |
| UT-OS-007 | 空白を含む引数が正しくクォートされること | E-02, E-04, E-06, E-12 | ○ |
| UT-OS-008 | ダブルクォートを含む引数が正しくエスケープされること | E-02, E-06, E-11 | ○ |
| UT-OS-009 | 空白もダブルクォートも含まない引数はそのまま返されること | E-02, E-06, E-12 | ○ |
| UT-OS-010 | 空文字列はそのまま返されること | E-02, E-06, E-12 | ○ |
| UT-OS-011 | バックスラッシュのみの引数が正しく処理されること | E-02, E-06 | ○ |
| UT-OS-012 | 末尾バックスラッシュと空白を含む引数が正しくエスケープされること | E-02, E-06, E-11 | ○ |
| UT-OS-013 | ダブルクォート前のバックスラッシュが正しくエスケープされること | E-02, E-06, E-11 | ○ |
| UT-OS-014 | URLパス形式の引数はクォートされないこと | E-02, E-06, E-12 | ○ |
| UT-OS-015 | Windowsパス形式の引数はクォートされないこと | E-02, E-06, E-12 | ○ |
| UT-OS-016 | ハイフン付き引数はクォートされないこと | E-02, E-06, E-12 | ○ |
| UT-OS-017 | cmd.exeメタ文字がエスケープされること | E-02, E-05, E-07 | ○ |
| UT-OS-018 | パーセント記号がエスケープされること | E-02, E-05, E-07 | ○ |
| UT-OS-019 | パイプ記号がエスケープされること | E-02, E-05, E-07 | ○ |
| UT-OS-020 | リダイレクト記号がエスケープされること | E-02, E-05, E-07 | ○ |
| UT-OS-021 | 括弧がエスケープされること | E-02, E-05, E-07 | ○ |
| UT-OS-022 | 感嘆符がエスケープされること | E-02, E-05, E-07 | ○ |
| UT-OS-023 | キャレット自体がエスケープされること | E-02, E-05, E-07 | ○ |
| UT-OS-024 | 空白もメタ文字も含まない引数はそのまま返されること | E-02, E-07, E-14 | ○ |
| UT-OS-025 | 複合パターン（空白+メタ文字）が正しく処理されること | E-02, E-07, E-13 | ○ |
| UT-OS-026 | 単一引数でcmd.exeが実行されること | E-02, E-08 | ○ |
| UT-OS-027 | 複数引数でcmd.exeが実行されること | E-02, E-08 | ○ |
| UT-OS-028 | 空白を含む引数が正しくクォートされて実行されること | E-02, E-08 | ○ |
| UT-OS-029 | 空の引数配列でIOExceptionがスローされないこと | **根拠なし** | △ |
| UT-OS-030 | NTFSジャンクションポイントが作成されること | E-02, E-09 | ○ |
| UT-OS-031 | 非Windows環境でUnsupportedOperationExceptionがスローされること | E-02, E-09 | ○ |
| UT-OS-032 | mklinkが失敗した場合にIOExceptionがスローされること | E-02, E-09 | ○ |
| UT-OS-033 | 対象ディレクトリが存在しない場合にIOExceptionがスローされること | **根拠なし** | △ |
| UT-OS-034 | 空白文字を含む文字列がマッチすること | E-02, E-04 | ○ |
| UT-OS-035 | ダブルクォートを含む文字列がマッチすること | E-02, E-04 | ○ |
| UT-OS-036 | タブ文字を含む文字列がマッチすること | E-02, E-04 | ○ |
| UT-OS-037 | すべてのメタ文字がマッチすること | E-02, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-OS-029**: execCmdに空の引数配列を渡した場合の挙動はコード上で明示されていない。`cmd.exe /C` のみが実行される可能性があるが、実際の動作確認が必要
  - 候補：実機テスト / Windows環境での動作確認 / Javadoc追記
- **UT-OS-033**: createJunctionで対象ディレクトリが存在しない場合の挙動は、mklinkコマンドの仕様に依存。IOExceptionがスローされる可能性が高いが、明示的な根拠なし
  - 候補：Windowsドキュメント参照 / 実機テスト / エラーメッセージの確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: PosixException関連テストケース（UT-OS-001〜006）- 非推奨クラスの基本動作確認のみ
- **1（中リスク）**: NEEDS_QUOTING/CMD_METACHARS パターン確認テスト（UT-OS-034〜037）- 正規表現の網羅性確認
- **2（高リスク）**: quoteArgument/quoteArgumentForCmdのセキュリティ関連テスト（UT-OS-007〜025）- コマンドインジェクション防止に直結
- **2（高リスク）**: execCmd/createJunctionのシステム操作テスト（UT-OS-026〜033）- ファイルシステム操作・プロセス実行に関わる

## 6) レビュアーチェックリスト（最小）
- [ ] quoteArgumentのバックスラッシュエスケープロジック（UT-OS-011〜013）が、Microsoftドキュメントと整合しているか確認
- [ ] CMD_METACHARSパターンが、cmd.exeの全メタ文字を網羅しているか確認
- [ ] createJunctionのエラーハンドリングが、mklinkの全エラーパターンをカバーしているか確認
- [ ] execCmdの空配列時の挙動を実機確認（Windows環境必要）
- [ ] 既存テスト（WindowsUtilTest.java）と重複がないか確認し、追加すべきテストケースを特定
