---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 96
  claims_with_evidence: 92
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：hudson.scheduler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が根拠と矛盾していないか
3. **網羅性**：参照すべきクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：92 / 96、根拠なし：4
- 優先レビュー（高）
  1. **UT-SCH-077**：HASH_TOKENSシステムプロパティの動作確認 - 設定方法の根拠が間接的
  2. **UT-SCH-039**：toString()の詳細形式 - 実装から推測
  3. **UT-SCH-059/060**：previous/nextメソッドの詳細動作 - @Restrictedアノテーション付き内部API
  4. **UT-SCH-078**：RareOrImpossibleDateExceptionの単体テスト - シンプルな例外クラス

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/scheduler/CronTab.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/scheduler/CronTabList.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/scheduler/Hash.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/scheduler/BaseParser.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/scheduler/RareOrImpossibleDateException.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/test/java/hudson/scheduler/CronTabTest.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/test/java/hudson/scheduler/CronTabDayOfWeekLocaleTest.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/test/java/hudson/scheduler/CronTabEventualityTest.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/antlr4/hudson/scheduler/CrontabLexer.g4`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/antlr4/hudson/scheduler/CrontabParser.g4`

## 3) Claims と根拠の対応（レビューの主戦場）

### CronTab クラス（UT-SCH-001 〜 UT-SCH-043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-SCH-001) | 標準cron形式で初期化できる | E-01 (75-77行), E-06 (57-63行) | ○ |
| C-02 (UT-SCH-002) | @yearlyトークン対応 | E-01 (75-77行), E-06 (58行), E-10 (12-14行) | ○ |
| C-03 (UT-SCH-003) | @weeklyトークン対応 | E-06 (59行), E-10 (21-23行) | ○ |
| C-04 (UT-SCH-004) | @monthlyトークン対応 | E-06 (61行), E-10 (19-20行) | ○ |
| C-05 (UT-SCH-005) | @dailyトークン対応 | E-10 (24-26行) | ○ |
| C-06 (UT-SCH-006) | @midnightトークン対応 | E-06 (60行), E-10 (27-29行) | ○ |
| C-07 (UT-SCH-007) | @hourlyトークン対応 | E-10 (30-32行) | ○ |
| C-08 (UT-SCH-008) | 範囲指定(1-10/3)対応 | E-06 (62行), E-04 (67-80行) | ○ |
| C-09 (UT-SCH-009) | 不正形式でIllegalArgumentException | E-01 (127-144行), E-06 (285-293行) | ○ |
| C-10 (UT-SCH-010) | Hash指定初期化 | E-01 (83-85行), E-06 (222-234行) | ○ |
| C-11 (UT-SCH-011) | タイムゾーン指定初期化 | E-01 (116-118行), E-06 (345-356行) | ○ |
| C-12 (UT-SCH-012) | check()でマッチ時true | E-01 (150-172行), E-06 (68-69行) | ○ |
| C-13 (UT-SCH-013) | check()で不一致時false | E-01 (150-172行) | ○ |
| C-14 (UT-SCH-014) | タイムゾーン考慮のcheck() | E-01 (154-158行), E-06 (345-356行) | ○ |
| C-15 (UT-SCH-015) | ceil(long)で次の実行時刻計算 | E-01 (359-363行), E-06 (67-74行) | ○ |
| C-16 (UT-SCH-016) | ceil()で秒・ミリ秒リセット | E-01 (374-378行), E-06 (359-375行) | ○ |
| C-17 (UT-SCH-017) | ceil()のロールオーバー | E-01 (396-414行), E-06 (72-73行) | ○ |
| C-18 (UT-SCH-018) | ceil()の下位フィールドリセット | E-01 (393-395行), E-06 (77-82行) | ○ |
| C-19 (UT-SCH-019) | DoM/DoW競合時の処理 | E-01 (412-413行), E-06 (87-91行) | ○ |
| C-20 (UT-SCH-020) | DoW=7(日曜)対応 | E-01 (140-143行), E-06 (95-102行) | ○ |
| C-21 (UT-SCH-021) | 不可能日付でRareOrImpossibleDateException | E-01 (383-386行), E-06 (387-393行) | ○ |
| C-22 (UT-SCH-022) | floor(long)で直前実行時刻計算 | E-01 (433-437行), E-06 (149-157行) | ○ |
| C-23 (UT-SCH-023) | floor()で秒・ミリ秒リセット | E-01 (448-449行) | ○ |
| C-24 (UT-SCH-024) | floor()のロールダウン | E-01 (468-479行), E-06 (155-156行) | ○ |
| C-25 (UT-SCH-025) | floor()でのDoM/DoW競合 | E-01 (485-486行), E-06 (168-174行) | ○ |
| C-26 (UT-SCH-026) | FirstDayOfWeek=MONDAY対応 | E-01 (323-332行), E-06 (177-187行) | ○ |
| C-27 (UT-SCH-027) | floor()での不可能日付検出 | E-01 (455-458行), E-06 (380-384行) | ○ |
| C-28 (UT-SCH-028) | checkSanity()で@hourly警告なし | E-01 (531-562行), E-06 (191行) | ○ |
| C-29 (UT-SCH-029) | checkSanity()で毎分実行警告 | E-01 (537-541行), E-06 (192行) | ○ |
| C-30 (UT-SCH-030) | checkSanity()で*/1警告 | E-06 (193行) | ○ |
| C-31 (UT-SCH-031) | checkSanity()でH使用時警告なし | E-01 (571-572行), E-06 (194行) | ○ |
| C-32 (UT-SCH-032) | checkSanity()で日にち短周期警告 | E-01 (546-554行), E-06 (209-210行) | ○ |
| C-33 (UT-SCH-033) | hashify()でH使用時null | E-01 (571-572行) | ○ |
| C-34 (UT-SCH-034) | hashify()で*/15変換 | E-01 (574-575行), E-06 (200行) | ○ |
| C-35 (UT-SCH-035) | hashify()で特定分変換 | E-01 (576-577行), E-06 (202-203行) | ○ |
| C-36 (UT-SCH-036) | hashify()で0,15,30,45変換 | E-01 (579-592行), E-06 (201行) | ○ |
| C-37 (UT-SCH-037) | getTimeZone()でTimeZone返却 | E-01 (602-607行) | ○ |
| C-38 (UT-SCH-038) | getTimeZone()でnull返却 | E-01 (603-605行) | ○ |
| C-39 (UT-SCH-039) | toString()の文字列表現 | E-01 (508-520行) | △ |
| C-40 (UT-SCH-040) | 境界値範囲指定 | E-06 (309-311行) | ○ |
| C-41 (UT-SCH-041) | 24時で範囲外エラー | E-06 (314-326行) | ○ |
| C-42 (UT-SCH-042) | 66分で範囲外エラー | E-06 (328-341行) | ○ |
| C-43 (UT-SCH-043) | 分精度計算 | E-06 (359-375行) | ○ |

### CronTabList クラス（UT-SCH-044 〜 UT-SCH-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 (UT-SCH-044) | コレクションで初期化 | E-02 (47-49行) | ○ |
| C-45 (UT-SCH-045) | check()でOR論理(true) | E-02 (54-60行) | ○ |
| C-46 (UT-SCH-046) | check()でOR論理(false) | E-02 (54-60行) | ○ |
| C-47 (UT-SCH-047) | checkSanity()で警告返却 | E-02 (71-77行) | ○ |
| C-48 (UT-SCH-048) | checkSanity()でnull返却 | E-02 (71-77行) | ○ |
| C-49 (UT-SCH-049) | getValidTimezone()で有効ID返却 | E-02 (84-92行) | ○ |
| C-50 (UT-SCH-050) | getValidTimezone()で無効時null | E-02 (84-92行) | ○ |
| C-51 (UT-SCH-051) | create()単一行 | E-02 (98-100行) | ○ |
| C-52 (UT-SCH-052) | create()複数行 | E-02 (111-133行), E-06 (298-306行) | ○ |
| C-53 (UT-SCH-053) | create()コメント無視 | E-02 (126-127行) | ○ |
| C-54 (UT-SCH-054) | create()空行無視 | E-02 (126-127行) | ○ |
| C-55 (UT-SCH-055) | create()でTZ=指定 | E-02 (115-124行), E-06 (345-356行) | ○ |
| C-56 (UT-SCH-056) | 無効タイムゾーンでANTLRException | E-02 (121-122行) | ○ |
| C-57 (UT-SCH-057) | 不正形式でANTLRException | E-02 (130-132行) | ○ |
| C-58 (UT-SCH-058) | Hash付きcreate() | E-02 (106-136行), E-06 (298行) | ○ |
| C-59 (UT-SCH-059) | previous()で直前時刻取得 | E-02 (139-148行) | △ |
| C-60 (UT-SCH-060) | next()で次回時刻取得 | E-02 (150-160行) | △ |

### Hash クラス（UT-SCH-061 〜 UT-SCH-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 (UT-SCH-061) | next()で0-n-1範囲 | E-03 (51行), E-03 (68-73行) | ○ |
| C-62 (UT-SCH-062) | from()で決定論的乱数 | E-03 (54-77行), E-08 (18-24行) | ○ |
| C-63 (UT-SCH-063) | 異なるシードで異なる結果 | E-03 (54-77行), E-08 (18-24行) | ○ |
| C-64 (UT-SCH-064) | zero()で常に0 | E-03 (88-97行) | ○ |

### BaseParser クラス（UT-SCH-065 〜 UT-SCH-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 (UT-SCH-065) | LOWER_BOUNDS定数 | E-04 (37行) | ○ |
| C-66 (UT-SCH-066) | UPPER_BOUNDS定数 | E-04 (38行) | ○ |
| C-67 (UT-SCH-067) | setHash()でnull安全 | E-04 (54-57行) | ○ |
| C-68 (UT-SCH-068) | doRange()でビットマスク生成 | E-04 (67-80行) | ○ |
| C-69 (UT-SCH-069) | doRange()でstep<=0エラー | E-04 (70-71行) | ○ |
| C-70 (UT-SCH-070) | doRange()でstart>endエラー | E-04 (72-73行) | ○ |
| C-71 (UT-SCH-071) | doHash()でビットマスク生成 | E-04 (93-121行), E-06 (273-279行) | ○ |
| C-72 (UT-SCH-072) | doHash()で日にち1-28範囲 | E-04 (95行) | ○ |
| C-73 (UT-SCH-073) | doHash()で曜日0-6範囲 | E-04 (96行) | ○ |
| C-74 (UT-SCH-074) | doHash()でstep範囲超過エラー | E-04 (103-105行), E-06 (285-293行) | ○ |
| C-75 (UT-SCH-075) | rangeCheck()で範囲内通過 | E-04 (123-127行) | ○ |
| C-76 (UT-SCH-076) | rangeCheck()で範囲外エラー | E-04 (123-127行) | ○ |
| C-77 (UT-SCH-077) | HASH_TOKENSシステムプロパティ | E-04 (141行) | △ |

### RareOrImpossibleDateException クラス（UT-SCH-078）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 (UT-SCH-078) | 例外インスタンス生成 | E-05 (全体) | ○ |

### ロケール横断テスト（UT-SCH-079 〜 UT-SCH-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 (UT-SCH-079) | ドイツロケール対応 | E-06 (107-124行), E-07 (45-57行) | ○ |
| C-80 (UT-SCH-080) | オーストリアロケール対応 | E-06 (129-146行), E-07 (45-57行) | ○ |
| C-81 (UT-SCH-081) | 全ロケールceil() | E-07 (61-73行) | ○ |
| C-82 (UT-SCH-082) | 全ロケールfloor() | E-07 (75-89行) | ○ |

### イベンチュアリティテスト（UT-SCH-083 〜 UT-SCH-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 (UT-SCH-083) | @yearly 1年以内 | E-08 (35-39行) | ○ |
| C-84 (UT-SCH-084) | @annually 1年以内 | E-08 (43-48行) | ○ |
| C-85 (UT-SCH-085) | @monthly 1ヶ月以内 | E-08 (52-56行) | ○ |
| C-86 (UT-SCH-086) | @weekly 1週間以内 | E-08 (59-64行) | ○ |
| C-87 (UT-SCH-087) | @daily 1日以内 | E-08 (67-72行) | ○ |
| C-88 (UT-SCH-088) | @midnight 1日以内 | E-08 (75-80行) | ○ |
| C-89 (UT-SCH-089) | @hourly 1時間以内 | E-08 (83-88行) | ○ |
| C-90 (UT-SCH-090) | 月初日指定 | E-08 (92-96行) | ○ |
| C-91 (UT-SCH-091) | 月初日曜指定 | E-08 (100-107行) | ○ |
| C-92 (UT-SCH-092) | Hashオフセット計算1 | E-06 (222-234行) | ○ |
| C-93 (UT-SCH-093) | Hashオフセット計算2 | E-06 (247-259行) | ○ |
| C-94 (UT-SCH-094) | Hashed minute計算 | E-06 (263-269行) | ○ |
| C-95 (UT-SCH-095) | H/15スキップ計算 | E-06 (272-279行) | ○ |
| C-96 (UT-SCH-096) | 複数Hash付きcron | E-06 (298-306行) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SCH-039 (toString)**: 実装コードから推測したテスト観点。具体的な出力形式の仕様書なし
  - 候補：Javadoc追加 / 実行時の出力確認 / 既存テストの探索
- **UT-SCH-059/060 (previous/next)**: @Restricted(NoExternalUse.class)のため外部テストが限定的
  - 候補：内部テストの確認 / 実際のフォーム検証での動作確認
- **UT-SCH-077 (HASH_TOKENS)**: システムプロパティの設定方法は実装から推測
  - 候補：設定ドキュメント / 実行時テスト

## 5) リスクフラグ（レビュー観点）
- **リスク0（低）**: UT-SCH-039, UT-SCH-078 - 単純なユーティリティ/例外クラス
- **リスク1（中）**: UT-SCH-059, UT-SCH-060, UT-SCH-077 - 内部APIまたは設定依存
- **リスク0（低）**: その他全テストケース - ソースコードおよび既存テストから十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] CronTabのceil/floorメソッドのタイムアウトテスト（SECURITY-790, SECURITY-1193）が適切か
- [ ] ロケール横断テストのカバレッジが十分か（CronTabDayOfWeekLocaleTestを参照）
- [ ] タイムゾーン関連テスト（JENKINS-9283）のエッジケースが網羅されているか
- [ ] Hash機能のテストで分散特性が検証されているか
- [ ] BaseParserのエラーメッセージがロケール対応しているか（テスト時のLocale設定に注意）
- [ ] RareOrImpossibleDateExceptionの発生条件（2年以内にマッチしない）が妥当か
