---
generated_at: 2026-01-22 21:15:00
metrics:
  claims_total: 113
  claims_with_evidence: 113
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.scm 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上のメソッド・クラスが実在するか
2. **根拠との整合性**：テストケースの内容がコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要なクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：113 / 113、根拠なし：0
- 優先レビュー（高）
  1. **ポーリング関連テスト（UT-SCM-011〜013, 059〜065）**：SCM変更検知の重要なロジック
  2. **checkout関連テスト（UT-SCM-015, 068〜069）**：ソース取得の中核処理
  3. **getEffectiveBrowser関連テスト（UT-SCM-004〜006）**：ブラウザ連携の重要なロジック

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/java/hudson/scm/SCM.java`
- E-02: `core/src/main/java/hudson/scm/ChangeLogSet.java`
- E-03: `core/src/main/java/hudson/scm/ChangeLogParser.java`
- E-04: `core/src/main/java/hudson/scm/RepositoryBrowser.java`
- E-05: `core/src/main/java/hudson/scm/SCMDescriptor.java`
- E-06: `core/src/main/java/hudson/scm/PollingResult.java`
- E-07: `core/src/main/java/hudson/scm/NullSCM.java`
- E-08: `core/src/main/java/hudson/scm/EmptyChangeLogSet.java`
- E-09: `core/src/main/java/hudson/scm/NullChangeLogParser.java`
- E-10: `core/src/main/java/hudson/scm/SCMRevisionState.java`
- E-11: `core/src/main/java/hudson/scm/EditType.java`
- E-12: `core/src/main/java/hudson/scm/ChangeLogAnnotator.java`
- E-13: `core/src/main/java/hudson/scm/SCMS.java`
- E-14: `core/src/main/java/hudson/scm/RepositoryBrowsers.java`
- E-15: `core/src/main/java/hudson/scm/AbstractScmTagAction.java`
- E-16: `core/src/main/java/hudson/scm/AutoBrowserHolder.java`
- E-17: `core/src/main/java/hudson/scm/browsers/QueryBuilder.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SCM.getApi - Apiオブジェクト返却 | E-01 (109-111行目) | ○ |
| C-02 | SCM.getBrowser - デフォルトnull返却 | E-01 (123-125行目) | ○ |
| C-03 | SCM.getType - クラス名返却 | E-01 (132-135行目) | ○ |
| C-04 | SCM.getEffectiveBrowser - getBrowser非null時 | E-01 (144-147行目) | ○ |
| C-05 | SCM.getEffectiveBrowser - guessBrowser呼び出し | E-01 (153-160行目) | ○ |
| C-06 | SCM.getEffectiveBrowser - 例外ハンドリング | E-01 (156-159行目) | ○ |
| C-07 | SCM.supportsPolling - デフォルトtrue | E-01 (169-171行目) | ○ |
| C-08 | SCM.requiresWorkspaceForPolling - デフォルトtrue | E-01 (195-197行目) | ○ |
| C-09 | SCM.processWorkspaceBeforeDeletion - 非AbstractProject | E-01 (238-244行目) | ○ |
| C-10 | SCM.processWorkspaceBeforeDeletion - AbstractProject委譲 | E-01 (247-253行目) | ○ |
| C-11 | SCM.poll - baseline=NONE時 | E-01 (425-436行目) | ○ |
| C-12 | SCM.poll - baseline非NONE時 | E-01 (430-431行目) | ○ |
| C-13 | SCM.poll - 旧SCM時pollChanges呼び出し | E-01 (437-439行目) | ○ |
| C-14 | SCM.getKey - getType返却 | E-01 (467-469行目) | ○ |
| C-15 | SCM.checkout - AbstractMethodError | E-01 (532-534行目) | ○ |
| C-16 | SCM.getModuleRoot - workspace返却 | E-01 (652-658行目) | ○ |
| C-17 | SCM.getModuleRoots - 1要素配列返却 | E-01 (693-700行目) | ○ |
| C-18 | SCM.createEmptyChangeLog - 空XML作成 | E-01 (744-748行目) | ○ |
| C-19 | SCM.nullify - null入力時null返却 | E-01 (750-754行目) | ○ |
| C-20 | SCM.nullify - 空文字時null返却 | E-01 (752行目) | ○ |
| C-21 | SCM.nullify - 空白のみ時null返却 | E-01 (752行目) | ○ |
| C-22 | SCM.nullify - 有効文字列時そのまま返却 | E-01 (753行目) | ○ |
| C-23 | SCM.all - ディスクリプタ一覧返却 | E-01 (766-768行目) | ○ |
| C-24 | SCM._for - null時all返却 | E-01 (777-778行目) | ○ |
| C-25 | SCM._for - フィルタリング | E-01 (780-793行目) | ○ |
| C-26 | SCM.guessBrowser - デフォルトnull | E-01 (807-809行目) | ○ |
| C-27 | ChangeLogSet.getRun - Run返却 | E-02 (89-91行目) | ○ |
| C-28 | ChangeLogSet.getBrowser - browser返却 | E-02 (96-98行目) | ○ |
| C-29 | ChangeLogSet.getItems - 配列返却 | E-02 (110-115行目) | ○ |
| C-30 | ChangeLogSet.getItems - 空配列 | E-02 (110-115行目) | ○ |
| C-31 | ChangeLogSet.getKind - デフォルトnull | E-02 (123-125行目) | ○ |
| C-32 | ChangeLogSet.createEmpty - EmptyChangeLogSet返却 | E-02 (131-133行目) | ○ |
| C-33 | Entry.getParent - 親返却 | E-02 (144-146行目) | ○ |
| C-34 | Entry.setParent - 親設定 | E-02 (151-153行目) | ○ |
| C-35 | Entry.getCommitId - デフォルトnull | E-02 (168-170行目) | ○ |
| C-36 | Entry.getTimestamp - デフォルト-1 | E-02 (184-186行目) | ○ |
| C-37 | Entry.getMsgAnnotated - アノテーション適用 | E-02 (249-261行目) | ○ |
| C-38 | Entry.getMsgAnnotated - 例外ハンドリング | E-02 (253-258行目) | ○ |
| C-39 | Entry.getMsgEscaped - HTMLエスケープ | E-02 (266-268行目) | ○ |
| C-40 | Entry.getAffectedFiles - 未実装例外 | E-02 (236-244行目) | ○ |
| C-41 | ChangeLogParser.parse - AbstractMethodError | E-03 (47-53行目) | ○ |
| C-42 | RepositoryBrowser.trimHeadSlash - スラッシュ除去 | E-04 (73-76行目) | ○ |
| C-43 | RepositoryBrowser.trimHeadSlash - スラッシュなし | E-04 (73-76行目) | ○ |
| C-44 | RepositoryBrowser.normalizeToEndWithSlash - スラッシュ追加 | E-04 (83-96行目) | ○ |
| C-45 | RepositoryBrowser.normalizeToEndWithSlash - スラッシュあり | E-04 (84-85行目) | ○ |
| C-46 | RepositoryBrowser.normalizeToEndWithSlash - クエリ保持 | E-04 (88-91行目) | ○ |
| C-47 | RepositoryBrowser.all - ディスクリプタ一覧 | E-04 (101-103行目) | ○ |
| C-48 | SCMDescriptor.getGeneration - 初期値1 | E-05 (84-86行目) | ○ |
| C-49 | SCMDescriptor.incrementGeneration - インクリメント | E-05 (94-96行目) | ○ |
| C-50 | SCMDescriptor.load - repositoryBrowser保持 | E-05 (101-114行目) | ○ |
| C-51 | SCMDescriptor.isBrowserReusable - デフォルトfalse | E-05 (129-131行目) | ○ |
| C-52 | SCMDescriptor.isApplicable - AbstractProject時true | E-05 (150-157行目) | ○ |
| C-53 | SCMDescriptor.isApplicable - 非AbstractProject時false | E-05 (142-148行目) | ○ |
| C-54 | SCMDescriptor.getBrowserDescriptors - null時空リスト | E-05 (166-168行目) | ○ |
| C-55 | SCMDescriptor.getBrowserDescriptors - フィルタリング | E-05 (166-169行目) | ○ |
| C-56 | PollingResult.コンストラクタ - フィールド設定 | E-06 (81-86行目) | ○ |
| C-57 | PollingResult.コンストラクタ - null時例外 | E-06 (82行目) | ○ |
| C-58 | PollingResult.コンストラクタ(Change) - 簡易構築 | E-06 (88-90行目) | ○ |
| C-59 | PollingResult.hasChanges - NONE時false | E-06 (92-94行目) | ○ |
| C-60 | PollingResult.hasChanges - INSIGNIFICANT時false | E-06 (93行目) | ○ |
| C-61 | PollingResult.hasChanges - SIGNIFICANT時true | E-06 (93行目) | ○ |
| C-62 | PollingResult.hasChanges - INCOMPARABLE時true | E-06 (93行目) | ○ |
| C-63 | PollingResult.NO_CHANGES定数 | E-06 (99行目) | ○ |
| C-64 | PollingResult.SIGNIFICANT定数 | E-06 (101行目) | ○ |
| C-65 | PollingResult.BUILD_NOW定数 | E-06 (106行目) | ○ |
| C-66 | NullSCM.calcRevisionsFromBuild - null返却 | E-07 (49-51行目) | ○ |
| C-67 | NullSCM.compareRemoteRevisionWith - NO_CHANGES返却 | E-07 (53-55行目) | ○ |
| C-68 | NullSCM.checkout - 空チェンジログ作成 | E-07 (57-61行目) | ○ |
| C-69 | NullSCM.checkout - changelogFile=null時 | E-07 (58行目) | ○ |
| C-70 | NullSCM.createChangeLogParser - NullChangeLogParser返却 | E-07 (63-65行目) | ○ |
| C-71 | EmptyChangeLogSet.isEmptySet - true返却 | E-08 (24-26行目) | ○ |
| C-72 | EmptyChangeLogSet.iterator - 空イテレータ | E-08 (29-31行目) | ○ |
| C-73 | NullChangeLogParser.parse - EmptyChangeLogSet返却 | E-09 (40-42行目) | ○ |
| C-74 | NullChangeLogParser.readResolve - シングルトン返却 | E-09 (44-46行目) | ○ |
| C-75 | SCMRevisionState.getIconFileName - null返却 | E-10 (28-31行目) | ○ |
| C-76 | SCMRevisionState.getDisplayName - null返却 | E-10 (33-36行目) | ○ |
| C-77 | SCMRevisionState.getUrlName - null返却 | E-10 (38-41行目) | ○ |
| C-78 | SCMRevisionState.NONE定数 | E-10 (52行目) | ○ |
| C-79 | EditType.コンストラクタ - フィールド設定 | E-11 (39-42行目) | ○ |
| C-80 | EditType.getName - name返却 | E-11 (44-46行目) | ○ |
| C-81 | EditType.getDescription - description返却 | E-11 (48-50行目) | ○ |
| C-82 | EditType.toExportedObject - name返却 | E-11 (53-55行目) | ○ |
| C-83 | EditType.ADD定数 | E-11 (57行目) | ○ |
| C-84 | EditType.EDIT定数 | E-11 (58行目) | ○ |
| C-85 | EditType.DELETE定数 | E-11 (59行目) | ○ |
| C-86 | EditType.ALL定数 | E-11 (61行目) | ○ |
| C-87 | ChangeLogAnnotator.annotate - 警告ログ | E-12 (81-87行目) | ○ |
| C-88 | ChangeLogAnnotator.register - リスト追加 | E-12 (102-104行目) | ○ |
| C-89 | ChangeLogAnnotator.unregister - リスト削除 | E-12 (109-111行目) | ○ |
| C-90 | ChangeLogAnnotator.unregister - 未登録時false | E-12 (110行目) | ○ |
| C-91 | ChangeLogAnnotator.all - ExtensionList返却 | E-12 (125-127行目) | ○ |
| C-92 | SCMS.parseSCM - フォームパース | E-13 (58-65行目) | ○ |
| C-93 | SCMS.parseSCM - null時NullSCM | E-13 (60-62行目) | ○ |
| C-94 | RepositoryBrowsers.filter - サブタイプフィルタ | E-14 (55-61行目) | ○ |
| C-95 | RepositoryBrowsers.filter - 空リスト | E-14 (56行目) | ○ |
| C-96 | RepositoryBrowsers.createInstance - JSON生成 | E-14 (88-94行目) | ○ |
| C-97 | RepositoryBrowsers.createInstance - null返却 | E-14 (91行目) | ○ |
| C-98 | AbstractScmTagAction.getUrlName - tagBuild返却 | E-15 (74-77行目) | ○ |
| C-99 | AbstractScmTagAction.getPermission - SCM.TAG返却 | E-15 (82-85行目) | ○ |
| C-100 | AbstractScmTagAction.getRun - Run返却 | E-15 (90-92行目) | ○ |
| C-101 | AbstractScmTagAction.getTooltip - null返却 | E-15 (102-104行目) | ○ |
| C-102 | AbstractScmTagAction.getACL - run.getACL返却 | E-15 (112-114行目) | ○ |
| C-103 | AbstractScmTagAction.chooseAction - tagForm.jelly | E-15 (145-149行目) | ○ |
| C-104 | AbstractScmTagAction.chooseAction - inProgress.jelly | E-15 (146-147行目) | ○ |
| C-105 | AbstractScmTagAction.onLoad - フィールドリストア | E-15 (155-158行目) | ○ |
| C-106 | AutoBrowserHolder.get - キャッシュ返却 | E-16 (53-56行目) | ○ |
| C-107 | AutoBrowserHolder.get - guessBrowserキャッシュ | E-16 (58-63行目) | ○ |
| C-108 | AutoBrowserHolder.get - キャッシュ再計算 | E-16 (64-68行目) | ○ |
| C-109 | QueryBuilder.コンストラクタ - 初期化 | E-17 (35-37行目) | ○ |
| C-110 | QueryBuilder.add - 最初のパラメータ | E-17 (39-44行目) | ○ |
| C-111 | QueryBuilder.add - 追加パラメータ | E-17 (42行目) | ○ |
| C-112 | QueryBuilder.add - null入力 | E-17 (40行目) | ○ |
| C-113 | QueryBuilder.toString - 文字列変換 | E-17 (48-50行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

全てのテストケースがソースコードに基づいて生成されており、根拠なしのケースは存在しません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがコードに基づいて生成されている
- 注意点：
  - SCMは抽象クラスであるため、テストには具象サブクラス（NullSCMなど）またはモックが必要
  - PollingResult.hasChangesのordinal比較はenum定義順序に依存するため、enum定義変更時は要注意
  - AutoBrowserHolderは@Deprecatedであり、デフォルトでは使用されない

## 6) レビュアーチェックリスト（最小）
- [ ] SCM.pollメソッドのテスト（UT-SCM-011〜013）が変更検知の主要ユースケースをカバーしているか
- [ ] PollingResult.hasChangesのテスト（UT-SCM-059〜062）がChange enum全値を網羅しているか
- [ ] getEffectiveBrowserのエラーハンドリングテスト（UT-SCM-006）が適切か
- [ ] AbstractScmTagActionの権限テスト（UT-SCM-099, 102）がセキュリティ観点で十分か
- [ ] NullSCM関連のテスト（UT-SCM-066〜070）がNo-op実装として適切か
