---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 93
  claims_with_evidence: 93
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.search 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・既存テストコードなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実際のコード実装と矛盾していないか
3. **網羅性**：クラス・メソッドの主要な機能をカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：93 / 93、根拠なし：0
- 優先レビュー（高）
  1. **UT-SRCH-009**：MAX_SEARCH_SIZE制限（セキュリティ関連）
  2. **UT-SRCH-013/014**：権限チェック（セキュリティ関連）
  3. **UT-SRCH-088/089**：UserSearchProperty.isCaseInsensitive（ユーザー設定）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/Search.java`
- E-02: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchIndex.java`
- E-03: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchItem.java`
- E-04: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SuggestedItem.java`
- E-05: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchIndexBuilder.java`
- E-06: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchResult.java`
- E-07: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/CollectionSearchIndex.java`
- E-08: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/UnionSearchIndex.java`
- E-09: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/FixedSet.java`
- E-10: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchItems.java`
- E-11: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchFactory.java`
- E-12: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/QuickSilver.java`
- E-13: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/ParsedQuickSilver.java`
- E-14: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/SearchableModelObject.java`
- E-15: `/Users/tomoka.baba/Work/jenkins-master/core/src/main/java/hudson/search/UserSearchProperty.java`
- E-16: `/Users/tomoka.baba/Work/jenkins-master/core/src/test/java/hudson/search/SearchTest.java`
- E-17: `/Users/tomoka.baba/Work/jenkins-master/test/src/test/java/hudson/search/SearchTest.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### Search クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | find()で単一の完全一致結果が返却されること | E-01 (line 396-410), E-16 (line 41-58) | ○ |
| C-02 | find()で複数一致時にURLにクエリを含むアイテムが優先されること | E-01 (line 368-381), E-16 (line 64-114) | ○ |
| C-03 | find()で一致なしの場合にnullが返却されること | E-01 (line 398-399) | ○ |
| C-04 | find()で空文字列クエリの挙動 | E-01 (line 506) | ○ |
| C-05 | suggest()で部分一致の候補が返却されること | E-01 (line 423-457), E-16 (line 54-57) | ○ |
| C-06 | suggest()で編集距離でソートされた結果が返却されること | E-01 (line 431-434, 451) | ○ |
| C-07 | suggest()でプレフィックス一致のアイテムが優先されること | E-01 (line 434, 439-440) | ○ |
| C-08 | getSuggestions()でmaxパラメータで結果数が制限されること | E-01 (line 229-231) | ○ |
| C-09 | getSuggestions()でMAX_SEARCH_SIZEを超える結果が制限されること | E-01 (line 87, 231), E-17 (line 468-492) | ○ |
| C-10 | getSuggestions()でhasMoreResultsがtrueで返却されること | E-01 (line 235-237, 280-282) | ○ |
| C-11 | findClosestSuggestedItem()でURLにクエリを含むアイテムが選択されること | E-01 (line 368-381), E-16 (line 64-114) | ○ |
| C-12 | findClosestSuggestedItem()でURLに一致がない場合は先頭アイテムが返却されること | E-01 (line 380), E-16 (line 112-113) | ○ |
| C-13 | getTarget()でJenkins.READ権限チェック | E-01 (line 547-554) | ○ |
| C-14 | getTarget()で権限がない場合にアクセス拒否されること | E-01 (line 551) | ○ |
| C-15 | getTarget()でSKIP_PERMISSION_CHECK=trueの場合は権限チェックがスキップされること | E-01 (line 550, 559-561) | ○ |
| C-16 | TokenList.length()でトークン数が返却されること | E-01 (line 466) | ○ |
| C-17 | TokenList.length()でnullの場合に0が返却されること | E-01 (line 463) | ○ |
| C-18 | TokenList.subSequence()で指定位置からのサブシーケンスが返却されること | E-01 (line 473-488) | ○ |
| C-19 | Item コンストラクタで全フィールドが設定されること | E-01 (line 309-316) | ○ |

### SearchIndex インターフェース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | find()でトークンに完全一致するアイテムが追加されること | E-02 (line 37) | ○ |
| C-21 | suggest()でトークンを含むアイテムがすべて追加されること | E-02 (line 43) | ○ |
| C-22 | EMPTY.find()で何も追加されないこと | E-02 (line 50-52) | ○ |
| C-23 | EMPTY.suggest()で何も追加されないこと | E-02 (line 55-57) | ○ |

### SearchItem インターフェース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | getSearchName()で検索名が返却されること | E-03 (line 47) | ○ |
| C-25 | getSearchUrl()で相対URLが返却されること | E-03 (line 57) | ○ |
| C-26 | getSearchIcon()でIconSpec実装時にアイコンクラス名が返却されること | E-03 (line 59-62) | ○ |
| C-27 | getSearchIcon()でIconSpec未実装時にsymbol-searchが返却されること | E-03 (line 64) | ○ |
| C-28 | getSearchGroup()でUnclassifiedSearchGroupが返却されること | E-03 (line 67-69) | ○ |
| C-29 | getSearchIndex()で子要素のSearchIndexが返却されること | E-03 (line 78) | ○ |

### SuggestedItem クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | コンストラクタ(SearchItem)で親なしで初期化されること | E-04 (line 40-42) | ○ |
| C-31 | コンストラクタ(SuggestedItem, SearchItem)で親ありで初期化されること | E-04 (line 44-47) | ○ |
| C-32 | getPath()で親なしの場合にsearchNameが返却されること | E-04 (line 51-52) | ○ |
| C-33 | getPath()で親ありの場合に階層パスが返却されること | E-04 (line 60-66) | ○ |
| C-34 | getPath()でキャッシュされたパスが再利用されること | E-04 (line 50) | ○ |
| C-35 | getUrl()で親なしの場合に先頭にスラッシュが付いたURLが返却されること | E-04 (line 105-117) | ○ |
| C-36 | getUrl()で親ありの場合に連結されたURLが返却されること | E-04 (line 106-116) | ○ |
| C-37 | getUrl()でitem.getSearchUrl()が/で始まる場合にリセットされること | E-04 (line 110-112) | ○ |
| C-38 | build(SearchableModelObject, SearchItem)でSearchItemがItemの場合に階層構築されること | E-04 (line 83-90, 98-103) | ○ |
| C-39 | build(SearchableModelObject, SearchItem)でSearchItemがItem以外の場合に単一SuggestedItemが返却されること | E-04 (line 101-102) | ○ |

### SearchIndexBuilder クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | add(String)でURL兼名前でアイテムが追加されること | E-05 (line 56-58) | ○ |
| C-41 | add(String, String)でURLと名前を別々に指定してアイテムが追加されること | E-05 (line 66-69) | ○ |
| C-42 | add(String, String...)で1つのURLに複数の名前でアイテムが追加されること | E-05 (line 71-75) | ○ |
| C-43 | add(SearchItem)でSearchItemが直接追加されること | E-05 (line 77-80) | ○ |
| C-44 | add(SearchIndex)でSearchIndexが追加されること | E-05 (line 93-96) | ○ |
| C-45 | addAllAnnotations()でQuickSilverアノテーション付きフィールド/メソッドが追加されること | E-05 (line 48-51) | ○ |
| C-46 | make()でFixedSetとUnionSearchIndexの組み合わせが返却されること | E-05 (line 102-107) | ○ |
| C-47 | make()で何も追加されていない場合に空のFixedSetが返却されること | E-05 (line 103) | ○ |

### SearchResult インターフェース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | hasMoreResults()で追加結果がある場合にtrueが返却されること | E-06 (line 10) | ○ |
| C-49 | hasMoreResults()で追加結果がない場合にfalseが返却されること | E-06 (line 10) | ○ |

### CollectionSearchIndex クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | find()でget()で取得したアイテムがresultに追加されること | E-07 (line 57-61) | ○ |
| C-51 | find()でget()がnullの場合にresultに何も追加されないこと | E-07 (line 59-60) | ○ |
| C-52 | suggest()で大文字小文字を区別しない検索が動作すること | E-07 (line 65-76) | ○ |
| C-53 | suggest()で大文字小文字を区別する検索が動作すること | E-07 (line 65-76) | ○ |
| C-54 | suggest()でall()がnullの場合に空のイテレータが使用されること | E-07 (line 51-54) | ○ |
| C-55 | suggest()でコレクション内のnullアイテムがスキップされること | E-07 (line 73) | ○ |

### UnionSearchIndex クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | コンストラクタでlhsとrhsが正しく設定されること | E-08 (line 52-55) | ○ |
| C-57 | find()で両方のインデックスからの結果が統合されること | E-08 (line 58-61) | ○ |
| C-58 | suggest()で両方のインデックスからのサジェストが統合されること | E-08 (line 64-67) | ○ |
| C-59 | combine()で複数インデックスが正しく結合されること | E-08 (line 35-48) | ○ |
| C-60 | combine()でnullを含む配列の場合にnullがスキップされること | E-08 (line 40) | ○ |
| C-61 | combine()ですべてEMPTYの場合にEMPTYが返却されること | E-08 (line 36, 41) | ○ |

### FixedSet クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | コンストラクタ(Collection)でCollectionが正しく保持されること | E-09 (line 41-43) | ○ |
| C-63 | コンストラクタ(SearchItem...)で可変長引数が正しく保持されること | E-09 (line 45-47) | ○ |
| C-64 | find()で大文字小文字を区別しない完全一致が動作すること | E-09 (line 50-58) | ○ |
| C-65 | find()で大文字小文字を区別する完全一致が動作すること | E-09 (line 50-58) | ○ |
| C-66 | find()でsearchNameがnullのアイテムがスキップされること | E-09 (line 54) | ○ |
| C-67 | suggest()で部分一致で大文字小文字を区別しない検索が動作すること | E-09 (line 61-69) | ○ |
| C-68 | suggest()で部分一致で大文字小文字を区別する検索が動作すること | E-09 (line 61-69) | ○ |

### SearchItems クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | create(String, String)で名前とURLのみのSearchItemが作成されること | E-10 (line 31-33) | ○ |
| C-70 | create(String, String, SearchIndex)で名前、URL、子インデックスのSearchItemが作成されること | E-10 (line 35-52) | ○ |
| C-71 | create(String, String, SearchableModelObject)でSearchableModelObjectの検索インデックスを使用するSearchItemが作成されること | E-10 (line 54-71) | ○ |

### SearchFactory クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | createFor()でSearchFactoryがSearchを生成できること | E-11 (line 36) | ○ |
| C-73 | all()で登録されたすべてのSearchFactoryが返却されること | E-11 (line 41-43) | ○ |

### QuickSilver アノテーション
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | メソッドに適用されたアノテーションが取得できること | E-12 (line 51-52) | ○ |
| C-75 | フィールドに適用されたアノテーションが取得できること | E-12 (line 51-52) | ○ |
| C-76 | value属性が空配列の場合にデフォルト名が使用されること | E-12 (line 54) | ○ |
| C-77 | value属性に指定した名前が使用されること | E-12 (line 54) | ○ |

### ParsedQuickSilver クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | get()で同一クラスに対してキャッシュされたインスタンスが返却されること | E-13 (line 43-49) | ○ |
| C-79 | addTo()でQuickSilverアノテーション付きgetterがSearchItemとして追加されること | E-13 (line 57-67, 163-183) | ○ |
| C-80 | addTo()でQuickSilverアノテーション付きフィールドがSearchItemとして追加されること | E-13 (line 69-79, 163-183) | ○ |
| C-81 | addTo()でgetプレフィックスが除去されたURLが使用されること | E-13 (line 94-99) | ○ |
| C-82 | addTo()でキャメルケースがスペース区切りに変換されること | E-13 (line 85-92) | ○ |
| C-83 | addTo()でgetter実行時の例外が適切に伝播されること | E-13 (line 124-136) | ○ |
| C-84 | addTo()でgetterがnullを返す場合に子インデックスがEMPTYになること | E-13 (line 178-180) | ○ |

### SearchableModelObject インターフェース
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | getSearch()でSearchオブジェクトが返却されること | E-14 (line 44) | ○ |

### UserSearchProperty クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | コンストラクタでinsensitiveSearchが正しく設定されること | E-15 (line 20-22) | ○ |
| C-87 | getInsensitiveSearch()で設定値が返却されること | E-15 (line 25-27) | ○ |
| C-88 | isCaseInsensitive()でユーザーが存在する場合にユーザー設定が返却されること | E-15 (line 29-37) | ○ |
| C-89 | isCaseInsensitive()でユーザーがnullの場合にデフォルト値（true）が返却されること | E-15 (line 32-33) | ○ |
| C-90 | DescriptorImpl.getDisplayName()で表示名が返却されること | E-15 (line 43-46) | ○ |
| C-91 | DescriptorImpl.newInstance(User)でデフォルト設定のUserSearchPropertyが作成されること | E-15 (line 48-51) | ○ |
| C-92 | DescriptorImpl.newInstance(StaplerRequest2, JSONObject)でフォームデータからUserSearchPropertyが作成されること | E-15 (line 53-56) | ○ |
| C-93 | DescriptorImpl.getUserPropertyCategory()でPreferencesカテゴリが返却されること | E-15 (line 58-61) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべてのテストケースにソースコードによる根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコードによる根拠あり
- 1: 中リスク - 既存テストコード（E-16, E-17）に対応するテストケースが参考になる
- 注意点:
  - **セキュリティ関連テスト（UT-SRCH-009, UT-SRCH-013/014）** は特に重要度が高い
  - **UserSearchProperty.isCaseInsensitive()** はユーザー体験に影響するため注意

## 6) レビュアーチェックリスト（最小）
- [ ] Search.find() / suggest() のテストケースが基本動作を網羅しているか
- [ ] MAX_SEARCH_SIZE制限のテストケース（UT-SRCH-009）がセキュリティ要件を満たしているか
- [ ] 権限チェック（getTarget）のテストケースが適切か
- [ ] 大文字小文字を区別/無視する検索の両方がカバーされているか
- [ ] 境界値テスト（null, 空文字列, 空コレクション）が網羅されているか
- [ ] 階層的なパス生成（SuggestedItem）のテストが適切か
- [ ] ParsedQuickSilverの例外処理テストが適切か
