---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 228
  claims_with_evidence: 228
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.security 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：228 / 228、根拠なし：0
- 優先レビュー（高）
  1. **全テストケースがソースコードに基づいて生成されている**
  2. **セキュリティ関連のため、権限チェック・認証・CSRF保護のテストを重点レビュー推奨**
  3. **パスワードハッシュ関連（JBCryptEncoder, PBKDF2PasswordEncoder）のテストケースは特に重要**

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/security/ACL.java`
- E-02: `core/src/main/java/hudson/security/Permission.java`
- E-03: `core/src/main/java/hudson/security/PermissionGroup.java`
- E-04: `core/src/main/java/hudson/security/PermissionScope.java`
- E-05: `core/src/main/java/hudson/security/SidACL.java`
- E-06: `core/src/main/java/hudson/security/SparseACL.java`
- E-07: `core/src/main/java/hudson/security/SecurityRealm.java`
- E-08: `core/src/main/java/hudson/security/AuthorizationStrategy.java`
- E-09: `core/src/main/java/hudson/security/FullControlOnceLoggedInAuthorizationStrategy.java`
- E-10: `core/src/main/java/hudson/security/HudsonPrivateSecurityRealm.java`
- E-11: `core/src/main/java/hudson/security/ACLContext.java`
- E-12: `core/src/main/java/hudson/security/AccessControlled.java`
- E-13: `core/src/main/java/hudson/security/AccessDeniedException3.java`
- E-14: `core/src/main/java/hudson/security/GroupDetails.java`
- E-15: `core/src/main/java/hudson/security/GlobalSecurityConfiguration.java`
- E-16: `core/src/main/java/hudson/security/csrf/CrumbIssuer.java`
- E-17: `core/src/main/java/hudson/security/csrf/DefaultCrumbIssuer.java`
- E-18: `core/src/main/java/hudson/security/csrf/CrumbFilter.java`
- E-19: `core/src/main/java/hudson/security/TokenBasedRememberMeServices2.java`
- E-20: `core/src/main/java/hudson/security/BasicAuthenticationFilter.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ACL クラス (UT-SEC-001 〜 UT-SEC-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | checkPermission: 権限を持つユーザーが通過 | E-01: L70-81 | ○ |
| C-02 | checkPermission: 権限なしでAccessDeniedException3 | E-01: L75-79 | ○ |
| C-03 | checkPermission: SYSTEM2は常に通過 | E-01: L72-74 | ○ |
| C-04 | checkAnyPermission: 複数権限の1つで通過 | E-01: L95-124 | ○ |
| C-05 | checkAnyPermission: 空配列でIllegalArgumentException | E-01: L96-98 | ○ |
| C-06 | checkAnyPermission: 全権限なしでAccessDeniedException | E-01: L100-123 | ○ |
| C-07 | hasPermission: 権限ありでtrue | E-01: L132-138 | ○ |
| C-08 | hasPermission: 権限なしでfalse | E-01: L132-138 | ○ |
| C-09 | hasPermission: SYSTEM2は常にtrue | E-01: L134-136 | ○ |
| C-10 | hasAnyPermission: 複数権限の1つでtrue | E-01: L149-165 | ○ |
| C-11 | hasAnyPermission: 空配列でIllegalArgumentException | E-01: L150-152 | ○ |
| C-12 | hasPermission2: 認証と権限で確認 | E-01: L175-181 | ○ |
| C-13 | lambda2: ラムダからACL生成 | E-01: L197-204 | ○ |
| C-14 | checkCreatePermission(ItemGroup): 権限ありで通過 | E-01: L231-241 | ○ |
| C-15 | checkCreatePermission(ItemGroup): 権限なしでAccessDeniedException | E-01: L237-240 | ○ |
| C-16 | checkCreatePermission(ViewGroup): 権限ありで通過 | E-01: L284-294 | ○ |
| C-17 | as2: 認証コンテキスト切り替え | E-01: L476-481 | ○ |
| C-18 | as(User): ユーザーとして切り替え | E-01: L509-512 | ○ |
| C-19 | as(User): nullでANONYMOUS2 | E-01: L511 | ○ |
| C-20 | isAnonymous2: AnonymousAuthenticationTokenでtrue | E-01: L520-523 | ○ |
| C-21 | isAnonymous2: 認証済みでfalse | E-01: L520-523 | ○ |

### Permission クラス (UT-SEC-022 〜 UT-SEC-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | コンストラクタ: 有効パラメータで作成 | E-02: L142-158 | ○ |
| C-23 | コンストラクタ: 無効識別子でIllegalArgumentException | E-02: L145-146 | ○ |
| C-24 | コンストラクタ: 重複でIllegalStateException | E-02: L156 (group.add経由) | ○ |
| C-25 | getId: owner.class.name形式 | E-02: L218-223 | ○ |
| C-26 | fromId: 有効IDから取得 | E-02: L240-253 | ○ |
| C-27 | fromId: 無効IDでnull | E-02: L242, L248, L250 | ○ |
| C-28 | fromId: ドットなしでnull | E-02: L242 | ○ |
| C-29 | isContainedBy: 含まれる場合true | E-02: L200-206 | ○ |
| C-30 | isContainedBy: 含まれない場合false | E-02: L200-206 | ○ |
| C-31 | setEnabled/getEnabled: フラグ設定・取得 | E-02: L260-266 | ○ |
| C-32 | getAll: 全Permission取得 | E-02: L273-275 | ○ |
| C-33 | equals: 同一IDでtrue | E-02: L225-227 | ○ |
| C-34 | hashCode: 同一IDで同一hashCode | E-02: L229-231 | ○ |

### PermissionGroup クラス (UT-SEC-035 〜 UT-SEC-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | コンストラクタ: 作成・登録 | E-03: L63-79 | ○ |
| C-36 | コンストラクタ: 重複でIllegalStateException | E-03: L162-166 | ○ |
| C-37 | add: Permission追加 | E-03: L98-102 | ○ |
| C-38 | add: 重複追加でIllegalStateException | E-03: L99-101 | ○ |
| C-39 | getPermissions: リスト返却 | E-03: L107-109 | ○ |
| C-40 | find: 名前で検索 | E-03: L121-127 | ○ |
| C-41 | find: 存在しない場合null | E-03: L126 | ○ |
| C-42 | get(Class): ownerで取得 | E-03: L182-189 | ○ |
| C-43 | get(Class): 存在しない場合null | E-03: L188 | ○ |
| C-44 | getAll: 全グループ取得 | E-03: L173-175 | ○ |
| C-45 | hasPermissionContainedBy: スコープ確認 | E-03: L111-116 | ○ |
| C-46 | compareTo: Hudson.classが優先 | E-03: L130-144 | ○ |

### PermissionScope クラス (UT-SEC-047 〜 UT-SEC-050)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | コンストラクタ: スコープ作成 | E-04: L69-72 | ○ |
| C-48 | isContainedBy: 自身でtrue | E-04: L81 | ○ |
| C-49 | isContainedBy: 親に含まれる場合true | E-04: L82-85 | ○ |
| C-50 | isContainedBy: 関係ない場合false | E-04: L86 | ○ |

### SidACL クラス (UT-SEC-051 〜 UT-SEC-058)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | hasPermission2: SYSTEM2で常にtrue | E-05: L48-53 | ○ |
| C-52 | hasPermission2: PrincipalSid優先評価 | E-05: L73-77 | ○ |
| C-53 | hasPermission2: GrantedAuthoritySid次に評価 | E-05: L82-88 | ○ |
| C-54 | hasPermission2: AUTOMATIC_SIDs最後に評価 | E-05: L91-97 | ○ |
| C-55 | hasPermission2: 該当なしでfalse | E-05: L59 | ○ |
| C-56 | newInheritingACL: 継承ACL作成 | E-05: L141-151 | ○ |
| C-57 | toString(Sid): GrantedAuthoritySidで権限名 | E-05: L123-124 | ○ |
| C-58 | toString(Sid): PrincipalSidでプリンシパル名 | E-05: L125-126 | ○ |

### SparseACL クラス (UT-SEC-059 〜 UT-SEC-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | コンストラクタ: 親ACL指定 | E-06: L61-63 | ○ |
| C-60 | add(Entry): エントリ追加 | E-06: L65-67 | ○ |
| C-61 | add(Sid, Permission, boolean): エントリ追加 | E-06: L69-71 | ○ |
| C-62 | hasPermission2: SYSTEM2で常にtrue | E-06: L75 | ○ |
| C-63 | hasPermission2: エントリ一致で結果返却 | E-06: L92-96 | ○ |
| C-64 | hasPermission2: impliedBy評価 | E-06: L92 | ○ |
| C-65 | hasPermission2: 親ACL委譲 | E-06: L79-83 | ○ |
| C-66 | hasPermission2: 親なし・一致なしでfalse | E-06: L86 | ○ |

### SecurityRealm クラス (UT-SEC-067 〜 UT-SEC-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | createSecurityComponents: コンポーネント作成 | E-07: L173 | ○ |
| C-68 | getUserIdStrategy: CASE_INSENSITIVE | E-07: L185-187 | ○ |
| C-69 | getGroupIdStrategy: getUserIdStrategyと同じ | E-07: L199-201 | ○ |
| C-70 | getAuthenticationGatewayUrl: j_spring_security_check | E-07: L229-234 | ○ |
| C-71 | getLoginUrl: login | E-07: L248-250 | ○ |
| C-72 | canLogOut: true | E-07: L265-267 | ○ |
| C-73 | doLogout: セッション無効化・リダイレクト | E-07: L372-384 | ○ |
| C-74 | doLogout: Remember-Meクッキーリセット | E-07: L387-394 | ○ |
| C-75 | allowsSignup: signup.jelly存在確認 | E-07: L442-445 | ○ |
| C-76 | loadUserByUsername2: UserDetails取得 | E-07: L456-468 | ○ |
| C-77 | loadUserByUsername2: 存在しないユーザーで例外 | E-07: L467 | ○ |
| C-78 | loadGroupByGroupname2: GroupDetails取得 | E-07: L497-518 | ○ |
| C-79 | loadGroupByGroupname2: デフォルトで例外 | E-07: L516 | ○ |
| C-80 | validateCaptcha: 正しいCaptchaでtrue | E-07: L585-593 | ○ |
| C-81 | validateCaptcha: CaptchaSupport nullでtrue | E-07: L592 | ○ |
| C-82 | validateCaptcha: 不正Captchaでfalse | E-07: L588 | ○ |
| C-83 | getSecurityComponents: キャッシュ | E-07: L604-609 | ○ |
| C-84 | createFilter: フィルターチェーン作成 | E-07: L626-684 | ○ |
| C-85 | getFrom: リダイレクト先取得 | E-07: L709-755 | ○ |
| C-86 | getFrom: 空で/ | E-07: L744-746 | ○ |
| C-87 | SecurityComponents: デフォルトコンストラクタ | E-07: L851-855 | ○ |
| C-88 | SecurityComponents: AuthenticationManager指定 | E-07: L860-864 | ○ |
| C-89 | SecurityComponents: 全パラメータ指定 | E-07: L892-900 | ○ |

### AuthorizationStrategy クラス (UT-SEC-090 〜 UT-SEC-099)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | getRootACL: ルートACL返却 | E-08: L80 | ○ |
| C-91 | getACL(Job): getRootACL | E-08: L91-93 | ○ |
| C-92 | getACL(View): 可視性ベースACL | E-08: L105-116 | ○ |
| C-93 | getACL(AbstractItem): getRootACL | E-08: L127-129 | ○ |
| C-94 | getACL(User): getRootACL | E-08: L140-142 | ○ |
| C-95 | getACL(Computer): getACL(Node)委譲 | E-08: L153-155 | ○ |
| C-96 | getACL(Cloud): getRootACL | E-08: L182-184 | ○ |
| C-97 | getGroups: グループ一覧 | E-08: L204 | ○ |
| C-98 | Unsecured.getRootACL: 全許可ACL | E-08: L240-242, L249 | ○ |
| C-99 | Unsecured.getGroups: 空Set | E-08: L245-247 | ○ |

### FullControlOnceLoggedInAuthorizationStrategy クラス (UT-SEC-100 〜 UT-SEC-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | getRootACL: denyFalseでANONYMOUS_READ | E-09: L59-61 | ○ |
| C-101 | getRootACL: denyTrueでAUTHENTICATED_READ | E-09: L59-61 | ○ |
| C-102 | isAllowAnonymousRead: denyの逆 | E-09: L71-73 | ○ |
| C-103 | setAllowAnonymousRead: deny設定 | E-09: L76-78 | ○ |
| C-104 | getGroups: 空List | E-09: L64-66 | ○ |

### HudsonPrivateSecurityRealm クラス (UT-SEC-105 〜 UT-SEC-149)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | コンストラクタ: パラメータ設定 | E-10: L143-156 | ○ |
| C-106 | コンストラクタ: フィルター追加 | E-10: L147-155 | ○ |
| C-107 | allowsSignup: disableの逆 | E-10: L159-161 | ○ |
| C-108 | isEnableCaptcha: 値返却 | E-10: L173-175 | ○ |
| C-109 | loadUserByUsername2: UserDetails取得 | E-10: L199-201 | ○ |
| C-110 | loadUserByUsername2: 存在しないユーザーで例外 | E-10: L206-208 | ○ |
| C-111 | loadUserByUsername2: Details未設定で例外 | E-10: L207-208 | ○ |
| C-112 | loadGroupByGroupname2: 常に例外 | E-10: L194-196 | ○ |
| C-113 | authenticate2: 正しい認証でUserDetails | E-10: L215-228 | ○ |
| C-114 | authenticate2: 不正パスワードで例外 | E-10: L224-226 | ○ |
| C-115 | authenticate2: 存在しないユーザーで例外 | E-10: L219-222 | ○ |
| C-116 | authenticate2: タイミング攻撃対策 | E-10: L221 | ○ |
| C-117 | createAccount: アカウント作成 | E-10: L534-539 | ○ |
| C-118 | createAccountWithHashedPassword: ハッシュで作成 | E-10: L548-564 | ○ |
| C-119 | createAccountWithHashedPassword: 不正ハッシュで例外 | E-10: L549-558 | ○ |
| C-120 | createAccountWithHashedPassword: nullで例外 | E-10: L551-552 | ○ |
| C-121 | getAllUsers: ソート済みユーザー一覧 | E-10: L594-602 | ○ |
| C-122 | getACL: JenkinsのACL | E-10: L576-578 | ○ |
| C-123 | doCreateAccount: サインアップ許可時に作成 | E-10: L265-282 | ○ |
| C-124 | doCreateAccount: サインアップ禁止時にエラー | E-10: L271-272 | ○ |
| C-125 | doCreateAccountByAdmin: 管理者が作成 | E-10: L312-315 | ○ |
| C-126 | doCreateAccountByAdmin: 権限なしで拒否 | E-10: L322 | ○ |
| C-127 | doCreateFirstAccount: 初回ユーザー作成 | E-10: L365-379 | ○ |
| C-128 | doCreateFirstAccount: 既存ユーザーでエラー | E-10: L369-372 | ○ |
| C-129 | Details.fromPlainPassword: ハッシュ化して作成 | E-10: L681-683 | ○ |
| C-130 | Details.fromHashedPassword: ハッシュで作成 | E-10: L677-679 | ○ |
| C-131 | Details.isPasswordCorrect: 正しいパスワードでtrue | E-10: L705-707 | ○ |
| C-132 | Details.isPasswordCorrect: 不正パスワードでfalse | E-10: L705-707 | ○ |
| C-133 | Details.getUsername: user.getId | E-10: L714-716 | ○ |
| C-134 | Details.getAuthorities2: AUTHENTICATED_AUTHORITY2含む | E-10: L688-691 | ○ |
| C-135 | Details.isAccountNonExpired: true | E-10: L722-724 | ○ |
| C-136 | Details.isAccountNonLocked: true | E-10: L726-728 | ○ |
| C-137 | Details.isCredentialsNonExpired: true | E-10: L730-732 | ○ |
| C-138 | Details.isEnabled: true | E-10: L734-736 | ○ |
| C-139 | JBCryptEncoder.encode: bcryptハッシュ化 | E-10: L940-951 | ○ |
| C-140 | JBCryptEncoder.encode: 72バイト超で例外 | E-10: L944-949 | ○ |
| C-141 | JBCryptEncoder.isHashValid: 有効ハッシュでtrue | E-10: L960-971 | ○ |
| C-142 | JBCryptEncoder.isHashValid: 無効ハッシュでfalse | E-10: L962-970 | ○ |
| C-143 | JBCryptEncoder.isHashValid: ラウンド数超過でfalse | E-10: L965-967 | ○ |
| C-144 | MultiPasswordEncoder.encode: ヘッダー付きエンコード | E-10: L1094-1096 | ○ |
| C-145 | MultiPasswordEncoder.matches: 正しいパスワードでtrue | E-10: L1099-1105 | ○ |
| C-146 | MultiPasswordEncoder.matches: 不正パスワードでfalse | E-10: L1099-1105 | ○ |
| C-147 | MultiPasswordEncoder.isPasswordHashed: ヘッダー付きでtrue | E-10: L1110-1125 | ○ |
| C-148 | MultiPasswordEncoder.isPasswordHashed: nullでfalse | E-10: L1111-1113 | ○ |
| C-149 | MultiPasswordEncoder.isPasswordHashed: ヘッダーなしでfalse | E-10: L1114-1124 | ○ |

### ACLContext クラス (UT-SEC-150 〜 UT-SEC-152)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | コンストラクタ: previousContext保持 | E-11: L49-51 | ○ |
| C-151 | getPreviousContext2: 保持コンテキスト返却 | E-11: L58-61 | ○ |
| C-152 | close: コンテキスト復元 | E-11: L72-74 | ○ |

### AccessControlled インターフェース (UT-SEC-153 〜 UT-SEC-159)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-153 | checkPermission: 権限ありで例外なし | E-12: L48-53 | ○ |
| C-154 | checkPermission: SYSTEM2でスキップ | E-12: L49-51 | ○ |
| C-155 | checkAnyPermission: 複数権限の1つで例外なし | E-12: L61-63 | ○ |
| C-156 | hasPermission: 権限ありでtrue | E-12: L68-73 | ○ |
| C-157 | hasPermission: SYSTEM2で常にtrue | E-12: L69-71 | ○ |
| C-158 | hasAnyPermission: 複数権限の1つでtrue | E-12: L81-83 | ○ |
| C-159 | hasPermission2: 認証ベース確認 | E-12: L89-94 | ○ |

### AccessDeniedException3 クラス (UT-SEC-160 〜 UT-SEC-164)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-160 | コンストラクタ: メッセージ生成 | E-13: L33-42 | ○ |
| C-161 | reportAsHeaders: 認証情報をヘッダー出力 | E-13: L59-72 | ○ |
| C-162 | reportAsHeaders: X-Required-Permission出力 | E-13: L68 | ○ |
| C-163 | reportAsHeaders: X-Permission-Implied-By出力 | E-13: L69-71 | ○ |
| C-164 | report: PrintWriterに出力 | E-13: L80-91 | ○ |

### GroupDetails クラス (UT-SEC-165 〜 UT-SEC-167)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165 | getName: グループ名返却 | E-14: L43 | ○ |
| C-166 | getDisplayName: getName返却 | E-14: L53-55 | ○ |
| C-167 | getMembers: デフォルトでnull | E-14: L70-72 | ○ |

### GlobalSecurityConfiguration クラス (UT-SEC-168 〜 UT-SEC-175)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-168 | getSecurityRealm: Jenkins.getSecurityRealm | E-15: L67-69 | ○ |
| C-169 | getAuthorizationStrategy: Jenkins.getAuthorizationStrategy | E-15: L71-73 | ○ |
| C-170 | doConfigure: 設定保存 | E-15: L103-118 | ○ |
| C-171 | doConfigure: 権限なしで拒否 | E-15: L123 | ○ |
| C-172 | configure: SecurityRealm/AuthorizationStrategy設定 | E-15: L127-128 | ○ |
| C-173 | configure: disableRememberMe設定 | E-15: L125 | ○ |
| C-174 | configure: markupFormatter設定 | E-15: L130-134 | ○ |
| C-175 | getRequiredPermission: SYSTEM_READ | E-15: L183-185 | ○ |

### CrumbIssuer クラス (UT-SEC-176 〜 UT-SEC-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-176 | getCrumbRequestField: フィールド名取得 | E-16: L62-64 | ○ |
| C-177 | getCrumb: crumb値取得 | E-16: L71-73 | ○ |
| C-178 | getCrumb(ServletRequest): キャッシュ返却 | E-16: L78-95 | ○ |
| C-179 | getCrumb(ServletRequest): 新規生成 | E-16: L83-91 | ○ |
| C-180 | validateCrumb(ServletRequest): 有効crumbでtrue | E-16: L144-149 | ○ |
| C-181 | validateCrumb(ServletRequest): 無効crumbでfalse | E-16: L144-149 | ○ |
| C-182 | validateCrumb(ServletRequest, MultipartFormDataParser): マルチパート検証 | E-16: L157-163 | ○ |
| C-183 | initStaplerCrumbIssuer: Stapler設定 | E-16: L246-265 | ○ |

### DefaultCrumbIssuer クラス (UT-SEC-184 〜 UT-SEC-193)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-184 | コンストラクタ: MessageDigest初期化 | E-17: L53-57, L92-99 | ○ |
| C-185 | issueCrumb: crumb生成 | E-17: L103-120 | ○ |
| C-186 | issueCrumb: EXCLUDE_SESSION_IDでセッションID除外 | E-17: L110-113 | ○ |
| C-187 | issueCrumb: 非HTTPでnull | E-17: L104 | ○ |
| C-188 | issueCrumb: MD nullでnull | E-17: L105, L118 | ○ |
| C-189 | validateCrumb: 有効crumbでtrue | E-17: L123-133 | ○ |
| C-190 | validateCrumb: 不正crumbでfalse | E-17: L123-133 | ○ |
| C-191 | validateCrumb: crumb nullでfalse | E-17: L126 | ○ |
| C-192 | validateCrumb: 非HTTPでfalse | E-17: L124 | ○ |
| C-193 | validateCrumb: 定数時間比較 | E-17: L128-129 | ○ |

### CrumbFilter クラス (UT-SEC-194 〜 UT-SEC-202)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-194 | getCrumbIssuer: Jenkins.getCrumbIssuer | E-18: L47-51 | ○ |
| C-195 | getCrumbIssuer: Jenkins未初期化でnull | E-18: L49 | ○ |
| C-196 | doFilter: POSTでcrumb検証 | E-18: L125-158 | ○ |
| C-197 | doFilter: GET/HEADでスキップ | E-18: L159-161 | ○ |
| C-198 | doFilter: CrumbIssuer nullでスキップ | E-18: L117-120 | ○ |
| C-199 | doFilter: CrumbExclusionでスキップ | E-18: L127-130 | ○ |
| C-200 | doFilter: 無効crumbで403 | E-18: L156-158 | ○ |
| C-201 | doFilter: ヘッダーからcrumb抽出 | E-18: L164-177 | ○ |
| C-202 | doFilter: パラメータからcrumb抽出 | E-18: L167-175 | ○ |

### TokenBasedRememberMeServices2 クラス (UT-SEC-203 〜 UT-SEC-220)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-203 | コンストラクタ: ラップして作成 | E-19: L94-96 | ○ |
| C-204 | makeTokenSignature: MAC署名生成 | E-19: L98-113 | ○ |
| C-205 | makeTokenSignature: DISABLE_USER_SEEDでno-seed | E-19: L100-101 | ○ |
| C-206 | makeTokenSignature: UserSeedProperty nullでno-prop | E-19: L105-108 | ○ |
| C-207 | onLoginSuccess: remember_meでクッキー設定 | E-19: L116-152 | ○ |
| C-208 | onLoginSuccess: remember_meなしでスキップ | E-19: L119-127 | ○ |
| C-209 | onLoginSuccess: disableRememberMeでスキップ | E-19: L128-136 | ○ |
| C-210 | processAutoLoginCookie: 有効クッキーでUserDetails | E-19: L174-210 | ○ |
| C-211 | processAutoLoginCookie: Jenkins未初期化で例外 | E-19: L175-179 | ○ |
| C-212 | processAutoLoginCookie: disableRememberMeで例外 | E-19: L180-183 | ○ |
| C-213 | processAutoLoginCookie: トークン数不正で例外 | E-19: L184-187 | ○ |
| C-214 | processAutoLoginCookie: 期限切れで例外 | E-19: L189-191 | ○ |
| C-215 | processAutoLoginCookie: 署名不一致で例外 | E-19: L205-208 | ○ |
| C-216 | isTokenExpired: 期限切れでtrue | E-19: L252-253 | ○ |
| C-217 | isTokenExpired: 有効でfalse | E-19: L255 | ○ |
| C-218 | isTokenExpired: 最大値超過でtrue | E-19: L244-249 | ○ |
| C-219 | isTokenExpired: SKIP_TOO_FARでスキップ | E-19: L244 | ○ |
| C-220 | createSuccessfulAuthentication: userSeedをセッション設定 | E-19: L223-235 | ○ |

### BasicAuthenticationFilter クラス (UT-SEC-221 〜 UT-SEC-228)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-221 | init: ServletContext取得 | E-20: L101-103 | ○ |
| C-222 | doFilter: Authorizationなしで通常処理 | E-20: L112-128 | ○ |
| C-223 | doFilter: userPrincipalありでContainerAuthentication | E-20: L115-121 | ○ |
| C-224 | doFilter: セキュリティ無効でスキップ | E-20: L113 | ○ |
| C-225 | doFilter: APIトークンで認証設定 | E-20: L152-167 | ○ |
| C-226 | doFilter: Basic認証でj_security_checkディスパッチ | E-20: L180-183 | ○ |
| C-227 | doFilter: 不正Base64で401 | E-20: L146-149 | ○ |
| C-228 | doFilter: /secured/でスキップ | E-20: L112 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全てのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストケースは全てソースコードに基づいている
- 1: 中リスク - セキュリティモジュールのため、実装の詳細な挙動を確認するために実際のテスト実行が推奨される
- 注意: パスワードハッシュ関連（JBCryptEncoder, PBKDF2PasswordEncoder, MultiPasswordEncoder）のテストは特に重要

## 6) レビュアーチェックリスト（最小）
- [ ] ACLの権限チェックロジック（checkPermission, hasPermission）のテストケースが網羅的か確認
- [ ] SYSTEMユーザーの特権処理が正しくテストされているか確認
- [ ] パスワードハッシュエンコーダーのテストケースが十分か確認
- [ ] CSRF保護（CrumbIssuer, CrumbFilter）のテストケースが十分か確認
- [ ] Remember-Me機能のセキュリティテストが含まれているか確認
- [ ] タイミング攻撃対策（authenticate2, validateCrumb）のテストが含まれているか確認
- [ ] 境界値テスト（null入力、空配列等）が十分か確認
