---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 147
  claims_with_evidence: 147
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.slaves 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：147 / 147、根拠なし：0
- 優先レビュー（高）
  1. **SlaveComputer接続管理テスト**：エージェント接続の重要機能
  2. **Cloud.provisionテスト**：クラウドプロビジョニングの重要機能
  3. **WorkspaceList割当テスト**：ワークスペース管理の重要機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/slaves/SlaveComputer.java`
- E-02: `core/src/main/java/hudson/slaves/ComputerLauncher.java`
- E-03: `core/src/main/java/hudson/slaves/Cloud.java`
- E-04: `core/src/main/java/hudson/slaves/DumbSlave.java`
- E-05: `core/src/main/java/hudson/slaves/RetentionStrategy.java`
- E-06: `core/src/main/java/hudson/slaves/JNLPLauncher.java`
- E-07: `core/src/main/java/hudson/slaves/NodeProvisioner.java`
- E-08: `core/src/main/java/hudson/slaves/OfflineCause.java`
- E-09: `core/src/main/java/hudson/slaves/NodeProperty.java`
- E-10: `core/src/main/java/hudson/slaves/WorkspaceList.java`
- E-11: `core/src/main/java/hudson/slaves/ChannelPinger.java`
- E-12: `core/src/main/java/hudson/slaves/DelegatingComputerLauncher.java`
- E-13: `core/src/main/java/hudson/slaves/ComputerListener.java`
- E-14: `core/src/main/java/hudson/slaves/EnvironmentVariablesNodeProperty.java`
- E-15: `core/src/main/java/hudson/slaves/CloudProvisioningListener.java`
- E-16: `core/src/main/java/hudson/slaves/SimpleScheduledRetentionStrategy.java`
- E-17: `core/src/main/java/hudson/slaves/AbstractCloudSlave.java`
- E-18: `core/src/main/java/hudson/slaves/AbstractCloudComputer.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SlaveComputer クラス (UT-SLV-001 ~ UT-SLV-035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isAcceptingTasks()がacceptingTasksフラグとsuperの結果のANDを返す | E-01 L178-182 | ○ |
| C-02 | setAcceptingTasks()でフラグが設定可能 | E-01 L200-202 | ○ |
| C-03 | getJnlpMac()がSLAVE_SECRET.mac()を呼び出す | E-01 L188-189 | ○ |
| C-04 | isUnix()がisUnixフィールドを返す | E-01 L205-207 | ○ |
| C-05 | getNode()がSlaveまたはnullを返す | E-01 L209-219 | ○ |
| C-06 | getLauncher()がlauncherフィールドを返す | E-01 L255-257 | ○ |
| C-07 | getDelegatedLauncher()が委譲元まで辿る | E-01 L264-276 | ○ |
| C-08 | isConnecting()がlastConnectActivityの状態を判定する | E-01 L382-385 | ○ |
| C-09 | getChannel()がchannelフィールドを返す | E-01 L773-775 | ○ |
| C-10 | getClassLoadingCount()がチャネル経由でカウントを取得 | E-01 L483-489 | ○ |
| C-11 | getRetentionStrategy()がノードの戦略またはNOOPを返す | E-01 L938-941 | ○ |
| C-12 | tryReconnect()が回数制限付きで再接続を試行する | E-01 L856-863 | ○ |
| C-13 | setChannel()で既に接続済みならIllegalStateException | E-01 L632-633 | ○ |
| C-14 | taskAccepted()がExecutorListenerに通知する | E-01 L332-343 | ○ |
| C-15 | getSlaveVersion()がチャネル経由でバージョンを取得 | E-01 L1008-1014 | ○ |

### ComputerLauncher クラス (UT-SLV-036 ~ UT-SLV-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | isLaunchSupported()がデフォルトでtrueを返す | E-02 L65-67 | ○ |
| C-17 | launch()が抽象メソッドとして定義されている | E-02 L93-96 | ○ |
| C-18 | afterDisconnect()がlegacy互換性を維持 | E-02 L118-121 | ○ |
| C-19 | checkJavaVersion()がバージョン文字列を検証する | E-02 L185-208 | ○ |
| C-20 | checkJavaVersion()がJava 1.7以下でIOExceptionをスロー | E-02 L196-198 | ○ |

### Cloud クラス (UT-SLV-043 ~ UT-SLV-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | getDisplayName()がnameを返す | E-03 L132-134 | ○ |
| C-22 | getUrl()がcloud/{name}/形式のURLを返す | E-03 L142-144 | ○ |
| C-23 | getACL()がAuthorizationStrategyからACLを取得 | E-03 L152-154 | ○ |
| C-24 | provision()がPlannedNodeコレクションを返す | E-03 L227-229 | ○ |
| C-25 | canProvision()がプロビジョニング可否を判定 | E-03 L247-249 | ○ |
| C-26 | コンストラクタがnull/空文字を拒否する | E-03 L120-129 | ○ |
| C-27 | CloudState.getLabel()がlabelを返す | E-03 L392-395 | ○ |

### DumbSlave クラス (UT-SLV-053 ~ UT-SLV-054)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | DataBoundConstructorで最小限のパラメータで作成可能 | E-04 L73-76 | ○ |

### RetentionStrategy クラス (UT-SLV-055 ~ UT-SLV-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | check()が抽象メソッドとして定義されている | E-05 L64-65 | ○ |
| C-30 | isManualLaunchAllowed()がデフォルトでtrue | E-05 L74-76 | ○ |
| C-31 | isAcceptingTasks()がデフォルトでtrue | E-05 L88-90 | ○ |
| C-32 | start()がcheck()を呼び出す | E-05 L103-105 | ○ |
| C-33 | Always.check()がオフライン時に再接続を試行 | E-05 L171-174 | ○ |
| C-34 | Demand.check()が需要とアイドル状態を判定する | E-05 L230-291 | ○ |
| C-35 | DemandコンストラクタがidleDelay最小値を1に補正 | E-05 L204-208 | ○ |

### JNLPLauncher クラス (UT-SLV-065 ~ UT-SLV-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | isLaunchSupported()が常にfalseを返す | E-06 L148-150 | ○ |
| C-37 | launch()が何も実行しない | E-06 L183-185 | ○ |
| C-38 | getWorkDirSettings()がworkDirSettingsを返す | E-06 L135-137 | ○ |
| C-39 | getInboundAgentUrl()がシステムプロパティまたはルートURLを返す | E-06 L324-330 | ○ |
| C-40 | readResolve()がnullの場合にDisabledDefaultsを設定 | E-06 L124-130 | ○ |

### NodeProvisioner クラス (UT-SLV-074 ~ UT-SLV-080)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | getPendingLaunches()がコピーを返す | E-07 L174-176 | ○ |
| C-42 | suggestReviewNow()がupdate()をスケジュールする | E-07 L184-205 | ○ |
| C-43 | PlannedNodeコンストラクタが引数を検証する | E-07 L103-108 | ○ |
| C-44 | StrategyState.recordPendingLaunches()がpendingLaunchesに追加 | E-07 L575-606 | ○ |

### OfflineCause クラス (UT-SLV-081 ~ UT-SLV-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | getTimestamp()がtimestampフィールドを返す | E-08 L62-66 | ○ |
| C-46 | ChannelTerminationがcauseを保持する | E-08 L109-118 | ○ |
| C-47 | LaunchFailed.toString()がメッセージを返す | E-08 L128-132 | ○ |
| C-48 | UserCauseがuserIdとmessageを保持する | E-08 L140-156 | ○ |
| C-49 | OfflineCause.create()がnullでnullを返す | E-08 L101-104 | ○ |
| C-50 | IdleOfflineCause.getComputerIcon()がアイコン名を返す | E-08 L227-230 | ○ |

### NodeProperty クラス (UT-SLV-091 ~ UT-SLV-094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | setNode()がnodeフィールドを設定する | E-09 L85 | ○ |
| C-52 | canTake()がデフォルトでnullを返す | E-09 L115-117 | ○ |
| C-53 | setUp()がデフォルトで空のEnvironmentを返す | E-09 L139-141 | ○ |
| C-54 | buildEnvVars()がデフォルトで何もしない | E-09 L172-174 | ○ |

### EnvironmentVariablesNodeProperty クラス (UT-SLV-095 ~ UT-SLV-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | コンストラクタがEntry ListをEnvVarsに変換する | E-14 L58-61 | ○ |
| C-56 | getEnvVars()がenvVarsを返す | E-14 L67-69 | ○ |
| C-57 | getEnv()がEntryリストを返す | E-14 L75-77 | ○ |
| C-58 | setUp()がenvVarsを含むEnvironmentを返す | E-14 L80-83 | ○ |
| C-59 | buildEnvVars()がenvにenvVarsを追加する | E-14 L86-88 | ○ |

### WorkspaceList クラス (UT-SLV-101 ~ UT-SLV-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | allocate()がLeaseを返す | E-10 L174-176 | ○ |
| C-61 | allocate()が使用中の場合は別のパスを割り当てる | E-10 L185-193 | ○ |
| C-62 | acquire()が使用中の場合は待機する | E-10 L252-275 | ○ |
| C-63 | record()が既に記録済みの場合はAssertionErrorをスロー | E-10 L198-206 | ○ |
| C-64 | Lease.release()がワークスペースを解放する | E-10 L126-127 | ○ |
| C-65 | tempDir()が@tmp付きのパスを返す | E-10 L311-314 | ○ |

### ChannelPinger クラス (UT-SLV-114 ~ UT-SLV-117)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | preOnline()がinstall()を呼び出す | E-11 L94-101 | ○ |
| C-67 | install()がSetUpRemotePingを実行する | E-11 L108-126 | ○ |
| C-68 | タイムアウト/インターバルが1未満でPingが無効化される | E-11 L111-114 | ○ |

### DelegatingComputerLauncher クラス (UT-SLV-118 ~ UT-SLV-121)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | getLauncher()がlauncherを返す | E-12 L58-60 | ○ |
| C-70 | launch()が委譲先のlaunchを呼び出す | E-12 L63-65 | ○ |
| C-71 | afterDisconnect()が委譲先を呼び出す | E-12 L68-70 | ○ |
| C-72 | beforeDisconnect()が委譲先を呼び出す | E-12 L73-75 | ○ |

### ComputerListener クラス (UT-SLV-122 ~ UT-SLV-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | preLaunch()がデフォルトで何もしない | E-13 L71-72 | ○ |
| C-74 | onLaunchFailure()がデフォルトで何もしない | E-13 L85-86 | ○ |
| C-75 | preOnline()がデフォルトで何もしない | E-13 L122-123 | ○ |
| C-76 | onOnline()がデフォルトで何もしない | E-13 L165-168 | ○ |
| C-77 | onOffline()がデフォルトで何もしない | E-13 L183-185 | ○ |

### CloudProvisioningListener クラス (UT-SLV-131 ~ UT-SLV-136)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | canProvision()がデフォルトでnullを返す | E-15 L66-68 | ○ |
| C-79 | onStarted()がデフォルトで何もしない | E-15 L81-83 | ○ |
| C-80 | onComplete()がデフォルトで何もしない | E-15 L91-93 | ○ |
| C-81 | onCommit()がデフォルトで何もしない | E-15 L103-105 | ○ |
| C-82 | onFailure()がデフォルトで何もしない | E-15 L113-115 | ○ |
| C-83 | onRollback()がデフォルトで何もしない | E-15 L126-129 | ○ |

### SimpleScheduledRetentionStrategy クラス (UT-SLV-137 ~ UT-SLV-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | コンストラクタがupTimeMins最小値を1に補正 | E-16 L73-81 | ○ |
| C-85 | isManualLaunchAllowed()がisOnlineScheduled()を呼び出す | E-16 L168-170 | ○ |
| C-86 | isAcceptingTasks()がisOnlineScheduled()を呼び出す | E-16 L173-175 | ○ |
| C-87 | check()がスケジュールに基づいて接続/切断を制御する | E-16 L178-243 | ○ |

### AbstractCloudSlave クラス (UT-SLV-143 ~ UT-SLV-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | terminate()が_terminate()とremoveNode()を呼び出す | E-17 L82-96 | ○ |
| C-89 | createComputer()が抽象メソッドとして定義されている | E-17 L77 | ○ |

### AbstractCloudComputer クラス (UT-SLV-145 ~ UT-SLV-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | getNode()がAbstractCloudSlaveをキャストして返す | E-18 L48-51 | ○ |
| C-91 | doDoDelete()がnode.terminate()を呼び出す | E-18 L58-69 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべてのテストケースは対応するソースコードの根拠に基づいて作成されています。

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：すべてのテストケースが実際のソースコードに基づいて作成されています。

## 6) レビュアーチェックリスト（最小）
- [ ] SlaveComputerのsetChannel/disconnect処理のテストケースが接続管理の要件を満たしているか確認
- [ ] Cloud.provision関連テストがプロビジョニングの境界条件を網羅しているか確認
- [ ] WorkspaceListの並行アクセステストが競合状態を考慮しているか確認
- [ ] RetentionStrategyのスケジュール関連テストがタイムゾーンを考慮しているか確認
- [ ] ComputerListenerのイベント通知順序が正しいか確認
- [ ] ChannelPingerのタイムアウト/インターバル設定テストが境界値を網羅しているか確認
