---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 140
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.tasks 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上の対応するメソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要クラス・メソッドが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各クラスのカバレッジを確認
3. 「不足情報」で追加が必要なテストケースを確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：140 / 140、根拠なし：0
- 優先レビュー（高）
  1. **ArtifactArchiver.perform**：アーカイブ機能の主要ロジック
  2. **BuildTrigger.perform**：下流ジョブトリガーの主要ロジック
  3. **LogRotator.perform**：ビルド削除の主要ロジック
  4. **CommandInterpreter.perform**：コマンド実行の主要ロジック
  5. **Maven.perform**：Mavenビルド実行の主要ロジック

## 2) 参照した情報（Evidence一覧）
> ソースコードファイル（全27ファイル）

- E-01: `core/src/main/java/hudson/tasks/ArtifactArchiver.java`
- E-02: `core/src/main/java/hudson/tasks/BatchFile.java`
- E-03: `core/src/main/java/hudson/tasks/BuildStep.java`
- E-04: `core/src/main/java/hudson/tasks/BuildStepCompatibilityLayer.java`
- E-05: `core/src/main/java/hudson/tasks/BuildStepDescriptor.java`
- E-06: `core/src/main/java/hudson/tasks/BuildStepMonitor.java`
- E-07: `core/src/main/java/hudson/tasks/BuildTrigger.java`
- E-08: `core/src/main/java/hudson/tasks/BuildWrapper.java`
- E-09: `core/src/main/java/hudson/tasks/BuildWrapperDescriptor.java`
- E-10: `core/src/main/java/hudson/tasks/BuildWrappers.java`
- E-11: `core/src/main/java/hudson/tasks/Builder.java`
- E-12: `core/src/main/java/hudson/tasks/CommandInterpreter.java`
- E-13: `core/src/main/java/hudson/tasks/Fingerprinter.java`
- E-14: `core/src/main/java/hudson/tasks/LogRotator.java`
- E-15: `core/src/main/java/hudson/tasks/Maven.java`
- E-16: `core/src/main/java/hudson/tasks/Notifier.java`
- E-17: `core/src/main/java/hudson/tasks/Publisher.java`
- E-18: `core/src/main/java/hudson/tasks/Recorder.java`
- E-19: `core/src/main/java/hudson/tasks/Shell.java`
- E-20: `core/src/main/java/hudson/tasks/UserAvatarResolver.java`
- E-21: `core/src/main/java/hudson/tasks/UserNameResolver.java`
- E-22: `core/src/main/java/hudson/tasks/_maven/MavenConsoleAnnotator.java`
- E-23: `core/src/main/java/hudson/tasks/_maven/MavenErrorNote.java`
- E-24: `core/src/main/java/hudson/tasks/_maven/MavenMojoNote.java`
- E-25: `core/src/main/java/hudson/tasks/_maven/MavenWarningNote.java`
- E-26: `core/src/main/java/hudson/tasks/_maven/Maven3MojoNote.java`
- E-27: `core/src/main/java/hudson/tasks/package-info.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ArtifactArchiver（UT-TSK-001 〜 UT-TSK-014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンストラクタでartifactsがトリムされる | E-01 (L121-124) | ○ |
| C-02 | getArtifactsでアーティファクトパターン取得 | E-01 (L170-172) | ○ |
| C-03 | setExcludesで除外パターン設定 | E-01 (L178-180) | ○ |
| C-04 | setExcludesでnull/空文字処理 | E-01 (L179: Util.fixEmptyAndTrim) | ○ |
| C-05 | isOnlyIfSuccessfulでフラグ取得 | E-01 (L187-189) | ○ |
| C-06 | performでアーティファクトアーカイブ | E-01 (L237-293) | ○ |
| C-07 | performで空artifacts時にAbortException | E-01 (L238-240) | ○ |
| C-08 | performでonlyIfSuccessful時のスキップ | E-01 (L242-246) | ○ |
| C-09 | performでマッチなし時のAbortException | E-01 (L280) | ○ |
| C-10 | performでallowEmptyArchive時の継続 | E-01 (L277-279) | ○ |
| C-11 | readResolveでデフォルト値設定 | E-01 (L152-168) | ○ |
| C-12 | getRequiredMonitorServiceでNONE返却 | E-01 (L326-329) | ○ |
| C-13 | DescriptorImpl.isApplicableでtrue返却 | E-01 (L374-377) | ○ |
| C-14 | DescriptorImpl.doCheckArtifactsでバリデーション | E-01 (L357-367) | ○ |

### BatchFile（UT-TSK-015 〜 UT-TSK-026）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | コンストラクタでWindows改行変換 | E-02 (L54-57) | ○ |
| C-16 | buildCommandLineでcmd形式構築 | E-02 (L72-75) | ○ |
| C-17 | getContentsでexit %ERRORLEVEL%追加 | E-02 (L77-80) | ○ |
| C-18 | getFileExtensionで.bat返却 | E-02 (L82-85) | ○ |
| C-19 | getUnstableReturnで値取得 | E-02 (L87-90) | ○ |
| C-20 | getUnstableReturnで0時null返却 | E-02 (L89) | ○ |
| C-21 | isErrorlevelForUnstableBuildで判定 | E-02 (L97-100) | ○ |
| C-22 | isErrorlevelForUnstableBuildで0時false | E-02 (L99: exitCode != 0) | ○ |
| C-23 | isErrorlevelForUnstableBuildで未設定時false | E-02 (L99: this.unstableReturn != null) | ○ |
| C-24 | doCheckUnstableReturnでOK返却 | E-02 (L127-145) | ○ |
| C-25 | doCheckUnstableReturnで0時warning | E-02 (L138-140) | ○ |
| C-26 | doCheckUnstableReturnで範囲外error | E-02 (L141-143) | ○ |

### Shell（UT-TSK-027 〜 UT-TSK-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | コンストラクタでUnix改行変換 | E-19 (L65-68) | ○ |
| C-28 | buildCommandLineでシェバン処理 | E-19 (L99-110) | ○ |
| C-29 | buildCommandLineでデフォルトシェル使用 | E-19 (L109) | ○ |
| C-30 | getContentsで非ASCII先頭行に改行追加 | E-19 (L88-96, L113-115) | ○ |
| C-31 | getContentsでシェバン時改行追加なし | E-19 (L89: startsWith("#!")) | ○ |
| C-32 | getFileExtensionで.sh返却 | E-19 (L117-120) | ○ |
| C-33 | getShellOrDefaultでデフォルト返却 | E-19 (L177-182, L184-199) | ○ |
| C-34 | getShellOrDefaultでカスタム値返却 | E-19 (L185-186) | ○ |
| C-35 | doCheckUnstableReturnで範囲チェック | E-19 (L230-231) | ○ |
| C-36 | doCheckShellでシェル検証 | E-19 (L245-248) | ○ |

### CommandInterpreter（UT-TSK-037 〜 UT-TSK-044）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | getCommandでコマンド取得 | E-12 (L75-77) | ○ |
| C-38 | performでコマンド実行 | E-12 (L91-182) | ○ |
| C-39 | performでws=null時例外 | E-12 (L109-115) | ○ |
| C-40 | performで終了コード非0時false | E-12 (L159) | ○ |
| C-41 | performでUNSTABLE設定 | E-12 (L151-154) | ○ |
| C-42 | createScriptFileで一時ファイル作成 | E-12 (L201-203) | ○ |
| C-43 | buildEnvVarsFilterRulesでルール返却 | E-12 (L79-82) | ○ |
| C-44 | buildEnvVarsFilterRulesでnull時空リスト | E-12 (L81) | ○ |

### BuildTrigger（UT-TSK-045 〜 UT-TSK-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | コンストラクタで値設定 | E-07 (L115-125) | ○ |
| C-46 | コンストラクタでnull時例外 | E-07 (L121-122) | ○ |
| C-47 | getThresholdで閾値取得 | E-07 (L139-144) | ○ |
| C-48 | getThresholdでnull時SUCCESS | E-07 (L140-141) | ○ |
| C-49 | getChildJobsで子ジョブ取得 | E-07 (L166-170) | ○ |
| C-50 | performで下流トリガー | E-07 (L196-240) | ○ |
| C-51 | performで閾値未満時スキップ | E-07 (L204) | ○ |
| C-52 | performで権限チェック | E-07 (L211-213) | ○ |
| C-53 | buildDependencyGraphで依存追加 | E-07 (L313-333) | ○ |
| C-54 | needsToRunAfterFinalizedでtrue | E-07 (L335-338) | ○ |
| C-55 | readResolveで空文字設定 | E-07 (L368-372) | ○ |
| C-56 | doCheckで有効値OK | E-07 (L411-443) | ○ |
| C-57 | doCheckで無効値error | E-07 (L423-426) | ○ |

### LogRotator（UT-TSK-058 〜 UT-TSK-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | コンストラクタで文字列パース | E-14 (L117-121) | ○ |
| C-59 | parseで数値パース | E-14 (L123-130) | ○ |
| C-60 | parseでnull時-1 | E-14 (L124) | ○ |
| C-61 | parseで不正値時-1 | E-14 (L127-129) | ○ |
| C-62 | performでnumToKeep削除 | E-14 (L166-173) | ○ |
| C-63 | performでdaysToKeep削除 | E-14 (L175-190) | ○ |
| C-64 | performでkeepLog保持 | E-14 (L229-232) | ○ |
| C-65 | performでlsb保持 | E-14 (L233-236) | ○ |
| C-66 | performでremoveLastBuild時削除 | E-14 (L163-164) | ○ |
| C-67 | performでartifactNumToKeep削除 | E-14 (L192-199) | ○ |
| C-68 | performで実行中保持 | E-14 (L241-244) | ○ |
| C-69 | shouldKeepRunでkeepLog判定 | E-14 (L228-246) | ○ |
| C-70 | getDaysToKeepStrで文字列取得 | E-14 (L277-279) | ○ |
| C-71 | getDaysToKeepStrで-1時空文字 | E-14 (L297-299) | ○ |

### Fingerprinter（UT-TSK-072 〜 UT-TSK-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | コンストラクタでターゲット設定 | E-13 (L115-117) | ○ |
| C-73 | performでフィンガープリント記録 | E-13 (L179-209) | ○ |
| C-74 | performで既存アクションに追加 | E-13 (L193-198) | ○ |
| C-75 | readResolveでデフォルト設定 | E-13 (L160-168) | ○ |
| C-76 | buildDependencyGraphで依存構築 | E-13 (L217-254) | ○ |
| C-77 | FingerprintActionコンストラクタ | E-13 (L378-382) | ○ |
| C-78 | FingerprintAction.addでレコード追加 | E-13 (L388-395) | ○ |
| C-79 | FingerprintAction.getFingerprintsで取得 | E-13 (L449-472) | ○ |
| C-80 | FingerprintAction.getDependenciesで取得 | E-13 (L477-522) | ○ |

### Maven（UT-TSK-081 〜 UT-TSK-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | コンストラクタで全パラメータ設定 | E-15 (L176-187) | ○ |
| C-82 | getMavenでインストール取得 | E-15 (L232-238) | ○ |
| C-83 | getMavenで不存在時null | E-15 (L237) | ○ |
| C-84 | performでMavenビルド実行 | E-15 (L290-381) | ○ |
| C-85 | performでパイプ区切り複数実行 | E-15 (L302-379) | ○ |
| C-86 | performでプライベートリポジトリ | E-15 (L356-357) | ○ |
| C-87 | performで変数注入 | E-15 (L348-350) | ○ |
| C-88 | performで実行ファイルなし時エラー | E-15 (L322-325) | ○ |
| C-89 | buildEnvVarsで環境変数設定 | E-15 (L394-412) | ○ |
| C-90 | buildEnvVarsでMAVEN_OPTS設定 | E-15 (L409-411) | ○ |
| C-91 | readResolveでデフォルト設定 | E-15 (L241-246) | ○ |
| C-92 | MavenInstallation.getExecutableで取得 | E-15 (L621-643) | ○ |
| C-93 | MavenInstallation.getExistsで存在確認 | E-15 (L666-672) | ○ |
| C-94 | meetsMavenReqVersionでMAVEN_20判定 | E-15 (L558-577) | ○ |
| C-95 | meetsMavenReqVersionでMAVEN_30判定 | E-15 (L573-575) | ○ |
| C-96 | forEnvironmentで環境変数展開 | E-15 (L677-679) | ○ |
| C-97 | forNodeでノード変換 | E-15 (L681-684) | ○ |

### Builder / BuildStepCompatibilityLayer / BuildStepDescriptor / BuildStepMonitor（UT-TSK-098 〜 UT-TSK-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | Builder.getRequiredMonitorServiceでNONE | E-11 (L63-66) | ○ |
| C-99 | Builder.prebuildでtrue | E-11 (L54-57) | ○ |
| C-100 | BuildStepCompatibilityLayer.performで委譲 | E-04 (L70-91) | ○ |
| C-101 | BuildStepCompatibilityLayer.performでws=null例外 | E-04 (L76-78) | ○ |
| C-102 | BuildStepCompatibilityLayer.getProjectActionsでリスト | E-04 (L101-108) | ○ |
| C-103 | BuildStepCompatibilityLayer.getProjectActionsでnull時空 | E-04 (L106) | ○ |
| C-104 | BuildStepDescriptor.filterでフィルタ | E-05 (L72-92) | ○ |
| C-105 | BuildStepDescriptor.isApplicable抽象メソッド | E-05 (L66) | ○ |
| C-106 | BuildStepMonitor.NONE.performで直接呼出 | E-06 (L17-22) | ○ |
| C-107 | BuildStepMonitor.STEP.performでブロック後呼出 | E-06 (L23-38) | ○ |
| C-108 | BuildStepMonitor.BUILD.performでCOMPLETEDブロック | E-06 (L39-49) | ○ |

### BuildWrapper / BuildWrapperDescriptor / BuildWrappers（UT-TSK-109 〜 UT-TSK-117）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | BuildWrapper.setUpでEnvironment返却 | E-08 (L152-159) | ○ |
| C-110 | BuildWrapper.setUpで未実装時例外 | E-08 (L156-158) | ○ |
| C-111 | BuildWrapper.decorateLauncherでそのまま返却 | E-08 (L209-211) | ○ |
| C-112 | BuildWrapper.decorateLoggerでそのまま返却 | E-08 (L236-238) | ○ |
| C-113 | BuildWrapper.preCheckoutでnoop | E-08 (L263-264) | ○ |
| C-114 | BuildWrapper.getProjectActionsでリスト | E-08 (L291-296) | ○ |
| C-115 | BuildWrapper.Environment.tearDownでtrue | E-08 (L113-127) | ○ |
| C-116 | BuildWrapperDescriptor.isApplicable抽象メソッド | E-09 (L60) | ○ |
| C-117 | BuildWrappers.getForでフィルタ | E-10 (L57-74) | ○ |

### Publisher / Recorder / Notifier（UT-TSK-118 〜 UT-TSK-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-118 | Publisher.needsToRunAfterFinalizedでfalse | E-17 (L119-121) | ○ |
| C-119 | Publisher.DescriptorExtensionListImpl.sortでソート | E-17 (L140-145) | ○ |
| C-120 | Recorder.getDescriptorでBuildStepDescriptor | E-18 (L52-55) | ○ |
| C-121 | Notifier.getDescriptorでBuildStepDescriptor | E-16 (L52-55) | ○ |

### UserNameResolver / UserAvatarResolver（UT-TSK-122 〜 UT-TSK-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | UserNameResolver.resolveで名前解決 | E-21 (L72-79) | ○ |
| C-123 | UserNameResolver.resolveでリゾルバなし時null | E-21 (L78) | ○ |
| C-124 | UserAvatarResolver.resolveでアバター解決 | E-20 (L86-89) | ○ |
| C-125 | UserAvatarResolver.resolveでフォールバック | E-20 (L88) | ○ |
| C-126 | UserAvatarResolver.resolveOrNullでURL返却 | E-20 (L95-109) | ○ |
| C-127 | UserAvatarResolver.resolveOrNullでnull返却 | E-20 (L108) | ○ |
| C-128 | UserAvatarResolver.resolveOrNullで不正サイズnull | E-20 (L104-106) | ○ |

### Maven Console Annotators（UT-TSK-129 〜 UT-TSK-140）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-129 | MavenConsoleAnnotator.eolでMojoNote追加 | E-22 (L58-60) | ○ |
| C-130 | MavenConsoleAnnotator.eolでMaven3MojoNote追加 | E-22 (L62-64) | ○ |
| C-131 | MavenConsoleAnnotator.eolでWarningNote追加 | E-22 (L66-68) | ○ |
| C-132 | MavenConsoleAnnotator.eolでErrorNote追加 | E-22 (L70-72) | ○ |
| C-133 | MavenMojoNote.annotateでマークアップ | E-24 (L48-52) | ○ |
| C-134 | Maven3MojoNote.annotateでマークアップ | E-26 (L57-60) | ○ |
| C-135 | MavenWarningNote.annotateでマークアップ | E-25 (L45-48) | ○ |
| C-136 | MavenErrorNote.annotateでマークアップ | E-23 (L43-47) | ○ |
| C-137 | MavenMojoNote.PATTERNでパターンマッチ | E-24 (L63) | ○ |
| C-138 | Maven3MojoNote.PATTERNでパターンマッチ | E-26 (L71) | ○ |
| C-139 | MavenWarningNote.PATTERNでパターンマッチ | E-25 (L60) | ○ |
| C-140 | MavenErrorNote.PATTERNでパターンマッチ | E-23 (L58) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースにソースコードの根拠が存在

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースに明確なソースコード根拠あり

### 追加テストケース検討項目（リスク0）
1. **BuildStep.PublisherList** - 内部クラスのテスト（優先度：低）
2. **ArtifactArchiver.Migrator** - マイグレーション処理のテスト（優先度：低）
3. **BuildTrigger$DescriptorImpl$ItemListenerImpl** - リネーム処理のテスト（優先度：低）

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（perform系メソッド）の期待結果がソースコードと一致しているか
- [ ] 境界値テストケースの条件が適切か
- [ ] 異常系テストケースで想定される例外が正しいか
- [ ] deprecated メソッドのテストケースは必要か確認
- [ ] 内部クラス（ListFiles, FindRecords等）の追加テストが必要か検討
