---
generated_at: 2026-01-22 21:15:00
metrics:
  claims_total: 143
  claims_with_evidence: 143
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.tools 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：143 / 143、根拠なし：0
- 優先レビュー（高）
  1. **UT-TOL-085 (InstallerTranslator同時インストール排他制御)**: 並行性テストの実装難易度が高い
  2. **UT-TOL-107 (DownloadFromUrlInstaller.performInstallation)**: ネットワーク接続が必要なテスト
  3. **UT-TOL-098 (ChmodRecAPlusX)**: Unix環境依存のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/tools/ToolInstallation.java`
- E-02: `core/src/main/java/hudson/tools/ToolDescriptor.java`
- E-03: `core/src/main/java/hudson/tools/ToolInstaller.java`
- E-04: `core/src/main/java/hudson/tools/ToolInstallerDescriptor.java`
- E-05: `core/src/main/java/hudson/tools/ToolProperty.java`
- E-06: `core/src/main/java/hudson/tools/ToolPropertyDescriptor.java`
- E-07: `core/src/main/java/hudson/tools/PropertyDescriptor.java`
- E-08: `core/src/main/java/hudson/tools/InstallSourceProperty.java`
- E-09: `core/src/main/java/hudson/tools/ToolLocationNodeProperty.java`
- E-10: `core/src/main/java/hudson/tools/ToolLocationTranslator.java`
- E-11: `core/src/main/java/hudson/tools/InstallerTranslator.java`
- E-12: `core/src/main/java/hudson/tools/ZipExtractionInstaller.java`
- E-13: `core/src/main/java/hudson/tools/DownloadFromUrlInstaller.java`
- E-14: `core/src/main/java/hudson/tools/AbstractCommandInstaller.java`
- E-15: `core/src/main/java/hudson/tools/CommandInstaller.java`
- E-16: `core/src/main/java/hudson/tools/BatchCommandInstaller.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### ToolInstallation関連 (C-01 〜 C-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-TOL-001: getNameで名前が取得できる | E-01 (L134-136) | ○ |
| C-02 | UT-TOL-002: getHomeでホームディレクトリが取得できる | E-01 (L145-147) | ○ |
| C-03 | UT-TOL-003: getHomeでnullが返却される場合がある | E-01 (L145: @CheckForNull) | ○ |
| C-04 | UT-TOL-004: getPropertiesでプロパティリストが取得できる | E-01 (L161-166) | ○ |
| C-05 | UT-TOL-005: propertiesがnullの場合に空リストが返却される | E-01 (L162-164: 遅延初期化) | ○ |
| C-06 | UT-TOL-006: buildEnvVarsが環境変数を設定する | E-01 (L158-159) | ○ |
| C-07 | UT-TOL-007: translate(Node,EnvVars,TaskListener)でNodeSpecific/EnvironmentSpecificの変換 | E-01 (L183-194) | ○ |
| C-08 | UT-TOL-008: translate(AbstractBuild,TaskListener)でビルド用変換 | E-01 (L200-203) | ○ |
| C-09 | UT-TOL-009: translateForでノード固有パス取得 | E-01 (L220-222) | ○ |
| C-10 | UT-TOL-010: readResolveでデシリアライズ時の初期化 | E-01 (L228-235) | ○ |
| C-11 | UT-TOL-011: toStringで文字列表現を生成 | E-01 (L255-257) | ○ |
| C-12 | UT-TOL-012: all()で全ToolDescriptorを取得 | E-01 (L280-283) | ○ |
| C-13 | UT-TOL-013: コンストラクタでプロパティ付き初期化 | E-01 (L112-124) | ○ |
| C-14 | UT-TOL-014: コンストラクタでプロパティnullハンドリング | E-01 (L115: if条件) | ○ |

### ToolDescriptor関連 (C-15 〜 C-27)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | UT-TOL-015: getInstallationsで設定済みインストール取得 | E-02 (L74-89) | ○ |
| C-16 | UT-TOL-016: getInstallationsで空配列返却 | E-02 (L76-88) | ○ |
| C-17 | UT-TOL-017: setInstallationsでインストール設定保存 | E-02 (L106-108) | ○ |
| C-18 | UT-TOL-018: getPropertyDescriptorsで適用可能なプロパティ記述子取得 | E-02 (L113-115) | ○ |
| C-19 | UT-TOL-019: getDefaultInstallersでデフォルトインストーラ取得 | E-02 (L129-131) | ○ |
| C-20 | UT-TOL-020: getDefaultPropertiesでデフォルトプロパティ生成 | E-02 (L137-146) | ○ |
| C-21 | UT-TOL-021: configureでStaplerRequest2からの設定反映 | E-02 (L149-170) | ○ |
| C-22 | UT-TOL-022: doCheckHomeで存在するディレクトリ検証 | E-02 (L176-189) | ○ |
| C-23 | UT-TOL-023: doCheckHomeでディレクトリでないパスの警告 | E-02 (L184-185) | ○ |
| C-24 | UT-TOL-024: doCheckHomeで空文字時のOK | E-02 (L180-182) | ○ |
| C-25 | UT-TOL-025: doCheckNameで有効な名前の検証 | E-02 (L205-207) | ○ |
| C-26 | UT-TOL-026: doCheckNameで空の名前のエラー | E-02 (L206: validateRequired) | ○ |
| C-27 | UT-TOL-027: checkHomeDirectoryでカスタム検証 | E-02 (L197-199) | ○ |

### ToolInstaller関連 (C-28 〜 C-39)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | UT-TOL-028: getLabelでラベル取得 | E-03 (L77-79) | ○ |
| C-29 | UT-TOL-029: getLabelでnull返却 | E-03 (L62: Util.fixEmptyAndTrim) | ○ |
| C-30 | UT-TOL-030: appliesToでラベル一致判定 | E-03 (L85-88) | ○ |
| C-31 | UT-TOL-031: appliesToでラベル未設定時全ノード適用 | E-03 (L87: l == null) | ○ |
| C-32 | UT-TOL-032: appliesToでラベル不一致時false | E-03 (L87: l.contains) | ○ |
| C-33 | UT-TOL-033: performInstallationの抽象メソッド | E-03 (L102) | ○ |
| C-34 | UT-TOL-034: preferredLocationでホーム指定時のパス | E-03 (L112-125) | ○ |
| C-35 | UT-TOL-035: preferredLocationでデフォルトパス生成 | E-03 (L117-118) | ○ |
| C-36 | UT-TOL-036: preferredLocationでnullノード例外 | E-03 (L113-115) | ○ |
| C-37 | UT-TOL-037: preferredLocationでオフラインノード例外 | E-03 (L120-123) | ○ |
| C-38 | UT-TOL-038: setToolでToolInstallation設定 | E-03 (L69-71) | ○ |
| C-39 | UT-TOL-039: getDescriptorでToolInstallerDescriptor取得 | E-03 (L131-134) | ○ |

### ToolInstallerDescriptor関連 (C-40 〜 C-45)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | UT-TOL-040: isApplicableでデフォルトtrue | E-04 (L49-51) | ○ |
| C-41 | UT-TOL-041: all()で全ToolInstallerDescriptor取得 | E-04 (L53-55) | ○ |
| C-42 | UT-TOL-042: for_で適用可能Descriptorフィルタ | E-04 (L60-66) | ○ |
| C-43 | UT-TOL-043: doAutoCompleteLabelで自動補完 | E-04 (L69-71) | ○ |
| C-44 | UT-TOL-044: doCheckLabelで有効ラベル検証 | E-04 (L74-76) | ○ |
| C-45 | UT-TOL-045: doCheckLabelで無効ラベルエラー | E-04 (L74-76) | ○ |

### ToolProperty/ToolPropertyDescriptor関連 (C-46 〜 C-54)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | UT-TOL-046: setToolでToolInstallation設定 | E-05 (L55-57) | ○ |
| C-47 | UT-TOL-047: getDescriptorでToolPropertyDescriptor取得 | E-05 (L59-62) | ○ |
| C-48 | UT-TOL-048: typeで対象タイプクラス返却 | E-05 (L67) | ○ |
| C-49 | UT-TOL-049: all()で全ToolPropertyDescriptor取得 | E-05 (L74-76) | ○ |
| C-50 | UT-TOL-050: ToolPropertyDescriptorのClass引数コンストラクタ | E-06 (L40-42) | ○ |
| C-51 | UT-TOL-051: ToolPropertyDescriptorの引数なしコンストラクタ | E-06 (L44-45) | ○ |
| C-52 | UT-TOL-052: PropertyDescriptor.isApplicableで型判定 | E-07 (L46-49) | ○ |
| C-53 | UT-TOL-053: PropertyDescriptor.for_(List,Class)でフィルタ | E-07 (L51-57) | ○ |
| C-54 | UT-TOL-054: PropertyDescriptor.for_(List,T)でフィルタ | E-07 (L59-61) | ○ |

### InstallSourceProperty関連 (C-55 〜 C-58)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | UT-TOL-055: コンストラクタでインストーラリスト初期化 | E-08 (L48-53) | ○ |
| C-56 | UT-TOL-056: コンストラクタでnullハンドリング | E-08 (L50) | ○ |
| C-57 | UT-TOL-057: setToolで全インストーラにtool設定 | E-08 (L55-60) | ○ |
| C-58 | UT-TOL-058: typeでToolInstallation.class返却 | E-08 (L62-65) | ○ |

### ToolLocationNodeProperty関連 (C-59 〜 C-78)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | UT-TOL-059: コンストラクタ(List)でロケーションリスト初期化 | E-09 (L57-63) | ○ |
| C-60 | UT-TOL-060: コンストラクタでnullハンドリング | E-09 (L59-61) | ○ |
| C-61 | UT-TOL-061: コンストラクタ(varargs)で初期化 | E-09 (L65-67) | ○ |
| C-62 | UT-TOL-062: getLocationsで変更不可能リスト返却 | E-09 (L69-71) | ○ |
| C-63 | UT-TOL-063: getHomeで一致するインストールのホーム返却 | E-09 (L73-80) | ○ |
| C-64 | UT-TOL-064: getHomeで一致なし時null返却 | E-09 (L79) | ○ |
| C-65 | UT-TOL-065: getToolHome(static)でノードプロパティからホーム取得 | E-09 (L95-106) | ○ |
| C-66 | UT-TOL-066: getToolHome(static)でTranslator連携 | E-09 (L107-114) | ○ |
| C-67 | UT-TOL-067: getToolHome(static)でフォールバック | E-09 (L116) | ○ |
| C-68 | UT-TOL-068: ToolLocation 3引数コンストラクタ | E-09 (L152-157) | ○ |
| C-69 | UT-TOL-069: ToolLocation キー形式コンストラクタ | E-09 (L159-164) | ○ |
| C-70 | UT-TOL-070: ToolLocation.getNameでツール名取得 | E-09 (L166-168) | ○ |
| C-71 | UT-TOL-071: ToolLocation.getHomeでホームパス取得 | E-09 (L170-172) | ○ |
| C-72 | UT-TOL-072: ToolLocation.getTypeでToolDescriptor取得 | E-09 (L174-180) | ○ |
| C-73 | UT-TOL-073: ToolLocation.getKeyでキー形式生成 | E-09 (L182-184) | ○ |
| C-74 | UT-TOL-074: DescriptorImpl.getDisplayNameで表示名取得 | E-09 (L122-126) | ○ |
| C-75 | UT-TOL-075: DescriptorImpl.getToolDescriptorsで全ToolDescriptor取得 | E-09 (L128-130) | ○ |
| C-76 | UT-TOL-076: DescriptorImpl.getKeyでキー生成 | E-09 (L132-134) | ○ |
| C-77 | UT-TOL-077: DescriptorImpl.isApplicableでJenkins以外true | E-09 (L136-139) | ○ |
| C-78 | UT-TOL-078: DescriptorImpl.isApplicableでJenkins時false | E-09 (L138) | ○ |

### ToolLocationTranslator/InstallerTranslator関連 (C-79 〜 C-85)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | UT-TOL-079: getToolHomeでツールホーム変換 | E-10 (L66) | ○ |
| C-80 | UT-TOL-080: all()で全Translator取得 | E-10 (L71-73) | ○ |
| C-81 | UT-TOL-081: InstallerTranslator.getToolHomeでインストーラ経由取得 | E-11 (L46-82) | ○ |
| C-82 | UT-TOL-082: InstallerTranslator.getToolHomeでオフラインノード処理 | E-11 (L47-50) | ○ |
| C-83 | UT-TOL-083: InstallerTranslator.getToolHomeでプロパティなし時null | E-11 (L51-54) | ○ |
| C-84 | UT-TOL-084: InstallerTranslator.getToolHomeで適用不可時null | E-11 (L71-80) | ○ |
| C-85 | UT-TOL-085: InstallerTranslator.getToolHomeでSemaphore排他制御 | E-11 (L60-70) | ○ |

### ZipExtractionInstaller関連 (C-86 〜 C-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | UT-TOL-086: コンストラクタで初期化 | E-12 (L70-75) | ○ |
| C-87 | UT-TOL-087: コンストラクタで空subdir時null変換 | E-12 (L74: Util.fixEmptyAndTrim) | ○ |
| C-88 | UT-TOL-088: getUrlでURL取得 | E-12 (L77-79) | ○ |
| C-89 | UT-TOL-089: getSubdirでサブディレクトリ取得 | E-12 (L81-83) | ○ |
| C-90 | UT-TOL-090: performInstallationでZIP展開 | E-12 (L85-96) | ○ |
| C-91 | UT-TOL-091: performInstallationでsubdir指定時子ディレクトリ返却 | E-12 (L93-95) | ○ |
| C-92 | UT-TOL-092: performInstallationでsubdir未指定時ルート返却 | E-12 (L91-92) | ○ |
| C-93 | UT-TOL-093: doCheckUrlで有効HTTP URL検証 | E-12 (L108-148) | ○ |
| C-94 | UT-TOL-094: doCheckUrlで空URL時OK | E-12 (L111-114) | ○ |
| C-95 | UT-TOL-095: doCheckUrlで不正URLエラー | E-12 (L116-128) | ○ |
| C-96 | UT-TOL-096: doCheckUrlで接続不可エラー | E-12 (L139-147) | ○ |
| C-97 | UT-TOL-097: doCheckUrlでfile:// URL検証 | E-12 (L122-129) | ○ |
| C-98 | UT-TOL-098: ChmodRecAPlusX.invokeでUnix実行権限設定 | E-12 (L159-177) | ○ |
| C-99 | UT-TOL-099: ChmodRecAPlusX.invokeでWindows時何もしない | E-12 (L161) | ○ |
| C-100 | UT-TOL-100: ChmodRecAPlusX.invokeで再帰処理 | E-12 (L166-176) | ○ |

### DownloadFromUrlInstaller関連 (C-101 〜 C-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | UT-TOL-101: コンストラクタでID初期化 | E-13 (L30-35) | ○ |
| C-102 | UT-TOL-102: isUpToDateでマーカー一致時true | E-13 (L43-46) | ○ |
| C-103 | UT-TOL-103: isUpToDateでマーカーなし時false | E-13 (L45: marker.exists) | ○ |
| C-104 | UT-TOL-104: isUpToDateでURL不一致時false | E-13 (L45: equals) | ○ |
| C-105 | UT-TOL-105: getInstallableでID一致Installable取得 | E-13 (L53-58) | ○ |
| C-106 | UT-TOL-106: getInstallableで一致なし時null | E-13 (L57) | ○ |
| C-107 | UT-TOL-107: performInstallationでダウンロード展開 | E-13 (L60-88) | ○ |
| C-108 | UT-TOL-108: performInstallationでキャッシュ活用 | E-13 (L74-75) | ○ |
| C-109 | UT-TOL-109: performInstallationで無効ID時ログ出力 | E-13 (L65-68) | ○ |
| C-110 | UT-TOL-110: performInstallationでNodeSpecific処理 | E-13 (L70-72) | ○ |
| C-111 | UT-TOL-111: findPullUpDirectoryで単一ディレクトリ返却 | E-13 (L114-122) | ○ |
| C-112 | UT-TOL-112: findPullUpDirectoryで複数エントリ時null | E-13 (L118) | ○ |
| C-113 | UT-TOL-113: findPullUpDirectoryで単一ファイル時null | E-13 (L119-121) | ○ |
| C-114 | UT-TOL-114: DescriptorImpl.getIdでクラス名ベースID | E-13 (L204-207) | ○ |
| C-115 | UT-TOL-115: DescriptorImpl.getInstallablesでリスト取得 | E-13 (L218-222) | ○ |
| C-116 | UT-TOL-116: DescriptorImpl.getInstallablesでデータなし時空リスト | E-13 (L220) | ○ |
| C-117 | UT-TOL-117: DescriptorImpl.createDownloadableでDownloadable生成 | E-13 (L135-148) | ○ |
| C-118 | UT-TOL-118: DescriptorImpl.reduceで重複除去マージ | E-13 (L178-197) | ○ |
| C-119 | UT-TOL-119: Installableフィールドアクセス | E-13 (L236-249) | ○ |
| C-120 | UT-TOL-120: InstallableListフィールドアクセス | E-13 (L228-231) | ○ |

### AbstractCommandInstaller/CommandInstaller/BatchCommandInstaller関連 (C-121 〜 C-143)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | UT-TOL-121: AbstractCommandInstallerコンストラクタ | E-14 (L51-55) | ○ |
| C-122 | UT-TOL-122: getCommandでコマンド取得 | E-14 (L57-59) | ○ |
| C-123 | UT-TOL-123: getToolHomeでツールホーム取得 | E-14 (L61-63) | ○ |
| C-124 | UT-TOL-124: getCommandFileExtension抽象メソッド | E-14 (L65) | ○ |
| C-125 | UT-TOL-125: getCommandCall抽象メソッド | E-14 (L70) | ○ |
| C-126 | UT-TOL-126: performInstallationでコマンド正常実行 | E-14 (L72-87) | ○ |
| C-127 | UT-TOL-127: performInstallationで非0時例外 | E-14 (L80-82) | ○ |
| C-128 | UT-TOL-128: performInstallationで一時スクリプト削除 | E-14 (L83-85: finally) | ○ |
| C-129 | UT-TOL-129: Descriptor.doCheckCommandで入力あり時OK | E-14 (L92-98) | ○ |
| C-130 | UT-TOL-130: Descriptor.doCheckCommandで空時エラー | E-14 (L95-97) | ○ |
| C-131 | UT-TOL-131: Descriptor.doCheckToolHomeで入力あり時OK | E-14 (L100-106) | ○ |
| C-132 | UT-TOL-132: Descriptor.doCheckToolHomeで空時エラー | E-14 (L103-105) | ○ |
| C-133 | UT-TOL-133: CommandInstallerコンストラクタで改行変換 | E-15 (L41-44) | ○ |
| C-134 | UT-TOL-134: CommandInstaller.getCommandFileExtensionで.sh返却 | E-15 (L46-49) | ○ |
| C-135 | UT-TOL-135: CommandInstaller.getCommandCallでshコマンド返却 | E-15 (L51-54) | ○ |
| C-136 | UT-TOL-136: CommandInstaller.readResolveで新インスタンス生成 | E-15 (L56-58) | ○ |
| C-137 | UT-TOL-137: BatchCommandInstallerコンストラクタで改行変換 | E-16 (L42-45) | ○ |
| C-138 | UT-TOL-138: BatchCommandInstaller.getCommandFileExtensionで.bat返却 | E-16 (L47-50) | ○ |
| C-139 | UT-TOL-139: BatchCommandInstaller.getCommandCallでcmdコマンド返却 | E-16 (L52-55) | ○ |
| C-140 | UT-TOL-140: BatchCommandInstaller.readResolveで新インスタンス生成 | E-16 (L57-59) | ○ |
| C-141 | UT-TOL-141: ToolInstallerListフィールドアクセス | E-03 (L137-142) | ○ |
| C-142 | UT-TOL-142: ToolInstallerEntryデフォルトコンストラクタ | E-03 (L162-164) | ○ |
| C-143 | UT-TOL-143: ToolInstallerEntry 3引数コンストラクタ | E-03 (L172-176) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコードに基づいて生成されており、根拠が明確です

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 143件中141件
  - 基本的なgetterメソッド、単純なロジックのテスト
- **1 (中リスク)**: 2件
  - UT-TOL-085: 並行性制御のテストは実装・検証が複雑
  - UT-TOL-107/108: ネットワーク接続を伴うテストはモック化が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースIDが「UT-TOL-」で始まり、001から連番になっているか確認
- [ ] 全16クラスのメソッドが網羅されているか確認
- [ ] 正常系・異常系・境界値の観点が各クラスに適用されているか確認
- [ ] 優先度「高」のテストケース（インストール処理、パス解決、検証処理）が適切に設定されているか確認
- [ ] 抽象メソッドに対するテストケースがサブクラスで具体化されているか確認
- [ ] 並行性制御（Semaphore）に関するテストケースの実装方針が適切か確認
