---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 168
  claims_with_evidence: 168
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.triggers 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：168 / 168、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/triggers/Trigger.java` - 基底トリガークラス（383行）
- E-02: `core/src/main/java/hudson/triggers/TriggerDescriptor.java` - トリガーDescriptor（59行）
- E-03: `core/src/main/java/hudson/triggers/SCMTrigger.java` - SCMポーリングトリガー（783行）
- E-04: `core/src/main/java/hudson/triggers/TimerTrigger.java` - 定期実行トリガー（141行）
- E-05: `core/src/main/java/hudson/triggers/SafeTimerTask.java` - 安全なTimerTaskラッパー（127行）
- E-06: `core/src/main/java/hudson/triggers/SlowTriggerAdminMonitor.java` - 遅延トリガー監視（129行）
- E-07: `core/src/main/java/hudson/triggers/Triggers.java` - 非推奨ユーティリティ（64行）
- E-08: `core/src/main/java/hudson/triggers/package-info.java` - パッケージ情報

## 3) Claims と根拠の対応（レビューの主戦場）

### Trigger クラス（UT-TRG-001 〜 UT-TRG-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Trigger(String)コンストラクタで有効なcron式が解析される | E-01 L177-180 | ○ |
| C-02 | 不正なcron式でIllegalArgumentExceptionがスローされる | E-01 L179 (CronTabList.create) | ○ |
| C-03 | 引数なしコンストラクタで空のTriggerが生成される | E-01 L185-188 | ○ |
| C-04 | start()でプロジェクト名ハッシュでcronタブが再解析される | E-01 L93-107 | ○ |
| C-05 | specがnullの場合に警告ログが出力される | E-01 L101-102 | ○ |
| C-06 | cron解析失敗時に既存tabsが維持される | E-01 L103-107 | ○ |
| C-07 | stop()が正常に呼び出せる | E-01 L129 | ○ |
| C-08 | run()のデフォルト実装は空 | E-01 L118 | ○ |
| C-09 | getProjectAction()のデフォルトはnull | E-01 L139-141 | ○ |
| C-10 | getProjectActions()でActionをリストで返却 | E-01 L150-155 | ○ |
| C-11 | getSpec()でcron式が取得できる | E-01 L195-197 | ○ |
| C-12 | readResolve()でデシリアライズ時にtabsが再構築される | E-01 L199-208 | ○ |
| C-13 | toString()でクラス名とspec情報が返却される | E-01 L211-213 | ○ |
| C-14 | all()でDescriptorExtensionListが返却される | E-01 L359-361 | ○ |
| C-15 | for_()で適用可能なDescriptorがフィルタリングされる | E-01 L366-381 | ○ |
| C-16 | Cron.doRun()でトリガーチェックが実行される | E-01 L238-250 | ○ |
| C-17 | checkTriggers()でcron一致時にトリガーが実行される | E-01 L256-330 | ○ |
| C-18 | 実行時間が閾値超過でSlowTriggerAdminMonitorに報告される | E-01 L308-314 | ○ |

### TriggerDescriptor クラス（UT-TRG-029 〜 UT-TRG-031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | TriggerDescriptor(Class)でDescriptorが生成される | E-02 L36-38 | ○ |
| C-20 | 引数なしコンストラクタで型推論される | E-02 L47-48 | ○ |
| C-21 | isApplicable(Item)が抽象メソッドとして定義 | E-02 L57 | ○ |

### SCMTrigger クラス（UT-TRG-032 〜 UT-TRG-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | SCMTrigger(String)でポーリングスケジュール設定 | E-03 L110-113 | ○ |
| C-23 | isIgnorePostCommitHooks()でフラグ取得 | E-03 L138-140 | ○ |
| C-24 | setIgnorePostCommitHooks()でフラグ設定 | E-03 L150-153 | ○ |
| C-25 | run()でjobがnullの場合早期リターン | E-03 L160-166 | ○ |
| C-26 | run(Action[])で同期/非同期実行が分岐 | E-03 L174-194 | ○ |
| C-27 | getProjectActions()でSCMActionを返却 | E-03 L201-208 | ○ |
| C-28 | getLogFile()でscm-polling.logパスを返却 | E-03 L213-215 | ○ |
| C-29 | DescriptorImpl.isApplicable()でSCMTriggerItem判定 | E-03 L257-259 | ○ |
| C-30 | getPollingThreadCount()でスレッド数取得 | E-03 L306-308 | ○ |
| C-31 | setPollingThreadCount()で範囲チェック付き設定 | E-03 L314-326 | ○ |
| C-32 | configure()で設定保存 | E-03 L358-371 | ○ |
| C-33 | doCheckPollingThreadCount()でバリデーション | E-03 L373-375 | ○ |
| C-34 | doCheckScmpoll_spec()でcron式バリデーション | E-03 L380-393 | ○ |
| C-35 | AdministrativeMonitorImpl.isActivated()で状態取得 | E-03 L406-409 | ○ |
| C-36 | BuildAction.getRun()でRun取得 | E-03 L440-442 | ○ |
| C-37 | BuildAction.getPollingLogFile()でログパス取得 | E-03 L447-449 | ○ |
| C-38 | SCMAction.getDisplayName()でSCM名付き表示名 | E-03 L523-529 | ○ |
| C-39 | Runner.runPolling()でSCM変更チェック | E-03 L607-635 | ○ |
| C-40 | Runner.run()でSCMDecisionHandlerによるveto処理 | E-03 L638-686 | ○ |
| C-41 | Runner.equals()でjobベースの等価性判定 | E-03 L689-696 | ○ |
| C-42 | SCMTriggerCause.onAddedTo()でログファイル保存 | E-03 L742-755 | ○ |

### TimerTrigger クラス（UT-TRG-126 〜 UT-TRG-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | TimerTrigger(String)でcron式設定 | E-04 L55-58 | ○ |
| C-44 | run()でscheduleBuild()呼び出し | E-04 L60-67 | ○ |
| C-45 | DescriptorImpl.isApplicable()でBuildableItem判定 | E-04 L71-74 | ○ |
| C-46 | doCheckSpec()でcron式バリデーションと次回実行時刻表示 | E-04 L90-122 | ○ |
| C-47 | TimerTriggerCause.equals()で型チェック | E-04 L132-134 | ○ |
| C-48 | TimerTriggerCause.hashCode()で固定値5を返却 | E-04 L137-139 | ○ |

### SafeTimerTask クラス（UT-TRG-143 〜 UT-TRG-150）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | of()でラムダからSafeTimerTask生成 | E-05 L56-63 | ○ |
| C-50 | run()でSYSTEM権限コンテキスト実行 | E-05 L88-96 | ○ |
| C-51 | 例外発生時もTimerが継続 | E-05 L93-95 | ○ |
| C-52 | getLogsRoot()でログディレクトリ取得 | E-05 L109-124 | ○ |

### SlowTriggerAdminMonitor クラス（UT-TRG-151 〜 UT-TRG-168）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | getInstance()でシングルトン取得 | E-06 L38-40 | ○ |
| C-54 | isActivated()でerrorsの空チェック | E-06 L46-48 | ○ |
| C-55 | clear()でerrorsクリア | E-06 L56-60 | ○ |
| C-56 | report()でエラー情報登録とMAX_ENTRIES制限 | E-06 L62-81 | ○ |
| C-57 | doClear()でADMINISTER権限チェック | E-06 L89-95 | ○ |
| C-58 | Value.getTimeString()でフォーマット済み時刻 | E-06 L112-114 | ○ |

### Triggers クラス（UT-TRG-167 〜 UT-TRG-168）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | TRIGGERSフィールドで非推奨リスト | E-07 L47 | ○ |
| C-60 | getApplicableTriggers()でTrigger.for_()に委譲 | E-07 L60-62 | ○ |

## 4) 不足情報（Unknown / Missing）
- **該当なし**：全テストケースはソースコードに基づいて生成されています。
- 既存のテストコード（`core/src/test/java/hudson/triggers/`）も参照し、実装の妥当性を確認済み。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードの実装に基づいており、根拠が明確です。

### 注意が必要な点
1. **セキュリティ関連テスト（UT-TRG-144, UT-TRG-160, UT-TRG-161）**: ACL権限チェックのテストは実際のJenkins環境での確認が推奨されます。
2. **並行処理関連テスト（UT-TRG-024, UT-TRG-040, UT-TRG-041, UT-TRG-106-108）**: スレッド同期のテストは実行環境に依存する可能性があります。
3. **非推奨メソッド（UT-TRG-167, UT-TRG-168）**: Triggersクラスは非推奨のため、テスト優先度は低く設定しています。

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（優先度「高」）の妥当性を確認
- [ ] SCMTrigger.Runnerクラスのテストケース（UT-TRG-095〜UT-TRG-113）のカバレッジ確認
- [ ] SlowTriggerAdminMonitorのMAX_ENTRIES制限テスト（UT-TRG-157）の境界条件確認
- [ ] 例外ハンドリングテスト（UT-TRG-026, UT-TRG-105, UT-TRG-145）の網羅性確認
- [ ] デシリアライズテスト（UT-TRG-014, UT-TRG-015, UT-TRG-070）のエッジケース確認
