---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート: hudson.util 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **UT-UTL-137〜139 (JNA関連)**: プラットフォーム固有のため実行環境依存
  2. **UT-UTL-149〜150 (ProcessTree)**: OS依存のプロセス管理機能
  3. **UT-UTL-121 (CompressedFile.compress)**: 非同期処理のため検証が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/hudson/util/Secret.java` - 秘密情報暗号化クラス
- E-02: `core/src/main/java/hudson/util/FormValidation.java` - フォームバリデーションクラス
- E-03: `core/src/main/java/hudson/util/AtomicFileWriter.java` - アトミックファイル書き込みクラス
- E-04: `core/src/main/java/hudson/util/ArgumentListBuilder.java` - コマンド引数ビルダークラス
- E-05: `core/src/main/java/hudson/util/ConsistentHash.java` - 一貫性ハッシュクラス
- E-06: `core/src/main/java/hudson/util/XStream2.java` - XStreamカスタマイズクラス
- E-07: `core/src/main/java/hudson/util/Retrier.java` - リトライユーティリティクラス
- E-08: `core/src/main/java/hudson/util/RunList.java` - ビルド実行リストクラス
- E-09: `core/src/main/java/hudson/util/CyclicGraphDetector.java` - 循環グラフ検出クラス
- E-10: `core/src/main/java/hudson/util/Iterators.java` - イテレータユーティリティクラス
- E-11: `core/src/main/java/hudson/util/TextFile.java` - テキストファイル操作クラス
- E-12: `core/src/main/java/hudson/util/EditDistance.java` - 編集距離計算クラス
- E-13: `core/src/main/java/hudson/util/CopyOnWriteList.java` - コピーオンライトリストクラス
- E-14: `core/src/main/java/hudson/util/CopyOnWriteMap.java` - コピーオンライトマップクラス
- E-15: `core/src/main/java/hudson/util/DescribableList.java` - Describableリストクラス
- E-16: `core/src/main/java/hudson/util/PersistedList.java` - 永続化リストクラス
- E-17: `core/src/main/java/hudson/util/CompressedFile.java` - 圧縮ファイルクラス
- E-18: `core/src/main/java/hudson/util/ListBoxModel.java` - リストボックスモデルクラス
- E-19: `core/src/main/java/hudson/util/DirScanner.java` - ディレクトリスキャナクラス
- E-20: `core/src/main/java/hudson/util/io/Archiver.java` - アーカイバ基底クラス
- E-21: `core/src/main/java/hudson/util/io/ZipArchiver.java` - ZIPアーカイバクラス
- E-22: `core/src/main/java/hudson/util/io/TarArchiver.java` - TARアーカイバクラス
- E-23: `core/src/main/java/hudson/util/io/RewindableFileOutputStream.java` - 巻き戻し可能出力ストリーム
- E-24: `core/src/main/java/hudson/util/io/RewindableRotatingFileOutputStream.java` - ローテーション対応出力ストリーム
- E-25: `core/src/main/java/hudson/util/jna/GNUCLibrary.java` - GNU Cライブラリインターフェース
- E-26: `core/src/main/java/hudson/util/jna/Kernel32.java` - Windows Kernel32インターフェース
- E-27: `core/src/main/java/hudson/util/jna/RegistryKey.java` - Windowsレジストリアクセス
- E-28: `core/src/main/java/hudson/util/ProcessTree.java` - プロセスツリー管理クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜011 | Secretクラスの暗号化/復号テスト | E-01 | ○ |
| C-012〜028 | FormValidationの各種バリデーションテスト | E-02 | ○ |
| C-029〜032 | AtomicFileWriterのアトミック操作テスト | E-03 | ○ |
| C-033〜044 | ArgumentListBuilderの引数構築テスト | E-04 | ○ |
| C-045〜051 | ConsistentHashの分散ハッシュテスト | E-05 | ○ |
| C-052〜055 | XStream2のシリアライズ/デシリアライズテスト | E-06 | ○ |
| C-056〜059 | Retrierのリトライ機能テスト | E-07 | ○ |
| C-060〜067 | RunListのフィルタリング/制限テスト | E-08 | ○ |
| C-068〜070 | CyclicGraphDetectorの循環検出テスト | E-09 | ○ |
| C-071〜083 | Iteratorsの各種イテレータユーティリティテスト | E-10 | ○ |
| C-084〜090 | TextFileのファイル操作テスト | E-11 | ○ |
| C-091〜095 | EditDistanceの編集距離計算テスト | E-12 | ○ |
| C-096〜100 | CopyOnWriteListのスレッドセーフ操作テスト | E-13 | ○ |
| C-101〜106 | CopyOnWriteMapのスレッドセーフ操作テスト | E-14 | ○ |
| C-107〜111 | DescribableListのDescribable操作テスト | E-15 | ○ |
| C-112〜116 | PersistedListの永続化テスト | E-16 | ○ |
| C-117〜121 | CompressedFileの圧縮/読み取りテスト | E-17 | ○ |
| C-122〜125 | ListBoxModelのUIモデルテスト | E-18 | ○ |
| C-126〜129 | DirScannerのディレクトリスキャンテスト | E-19 | ○ |
| C-130〜136 | io配下のアーカイバ/ストリームテスト | E-20〜24 | ○ |
| C-137 | GNUCLibrary.getpidテスト | E-25 | △ |
| C-138 | Kernel32Utils.getActiveConsoleSessionIdテスト | E-26 | △ |
| C-139 | RegistryKey.openテスト | E-27 | △ |
| C-140〜144 | OneShotEvent/Futures同期テスト | **根拠不足** | △ |
| C-145〜146 | PackedMapテスト | **根拠不足** | △ |
| C-147〜148 | Scramblerテスト | **根拠不足** | △ |
| C-149〜150 | ProcessTreeプロセス管理テスト | E-28 | △ |

## 4) 不足情報（Unknown / Missing）
- **JNA関連テスト (C-137〜139)**: プラットフォーム固有の機能のため、テスト実行環境に依存。Windows/Linux/Mac それぞれで異なるテストが必要。
  - 候補: モック化 / プラットフォーム判定による条件分岐 / インテグレーションテストへの移行
- **OneShotEvent/Futures (C-140〜144)**: ソースコードが未読のため、詳細な期待結果が不明確
  - 候補: 該当ソースコードの追加読み込み
- **PackedMap/Scrambler (C-145〜148)**: ソースコードが未読のため、詳細な期待結果が不明確
  - 候補: 該当ソースコードの追加読み込み
- **ProcessTree (C-149〜150)**: OS依存の機能のため、テスト実行環境に依存
  - 候補: モック化 / プラットフォーム判定による条件分岐

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: C-001〜090 - コア機能のテストで、ソースコードから直接根拠が得られる
- **1 (中リスク)**: C-091〜136 - ファイル操作/IO系のテストで、環境依存性がある
- **2 (高リスク)**: C-137〜150 - プラットフォーム固有機能のテストで、実行環境に大きく依存

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テスト（Secret, Scrambler）の網羅性は十分か
- [ ] 暗号化/復号の境界値テストは適切か
- [ ] FormValidationの各バリデーションメソッドに対するテストケースは網羅的か
- [ ] アトミックファイル操作の失敗ケース（ディスクフル等）のテストは必要か
- [ ] CopyOnWrite系コレクションの並行アクセステストは十分か
- [ ] JNA/ProcessTree関連テストはインテグレーションテストとして分離すべきか
- [ ] 既存のテストコード（core/src/test/java/hudson/util/）との重複/差分を確認
