---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 63
  claims_with_evidence: 63
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：hudson.widgets モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でテストケース一覧の内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが実在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールのpublicメソッド、重要な内部ロジックを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：63 / 63、根拠なし：0
- 優先レビュー（高）
  1. **UT-WGT-022〜025（doAjax関連）**：AJAX処理の複雑なロジック、実際のHTTPリクエスト/レスポンスのモックが必要
  2. **UT-WGT-057〜063（RenderOnDemandClosure.render関連）**：Jellyスクリプト実行の検証、モック設定が複雑
  3. **UT-WGT-042〜046（BuildHistoryWidget キュー関連）**：Jenkins.get().getQueue()のモックが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/java/hudson/widgets/Widget.java`
- E-02: `core/src/main/java/hudson/widgets/HistoryWidget.java`
- E-03: `core/src/main/java/hudson/widgets/BuildHistoryWidget.java`
- E-04: `core/src/main/java/hudson/widgets/RenderOnDemandClosure.java`
- E-05: `test/src/test/java/hudson/widgets/HistoryWidgetTest.java`（既存テスト参照）

## 3) Claims と根拠の対応（レビューの主戦場）

### Widget クラス（UT-WGT-001〜004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getUrlName()はgetClass().getSimpleName()を返す | E-01 L67-69 | ○ |
| C-02 | getOwnerUrl()はデフォルトでnullを返す | E-01 L75-78 | ○ |
| C-03 | getUrl()はownerUrl + widget/ + urlName + /形式 | E-01 L83-86 | ○ |
| C-04 | getUrl()でownerUrlがnullの場合は空文字として扱う | E-01 L84-85 | ○ |

### HistoryWidget クラス（UT-WGT-005〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | コンストラクタでadapter, baseList, baseUrl, owner, newerThan, olderThan, searchStringが設定される | E-02 L107-116 | ○ |
| C-06 | getOwnerUrl()はbaseUrlを返す | E-02 L118-121 | ○ |
| C-07 | getDisplayName()はAlternativeUiTextProviderを使用 | E-02 L126-128 | ○ |
| C-08 | getUrlName()は"buildHistory"を返す | E-02 L130-133 | ○ |
| C-09 | getFirstTransientBuildKey()はfirstTransientBuildKeyを返す | E-02 L135-137 | ○ |
| C-10 | updateFirstTransientBuildKeyはビルド中レコードのキーを設定 | E-02 L153-162 | ○ |
| C-11 | getRenderList()はtrimmed時にTHRESHOLD件に切り詰める | E-02 L167-179 | ○ |
| C-12 | getHistoryPageFilter()はbaseListを含むフィルターを生成 | E-02 L200-206 | ○ |
| C-13 | newPageFilter()はnewerThan/olderThan/searchStringを設定 | E-02 L208-223 | ○ |
| C-14 | isTrimmed()/setTrimmed()はtrimmedフィールドのgetter/setter | E-02 L225-231 | ○ |
| C-15 | doAjax()はHeader nに基づいてビルド履歴を返す | E-02 L240-279 | ○ |
| C-16 | THRESHOLDはシステムプロパティから取得、デフォルト30 | E-02 L281 | ○ |
| C-17 | getNextBuildNumberToFetch()/setNextBuildNumberToFetch()はgetter/setter | E-02 L283-289 | ○ |
| C-18 | Adapterインターフェースはcompare, getKey, isBuilding, getNextKeyを定義 | E-02 L291-302 | ○ |
| C-19 | getPagingParam()はリクエストパラメータをLongに変換 | E-02 L304-318 | ○ |
| C-20 | FactoryImpl.type()はJob.classを返す | E-02 L325-327 | ○ |
| C-21 | FactoryImpl.widgetType()はHistoryWidget.classを返す | E-02 L329-332 | ○ |
| C-22 | FactoryImpl.createFor()はQueue.Task以外のJobでHistoryWidgetを生成 | E-02 L334-342 | ○ |

### BuildHistoryWidget クラス（UT-WGT-041〜050）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | コンストラクタは親クラスのコンストラクタを呼ぶ | E-03 L59-61 | ○ |
| C-24 | getQueuedItem()はJenkins.get().getQueue().getItem(owner)を返す | E-03 L66-68 | ○ |
| C-25 | getQueuedItems()はownerのキューアイテムを逆順で返す | E-03 L73-81 | ○ |
| C-26 | getHistoryPageFilter()はbaseListとqueuedItemsを含むフィルターを生成 | E-03 L83-90 | ○ |
| C-27 | FactoryImpl.type()はJob.classを返す | E-03 L96-99 | ○ |
| C-28 | FactoryImpl.widgetType()はBuildHistoryWidget.classを返す | E-03 L101-104 | ○ |
| C-29 | FactoryImpl.createFor()はQueue.TaskのJobでBuildHistoryWidgetを生成 | E-03 L106-113 | ○ |

### RenderOnDemandClosure クラス（UT-WGT-051〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | コンストラクタでbodyStackがJellyContextの親をたどって構築される | E-04 L65-72 | ○ |
| C-31 | コンストラクタでattributesToCaptureの変数がキャプチャされる | E-04 L74-80 | ○ |
| C-32 | コンストラクタでcurrentDescriptorByNameUrlがキャプチャされる | E-04 L83 | ○ |
| C-33 | コンストラクタでadjunctsがキャプチャされる | E-04 L87-92 | ○ |
| C-34 | render()はHttpResponseを返す | E-04 L99-136 | ○ |
| C-35 | render()のgenerateResponseでDefaultScriptInvokerが使用される | E-04 L107-129 | ○ |
| C-36 | createContext()でbodyStackからネストされたコンテキストが作成される | E-04 L109-119 | ○ |
| C-37 | exportVariables()でvariablesとcurrentDescriptorByNameUrlが設定される | E-04 L124-128 | ○ |
| C-38 | JellyTagException発生時にIOExceptionがスローされる | E-04 L130-133 | ○ |
| C-39 | adjunctsレストア失敗時にWARNINGログが出力される | E-04 L117-119 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースに対してソースコードの根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - doAjax()のテスト（UT-WGT-022〜025）
  - 理由：Staplerのリクエスト/レスポンス処理が複雑で、モック設定に注意が必要
- **1: 中リスク** - RenderOnDemandClosure.render()のテスト（UT-WGT-057〜063）
  - 理由：Jelly実行環境のセットアップが複雑で、統合テストに近い性質を持つ
- **1: 中リスク** - BuildHistoryWidgetのキュー関連テスト（UT-WGT-042〜046）
  - 理由：Jenkins.get()のモックが必要で、シングルトンアクセスのテストが複雑

## 6) レビュアーチェックリスト（最小）
- [ ] Widgetクラスのテストケース（UT-WGT-001〜004）が抽象クラスの具象サブクラスを適切に使用しているか確認
- [ ] HistoryWidgetのdoAjax()テストで、StaplerRequest2/StaplerResponse2のモックが適切に設定されているか確認
- [ ] BuildHistoryWidgetのgetQueuedItems()テストで、Jenkins.get()のモックが適切に設定されているか確認
- [ ] RenderOnDemandClosureのテストで、JellyContextとScriptのモックが適切に設定されているか確認
- [ ] THRESHOLDに関するテストで、SystemPropertiesのモックまたは実際のシステムプロパティ設定が考慮されているか確認
- [ ] 既存テスト（HistoryWidgetTest.java）との重複・整合性を確認
