---
generated_at: 2026-01-22 21:20:00
metrics:
  claims_total: 93
  claims_with_evidence: 93
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：jenkins.agents 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：93 / 93、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/agents/AgentComputerUtil.java`
- E-02: `core/src/main/java/jenkins/agents/ControllerToAgentCallable.java`
- E-03: `core/src/main/java/jenkins/agents/ControllerToAgentFileCallable.java`
- E-04: `core/src/main/java/jenkins/agents/CloudsLink.java`
- E-05: `core/src/main/java/jenkins/agents/CloudSet.java`
- E-06: `core/src/main/java/jenkins/agents/IOfflineCause.java`
- E-07: `core/src/main/java/jenkins/agents/WebSocketAgents.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### AgentComputerUtil（UT-AGT-001〜005）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getChannelToController()がJenkinsJVM上でFilePath.localChannelを返す | E-01 L48-49 | ○ |
| C-02 | getChannelToController()がagentプロパティtrueのChannelを返す | E-01 L53-56 | ○ |
| C-03 | Channelがnullの場合nullを返す | E-01 L53-58 | ○ |
| C-04 | agentプロパティがfalseの場合nullを返す | E-01 L54-58 | ○ |
| C-05 | getChannelToMaster()がgetChannelToController()を呼び出す | E-01 L67-68 | ○ |

### ControllerToAgentCallable（UT-AGT-006〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | checkRoles()がRoles.SLAVEをチェックする | E-02 L45-46 | ○ |
| C-07 | ロールチェック失敗でSecurityExceptionがスローされる | E-02 L45 (throws宣言) | ○ |

### ControllerToAgentFileCallable（UT-AGT-008〜009）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | checkRoles()がRoles.SLAVEをチェックする | E-03 L40-41 | ○ |
| C-09 | ロールチェック失敗でSecurityExceptionがスローされる | E-03 L40 (throws宣言) | ○ |

### CloudsLink（UT-AGT-010〜015）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | getDisplayName()がMessages.CloudsLink_DisplayName()を返す | E-04 L39-41 | ○ |
| C-11 | getDescription()がMessages.CloudsLink_Description()を返す | E-04 L44-46 | ○ |
| C-12 | getIconFileName()が"symbol-cloud"を返す | E-04 L49-51 | ○ |
| C-13 | getUrlName()が"cloud"を返す | E-04 L54-56 | ○ |
| C-14 | getCategory()がCategory.CONFIGURATIONを返す | E-04 L60-62 | ○ |
| C-15 | getRequiredPermission()がJenkins.SYSTEM_READを返す | E-04 L66-68 | ○ |

### CloudSet（UT-AGT-016〜063）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | getDescriptor()がJenkins.getDescriptorOrDieを使用 | E-05 L71-73 | ○ |
| C-17 | getDynamic(String)がJenkins.getCloud()を呼び出す | E-05 L75-77 | ○ |
| C-18 | getDynamic(String)でCloud不在時nullを返す | E-05 L76 (Jenkins.getCloudの仕様) | ○ |
| C-19 | getTarget()がJenkins.SYSTEM_READ権限をチェック | E-05 L82-83 | ○ |
| C-20 | 権限なしでAccessDeniedExceptionがスローされる | E-05 L82 | ○ |
| C-21 | getIconFileName()がnullを返す | E-05 L87-89 | ○ |
| C-22 | getDisplayName()がMessages.CloudSet_DisplayName()を返す | E-05 L92-94 | ○ |
| C-23 | getUrlName()が"cloud"を返す | E-05 L97-99 | ○ |
| C-24 | getSearchUrl()が"/cloud/"を返す | E-05 L102-104 | ○ |
| C-25 | getManagementLink()がCloudsLinkシングルトンを返す | E-05 L108-109 | ○ |
| C-26 | getCloudUrl()が一意Cloud名で標準URLを生成 | E-05 L114-120 | ○ |
| C-27 | getCloudUrl()が重複Cloud名でインデックスベースURLを生成 | E-05 L116-117 | ○ |
| C-28 | getCloudByIndex()が指定インデックスのCloudを返す | E-05 L135-137 | ○ |
| C-29 | 範囲外インデックスでIndexOutOfBoundsExceptionがスローされる | E-05 L136 (List.get仕様) | ○ |
| C-30 | isCloudAvailable()がCloud.all()の空判定を行う | E-05 L140-142 | ○ |
| C-31 | Cloud未登録時falseを返す | E-05 L141 | ○ |
| C-32 | getCloudUpdateCenterCategoryLabel()がURLエンコードを行う | E-05 L145-147 | ○ |
| C-33 | doChildrenContextMenu()が全Cloudを含むメニューを返す | E-05 L150-154 | ○ |
| C-34 | getDynamic(3引数)がclouds.getByName()を使用 | E-05 L156-158 | ○ |
| C-35 | getClouds()がJenkins.get().cloudsを返す | E-05 L162-164 | ○ |
| C-36 | hasClouds()がCloud存在時trueを返す | E-05 L168-170 | ○ |
| C-37 | hasClouds()がCloud不在時falseを返す | E-05 L169 | ○ |
| C-38 | checkName()が有効名をトリムして返す | E-05 L180-181 | ○ |
| C-39 | checkName()がnullでFailureをスロー | E-05 L177-178 | ○ |
| C-40 | checkName()が不正名でFailureをスロー | E-05 L181 (Jenkins.checkGoodName) | ○ |
| C-41 | checkName()が既存Cloud名でFailureをスロー | E-05 L183-184 | ○ |
| C-42 | doCheckName()が有効名でFormValidation.ok()を返す | E-05 L196-198 | ○ |
| C-43 | doCheckName()が空値でFormValidation.ok()を返す | E-05 L193-195 | ○ |
| C-44 | doCheckName()が重複名でFormValidation.error()を返す | E-05 L199-201 | ○ |
| C-45 | doCheckName()が権限なしでAccessDeniedExceptionをスロー | E-05 L192 | ○ |
| C-46 | doCreate()がコピーモードでCloudを作成 | E-05 L214-233 | ○ |
| C-47 | doCreate()がコピー元不在でFailureをスロー | E-05 L218-223 | ○ |
| C-48 | doCreate()がコピー元空でFailureをスロー | E-05 L219-221 | ○ |
| C-49 | doCreate()が新規モードで_new.jellyにフォワード | E-05 L234-245 | ○ |
| C-50 | doCreate()が不明モードでFailureをスロー | E-05 L240-243 | ○ |
| C-51 | doCreate()がモードnullでFailureをスロー | E-05 L236-238 | ○ |
| C-52 | doCreate()が権限なしでAccessDeniedExceptionをスロー | E-05 L212 | ○ |
| C-53 | doDoCreate()がCloudを作成 | E-05 L262-274 | ○ |
| C-54 | doDoCreate()が不明DescriptorでFailureをスロー | E-05 L266-268 | ○ |
| C-55 | doDoCreate()が権限なしでAccessDeniedExceptionをスロー | E-05 L264 | ○ |
| C-56 | doReorder()がCloud順序を変更 | E-05 L278-289 | ○ |
| C-57 | doReorder()が名前nullでFailureをスロー | E-05 L281-283 | ○ |
| C-58 | doReorder()が権限なしでAccessDeniedExceptionをスロー | E-05 L279 | ○ |
| C-59 | DescriptorImpl.doAutoCompleteCopyNewItemFrom()が前方一致補完 | E-05 L303-308 | ○ |
| C-60 | 空文字で全Cloud名を返す | E-05 L306 (startsWith("")は常にtrue) | ○ |
| C-61 | 一致なしで空候補を返す | E-05 L305-307 | ○ |
| C-62 | DescriptorImpl.getTarget()がADMINISTER権限をチェック | E-05 L312-314 | ○ |
| C-63 | DescriptorImpl.getTarget()が権限なしでAccessDeniedExceptionをスロー | E-05 L313 | ○ |

### IOfflineCause（UT-AGT-064〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | getComputerIcon()が"symbol-computer-offline"を返す | E-06 L42-44 | ○ |
| C-65 | getComputerIconAltText()が"[offline]"を返す | E-06 L50-52 | ○ |
| C-66 | getIcon()が"symbol-error"を返す | E-06 L58-60 | ○ |
| C-67 | getReason()が理由文字列を整形して返す | E-06 L68-76 | ○ |
| C-68 | getReason()がコメントなしで空文字を返す | E-06 L74-75 | ○ |
| C-69 | getReason()がHTMLエスケープを適用 | E-06 L75 (Util.escape) | ○ |
| C-70 | getMessage()がMessages.IOfflineCause_offline()を返す | E-06 L85-87 | ○ |
| C-71 | getStatusClass()が"warning"を返す | E-06 L93-95 | ○ |
| C-72 | getTime()がタイムスタンプからDateを生成 | E-06 L106-108 | ○ |

### WebSocketAgents（UT-AGT-073〜093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | getUrlName()がWebSocketサポート時"wsagents"を返す | E-07 L71-73 | ○ |
| C-74 | getUrlName()がWebSocket非サポート時nullを返す | E-07 L72 | ○ |
| C-75 | doIndex()がagentヘッダーなしで400エラー | E-07 L76-82 | ○ |
| C-76 | doIndex()がsecretヘッダーなしで400エラー | E-07 L77-82 | ○ |
| C-77 | doIndex()がcapabilityヘッダーなしで400エラー | E-07 L78-82 | ○ |
| C-78 | doIndex()がエージェント不在で400エラー | E-07 L84-86 | ○ |
| C-79 | doIndex()がシークレット不一致で403エラー | E-07 L88-91 | ○ |
| C-80 | doIndex()が正しい認証でWebSocket接続成功 | E-07 L121 | ○ |
| C-81 | doIndex()がクッキー提供時そのまま使用 | E-07 L99-107 | ○ |
| C-82 | doIndex()がクッキーなしで新規生成 | E-07 L104-105 | ○ |
| C-83 | doIndex()が不正クッキーで例外スロー | E-07 L103 (Util.fromHexString) | ○ |
| C-84 | doIndex()がConnectionRefusalExceptionで400エラー | E-07 L110-113 | ○ |
| C-85 | Session.opened()がthreadPoolForRemoting.submit()を呼ぶ | E-07 L141-150 | ○ |
| C-86 | Session.binary()がtransport.receive()を呼ぶ | E-07 L154-160 | ○ |
| C-87 | Session.binary()がIOExceptionでerror()を呼ぶ | E-07 L158-159 | ○ |
| C-88 | Session.closed()がチャネルクローズイベントを発火 | E-07 L164-170 | ○ |
| C-89 | Transport.write()がsendBinary()を呼ぶ | E-07 L184-191 | ○ |
| C-90 | Transport.write()がタイムアウトでIOExceptionスロー | E-07 L188-190 | ○ |
| C-91 | Transport.getRemoteCapability()がremoteCapabilityを返す | E-07 L195-197 | ○ |
| C-92 | Transport.closeWrite()がclose()を呼ぶ | E-07 L200-203 | ○ |
| C-93 | Transport.closeRead()がclose()を呼ぶ | E-07 L205-208 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全93件のテストケースについてソースコードによる根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード根拠を持つ
- 注意点:
  - WebSocketAgents（UT-AGT-075〜084）：セキュリティ関連のテストが多く、実際の認証フローの検証が重要
  - CloudSet.doCreate/doDoCreate（UT-AGT-046〜055）：Cloud作成における権限チェックと入力検証の網羅性を確認
  - IOfflineCause.getReason（UT-AGT-067〜069）：XSS対策のHTMLエスケープ処理の検証が重要

## 6) レビュアーチェックリスト（最小）
- [ ] AgentComputerUtil：JenkinsJVM判定とChannel取得ロジックが適切にテストされているか
- [ ] ControllerToAgentCallable/FileCallable：Roles.SLAVEロールチェックのモック化が適切か
- [ ] CloudsLink：ManagementLink継承メソッドの返却値が仕様通りか
- [ ] CloudSet.checkName/doCheckName：入力検証（null、空、不正文字、重複）が網羅されているか
- [ ] CloudSet.doCreate/doDoCreate：権限チェックとエラーハンドリングが十分か
- [ ] IOfflineCause.getReason：HTMLエスケープによるXSS対策のテストが含まれているか
- [ ] WebSocketAgents.doIndex：全必須ヘッダー検証、認証失敗、接続成功のパスが網羅されているか
- [ ] WebSocketAgents.Session/Transport：非同期処理とエラーハンドリングのテストが適切か
