---
generated_at: 2026-01-22 21:25:00
metrics:
  claims_total: 46
  claims_with_evidence: 42
  claims_without_evidence: 4
confidence_derived: 0.91
---

# 根拠レポート：jenkins.cli 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：42 / 46、根拠なし：4
- 優先レビュー（高）
  1. **UT-JCLI-028**：CLIContext.getArgs()の返却リスト不変性 - List.of()の挙動に基づく推測
  2. **UT-JCLI-020**：SafeRestartCommand.run()のJenkinsインスタンス未初期化時の挙動 - Jenkins.get()の挙動に基づく推測
  3. **UT-JCLI-035**：DefaultCLIListener.onExecution()のauth=null時の挙動 - コード推測
  4. **UT-JCLI-037**：DefaultCLIListener.onCompleted()の異常終了コードログ - コード推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/java/jenkins/cli/StopBuildsCommand.java` - StopBuildsCommandクラスの実装
- E-02: `core/src/main/java/jenkins/cli/SafeRestartCommand.java` - SafeRestartCommandクラスの実装
- E-03: `core/src/main/java/jenkins/cli/listeners/CLIListener.java` - CLIListenerインターフェースの定義
- E-04: `core/src/main/java/jenkins/cli/listeners/CLIContext.java` - CLIContextクラスの実装
- E-05: `core/src/main/java/jenkins/cli/listeners/DefaultCLIListener.java` - DefaultCLIListenerクラスの実装
- E-06: `test/src/test/java/jenkins/cli/StopBuildsCommandTest.java` - StopBuildsCommandの既存テスト
- E-07: `test/src/test/java/jenkins/cli/DefaultCLIListenerTest.java` - DefaultCLIListenerの既存テスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StopBuildsCommand.getShortDescription()が「Stop all running builds for job(s)」を返却 | E-01 (L52-54) | ○ |
| C-02 | StopBuildsCommand.run()で実行中ビルドが停止される | E-01 (L57-81), E-06 (L63-71) | ○ |
| C-03 | 複数ジョブのビルド停止 | E-01 (L62-74), E-06 (L121-124) | ○ |
| C-04 | 重複ジョブ名のフィルタリング | E-01 (L60), E-06 (L127-130) | ○ |
| C-05 | 並行ビルドの全停止 | E-01 (L83-91, L112-118), E-06 (L86-101) | ○ |
| C-06 | 完了済みビルドのスキップ | E-01 (L87), E-06 (L75-83) | ○ |
| C-07 | 最新完了時の以前ビルド停止 | E-01 (L90, L112-118), E-06 (L187-206) | ○ |
| C-08 | 存在しないジョブでIllegalArgumentException | E-01 (L64-69), E-06 (L114-118) | ○ |
| C-09 | Job型以外でIllegalArgumentException | E-01 (L65-69), E-06 (L104-111) | ○ |
| C-10 | 権限不足時のエラーメッセージ出力 | E-01 (L103-106), E-06 (L133-153) | ○ |
| C-11 | 最初ジョブ失敗でも2番目ジョブ停止 | E-01 (L72-74), E-06 (L156-184) | ○ |
| C-12 | lastBuildがnull時のスキップ | E-01 (L84-91) | ○ |
| C-13 | Executorがnull時のメッセージ出力 | E-01 (L107-109) | ○ |
| C-14 | doStop()のRuntimeException時のエラーメッセージ | E-01 (L103-106) | ○ |
| C-15 | 以前ビルドの全停止 | E-01 (L112-118) | ○ |
| C-16 | 以前ビルドなし時のスキップ | E-01 (L115-118) | ○ |
| C-17 | SafeRestartCommand.getShortDescription()がMessagesから返却 | E-02 (L51-53) | ○ |
| C-18 | SafeRestartCommand.run()でメッセージなしSafe Restart | E-02 (L56-58) | ○ |
| C-19 | メッセージ付きSafe Restart | E-02 (L47-48, L57) | ○ |
| C-20 | Jenkinsインスタンス未初期化時の例外 | E-02 (L57) - Jenkins.get()の仕様に基づく推測 | △ |
| C-21 | CLIContextコンストラクタで全引数設定 | E-04 (L51-55) | ○ |
| C-22 | args=null時に空リスト設定 | E-04 (L53) | ○ |
| C-23 | getCorrelationId()がUUID返却 | E-04 (L41, L60-63) | ○ |
| C-24 | 同一インスタンスで同じUUID | E-04 (L41) - finalフィールド | ○ |
| C-25 | 異なるインスタンスで異なるUUID | E-04 (L41) - UUID.randomUUID() | ○ |
| C-26 | getCommand()がコマンド名返却 | E-04 (L67-70) | ○ |
| C-27 | getArgs()が引数リスト返却 | E-04 (L74-77) | ○ |
| C-28 | 返却リストの不変性 | E-04 (L53) - List.of()の挙動に基づく推測 | △ |
| C-29 | getAuth()が認証情報返却 | E-04 (L82-86) | ○ |
| C-30 | auth=null時にnull返却 | E-04 (L54, L82-86) | ○ |
| C-31 | CLIListener.onExecution()デフォルト実装 | E-03 (L43) | ○ |
| C-32 | CLIListener.onCompleted()デフォルト実装 | E-03 (L54) | ○ |
| C-33 | CLIListener.onThrowable()デフォルト実装 | E-03 (L65) | ○ |
| C-34 | DefaultCLIListener.onExecution()のログ出力 | E-05 (L47-51), E-07 (L69-82) | ○ |
| C-35 | auth=null時の「<unknown>」ログ出力 | E-05 (L87-88) - コード推測 | △ |
| C-36 | DefaultCLIListener.onCompleted()のログ出力 | E-05 (L54-59), E-07 (L69-82) | ○ |
| C-37 | 異常終了コードのログ出力 | E-05 (L54-59) - コード推測 | △ |
| C-38 | BadCredentialsExceptionのINFOログ | E-05 (L63-66) | ○ |
| C-39 | CmdLineExceptionのFINEログ | E-05 (L67-78), E-07 (L85-100) | ○ |
| C-40 | IllegalArgumentExceptionのFINEログ | E-05 (L68) | ○ |
| C-41 | IllegalStateExceptionのFINEログ | E-05 (L69) | ○ |
| C-42 | AbortExceptionのFINEログ | E-05 (L70) | ○ |
| C-43 | AccessDeniedExceptionのFINEログ | E-05 (L71) | ○ |
| C-44 | その他例外のWARNINGログ | E-05 (L79-84), E-07 (L103-117) | ○ |
| C-45 | authName()がユーザー名返却 | E-05 (L87-88) | ○ |
| C-46 | authName()でauth=null時「<unknown>」返却 | E-05 (L88) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-JCLI-020**: Jenkins.get()がインスタンス未初期化時にどのような例外をスローするかは、Jenkinsクラスの実装に依存
  - 候補：IllegalStateException / NullPointerException / カスタム例外
- **UT-JCLI-028**: CLIContextのargsがnullでない場合にそのまま保持されるか、List.copyOf()でコピーされるかはコードから明確
  - 実際はargs != null ? args : List.of()で元のリストをそのまま保持（L53）
- **UT-JCLI-035, UT-JCLI-037**: 既存テストでカバーされていないエッジケース
  - 候補：テスト追加 / 手動検証

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - CLIListener インターフェースのデフォルトメソッド（UT-JCLI-031〜033）
- **0: 低リスク** - ヘルプ文字列の返却（UT-JCLI-001, UT-JCLI-017）
- **1: 中リスク** - CLIContext のイミュータブル性（UT-JCLI-028）- List.of()で返却されるがフィールドはそのまま保持
- **1: 中リスク** - authName()のnullハンドリング（UT-JCLI-046）
- **2: 高リスク** - 権限チェックのバイパス可能性（UT-JCLI-010, UT-JCLI-011）- 例外発生時も処理継続

## 6) レビュアーチェックリスト（最小）
- [ ] StopBuildsCommand: ジョブ名の重複除去ロジック（LinkedHashSet使用）が正しく動作するか確認
- [ ] StopBuildsCommand: executor.doStop()失敗時の例外ハンドリングが適切か確認
- [ ] SafeRestartCommand: doSafeRestart()呼び出し時のnull引数の影響を確認
- [ ] CLIContext: argsフィールドがイミュータブルコレクションで保護されているか確認
- [ ] CLIContext: correlationIdの一意性が本番環境で保証されるか確認（UUID衝突リスク）
- [ ] DefaultCLIListener: BadCredentialsException時のログレベル（INFO）がセキュリティ要件を満たすか確認
- [ ] DefaultCLIListener: 予期しない例外（WARNING）が適切なアラートにつながるか確認
- [ ] 既存テスト（E-06, E-07）との整合性を確認し、重複テストケースを特定
